$(document).ready(function(){

	function getPeriodo()
	{
		var dat = {
			id: $("#cmbPeriodo").val()
		};

		$.ajax({
			data: dat,
			url: $("#frmFechas").attr("data-url"),
			method: "POST",
			dataType: "JSON",
			success: function(response){
				$("#lblFechaActual").text(response["fechaHoy"]);
				$("#lblFechaCaducidad").text(response["fechaCaducidad"]);
			}
		});
	}

	function createUsuario(adm_mail, adm_prog, adm_db, codmedico, periodo, asistente, direccion, 
		nomComercial, facturar, ruc_medico, nro_establ, ptoEmision, tip_contrib, nro_contrib,
		institucion, razon_social, telf_institucion, cell_institucion, email_institucion, dir_matriz, dir_establ,
		firma_elec, clave_firma)
	{
		var dat = {
			tipousuario: $("#cmbTipousuario").val(),
			cedula: $("#inputNewCedula").val(),
			nombreUsuario: $("#inputNombreUsuario").val(),
			password: $("#inputPasswordSha256").val(),
			nombres: $("#inputNombres").val(),
			apellidos: $("#inputApellidos").val(),
			telefono: $("#inputTelefonocon").val(),
			mail: $("#inputMail").val(),
			adm_mail: adm_mail,
			adm_prog: adm_prog,
			adm_db: adm_db,
			codmedico: codmedico,
			periodo: periodo,
			asistente: asistente,
			direccion: direccion,
			nomComercial: nomComercial,
			tipo_iden: $("#cmbTipoIdentificacion").val(),
			facturar: facturar,
			ruc_medico: ruc_medico,
			nro_establ: nro_establ,
			ptoEmision: ptoEmision,
			tip_contrib: tip_contrib,
			nro_contrib: nro_contrib,
			institucion: institucion,
			razon_social: razon_social,
			telf_institucion: telf_institucion,
			cell_institucion: cell_institucion,
			email_institucion: email_institucion,
			dir_matriz: dir_matriz,
			dir_establ: dir_establ,
			firma_elec: firma_elec,
			clave_firma: clave_firma
		};

		$.ajax({
			data: dat,
			url: $("#frmNewUser").attr("action"),
			method: "POST",
			success: function(datos){
				$("#inputIdMedico").val(datos);
				if($("#cmbTipousuario").val() == 2)
					createMedicoEspecialidad(datos);
				else
					window.location = $("#btnCancelar").prop("href");
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function createMedicoEspecialidad(medico)
	{
		var dat = new FormData($("#frmNewUser")[0]);

		$.ajax({
			data: dat,
			url: "../store/especialidad/medico/",
			method: "POST",
			contentType: false,
			processData: false,
			success: function(datos){
				window.location = $("#btnCancelar").prop("href");
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	$("#cmbPeriodo").change(function(){
		getPeriodo();
	});

	$("#frmNewUser").on("submit", function(e){
		e.preventDefault();
		$("#btnGuardar").prop("disabled", true);

		if($("#cmbTipousuario").val() == 1)
		{
			createUsuario($("#inputMailRecuperacion").val(), $("#inputPassProgramamed").val(), 
				$("#inputPassDb").val(), "", "", "", "", "", "", "", "", "", "", "",
				"", "", "", "", "", "", "", "", "");
		}
		else if($("#cmbTipousuario").val() == 2)
		{
			var asistente = 0;
			if($("#rdbOptionsRadios1").prop("checked"))
				asistente = $("#cmbAsistente").val();

			if($("#rdbFacturarSi").prop("checked"))
			{
				createUsuario("", "", "", $("#inputCodmedico").val(), $("#cmbPeriodo").val(), 
					asistente, $("#inputDireccion").val(),	
					$("#inputNombreComercial").val(), "si", $("#inputRuc").val(), $("#inputNroEstabl").val(), 
					$("#inputPtoEmision").val(), $("#cmbTipoContribuyente").val(), $("#inputNroContri").val(),
					$("#cmbInstitucion").val(), $("#inputRazonSocial").val(), $("#inputTelfInst").val(), 
					$("#inputCellInst").val(),	$("#inputEmailInst").val(), $("#inputDirMatriz").val(),
					$("#inputDirEstabl").val(), $("#inputFirma").val(), $("#inputClaveFirma").val());
			}
			
			if($("#rdbFacturarNo").prop("checked"))
			{
				createUsuario("", "", "", $("#inputCodmedico").val(), $("#cmbPeriodo").val(), 
					asistente, $("#inputDireccion").val(),	
					$("#inputNombreComercial").val(), "no", "", "", "", "", "",
					"", "", "", "", "", "", "", "", "");
			}
		}
		else
		{
			createUsuario("", "", "", "", $("#cmbPeriodo").val(), "", "",
				 "", "", "", "", "", "", "",
				 "", "", "", "", "", "", "", "", "");
		}
	});

	$(function() {
		$.widget( "custom.combobox", {
			_create: function() {
				this.wrapper = $( "<span class='form-control p-0'>" )
				.insertAfter( this.element );

				this.element.hide();
				this._createAutocomplete();
				//this._createShowAllButton();
			},

			_createAutocomplete: function() {
				var selected = this.element.children( ":selected" ),
				value = selected.val() ? selected.text() : "";

				this.input = $( "<input id='inputAsistente'>" )
				.appendTo( this.wrapper )
				.val( value )
				.attr( "title", "" )
				.addClass("form-control")
				.prop("placeholder", "")
				.autocomplete({
					delay: 0,
					minLength: 2,
					source: $.proxy( this, "_source" )
				})
				.tooltip({
					classes: {
					"ui-tooltip": "ui-state-highlight"
					}
				});

				this._on( this.input, {
					autocompleteselect: function( event, ui ) {
						ui.item.option.selected = true;
						this._trigger( "select", event, {
							item: ui.item.option
						});
					},
					autocompletechange: "_removeIfInvalid"
				});
			},

			_source: function( request, response ) {
				var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
				response( this.element.children( "option" ).map(function() {
					var text = $( this ).text();
					if ( this.value && ( !request.term || matcher.test(text) ) )
					return {
						label: text,
						value: text,
						option: this
					};
				}) );
			},

			_removeIfInvalid: function( event, ui ) {

				// Selected an item, nothing to do
				if ( ui.item ) {
					return;
				}

				// Search for a match (case-insensitive)
				var value = this.input.val(),
				valueLowerCase = value.toLowerCase(),
				valid = false;
				this.element.children( "option" ).each(function() {
					if ( $( this ).text().toLowerCase() === valueLowerCase ) {
						this.selected = valid = true;
						return false;
					}
				});

				// Found a match, nothing to do
				if ( valid ) {
					return;
				}

				// Remove invalid value
				this.input
				.val("")
				.attr( "title", value + " no coincide con ningún elemento" )
				.tooltip( "open" );
				this.element.val( "" );
				this._delay(function() {
					this.input.tooltip( "close" ).attr( "title", "" );
				}, 2500 );
				this.input.autocomplete( "instance" ).term = "";
			},

			_destroy: function() {
				this.wrapper.remove();
				this.element.show();
			}
		});

		$( "#cmbAsistente" ).combobox();
	});

});