$(document).ready(function(){

	var pag = 0;

	function graficoPorGenero(datos)
	{
		Highcharts.chart('repGenPac', {
		    chart: {
		        type: 'pie',
		        options3d: {
		            enabled: true,
		            alpha: 45,
		            beta: 0
		        }
		    },
		    title: {
		        text: 'Total de pacientes registrados según su género'
		    },
		    tooltip: {
		        pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
		    },
		    plotOptions: {
		        pie: {
		            allowPointSelect: true,
		            cursor: 'pointer',
		            depth: 35,
		            dataLabels: {
		                enabled: true,
		                format: '{point.name}'
		            }
		        }
		    },
		    series: [{
		        type: 'pie',
		        name: 'Reporte por Género',
		        data: [
		        	['Masculino', parseInt(datos["Masculino"])],
		            ['Femenino', parseInt(datos["Femenino"])],
		            ['Otro', parseInt(datos["Otro"])]
		        ]
		    }]
		});
	}

	function graficoPacienteNuevos(datos)
	{
		Highcharts.chart('repNewPac', {
		    chart: {
		        type: 'column',
		        options3d: {
		            enabled: true,
		            alpha: 0,
		            beta: 0,
		            depth: 0
		        }
		    },
		    title: {
		        text: 'Pacientes nuevos'
		    },
		    subtitle: {
		        text: 'Registro de pacientes nuevos'
		    },
		    plotOptions: {
		        column: {
		            depth: 25
		        }
		    },
		    xAxis: {
		        categories: [
		        	"Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"
		        ],
		        labels: {
		            skew3d: true,
		            style: {
		                fontSize: '16px'
		            }
		        }
		    },
		    yAxis: {
		        title: {
		            text: null
		        }
		    },
		    series: [{
		        name: 'Pacientes nuevos',
		        data: [
		        	["Enero", parseInt(datos["enero"])],
		        	["Febrero", parseInt(datos["febrero"])],
		        	["Marzo", parseInt(datos["marzo"])],
		        	["Abril", parseInt(datos["abril"])],
		        	["Mayo", parseInt(datos["mayo"])],
		        	["Junio", parseInt(datos["junio"])],
		        	["Julio", parseInt(datos["julio"])],
		        	["Agosto", parseInt(datos["agosto"])],
		        	["Septiembre", parseInt(datos["septiembre"])],
		        	["Octubre", parseInt(datos["octubre"])],
		        	["Noviembre", parseInt(datos["noviembre"])],
		        	["Diciembre", parseInt(datos["diciembre"])]
		        ]
		    }]
		});
	}

	function getReportePorGenero()
	{
		$.ajax({
			data: {},
			url: "./genero/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				graficoPorGenero(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function getReporteFechaRegistro(anio)
	{
		$.ajax({
			data: {
				anio: anio
			},
			url: "./registro/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				graficoPacienteNuevos(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getReporteEstadoCivil()
	{
		$.ajax({
			data: {},
			url: $("#tableEstCivil").attr("data-url"),
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				$(".spCasTot").text(datos["totCas"]);
				$(".spCasG1").text(datos["casG1"]);
				$(".spCasG2").text(datos["casG2"]);
				$(".spCasG3").text(datos["casG3"]);
				$(".spCasG4").text(datos["casG4"]);
				$(".spCasG5").text(datos["casG5"]);
				$(".spCasG6").text(datos["casG6"]);

				$(".spSolTot").text(datos["totSol"]);
				$(".spSolG1").text(datos["solG1"]);
				$(".spSolG2").text(datos["solG2"]);
				$(".spSolG3").text(datos["solG3"]);
				$(".spSolG4").text(datos["solG4"]);
				$(".spSolG5").text(datos["solG5"]);
				$(".spSolG6").text(datos["solG6"]);

				$(".spViuTot").text(datos["totViu"]);
				$(".spViuG1").text(datos["viuG1"]);
				$(".spViuG2").text(datos["viuG2"]);
				$(".spViuG3").text(datos["viuG3"]);
				$(".spViuG4").text(datos["viuG4"]);
				$(".spViuG5").text(datos["viuG5"]);
				$(".spViuG6").text(datos["viuG6"]);

				$(".spDivTot").text(datos["totDiv"]);
				$(".spDivG1").text(datos["divG1"]);
				$(".spDivG2").text(datos["divG2"]);
				$(".spDivG3").text(datos["divG3"]);
				$(".spDivG4").text(datos["divG4"]);
				$(".spDivG5").text(datos["divG5"]);
				$(".spDivG6").text(datos["divG6"]);

				$(".spUniTot").text(datos["totUni"]);
				$(".spUniG1").text(datos["uniG1"]);
				$(".spUniG2").text(datos["uniG2"]);
				$(".spUniG3").text(datos["uniG3"]);
				$(".spUniG4").text(datos["uniG4"]);
				$(".spUniG5").text(datos["uniG5"]);
				$(".spUniG6").text(datos["uniG6"]);

				$(".spOtrTot").text(datos["totOtr"]);
				$(".spOtrG1").text(datos["otrG1"]);
				$(".spOtrG2").text(datos["otrG2"]);
				$(".spOtrG3").text(datos["otrG3"]);
				$(".spOtrG4").text(datos["otrG4"]);
				$(".spOtrG5").text(datos["otrG5"]);
				$(".spOtrG6").text(datos["otrG6"]);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getReportePorUbicacion(pagina)
	{
		var dat = {
			reporte: "ubicacion",
			pagina: pagina,
			cantidad: 20
		};

		$.ajax({
			data: dat,
			url: "./pacientes/",
			method: "POST",
			success: function(datos){
				$("#tableUbicacion").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function getReportePorSeguro(pagina)
	{
		var dat = {
			reporte: "seguro",
			pagina: pagina,
			cantidad: 20
		};

		$.ajax({
			data: dat,
			url: "./pacientes/",
			method: "POST",
			success: function(datos){
				$("#tableSeguro").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function getReporteTotal(pagina)
	{
		var dat = {
			reporte: "total",
			pagina: pagina,
			cantidad: 20
		};

		$.ajax({
			data: dat,
			url: "./pacientes/",
			method: "POST",
			success: function(datos){
				$("#tableTotal").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function getReporteCie10()
	{
		$.ajax({
			data: {},
			url: "./cie10/",
			method: "POST",
			success: function(datos){
				$("#tableCie10").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getReporteMedicamento()
	{
		$.ajax({
			data: {},
			url: "./medicamentos/",
			method: "POST",
			success: function(datos){
				$("#tableMedicamento").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getReporteMotivoConsulta(pagina)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 20
			},
			url: "./motivo/consulta/",
			method: "POST",
			success: function(datos){
				//$("#tableMedicamento").html(datos);
				console.log(datos);
				$("#divRepMotivoConsulta").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	$("input[name=rdbReporte]").change(function(){
		$(".divReportes").slideUp();
		if($(this).val() == 1)
		{
			$("#divRepGenPac").slideDown();
			getReportePorGenero();
		}
		else if($(this).val() == 2)
		{
			$("#divRepNewPac").slideDown();
			getReporteFechaRegistro($("#cmbAnio").val());
		}
		else if($(this).val() == 3)
		{
			$("#divRepUbiPac").slideDown();
			getReportePorUbicacion(0);
		}
		else if($(this).val() == 4)
		{
			$("#divRepSegPac").slideDown();
			getReportePorSeguro(0);
		}
		else if($(this).val() == 5)
		{
			$("#divRepEstCiv").slideDown();
			getReporteEstadoCivil();
		}
		else if($(this).val() == 6)
		{
			$("#divRepTotPac").slideDown();
			getReporteTotal(0);
		}
		else if($(this).val() == 7)
		{
			$("#divRepCie10").slideDown();
			getReporteCie10();
		}
		else if($(this).val() == 8)
		{
			$("#divRepMedicamento").slideDown();
			getReporteMedicamento();
		}
		else if($(this).val() == 9)
		{
			console.log("Vamos bien");
			$("#divContenedorRepMotivoConsulta").slideDown();
			getReporteMotivoConsulta(0);
		}
	});

	$("#cmbAnio").change(function(){
		getReporteFechaRegistro($(this).val());
	});

	$(document).on("click", "#tableUbicacion .paginacion .page-link", function(e){
		e.preventDefault();
		//pag = $(this).prop("id");
		getReportePorUbicacion($(this).prop("id"));
	});

	$(document).on("click", "#tableSeguro .paginacion .page-link", function(e){
		e.preventDefault();
		//pag = $(this).prop("id");
		getReportePorSeguro($(this).prop("id"));
	});

});