$(document).ready(function(){

	var idPaciente = 0;
	var pag = 0;
	var pagRes = 0;
	var fechaActual = new Date();
	var anio = fechaActual.getFullYear();
	var anio_min = anio - 120;

	$("#inputFechaNacimiento").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
        changeYear: true,
        yearRange: anio_min + ":" + anio,
		currentText: 'Hoy',
		monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
		'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
		monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
		'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
		dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
		dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié;', 'Juv', 'Vie', 'Sáb'],
		dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
	});
	
	$("#inputFechaNacimiento").on("focus", function(){
		$(".ui-datepicker").css({"z-index" : 9999});
	});

	$('#ui-datepicker-div').appendTo($('#myModalNewElement'));

	function limpiarCampos()
	{
		idPaciente = 0;
		$("#inputFechaNacimiento").val("");
		$("#inputTipoSangre").val("");
		$("#chkDeportista").prop("checked", false);
		$("#cmbGenero").val("");
		$("#cmbEstadoCivil").val("Otros");
		$("#inputDireccion").val("");
		$("#inputSector").val("");
		$("#inputContacto").val("");
		$("#inputOcupacion").val("");
		$("#inputTrabajo").val("");
		$("#inputCedula").val("");
		$("#inputNombre").val("");
		$("#inputApellido").val("");
		$("#inputTelefono").val("");
		$("#inputEmail").val("");
	}

	$("#cmbTipoIdentificacion").change(function(){
		if($(this).val() == "CED")
		{
			$("#inputCedula").attr("minlength", "1");
			$("#inputCedula").prop("maxlength", 10);
			$("#inputCedula").removeClass("sln");
			$("#inputCedula").addClass("sn");
			$("#inputCedula").val("");
		}
		else if($(this).val() == "RUC")
		{
			$("#inputCedula").attr("minlength", "13");
			$("#inputCedula").prop("maxlength", 13);
			$("#inputCedula").removeClass("sln");
			$("#inputCedula").addClass("sn");
			$("#inputCedula").val("");
		}
		else if($(this).val() == "PAS")
		{
			$("#inputCedula").attr("minlength", "15");
			$("#inputCedula").prop("maxlength", 20);
			$("#inputCedula").removeClass("sn");
			$("#inputCedula").addClass("sln");
			$("#inputCedula").val("");
		}
	});

	function getCatalogoPacientes(pagina, buscar)
	{
		$.ajax({
			data: {
				medico: $("#cmbMedicos").val(),
				buscar: buscar,
				pagina: pagina,
				cantidad: 20
			},
			url: "./catalogo/",
			method: "POST",
			success: function(datos){
				$("#catalogPaciente").html(datos);
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getCatalogoPacientesResponsive(pagina, buscar)
	{
		$.ajax({
			data: {
				medico: $("#cmbMedicos").val(),
				buscar: buscar,
				pagina: pagina,
				cantidad: 5
			},
			url: "./catalogo/responsive/",
			method: "POST",
			success: function(datos){
				$("#tablaPacienteResponsive").html(datos);
			},
			error: function(error){
				//console.log(error);
				//$("#errores").html(error.responseText);
			}
		});
	}

	function getUsuarioByCedula(cedula)
	{
		var dat = {
			medico: $("#cmbMedicos").val(),
		};

		$.ajax({
			data: dat,
			url: "../recursos/paciente/0/" + cedula,
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos["success"])
				{
					$("#inputCedula").val("");
					$("#inputCedula").focus();
					$(".alert-cedula").show();
				}
				else
				{
					$(".alert-cedula").hide();
				}
			},
			error: function(error){
				//console.log(error);
			}
		})
	}

	function getPaciente(id)
	{
		$.ajax({
			data: {},
			url: "../recursos/paciente/" + id,
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				console.log(datos)
				$("#inputFechaNacimiento").val(datos["fechaNacimiento"]);
				$("#inputAseguradora").val(datos["aseguradora"]);
				$("#inputCelular").val(datos["celular"]);
				$("#cmbGenero").val(datos["genero"]);
				$("#cmbEstadoCivil").val(datos["estadoCivil"]);
				$("#inputDireccion").val(datos["direccion"]);
				$("#inputSector").val(datos["sector"]);
				$("#inputContacto").val(datos["contacto"]);
				$("#cmbOcupacion").val(datos["ocupacion"]);
				$("#inputCedula").val(datos["cedula"]);
				$("#inputNombre").val(datos["nombre"]);
				$("#inputApellido").val(datos["apellido"]);
				$("#inputTelefono").val(datos["telefono"]);
				$("#inputEmail").val(datos["email"]);
				$("#cmbProvincia").val(datos["provincia"]);
				$("#cmbTipoIdentificacion").val(datos["tipo_iden"]);
				getCmbCantones(datos["provincia"], datos["canton"], datos["parroquia"]);

				if(datos["tipo_iden"] === "CED")
				{
					$("#inputCedula").attr("minlength", "1");
					$("#inputCedula").prop("maxlength", 10);
					$("#inputCedula").removeClass("sln");
					$("#inputCedula").addClass("sn");
				}
				else if(datos["tipo_iden"] === "RUC")
				{
					$("#inputCedula").attr("minlength", "13");
					$("#inputCedula").prop("maxlength", 13);
					$("#inputCedula").removeClass("sln");
					$("#inputCedula").addClass("sn");
				}
				else if(datos["tipo_iden"] === "PAS")
				{
					$("#inputCedula").attr("minlength", "15");
					$("#inputCedula").prop("maxlength", 20);
					$("#inputCedula").removeClass("sn");
					$("#inputCedula").addClass("sln");
				}
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function crearPaciente()
	{
		var dat = {
			fechaNacimiento: $("#inputFechaNacimiento").val(),
			seguro: $("#inputAseguradora").val(),
			celular: $("#inputCelular").val(),
			genero: $("#cmbGenero").val(),
			estadoCivil: $("#cmbEstadoCivil").val(),
			direccion: $("#inputDireccion").val(),
			sector: $("#inputSector").val(),
			contacto: $("#inputContacto").val(),
			ocupacion: $("#cmbOcupacion").val(),
			parroquia: $("#cmbParroquia").val(),
			cedula: $("#inputCedula").val(),
			nombre: $("#inputNombre").val(),
			apellido: $("#inputApellido").val(),
			telefono: $("#inputTelefono").val(),
			email: $("#inputEmail").val(),
			medico: $("#cmbMedicos").val(),
			tipo_iden: $("#cmbTipoIdentificacion").val()
		};

		$.ajax({
			data: dat,
			url: "./crear/",
			method: "POST",
			success: function(datos){
				getCatalogoPacientes(pag, $("#txtBuscar").val());
				getCatalogoPacientesResponsive(pagRes, $("#txtBuscarRes").val());
				limpiarCampos();
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function updatePaciente(paciente)
	{
		var dat = {
			fechaNacimiento: $("#inputFechaNacimiento").val(),
			seguro: $("#inputAseguradora").val(),
			telefono: $("#inputTelefono").val(),
			genero: $("#cmbGenero").val(),
			estadoCivil: $("#cmbEstadoCivil").val(),
			direccion: $("#inputDireccion").val(),
			sector: $("#inputSector").val(),
			contacto: $("#inputContacto").val(),
			ocupacion: $("#cmbOcupacion").val(),
			parroquia: $("#cmbParroquia").val(),
			cedula: $("#inputCedula").val(),
			nombre: $("#inputNombre").val(),
			apellido: $("#inputApellido").val(),
			celular: $("#inputCelular").val(),
			email: $("#inputEmail").val(),
			tipo_iden: $("#cmbTipoIdentificacion").val()
		};

		$.ajax({
			data: dat,
			url: "./update/" + paciente,
			method: "POST",
			success: function(datos){
				getCatalogoPacientes(pag, $("#txtBuscar").val());
				getCatalogoPacientesResponsive(pagRes, $("#txtBuscarRes").val());
				limpiarCampos();
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getCmbCantones(provincia, id, idParroquia)
	{
		var dat = {
			provincia: provincia,
			id: id
		};

		$.ajax({
			data: dat,
			url: "./../recursos/cantones/cmb/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				$("#cmbCanton").html(datos["cmb"]);
				getCmbParroquias(datos["primerId"], idParroquia);
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getCmbParroquias(canton, id)
	{
		var dat = {
			canton: canton,
			id: id
		};

		$.ajax({
			data: dat,
			url: "./../recursos/parroquias/cmb/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				$("#cmbParroquia").html(datos["cmb"]);
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function buscarTabla(texto)
	{
		$("#table_pacientes tbody tr").each(function(){
			var existe = false;
			$(this).each(function(){
				if($(this).text().toLowerCase().indexOf(texto.toLowerCase()) >= 0)
					existe = true;

				if(existe == true)
					$(this).show();
				else
					$(this).hide();
			});
		});
	}

	function buscarTablaResponsive(texto)
	{
		$("#table_pacientes_responsive tbody").each(function(){
			var existe = false;
			$(this).each(function(){
				if($(this).text().toLowerCase().indexOf(texto.toLowerCase()) >= 0)
					existe = true;

				if(existe == true)
					$(this).show();
				else
					$(this).hide();
			});
		});
	}

	getCatalogoPacientes(0, "");
	getCatalogoPacientesResponsive(0, "");
	getCmbCantones($("#cmbProvincia").val(), 0, 0);

	$("#cmbMedicos").change(function(){
		getCatalogoPacientes(0, "");
		getCatalogoPacientesResponsive(0, "");
	});

	$("#inputCedula").blur(function(){
		if(idPaciente == 0)
			getUsuarioByCedula($(this).val());
	});

	$("#frmCrearPaciente").on("submit", function(e){
		e.preventDefault();
		$("#myModalNewElement").modal("hide");
		if(idPaciente == 0){
			crearPaciente();
		}
		else{
			updatePaciente(idPaciente);
		}
	});

	$(document).on("click", ".btnEditar", function(e){
		e.preventDefault();
		idPaciente = atob($(this).prop("name"));
		getPaciente(atob($(this).prop("name")));
		$("#myModalNewElement").modal("show");
	});

	$(".btnNuevo").click(function(){
		limpiarCampos();
	});

	$(document).on("keyup", "#txtBuscar", function(){
		getCatalogoPacientes(0, $(this).val());
	});

	$(document).on("keyup", "#txtBuscarRes", function(){
		getCatalogoPacientesResponsive(0, $(this).val());
	});

	$(document).on("change", "#cmbProvincia", function(){
		getCmbCantones($(this).val(), 0, 0);
	});

	$(document).on("change", "#cmbCanton", function(){
		getCmbParroquias($(this).val(), 0);
	});

	$(document).on("click", "#catalogPaciente .paginacion .page-link", function(e){
		e.preventDefault();
		pag = $(this).prop("id");
		getCatalogoPacientes(pag, $("#txtBuscar").val());
	});

	$(document).on("click", "#tablaPacienteResponsive .paginacion_responsive .page-link", function(e){
		e.preventDefault();
		pagRes = $(this).prop("id");
		getCatalogoPacientesResponsive(pagRes, $("#txtBuscarRes").val());
	});
});