$(document).ready(function(){

	var pag = 0;
	var pagRes = 0;

	function getMedicos(pagina, buscar)
	{
		$.ajax({
			data: {
				pagina: pagina,
				buscar: buscar,
				cantidad: 20
			},
			url: "../catalogos/medico/",
			method: "POST",
			success: function(datos){
				$('#catalogMedicos').html(datos);
			},
			error: function(error){
				console.log(error.responseText);
				$("#errores").html(error.responseText);
			}
		})
	}

	function getMedicosResponsive(pagina, buscar)
	{
		$.ajax({
			data: {
				pagina: pagina,
				buscar: buscar,
				cantidad: 5
			},
			url: "../catalogosRes/medico/",
			method: "POST",
			success: function(datos){
				$("#catalogMedicosRes").html(datos);
			},
			error: function(error){
				console.log(error.responseText);
				$("#errores").html(error.responseText);
			}
		});
	}

	function updateEstadoUser(url, campo)
	{
		$.ajax({
			data: {},
			url: url,
			method: "POST",
			success: function(datos){
				if(datos == 0)
				{
					campo.removeClass("btn-success");
					campo.removeClass("Activo");
					campo.addClass("btn-danger");
					campo.addClass("Inactivo");
					campo.text("Inactivo");
				}
				else
				{
					campo.removeClass("btn-danger");
					campo.removeClass("Inactivo");
					campo.addClass("btn-success");
					campo.addClass("Activo");
					campo.text("Activo");
				}
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function updateLicencia(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: "../../update/licencia/usuario/",
			method: "POST",
			success: function(){
				getMedicos(pag, $("#txtBuscar").val());
				getMedicosResponsive(pagRes, $("#txtBuscarRes").val());
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function buscarTabla(texto)
	{
		$("#table_usuarios tbody tr").each(function(){
			var existe = false;
			$(this).each(function(){
				if($(this).text().toLowerCase().indexOf(texto.toLowerCase()) >= 0)
				{
					existe = true;
				}
			});

			if(existe == true)
				$(this).show();
			else
				$(this).hide();
		});
	}

	function buscarTablaResponsive(texto)
	{
		$("#table_usuarios_responsive tbody").each(function(){
			var existe = false;
			$(this).each(function(){
				if($(this).text().toLowerCase().indexOf(texto.toLowerCase()) >= 0)
				{
					existe = true;
				}
			});

			if(existe == true)
				$(this).show();
			else
				$(this).hide();
		});
	}

	getMedicos(0, "");
	getMedicosResponsive(0, "");

	$(document).on("click", ".btnEstado", function(e){
		e.preventDefault();

		if($(this).hasClass("Activo"))
			updateEstadoUser("../../updateEstado/" + atob($(this).prop("name")) + "/0", $(".u" + atob($(this).prop("name"))));
		else
			updateEstadoUser("../../updateEstado/" + atob($(this).prop("name")) + "/1", $(".u" + atob($(this).prop("name"))));
	});

	$(document).on("click", ".btnRenovar", function(e){
		e.preventDefault();
		updateLicencia(atob($(this).prop("name")));
	});

	$(document).on("keyup", "#txtBuscar", function(){
		getMedicos(0, $(this).val());
	});
	
	$(document).on("keyup", "#txtBuscarRes", function(){
		getMedicosResponsive(0, $(this).val());
	});

	$(document).on("click", "#tablaMedicos .paginacion .page-link", function(e){
		e.preventDefault();
		pag = $(this).prop("id");
		getMedicos(pag, $("#txtBuscar").val());
	});

	$(document).on("click", "#tablaMedicosResponsive .paginacion_responsive .page-link", function(e){
		e.preventDefault();
		pagRes = $(this).prop("id");
		getMedicosResponsive(pagRes, $("#txtBuscarRes").val());
	});

});