$(document).ready(function () {
  function getParameterByName(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]')
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)'),
      results = regex.exec(location.search)
    return results === null
      ? ''
      : decodeURIComponent(results[1].replace(/\+/g, ' '))
  }

  function getPacienteByCedula() {
    var dat = {
      idMedico: idMed,
      buscar: $('#inputBuscarPaciente').val(),
    }

    $.ajax({
      data: dat,
      url: $('#frmPaciente').attr('action'),
      method: 'POST',
      success: function (datos) {
        $('#infoPacientes').html(datos)
        $('#modalBuscarPaciente').modal('show')
      },
      error: function (error) {
        console.log(error)
      },
    })
  }

  function getPacienteById(id) {
    var dat = {}

    $.ajax({
      data: dat,
      url: $('#infoPacientes').attr('data-url') + '/' + id,
      method: 'POST',
      dataType: 'JSON',
      success: function (datos) {
        console.log(datos)
        $('#inputPaciente').val(datos['idPaciente'])
        $('#inputNombrePaciente').val(datos['nombre'])
        var arreglo = datos['fechaNacimiento'].split('-', 3)
        $('#inputAnioPaciente').val(arreglo[0])
        $('#inputMesPaciente').val(arreglo[1])
        $('#inputDiaPaciente').val(arreglo[2])
        $('#inputEdadPaciente').val(datos['edad'])
        $('#inputSexoPaciente').val(datos['genero'])
        $('#inputDNIPaciente').val(datos['cedula'])
        $('#inputProvinciaPaciente').val(datos['provincia_nombre'])
        $('#inputCantonPaciente').val(datos['canton_nombre'])
        $('#inputParroquiaPaciente').val(datos['parroquia_nombre'])
        $('#inputDireccionPaciente').val(datos['direccion'])
        $('#inputTelefonoPaciente').val(datos['celular'])
        $('#inputNombreProfesional2').val(datos['medico'])
        $('#inputNombreProfesional').val(datos['medico'])
        $('#inputMsp2').val(datos['codigoMedico'])
        $('#inputMsp').val(datos['codigoMedico'])
        $('#inputNombreProfesional2').val(datos['nombreMedico'])
        $('#inputNombreProfesional').val(datos['nombreMedico'])
        
        
        /* $('#lblApellidosPac').text(datos['apellido'])
        $('#lblNombresPac').text(datos['nombre'])
        $('#lblEdadPac').text(datos['edad'] + ' años')
        $('.lblCedulaPaciente').text(datos['cedula'])
        $('.lblPaciente').text(datos['apellido'] + ' ' + datos['nombre']) */
      },
      error: function (error) {
        console.log(error)
      },
    })
  }

  function subirImagenForm() {
    var parametros = new FormData($('#frmFormulario024')[0])

    $.ajax({
      data: parametros,
      url: $('#flGrafico').attr('data-url'),
      method: 'POST',
      contentType: false,
      processData: false,
      success: function (datos) {
        if (datos === 'nok') {
          alert(
            'No se ha podido subir la imagen, compruebe que el peso de está no se mayor a 2 megas.',
          )
          $('flGrafico').val('')
        } else {
          $('#imgGrafico').prop('src', url_global + datos)
          $('#imgGrafico').removeClass('d0')
          $('#inputGrafico').val(datos)
        }
      },
      error: function (error) {
        console.log(error)
        $('#errores').html(error.responseText)
      },
    })
  }

  $('#frmPaciente').on('submit', function (e) {
    e.preventDefault()
    getPacienteByCedula()
  })

  $(document).on('click', '.btnSelectPaciente', function (e) {
    e.preventDefault()
    $('#modalBuscarPaciente').modal('hide')
    getPacienteById(atob($(this).prop('id')))
  })

  $('#chkAcepta').change(function () {
    if ($(this).prop('checked')) {
      $('.negativa').hide()
      $('.declaracion').slideDown()
      $('#inputNomTestigo').val('')
      $('#inputCedTestigo').val('')
      $('#inputRpNomN').val('')
      $('#inputRpCedN').val('')
      $('#inputRpParenN').val('')
    } else {
      $('.declaracion').hide()
      $('.negativa').slideDown()
      $('#inputRpNomA').val('')
      $('#inputRpCedA').val('')
      $('#inputRpParenA').val('')
    }
  })

  $(document).on('change', '#flGrafico', function () {
    if ($('#inputPaciente').val() != 0) subirImagenForm()
    else {
      alert('Seleccione primero un paciente para el consentimiento informado.')
      $(this).val('')
    }
  })

  $(document).on('click', '#radio1', function(e){
    $(".uno").removeClass("d-none");
    $(".dos").addClass("d-none");
  })

  $(document).on('click', '#radio2', function(e){
    $(".uno").removeClass("d-none");
    $(".dos").addClass("d-none");
  })

  $(document).on('click', '#radio3', function(e){
    $(".dos").removeClass("d-none");
    $(".uno").addClass("d-none");
  })

  $(document).on('click', '#radio4', function(e){
    $(".dos").removeClass("d-none");
    $(".uno").addClass("d-none");
  })

  function radio(){
    if( $("#frmFormulario053 input[id = 'radio1']:radio").is(':checked') || $("#frmFormulario053 input[id = 'radio2']:radio").is(':checked') ){
      $(".uno").removeClass("d-none");
      $(".dos").addClass("d-none");
    } else if ( $("#frmFormulario053 input[id = 'radio3']:radio").is(':checked') || $("#frmFormulario053 input[id = 'radio4']:radio").is(':checked')){
      $(".dos").removeClass("d-none");
      $(".uno").addClass("d-none");
    }
  }

  radio();

  $("#btnPrueba").click(function(){
    alert($('input:radio[name=radio]:checked').val());
    alert($('input:checkbox[name=check]:checked').val());
  })

  $("#check5").change(function(){
    if($(this).prop('checked') == true){
      $("#inputOtroMotivoReferencia").prop("disabled", false);
    }else{
      $("#inputOtroMotivoReferencia").prop("disabled", true);
    }
  })

})
