$(document).ready(function(){

	function getParameterByName(name) {
	    name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
	    var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
	    results = regex.exec(location.search);
	    return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
	}

	function getCmbCie10()
	{
		$.ajax({
			data: {},
			url: $("#cmbCieDiez").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbCieDiez").html(datos);
				$(function() {
					$.widget( "custom.combobox", {
						_create: function() {
							this.wrapper = $( "<span class='form-control p-0'>" )
							.insertAfter( this.element );

							this.element.hide();
							this._createAutocomplete();
							//this._createShowAllButton();
						},

						_createAutocomplete: function() {
							var selected = this.element.children( ":selected" ),
							value = selected.val() ? selected.text() : "";

							if($("#inputForm").val() != 0)
							{
								this.input = $( "<input id='inputCie10' disabled>" )
								.appendTo( this.wrapper )
								.val( value )
								.attr( "title", "" )
								.addClass("form-control")
								.prop("placeholder", "")
								.autocomplete({
									delay: 0,
									minLength: 3,
									source: $.proxy( this, "_source" )
								})
								.tooltip({
									classes: {
									"ui-tooltip": "ui-state-highlight"
									}
								});
							}
							else
							{
								this.input = $( "<input id='inputCie10' required>" )
								.appendTo( this.wrapper )
								.val( value )
								.attr( "title", "" )
								.addClass("form-control")
								.prop("placeholder", "")
								.autocomplete({
									delay: 0,
									minLength: 3,
									source: $.proxy( this, "_source" )
								})
								.tooltip({
									classes: {
									"ui-tooltip": "ui-state-highlight"
									}
								});
							}

							this._on( this.input, {
								autocompleteselect: function( event, ui ) {
									ui.item.option.selected = true;
									this._trigger( "select", event, {
										item: ui.item.option
									});
								},
								autocompletechange: "_removeIfInvalid"
							});
						},

						_source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( this.element.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text,
									value: text,
									option: this
								};
							}) );
						},

						_removeIfInvalid: function( event, ui ) {

							// Selected an item, nothing to do
							if ( ui.item ) {
								return;
							}

							// Search for a match (case-insensitive)
							var value = this.input.val(),
							valueLowerCase = value.toLowerCase(),
							valid = false;
							this.element.children( "option" ).each(function() {
								if ( $( this ).text().toLowerCase() === valueLowerCase ) {
									this.selected = valid = true;
									return false;
								}
							});

							// Found a match, nothing to do
							if ( valid ) {
								return;
							}

							// Remove invalid value
							this.input
							.val("")
							.attr( "title", value + " no coincide con ningún elemento" )
							.tooltip( "open" );
							this.element.val( "" );
							this._delay(function() {
								this.input.tooltip( "close" ).attr( "title", "" );
							}, 2500 );
							this.input.autocomplete( "instance" ).term = "";
						},

						_destroy: function() {
							this.wrapper.remove();
							this.element.show();
						}
					});

					$( "#cmbCieDiez" ).combobox();
				});

				if($("#inputForm").val() != 0)
				{
					$("#cmbCieDiez").val(idCie);
					$("#inputCie10").val($("#cmbCieDiez option:selected").text());
				}
			}
		})
	}

	function getPacienteByCedula()
	{
		var dat = {
			idMedico: idMed,
			buscar: $("#inputBuscarPaciente").val()
		};

		$.ajax({
			data: dat,
			url: $("#frmPaciente").attr("action"),
			method: "POST",
			success: function(datos){
				$("#infoPacientes").html(datos);
				$("#modalBuscarPaciente").modal("show");
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function getPacienteById(id)
	{
		var dat = {};

		$.ajax({
			data: dat,
			url: $("#infoPacientes").attr("data-url") + "/" + id,
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				console.log(datos)
				$("#inputPaciente").val(datos["idPaciente"]);
				$("#lblApellidosPac").text(datos["apellido"]);
				$("#lblNombresPac").text(datos["nombre"]);
				$("#lblEdadPac").text(datos["edad"] + " años");
				$(".lblCedulaPaciente").text(datos["cedula"]);
				$(".lblPaciente").text(datos["apellido"] + " " + datos["nombre"]);
			},
			error: function(error){
				console.log(error);
			}
		})
	}

	function subirImagenForm()
	{
		var parametros = new FormData($("#frmFormulario024")[0]);

		$.ajax({
			data: parametros,
			url: $("#flGrafico").attr("data-url"),
			method: "POST",
			contentType: false,
			processData: false,
			success: function(datos){
				if(datos === "nok")
				{
					alert("No se ha podido subir la imagen, compruebe que el peso de está no se mayor a 2 megas.");
					$("flGrafico").val("");
				}
				else
				{
					$("#imgGrafico").prop("src", url_global + datos);
					$("#imgGrafico").removeClass("d0");
					$("#inputGrafico").val(datos);
				}
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	getCmbCie10();

	$("#frmPaciente").on("submit", function(e){
		e.preventDefault();
		getPacienteByCedula();
	});

	$(document).on("click", ".btnSelectPaciente", function(e){
		e.preventDefault();
		$("#modalBuscarPaciente").modal("hide");
		getPacienteById(atob($(this).prop("id")));
	});

	$("#chkAcepta").change(function(){
		if($(this).prop("checked"))
		{
			$(".negativa").hide();
			$(".declaracion").slideDown();
			$("#inputNomTestigo").val("");
			$("#inputCedTestigo").val("");
			$("#inputRpNomN").val("");
			$("#inputRpCedN").val("");
			$("#inputRpParenN").val("");
		}
		else
		{
			$(".declaracion").hide();
			$(".negativa").slideDown();
			$("#inputRpNomA").val("");
			$("#inputRpCedA").val("");
			$("#inputRpParenA").val("");
		}
	});

	$(document).on("change", "#flGrafico", function(){
		if($("#inputPaciente").val() != 0)
			subirImagenForm();
		else
		{
			alert("Seleccione primero un paciente para el consentimiento informado.");
			$(this).val("");
		}
	});
	
});