$(document).ready(function(){

	var iva = 0;
	var descuento = 0;
	var cont = 0;

	$("#inputNombres").val(nombPaciente);
	$("#inputIdentificacion").val(idenPaciente);
	$("#inputTelefono").val(telfPaciente);
	$("#inputDireccion").val(dirPaciente);
	$("#inputEmail").val(emailPaciente);
	$("#cmbTipoIden").val(tipoIdenPaciente);

	function agregar_campos()
	{
		var precio = parseFloat($("#inputValor").val());
		var impuesto = parseFloat($("#inputIva").val());
		var desc = parseFloat($("#inputValorDescuento").val());
		var porIva = "NO";
		var porDes = "";

		var total = precio;
		if($("#chkIva").prop("checked"))
		{
			total = total + impuesto;
			porIva = $("#cmbIva").val();
		}

		if($("#chkDescuento").prop("checked"))
		{
			total = total - desc;
			porDes = $("#inputDescuento").val();
		}
		
		var fila = "<tr>"
			+"<td><label class='m-0 lblCont'></label><input type='hidden' class='inputCodAux' name='inputCodAux[]'></td>"
			+"<td>"
				+$("#inputDescripcion").val()+"<input type='hidden' name='inputDetDescrip[]' value='"+$("#inputDescripcion").val()+"'>"
			+"</td>"
			+"<td>"
				+"1<input type='hidden' name='inputDetCant[]' value='1'>"
			+"</td>"
			+"<td>"
				+$("#inputValor").val()+"<input type='hidden' name='inputDetVal[]' value='"+$("#inputValor").val()+"'>"
			+"</td>"
			+"<td>"
				+$("#inputIva").val()
				+"<input type='hidden' name='inputDetIva[]' value='"+$("#inputIva").val()+"'>"
				+"<input type='hidden' name='inputDetPIva[]' value='"+porIva+"'>"
			+"</td>"
			+"<td>"
				+$("#inputValorDescuento").val()
				+"<input type='hidden' name='inputDetDesc[]' value='"+$("#inputValorDescuento").val()+"'>"
				+"<input type='hidden' name='inputDetPDes[]' value='"+porDes+"'>"
			+"</td>"
			+"<td>"
				+total.toFixed(2)+"<input type='hidden' name='inputDetTot[]' value='"+total.toFixed(2)+"'>"
			+"</td>"
			+"<td>"
				+"<button class='btnDetEliminar btn btn-sm btn-outline-danger'><span class='icon-minus'></span></button>"
			+"</td>"
		+"</tr>";
		$("#tbodyDetalle").append(fila);
		reordenar();
	}

	function reordenar()
	{
		var num = 1;
		cont = 0;
		$("#tbodyDetalle tr").each(function(){
			//$(this).find("td").eq(0).text(num);
			$(this).find(".lblCont").text(num);
			$(this).find(".inputCodAux").val(num);
			num++;
			cont++;
		});

		if(cont == 0)
			$("#frmFactura").addClass("d0");
		else
			$("#frmFactura").removeClass("d0");
	}

	function saveDetalleFactura()
	{
		var dat = new FormData($("#frmFactura")[0]);

		$.ajax({
			data: dat,
			url: $("#frmDetalleFactura").attr("action"),
			method: "POST",
			contentType: false,
			processData: false,
			success: function(response){
				if($("#chkFacturarOtro").prop("checked"))
				{
					saveFactura(response, $("#cmbTipoIden").val(), $("#inputNombres").val(), $("#inputIdentificacion").val(),
						$("#inputTelefono").val(), $("#inputDireccion").val(), $("#inputEmail").val());
				}
				else
				{
					saveFactura(response, tipoIdenPaciente, nombPaciente, idenPaciente, telfPaciente, 
						dirPaciente, emailPaciente);
				}
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function saveFactura(facturaMed, tipIdenClie, nomClie, idenClie, telfClie, dirClie, emailClie)
	{
		var dat = {
			factura: facturaMed,
			medReferido: $("#inputMedReferido").val(),
			promocion: $("#inputPromocion").val(),
			copago: $("#inputCopago").val(),
			titSeguro: $("#inputTitSeguro").val(),
			ambiente: ambienteFac,
			emision: emisionFac,
			claveAcceso: claveAccesoFac,
			tipoPago: $("#cmbTipoPago").val(),
			fechaEmision: fechaEmisionFac,
			tipIdenClie: tipIdenClie,
			nomClie: nomClie,
			idenClie: idenClie,
			telfClie: telfClie,
			dirClie: dirClie,
			emailClie: emailClie,
			plazo: 0,
			uniTiempo: "días",
		};

		$.ajax({
			data: dat,
			url: $("#frmFactura").attr("action"),
			method: "POST",
			success: function(datos){
				window.location = urlSalida + "/" + datos + "/" + btoa(facturaMed);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}
	
	$(document).on("change", "#chkIva", function(){
		if($(this).prop("checked"))
		{
			$("#inputIva").removeClass("d0");
			$("#cmbIva").removeClass("d0");
			
			iva = parseFloat($("#inputValor").val() * ($("#cmbIva").val() / 100)).toFixed(2);
			$("#inputIva").val(iva);
		}
		else
		{
			$("#inputIva").addClass("d0");
			$("#cmbIva").addClass("d0");
			$("#inputIva").val("");
		}
	});

	$(document).on("change", "#chkDescuento", function(){
		if($(this).prop("checked"))
		{
			$(".elemDescuento").removeClass("d0");
			$("#inputDescuento").prop("required", true);

			descuento = parseFloat($("#inputValor").val()) * (parseFloat($("#inputDescuento").val())/100);
			$("#inputValorDescuento").val(descuento.toFixed(2));
		}
		else
		{
			$(".elemDescuento").addClass("d0");
			$("#inputDescuento").prop("required", false);
			$("#inputDescuento").val("0");
			$("#inputValorDescuento").val("");
		}
	});

	$("#cmbIva").change(function(){
		iva = parseFloat($("#inputValor").val() * ($("#cmbIva").val() / 100)).toFixed(2);
		$("#inputIva").val(iva);
	});

	$("#inputValor").keyup(function(){
		if($("#chkIva").prop("checked"))
		{
			iva = parseFloat($("#inputValor").val() * ($("#cmbIva").val() / 100)).toFixed(2);
			$("#inputIva").val(iva);
		}

		if($("#chkDescuento").prop("checked"))
		{
			descuento = parseFloat($("#inputValor").val()) * (parseFloat($("#inputDescuento").val())/100);
			$("#inputValorDescuento").val(descuento.toFixed(2));
		}
	});

	$("#inputDescuento").keyup(function(){
		if($("#inputValor").val().length > 0)
		{
			descuento = parseFloat($("#inputValor").val()) * (parseFloat($(this).val())/100);
			$("#inputValorDescuento").val(descuento.toFixed(2));
		}
	});

	$("#chkFacturarOtro").change(function(){
		if($(this).prop("checked"))
		{
			$(".inputCli").prop("disabled", false);
			$(".inputCli").prop("required", true);
			$("#inputNombres").val("");
			$("#inputIdentificacion").val("");
			$("#inputTelefono").val("");
			$("#inputDireccion").val("");
			$("#inputEmail").val("");
		}
		else
		{
			$(".inputCli").prop("disabled", true);
			$(".inputCli").prop("required", false);
			$("#inputNombres").val(nombPaciente);
			$("#inputIdentificacion").val(idenPaciente);
			$("#inputTelefono").val(telfPaciente);
			$("#inputDireccion").val(dirPaciente);
			$("#inputEmail").val(emailPaciente);
			$("#cmbTipoIden").val(tipoIdenPaciente);

			if(tipoIdenPaciente == "CED")
			{
				$("#inputIdentificacion").attr("minlength", "1");
				$("#inputIdentificacion").prop("maxlength", 10);
				$("#inputIdentificacion").removeClass("sln");
				$("#inputIdentificacion").addClass("sn");
			}
			else if(tipoIdenPaciente == "RUC")
			{
				$("#inputIdentificacion").attr("minlength", "13");
				$("#inputIdentificacion").prop("maxlength", 13);
				$("#inputIdentificacion").removeClass("sln");
				$("#inputIdentificacion").addClass("sn");
			}
			else if(tipoIdenPaciente == "PAS")
			{
				$("#inputIdentificacion").attr("minlength", "15");
				$("#inputIdentificacion").prop("maxlength", 20);
				$("#inputIdentificacion").removeClass("sn");
				$("#inputIdentificacion").addClass("sln");
			}
		}
	});

	$("#cmbTipoIden").change(function(){
		if($(this).val() == "CED")
		{
			$("#inputIdentificacion").attr("minlength", "1");
			$("#inputIdentificacion").prop("maxlength", 10);
			$("#inputIdentificacion").removeClass("sln");
			$("#inputIdentificacion").addClass("sn");
			$("#inputIdentificacion").val("");
		}
		else if($(this).val() == "RUC")
		{
			$("#inputIdentificacion").attr("minlength", "13");
			$("#inputIdentificacion").prop("maxlength", 13);
			$("#inputIdentificacion").removeClass("sln");
			$("#inputIdentificacion").addClass("sn");
			$("#inputIdentificacion").val("");
		}
		else if($(this).val() == "PAS")
		{
			$("#inputIdentificacion").attr("minlength", "15");
			$("#inputIdentificacion").prop("maxlength", 20);
			$("#inputIdentificacion").removeClass("sn");
			$("#inputIdentificacion").addClass("sln");
			$("#inputIdentificacion").val("");
		}
	})

	$("#frmDetalleFactura").on("submit", function(e){
		e.preventDefault();
		agregar_campos();
		$("#inputDescripcion").val("");
		$("#inputValor").val("");
		$("#inputIva").val("");
		$("#inputDescuento").val("0");
		$("#inputValorDescuento").val("");
	});

	$(document).on("click", ".btnDetEliminar", function(){
		$(this).closest("tr").remove();
		reordenar();
	});

	$("#frmFactura").on("submit", function(e){
		e.preventDefault();

		if($("#chkFacturarOtro").prop("checked"))
			$("#btnOculto").click();
		else
			saveDetalleFactura();
	});

	$("#frmInfoCliente").on("submit", function(e){
		e.preventDefault();
		saveDetalleFactura();
	});
});