$(document).ready(function(){

	function getCmbImagen()
	{
		$.ajax({
			data: {},
			url: $("#cmbImagen").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbImagen").html(datos);
				$(function() {
					$.widget( "custom.combobox", {
						_create: function() {
							this.wrapper = $( "<span class='form-control p-0'>" )
							.insertAfter( this.element );

							this.element.hide();
							this._createAutocomplete();
							//this._createShowAllButton();
						},

						_createAutocomplete: function() {
							var selected = this.element.children( ":selected" ),
							value = selected.val() ? selected.text() : "";

							this.input = $( "<input id='inputImagen' required>" )
							.appendTo( this.wrapper )
							.val( value )
							.attr( "title", "" )
							.addClass("form-control")
							.prop("placeholder", "")
							.autocomplete({
								delay: 0,
								minLength: 3,
								classes: {
									"ui-autocomplete": "ui-id-img-2"
								},
								source: $.proxy( this, "_source" )
							})
							.tooltip({
								classes: {
								"ui-tooltip": "ui-state-highlight"
								}
							});

							this._on( this.input, {
								autocompleteselect: function( event, ui ) {
									ui.item.option.selected = true;
									this._trigger( "select", event, {
										item: ui.item.option
									});
								},
								autocompletechange: "_removeIfInvalid"
							});
						},

						_source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( this.element.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text,
									value: text,
									option: this
								};
							}) );
						},

						_removeIfInvalid: function( event, ui ) {

							// Selected an item, nothing to do
							if ( ui.item ) {
								return;
							}

							// Search for a match (case-insensitive)
							var value = this.input.val(),
							valueLowerCase = value.toLowerCase(),
							valid = false;
							this.element.children( "option" ).each(function() {
								if ( $( this ).text().toLowerCase() === valueLowerCase ) {
									this.selected = valid = true;
									return false;
								}
							});

							// Found a match, nothing to do
							if ( valid ) {
								return;
							}

							// Remove invalid value
							/*this.input
							.val("")
							.attr( "title", value + " no coincide con ningún elemento" )
							.tooltip( "open" );
							this.element.val( "" );
							this._delay(function() {
								this.input.tooltip( "close" ).attr( "title", "" );
							}, 2500 );
							this.input.autocomplete( "instance" ).term = "";*/

							this.element.val("");
							this.input.autocomplete( "instance" ).term = "";
						},

						_destroy: function() {
							this.wrapper.remove();
							this.element.show();
						}
					});

					$( "#cmbImagen" ).combobox();
				});
			}
		})
	}

	function getCmbMedicamento()
	{
		$.ajax({
			data: {},
			url: $("#cmbMedicamento").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbMedicamento").html(datos);
				$(function() {
					$.widget( "custom.combobox", {
						_create: function() {
							this.wrapper = $( "<span class='form-control p-0'>" )
							.insertAfter( this.element );

							this.element.hide();
							this._createAutocomplete();
							//this._createShowAllButton();
						},

						_createAutocomplete: function() {
							var selected = this.element.children( ":selected" ),
							value = selected.val() ? selected.text() : "";

							this.input = $( "<input id='inputMedicamento' required>" )
							.appendTo( this.wrapper )
							.val( value )
							.attr( "title", "" )
							.addClass("form-control")
							.prop("placeholder", "")
							.autocomplete({
								delay: 0,
								minLength: 3,
								source: $.proxy( this, "_source" )
							})
							.tooltip({
								classes: {
								"ui-tooltip": "ui-state-highlight"
								}
							});

							this._on( this.input, {
								autocompleteselect: function( event, ui ) {
									ui.item.option.selected = true;
									this._trigger( "select", event, {
										item: ui.item.option
									});
								},
								autocompletechange: "_removeIfInvalid"
							});
						},

						_source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( this.element.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text,
									value: text,
									option: this
								};
							}) );
						},

						_removeIfInvalid: function( event, ui ) {

							// Selected an item, nothing to do
							if ( ui.item ) {
								return;
							}

							// Search for a match (case-insensitive)
							var value = this.input.val(),
							valueLowerCase = value.toLowerCase(),
							valid = false;
							this.element.children( "option" ).each(function() {
								if ( $( this ).text().toLowerCase() === valueLowerCase ) {
									this.selected = valid = true;
									return false;
								}
							});

							// Found a match, nothing to do
							if ( valid ) {
								return;
							}

							// Remove invalid value
							/*this.input
							.val("")
							.attr( "title", value + " no coincide con ningún elemento" )
							.tooltip( "open" );
							this.element.val( "" );
							this._delay(function() {
								this.input.tooltip( "close" ).attr( "title", "" );
							}, 2500 );
							this.input.autocomplete( "instance" ).term = "";*/

							this.element.val("");
							this.input.autocomplete( "instance" ).term = "";
						},

						_destroy: function() {
							this.wrapper.remove();
							this.element.show();
						}
					});

					$( "#cmbMedicamento" ).combobox();
				});
			}
		})
	}

	function getImagenConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#tableImagen").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapEvolucionImagen").removeClass("d-none");
					$("#wrapEvolucionImagen").addClass("d-block");
					$(".wrapIndicacionesEvoImagen").removeClass("d-none");
					$(".wrapIndicacionesEvoImagen").addClass("d-block");
				}
				else
				{
					$("#wrapEvolucionImagen").removeClass("d-block");
					$("#wrapEvolucionImagen").addClass("d-none");
					$(".wrapIndicacionesEvoImagen").removeClass("d-block");
					$(".wrapIndicacionesEvoImagen").addClass("d-none");
				}
				$("#tbodyImagen").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function getLaboratorioConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#tableLab").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapEvolucionLab").removeClass("d-none");
					$("#wrapEvolucionLab").addClass("d-block");
					$(".wrapIndicacionesEvoLab").removeClass("d-none");
					$(".wrapIndicacionesEvoLab").addClass("d-block");

				}
				else
				{
					$("#wrapEvolucionLab").removeClass("d-block");
					$("#wrapEvolucionLab").addClass("d-none");
					$(".wrapIndicacionesEvoLab").removeClass("d-block");
					$(".wrapIndicacionesEvoLab").addClass("d-none");
				}
				$("#tbodyLab").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function getComplementarioConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#tableComplem").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapEvolucionComple").removeClass("d-none");
					$("#wrapEvolucionComple").addClass("d-block");
					$(".wrapIndicacionesEvoComplem").removeClass("d-none");
					$(".wrapIndicacionesEvoComplem").addClass("d-block");

				}
				else
				{
					$("#wrapEvolucionComple").removeClass("d-block");
					$("#wrapEvolucionComple").addClass("d-none");
					$(".wrapIndicacionesEvoComplem").removeClass("d-block");
					$(".wrapIndicacionesEvoComplem").addClass("d-none");
				}
				$("#tbodyComplem").html(datos);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function getMedicamentosConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#tableMedicamento").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapEvoMedicamento").removeClass("d-none");
					$("#wrapEvoMedicamento").addClass("d-block");
				}
				else
				{
					$("#wrapEvoMedicamento").removeClass("d-block");
					$("#wrapEvoMedicamento").addClass("d-none");
				}
				$("#tbodyEvoMedicamento").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		})
	}

	function createImageConsulta(imagen)
	{
		var dat = {
			imagen: imagen,
			resumen: idResumenHistoria,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarImagen").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbImagen").val("");
				$("#inputImagen").val("");
				getImagenConsulta();

				$("#modalImagenMensaje").html("Examen Guardado");
	            $("#modalImagenImg").show();
	            $("#modalImagenMensaje").show();
	            setTimeout(ocultarMensajeImg, 1500);

	            if(isNaN(imagen) === true)
	            	getCmbImagen();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function createLaboratorioConsulta(laboratorio)
	{
		var dat = {
			laboratorio: laboratorio,
			resumen: idResumenHistoria,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#modalPedidoExamen").attr("data-url"),
			method: "POST",
			success: function(datos){
				getLaboratorioConsulta();

	            $("#modalExamenMensaje").html("Campo Guardado");
	            $("#modalExamenMensaje").show();                
	            $("#modalExamenImg").show();
	            setTimeout(ocultarMensaje, 1500);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function createComplementarioConsulta()
	{
		var dat = {
			resumen: idResumenHistoria,
			examen_compl: $("#inputExamCompl").val(),
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#frmPedidoCompl").attr("action"),
			method: "POST",
			success: function(datos){
				$("#inputExamCompl").val("");
				getComplementarioConsulta();

				$("#modalComplMensaje").html("Campo Guardado");
	            $("#modalComplMensaje").show();                
	            $("#modalComplImg").show();
	            setTimeout(ocultarMensajeCompl, 1500);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function createMedicamentoConsulta(medicamento)
	{
		var dat = {
			medicamento: medicamento,
			resumen: idResumenHistoria,
			cantidad: $("#inputCantidad").val(),
			indicaciones: $("#inputIndicacionMedicamento").val(),
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarMedicamento").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbMedicamento").val("");
				$("#inputMedicamento").val("");
				$("#inputCantidad").val("");
				$("#inputIndicacionMedicamento").val("");
				getMedicamentosConsulta();

				if(isNaN(medicamento) === true)
	            	getCmbMedicamento();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		})
	}

	function deleteImagenConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#tableImagen").attr("data-del"),
			method: "POST",
			success: function(datos){
				getImagenConsulta();	
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function deleteLaboratorioConsulta(id, resumenHc, idExaComple)
	{
		var dat = {
			id: id,
			resumenHc: resumenHc,
			idExaComple: idExaComple,
			tipoPedido: "EVOLUCION"
		};

		$.ajax({
			data: dat,
			url: $("#tableLab").attr("data-del"),
			method: "POST",
			success: function(datos){
				getLaboratorioConsulta();	
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function deleteComplementarioConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#tableComplem").attr("data-del"),
			method: "POST",
			success: function(datos){
				getComplementarioConsulta();
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function deleteMedicamentoConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarMedicamento").attr("data-del"),
			method: "POST",
			success: function(datos){
				getMedicamentosConsulta();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function readEvolucion()
	{
		var dat = {
			resumen: idResumenHistoria
		};

		$.ajax({
			data: dat,
			url: $("#divEvolucion").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#divEvolucion").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function createEvolucion(pre_sist, pre_dias, fre_card, fre_resp, tem_buca, tem_axil, peso_kg, peso_lb, talla_cm, 
		indic_mc, peri_cef, sat_oxig, peri_abd, temp_alt, sig_vit, tip_sangre)
	{
		var dat = {
			resumen: idResumenHistoria,
			objetiva: $("#evoDos").val(),
			subjetiva: $("#evoUno").val(),
			apreciacion: $("#evoTres").val(),
			planes: $("#evoCuatro").val(),
			pre_sist: pre_sist,
			pre_dias: pre_dias,
			fre_card: fre_card,
			fre_resp: fre_resp,
			tem_buca: tem_buca,
			tem_axil: tem_axil,
			peso_kg: peso_kg,
			peso_lb: peso_lb,
			talla_cm: talla_cm,
			indic_mc: indic_mc,
			peri_cef: peri_cef,
			sat_oxig: sat_oxig,
			peri_abd: peri_abd,
			temp_alt: temp_alt,
			sig_vit: sig_vit,
			tip_sangre: tip_sangre
		};

		$.ajax({
			data: dat,
			url: $("#frmNewEvolucion").attr("action"),
			method: "POST",
			success: function(datos){
				readEvolucion();
				$("#evoDos").val("");
				$("#evoUno").val("");
				$("#evoTres").val("");
				$("#evoCuatro").val("");
				$("#divSigVitEvo").addClass("d-none");
				$(".inputSVE").val("");
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getSignosVitalesEvolucion(id)
	{
		var dat = {
			id: atob(id)
		};

		$.ajax({
			data: dat,
			url: $("#divEvolucion").attr("data-sig-vit"),
			method: "POST",
			success: function(datos){
				$("#tableModalSigVitEvo").html(datos);
				$("#modalSigVitEvolucion").modal("show");
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function createExamenLab()
	{
		var dat = {
			nombreExamen: $("#inputExamLab").val()
		};

		$.ajax({
			data: dat,
			url: $("#frmNewExaLab").attr("action"),
			method: "POST",
			success: function(){
				$("#inputExamLab").val("");
				getExamenesLab();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}
	
	$(document).on("focus", "#inputImagen", function(){
		$(".ui-id-img-2").css({"z-index": 9999});
		$(".ui-id-img-2").appendTo($("#modalPedidoImagen"));
	});

	readEvolucion();
	getCmbImagen();
	getCmbMedicamento();
	getImagenConsulta();
	getLaboratorioConsulta();
	getComplementarioConsulta();
	getMedicamentosConsulta();

	$("#chkSVEvo").change(function(){
		if($(this).prop("checked"))
			$("#divSigVitEvo").removeClass("d-none");
		else
			$("#divSigVitEvo").addClass("d-none");
	});

	$(document).on("submit", "#frmNewEvolucion", function(e){
		e.preventDefault();
		if($("#chkSVEvo").prop("checked"))
		{
			createEvolucion($("#inputPreSisto").val(), $("#inputPreDiasto").val(), $("#inputFreCard").val(), 
				$("#inputFreResp").val(), $("#inputTemBucal").val(), $("#inputTemAxilar").val(), 
				$("#inputPesoKg").val(), $("#inputPesoLb").val(), $("#inputTalla").val(), 
				$("#inputIMC").val(), $("#inputPerCefali").val(), $("#inputSatOxig").val(),
				$("#inputPerAbdom").val(), $("#inputTempAlt").val(), "si", $("#inputTipoSangre").val());
		}
		else
			createEvolucion("", "", "", "", "", "", "", "", "", "", "", "", "", "", "no", "");
	});

	$(document).on("submit", "#frmPedidoImagen", function(e){
		e.preventDefault();
		if($("#cmbImagen").val() == null || $("#cmbImagen").val() == "")
			createImageConsulta($("#inputImagen").val());
		else
			createImageConsulta(parseInt($("#cmbImagen").val()));
	});

	$(document).on("click", ".btnEliminarImagen", function(){
		deleteImagenConsulta(atob($(this).prop("id")));
	});

	$(document).on("change", ".chkLab", function(){
		if($(this).prop("checked"))
			createLaboratorioConsulta($(this).val());
		else
			deleteLaboratorioConsulta(0, idResumenHistoria, $(this).val());
	});

	$(document).on("click", ".btnEliminarLaboratorio", function(){
		deleteLaboratorioConsulta(atob($(this).prop("id")), 0, 0);
		$("#chkLab" + atob($(this).prop("id"))).prop("checked", false);
	});

	$(document).on("submit", "#frmPedidoCompl", function(e){
		e.preventDefault();
		createComplementarioConsulta();
	});

	$(document).on("click", ".btnEliminarComplem", function(){
		deleteComplementarioConsulta(atob($(this).prop("id")));
	});

	$(document).on("click", ".btnSigVitEvo", function(){
		getSignosVitalesEvolucion($(this).prop("id"));
	});

	$(document).on("submit", "#frmNewExaLab", function(e){
		e.preventDefault();
		createExamenLab();
	});

	$(document).on("submit", "#frmMedicamentos", function(e){
		e.preventDefault();
		if($("#cmbMedicamento").val() == "" || $("#cmbMedicamento").val() == null)
			createMedicamentoConsulta($("#inputMedicamento").val());
		else
			createMedicamentoConsulta(parseInt($("#cmbMedicamento").val()));
	});

	$(document).on("click", ".btnEliminarMedicamento", function(){
		deleteMedicamentoConsulta(atob($(this).prop("id")));
	});

});