$(document).ready(function(){

	var pag = 0;
	var pagRes = 0;

	function getTablaEspecialidades(pagina)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 20
			},
			url: "./list/",
			method: "POST",
			success: function(datos){
				$("#catalogEspecialidades").html(datos);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function getTablaEspecialidadesResponsive(pagina)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 5
			},
			url: "./listResp/",
			method: "POST",
			success: function(datos){
				$("#tablaEspecialidadesResponsive").html(datos);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function createEspecialidad()
	{
		var dat = {
			codigo: $("#inputCodigo").val(),
			nombre: $("#inputNombre").val()
		};

		$.ajax({
			data: dat,
			url: "./../store/",
			method: "POST",
			success: function(datos){
				window.location = $("#btnCancelar").prop("href");
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function updateEspecialidades()
	{
		var dat = {
			id: $("#inputId").val(),
			codigo: $("#inputCodigo").val(),
			nombre: $("#inputNombre").val()
		};

		$.ajax({
			data: dat,
			url: "./../update/",
			method: "POST",
			success: function(datos){
				window.location = $("#btnCancelar").prop("href");
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function deleteEspecialidades(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: "./delete/",
			method: "POST",
			success: function(datos){
				getTablaEspecialidades(pag);
				getTablaEspecialidadesResponsive(pagRes);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	getTablaEspecialidades(0);
	getTablaEspecialidadesResponsive(0);

	$("#frmNewEspecialidad").on("submit", function(e){
		e.preventDefault();
		createEspecialidad();
	});

	$("#frmEditEspecialidad").on("submit", function(e){
		e.preventDefault();
		updateEspecialidades();
	});

	$(document).on("click", ".btnEliminar", function(e){
		e.preventDefault();
		deleteEspecialidades(atob($(this).prop("name")));
	});

	$(document).on("click", "#catalogEspecialidades .paginacion .page-link", function(e){
		e.preventDefault();
		pag = $(this).prop("id");
		getTablaEspecialidades(pag);
	});

	$(document).on("click", "#tablaEspecialidadesResponsive .paginacion_responsive .page-link", function(e){
		e.preventDefault();
		pagRes = $(this).prop("id");
		getTablaEspecialidadesResponsive(pagRes);
	});

});