$(document).ready(function(){

	function getCmbCie10()
	{
		$.ajax({
			data: {},
			url: $("#cmbCieDiez").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbCieDiez").html(datos);
				$(function() {
					$.widget( "custom.combobox", {
						_create: function() {
							this.wrapper = $( "<span class='form-control p-0'>" )
							.insertAfter( this.element );

							this.element.hide();
							this._createAutocomplete();
							//this._createShowAllButton();
						},

						_createAutocomplete: function() {
							var selected = this.element.children( ":selected" ),
							value = selected.val() ? selected.text() : "";

							this.input = $( "<input id='inputCie10' required>" )
							.appendTo( this.wrapper )
							.val( value )
							.attr( "title", "" )
							.addClass("form-control")
							.prop("placeholder", "")
							.autocomplete({
								delay: 0,
								minLength: 3,
								source: $.proxy( this, "_source" )
							})
							.tooltip({
								classes: {
								"ui-tooltip": "ui-state-highlight"
								}
							});

							this._on( this.input, {
								autocompleteselect: function( event, ui ) {
									ui.item.option.selected = true;
									this._trigger( "select", event, {
										item: ui.item.option
									});
								},
								autocompletechange: "_removeIfInvalid"
							});
						},

						_source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( this.element.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text,
									value: text,
									option: this
								};
							}) );
						},

						_removeIfInvalid: function( event, ui ) {

							// Selected an item, nothing to do
							if ( ui.item ) {
								return;
							}

							// Search for a match (case-insensitive)
							var value = this.input.val(),
							valueLowerCase = value.toLowerCase(),
							valid = false;
							this.element.children( "option" ).each(function() {
								if ( $( this ).text().toLowerCase() === valueLowerCase ) {
									this.selected = valid = true;
									return false;
								}
							});

							// Found a match, nothing to do
							if ( valid ) {
								return;
							}

							// Remove invalid value
							this.input
							.val("")
							.attr( "title", value + " no coincide con ningún elemento" )
							.tooltip( "open" );
							this.element.val( "" );
							this._delay(function() {
								this.input.tooltip( "close" ).attr( "title", "" );
							}, 2500 );
							this.input.autocomplete( "instance" ).term = "";
						},

						_destroy: function() {
							this.wrapper.remove();
							this.element.show();
						}
					});

					$( "#cmbCieDiez" ).combobox();
				});
			}
		})
	}

	function getCmbImagen()
	{
		$.ajax({
			data: {},
			url: $("#cmbImagen").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbImagen").html(datos);
				$(function() {
					$.widget( "custom.combobox", {
						_create: function() {
							this.wrapper = $( "<span class='form-control p-0'>" )
							.insertAfter( this.element );

							this.element.hide();
							this._createAutocomplete();
							//this._createShowAllButton();
						},

						_createAutocomplete: function() {
							var selected = this.element.children( ":selected" ),
							value = selected.val() ? selected.text() : "";

							this.input = $( "<input id='inputImagen' required>" )
							.appendTo( this.wrapper )
							.val( value )
							.attr( "title", "" )
							.addClass("form-control")
							.prop("placeholder", "")
							.autocomplete({
								delay: 0,
								minLength: 3,
								classes: {
									"ui-autocomplete": "ui-id-img-1"
								},
								source: $.proxy( this, "_source" )
							})
							.tooltip({
								classes: {
								"ui-tooltip": "ui-state-highlight"
								}
							});

							this._on( this.input, {
								autocompleteselect: function( event, ui ) {
									ui.item.option.selected = true;
									this._trigger( "select", event, {
										item: ui.item.option
									});
								},
								autocompletechange: "_removeIfInvalid"
							});
						},

						_source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( this.element.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text,
									value: text,
									option: this
								};
							}) );
						},

						_removeIfInvalid: function( event, ui ) {

							// Selected an item, nothing to do
							if ( ui.item ) {
								return;
							}

							// Search for a match (case-insensitive)
							var value = this.input.val(),
							valueLowerCase = value.toLowerCase(),
							valid = false;
							this.element.children( "option" ).each(function() {
								if ( $( this ).text().toLowerCase() === valueLowerCase ) {
									this.selected = valid = true;
									return false;
								}
							});

							// Found a match, nothing to do
							if ( valid ) {
								return;
							}

							// Remove invalid value
							/*this.input
							.val("")
							.attr( "title", value + " no coincide con ningún elemento" )
							.tooltip( "open" );
							this.element.val( "" );
							this._delay(function() {
								this.input.tooltip( "close" ).attr( "title", "" );
							}, 2500 );
							this.input.autocomplete( "instance" ).term = "";*/

							this.element.val("");
							this.input.autocomplete( "instance" ).term = "";
						},

						_destroy: function() {
							this.wrapper.remove();
							this.element.show();
						}
					});

					$( "#cmbImagen" ).combobox();
				});
			}
		})
	}

	function getCmbMedicamento()
	{
		$.ajax({
			data: {},
			url: $("#cmbMedicamento").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbMedicamento").html(datos);
				$(function() {
					$.widget( "custom.combobox", {
						_create: function() {
							this.wrapper = $( "<span class='form-control p-0'>" )
							.insertAfter( this.element );

							this.element.hide();
							this._createAutocomplete();
							//this._createShowAllButton();
						},

						_createAutocomplete: function() {
							var selected = this.element.children( ":selected" ),
							value = selected.val() ? selected.text() : "";

							this.input = $( "<input id='inputMedicamento' required>" )
							.appendTo( this.wrapper )
							.val( value )
							.attr( "title", "" )
							.addClass("form-control")
							.prop("placeholder", "")
							.autocomplete({
								delay: 0,
								minLength: 3,
								source: $.proxy( this, "_source" )
							})
							.tooltip({
								classes: {
								"ui-tooltip": "ui-state-highlight"
								}
							});

							this._on( this.input, {
								autocompleteselect: function( event, ui ) {
									ui.item.option.selected = true;
									this._trigger( "select", event, {
										item: ui.item.option
									});
								},
								autocompletechange: "_removeIfInvalid"
							});
						},

						_source: function( request, response ) {
							var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
							response( this.element.children( "option" ).map(function() {
								var text = $( this ).text();
								if ( this.value && ( !request.term || matcher.test(text) ) )
								return {
									label: text,
									value: text,
									option: this
								};
							}) );
						},

						_removeIfInvalid: function( event, ui ) {

							// Selected an item, nothing to do
							if ( ui.item ) {
								return;
							}

							// Search for a match (case-insensitive)
							var value = this.input.val(),
							valueLowerCase = value.toLowerCase(),
							valid = false;
							this.element.children( "option" ).each(function() {
								if ( $( this ).text().toLowerCase() === valueLowerCase ) {
									this.selected = valid = true;
									return false;
								}
							});

							// Found a match, nothing to do
							if ( valid ) {
								return;
							}

							// Remove invalid value
							/*this.input
							.val("")
							.attr( "title", value + " no coincide con ningún elemento" )
							.tooltip( "open" );
							this.element.val( "" );
							this._delay(function() {
								this.input.tooltip( "close" ).attr( "title", "" );
							}, 2500 );
							this.input.autocomplete( "instance" ).term = "";*/

							this.element.val("");
							this.input.autocomplete( "instance" ).term = "";
						},

						_destroy: function() {
							this.wrapper.remove();
							this.element.show();
						}
					});

					$( "#cmbMedicamento" ).combobox();
				});
			}
		})
	}

	$(document).on("focus", "#inputImagen", function(){
		$(".ui-id-img-1").css({"z-index": 9999});
		$(".ui-id-img-1").appendTo($("#modalPedidoImagen"));
	});

	function getDiagnosticoConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria
		};

		$.ajax({
			data: dat,
			url: $("#tableDiagnosticos").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapDiagnosticos").removeClass("d-none");
					$("#wrapDiagnosticos").addClass("d-block");
				}
				else
				{
					$("#wrapDiagnosticos").removeClass("d-block");
					$("#wrapDiagnosticos").addClass("d-none");
				}
				$("#tbodyDiagnosticos").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function getMedicamentosConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#tableMedicamento").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapMedicamento").removeClass("d-none");
					$("#wrapMedicamento").addClass("d-block");
				}
				else
				{
					$("#wrapMedicamento").removeClass("d-block");
					$("#wrapMedicamento").addClass("d-none");
				}
				$("#tbodyMedicamento").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		})
	}

	function getImagenConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#tableImagen").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapPedidoImagen").removeClass("d-none");
					$("#wrapPedidoImagen").addClass("d-block");
					$(".wrapIndicacionesImagen").removeClass("d-none");
					$(".wrapIndicacionesImagen").addClass("d-block");
				}
				else
				{
					$("#wrapPedidoImagen").removeClass("d-block");
					$("#wrapPedidoImagen").addClass("d-none");
					$(".wrapIndicacionesImagen").removeClass("d-block");
					$(".wrapIndicacionesImagen").addClass("d-none");
				}
				$("#tbodyImagen").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function getLaboratorioConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#tableLab").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapPedidoLab").removeClass("d-none");
					$("#wrapPedidoLab").addClass("d-block");
					$(".wrapIndicacionesLab").removeClass("d-none");
					$(".wrapIndicacionesLab").addClass("d-block");

				}
				else
				{
					$("#wrapPedidoLab").removeClass("d-block");
					$("#wrapPedidoLab").addClass("d-none");
					$(".wrapIndicacionesLab").removeClass("d-block");
					$(".wrapIndicacionesLab").addClass("d-none");
				}
				$("#tbodyLab").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function getComplementarioConsulta()
	{
		var dat = {
			resumenHc: idResumenHistoria,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#tableComplem").attr("data-url"),
			method: "POST",
			success: function(datos){
				if(datos != "")
				{
					$("#wrapPedidoComple").removeClass("d-none");
					$("#wrapPedidoComple").addClass("d-block");
					$(".wrapIndicacionesComplem").removeClass("d-none");
					$(".wrapIndicacionesComplem").addClass("d-block");

				}
				else
				{
					$("#wrapPedidoComple").removeClass("d-block");
					$("#wrapPedidoComple").addClass("d-none");
					$(".wrapIndicacionesComplem").removeClass("d-block");
					$(".wrapIndicacionesComplem").addClass("d-none");
				}
				$("#tbodyComplem").html(datos);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function createDiagnosticoConsulta()
	{
		var dat = {
			idCieDiez: $("#cmbCieDiez").val(),
			idTipoDiagnostico: $("#cmbTipoDiagnostico").val(),
			resumen: idResumenHistoria,
			diagnostico: $("#inputDiagnostico").val()
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarDiagnostico").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#inputDiagnostico").val("");
				$("#inputCie10").val("");
				$("#cmbCieDiez").val("");
				$("#cmbTipoDiagnostico").val("");
				getDiagnosticoConsulta();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function createMedicamentoConsulta(medicamento)
	{
		var dat = {
			medicamento: medicamento,
			resumen: idResumenHistoria,
			cantidad: $("#inputCantidad").val(),
			indicaciones: $("#inputIndicacionMedicamento").val(),
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarMedicamento").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbMedicamento").val("");
				$("#inputMedicamento").val("");
				$("#inputCantidad").val("");
				$("#inputIndicacionMedicamento").val("");
				getMedicamentosConsulta();

				if(isNaN(medicamento) === true)
	            	getCmbMedicamento();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		})
	}

	function createImageConsulta(imagen)
	{
		var dat = {
			imagen: imagen,
			resumen: idResumenHistoria,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarImagen").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#cmbImagen").val("");
				$("#inputImagen").val("");
				getImagenConsulta();

				$("#modalImagenMensaje").html("Examen Guardado");
	            $("#modalImagenImg").show();
	            $("#modalImagenMensaje").show();
	            setTimeout(ocultarMensajeImg, 1500);

	            if(isNaN(imagen) === true)
	            	getCmbImagen();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function createLaboratorioConsulta(laboratorio)
	{
		var dat = {
			laboratorio: laboratorio,
			resumen: idResumenHistoria,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#modalPedidoExamen").attr("data-url"),
			method: "POST",
			success: function(datos){
				getLaboratorioConsulta();

	            $("#modalExamenMensaje").html("Campo Guardado");
	            $("#modalExamenMensaje").show();                
	            $("#modalExamenImg").show();
	            setTimeout(ocultarMensaje, 1500);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function createComplementarioConsulta()
	{
		var dat = {
			resumen: idResumenHistoria,
			examen_compl: $("#inputExamCompl").val(),
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#frmPedidoCompl").attr("action"),
			method: "POST",
			success: function(datos){
				$("#inputExamCompl").val("");
				getComplementarioConsulta();

				$("#modalComplMensaje").html("Campo Guardado");
	            $("#modalComplMensaje").show();                
	            $("#modalComplImg").show();
	            setTimeout(ocultarMensajeCompl, 1500);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function deleteDiagnosticoConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#tableDiagnosticos").attr("data-del"),
			method: "POST",
			success: function(datos){
				getDiagnosticoConsulta();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		})
	}

	function deleteMedicamentoConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#btnAgregarMedicamento").attr("data-del"),
			method: "POST",
			success: function(datos){
				getMedicamentosConsulta();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function deleteImagenConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#tableImagen").attr("data-del"),
			method: "POST",
			success: function(datos){
				getImagenConsulta();	
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function deleteLaboratorioConsulta(id, resumenHc, idExaComple)
	{
		var dat = {
			id: id,
			resumenHc: resumenHc,
			idExaComple: idExaComple,
			tipoPedido: "CITA"
		};

		$.ajax({
			data: dat,
			url: $("#tableLab").attr("data-del"),
			method: "POST",
			success: function(datos){
				getLaboratorioConsulta();	
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function deleteComplementarioConsulta(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: $("#tableComplem").attr("data-del"),
			method: "POST",
			success: function(datos){
				getComplementarioConsulta();
			},
			error: function(error){
				console.log(error);
			}
		});
	}


	function createExamenLab()
	{
		var dat = {
			nombreExamen: $("#inputExamLab").val()
		};

		$.ajax({
			data: dat,
			url: $("#frmNewExaLab").attr("action"),
			method: "POST",
			success: function(){
				$("#inputExamLab").val("");
				getExamenesLab();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	getCmbCie10();
	getCmbMedicamento();
	getCmbImagen();
	getDiagnosticoConsulta();
	getMedicamentosConsulta();
	getImagenConsulta();
	getLaboratorioConsulta();
	getComplementarioConsulta();

	$(document).on("submit", "#frmDiagnosticos", function(e){
		e.preventDefault();
		createDiagnosticoConsulta();
	});

	$(document).on("click", ".btnEliminarCie10", function(){
		deleteDiagnosticoConsulta(atob($(this).prop("id")));
	});

	$(document).on("submit", "#frmMedicamentos", function(e){
		e.preventDefault();
		if($("#cmbMedicamento").val() == "" || $("#cmbMedicamento").val() == null)
			createMedicamentoConsulta($("#inputMedicamento").val());
		else
			createMedicamentoConsulta(parseInt($("#cmbMedicamento").val()));
	});

	$(document).on("click", ".btnEliminarMedicamento", function(){
		deleteMedicamentoConsulta(atob($(this).prop("id")));
	});

	$(document).on("submit", "#frmPedidoImagen", function(e){
		e.preventDefault();
		if($("#cmbImagen").val() == null || $("#cmbImagen").val() == "")
			createImageConsulta($("#inputImagen").val());
		else
			createImageConsulta(parseInt($("#cmbImagen").val()));
	});

	$(document).on("click", ".btnEliminarImagen", function(){
		deleteImagenConsulta(atob($(this).prop("id")));
	});

	$(document).on("change", ".chkLab", function(){
		if($(this).prop("checked"))
			createLaboratorioConsulta($(this).val());
		else
			deleteLaboratorioConsulta(0, idResumenHistoria, $(this).val());
	});

	$(document).on("click", ".btnEliminarLaboratorio", function(){
		deleteLaboratorioConsulta(atob($(this).prop("id")), 0, 0);
		$("#chkLab" + atob($(this).prop("id"))).prop("checked", false);
	});

	$(document).on("submit", "#frmPedidoCompl", function(e){
		e.preventDefault();
		createComplementarioConsulta();
	});

	$(document).on("click", ".btnEliminarComplem", function(){
		deleteComplementarioConsulta(atob($(this).prop("id")));
	});

	$(document).on("submit", "#frmNewExaLab", function(e){
		e.preventDefault();
		createExamenLab();
	});

	var banio = 0;
	var vestido = 0;
	var aseo = 0;
	var retrete = 0;
	var deambulacion = 0;
	var traslado = 0;
	var escaleras = 0;
	var miccion = 0;
	var deposicion = 0;
	var alimentacion = 0;


	$(document).on("change", ".ind1-banio", function(){
		if($(this).prop("checked")){
			banio = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-vestido", function(){
		if($(this).prop("checked")){
			vestido = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-aseo", function(){
		if($(this).prop("checked")){
			aseo = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-retrete", function(){
		if($(this).prop("checked")){
			retrete = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-deambu", function(){
		if($(this).prop("checked")){
			deambulacion = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-traslado", function(){
		if($(this).prop("checked")){
			traslado = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-escalera", function(){
		if($(this).prop("checked")){
			escaleras = parseInt($(this).val());
		}
	});
	
	$(document).on("change", ".ind1-miccion", function(){
		if($(this).prop("checked")){
			miccion = parseInt($(this).val());
		}
	});
	
	$(document).on("change", ".ind1-deposicion", function(){
		if($(this).prop("checked")){
			deposicion = parseInt($(this).val());
		}
	});

	$(document).on("change", ".ind1-alimentacion", function(){
		if($(this).prop("checked")){
			alimentacion = parseInt($(this).val());
		}
	});

	$(document).on("click", "#ind1-btn-calcular", function(){
		$("#ind1-banio-respuesta").empty();
		var resultado = 0;
		var interpretacion = 'Dependiente total';
		resultado = banio+vestido+aseo+retrete+deambulacion+traslado+escaleras+miccion+deposicion+alimentacion;
		$("#ind1-banio-respuesta").append('RESPUESTA: '+resultado)
		if(resultado >= 20 && resultado < 40){
			interpretacion = 'Dependiente grave';
		}else if(resultado >= 40 && resultado <= 60){
			interpretacion = 'Dependiente moderado';
		}else if(resultado > 60 && resultado <=99){
			interpretacion = 'Dependiente leve';
		}else if(resultado == 100){
			interpretacion = 'Independiente';
		}
		$("#ind1-banio-interpretacion").empty();
		$("#ind1-banio-interpretacion").append('INTERPRETACIÓN: '+interpretacion);
	});

	var prueba = 0;
	
	$(document).on("change", ".ind2-check", function(){
		val = parseInt($(this).val());
		if($(this).prop("checked")){
			prueba = prueba + val; 
			console.log(prueba);
		}else{
			prueba = prueba - val; 
			console.log(prueba);
		}
	});

	$(document).on('click', "#ind2-btn-calcular", function(e) {
		
		$("#ind2-interpretacion").empty();
		$("#ind2-interpretacion").append(prueba);
		console.log(prueba);
	})

});