$(document).ready(function(){
	var fechaActual = new Date();
	var anio = fechaActual.getFullYear();
	var anio_min = anio - 100;
	var texto_certificado = "";

	$(".datepicker").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
        changeYear: true,
        yearRange: anio_min + ":" + anio,
		currentText: 'Hoy',
		monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
		'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
		monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
		'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
		dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
		dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié;', 'Juv', 'Vie', 'Sáb'],
		dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
	});

	$(".datepicker").on("focus", function(){
		$(".ui-datepicker").css({"z-index" : 9999});
	});

	$('#ui-datepicker-div').appendTo($('#modalCertificado'));

	function getPaciente()
	{
		$.ajax({
			data: {
				idMedico: $("#cmbMedico").val(),
				buscar: $("#inputPaciente").val()
			},
			url: $("#infoPacientes").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#infoPacientes").html(datos);
				$("#modalPaciente").modal("show");
			},
			error: function(error){
				$("#errores").html(error.responseText);
				console.log(error);
			}
		});
	}

	function getComboEspecialidades()
	{
		var dat = { idMedico: $("#cmbMedico").val() };

		$.ajax({
			data: dat,
			url:  $("#cmbEspecialidades").attr("data-url") + "/1",
			method: "POST",
			success: function(datos){
				$("#cmbEspecialidades").html(datos);
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function getCertificado()
	{
		var dat = {
			medico: $("#cmbMedico").val(),
			codigo: "CERTMED"
		};

		$.ajax({
			data: dat,
			url: $("#certificado").attr("data-get"),
			method: "POST",
			success: function(response){
				$("#txtCertificado").val(response);
				$("#certificado").html(response);
				CKEDITOR.instances.txtCertificado.setData(response);
			}
		});
	}

	function updateCertificado(texto)
	{
		var dat = {
			medico: $("#cmbMedico").val(),
			codigo: "CERTMED",
			texto: texto
		};

		$.ajax({
			data: dat,
			url: $("#certificado").attr("data-url"),
			method: "POST",
			success: function(response){
				$("#certificado").html(texto);
				$("#divEditCertidicado").hide();
				$("#divCertificado").show();
			}
		});
	}

	//Actualización de certificado ocupacional
	function updateCertificadoOcupacional(texto)
	{
		var dat = {
			medico: $("#cmbMedico").val(),
			codigo: "CERTOCU",
			texto: texto
		};

		$.ajax({
			data: dat,
			url: $("#certificado").attr("data-url"),
			method: "POST",
			success: function(response){
				$("#certificado").html(texto);
				$("#divEditCertidicado").hide();
				$("#divCertificado").show();
			}
		});
	}

	//Actualización de certificado general
	function updateCertificadoGeneral(texto)
	{
		var dat = {
			medico: $("#cmbMedico").val(),
			codigo: "CERTGEN",
			texto: texto
		};

		$.ajax({
			data: dat,
			url: $("#certificado").attr("data-url"),
			method: "POST",
			success: function(response){
				$("#certificado").html(texto);
				$("#divEditCertidicado").hide();
				$("#divCertificado").show();
			}
		});
	}
	
	//Actualización de certificado de movilidad
	function updateCertificadoMovilidad(texto)
	{
		var dat = {
			medico: $("#cmbMedico").val(),
			codigo: "CERTMOV",
			texto: texto
		};

		$.ajax({
			data: dat,
			url: $("#certificado").attr("data-url"),
			method: "POST",
			success: function(response){
				$("#certificado").html(texto);
				$("#divEditCertidicado").hide();
				$("#divCertificado").show();
			}
		});
	}

	//Actualización de orden de ingreso
	function updateOrdenIngreso(texto)
	{
		var dat = {
			medico: $("#cmbMedico").val(),
			codigo: "ORDING",
			texto: texto
		};

		$.ajax({
			data: dat,
			url: $("#certificado").attr("data-url"),
			method: "POST",
			success: function(response){
				$("#certificado").html(texto);
				$("#divEditCertidicado").hide();
				$("#divCertificado").show();
			}
		});
	}

	getComboEspecialidades();
	CKEDITOR.replace("txtCertificado");

	$("#cmbMedico").change(function(){
		getCertificado();
		getComboEspecialidades();
	});

	$("#btnEdit").click(function(){
		$("#divEditCertidicado").show();
		$("#divCertificado").hide();
	});

	$("#btnCancel").click(function(){
		$("#divEditCertidicado").hide();
		$("#divCertificado").show();
	});

	$("#btnGuardar").click(function(){
		var texto_cer = CKEDITOR.instances.txtCertificado.getData();
		updateCertificado(texto_cer);
	});

	//Guardar para certificado ocupacional
	$("#btnGuardarOcupacional").click(function(){
		var texto_cer = CKEDITOR.instances.txtCertificado.getData();
		updateCertificadoOcupacional(texto_cer);
	});

	//Guardar para certificado general
	$("#btnGuardarGeneral").click(function(){
		var texto_cer = CKEDITOR.instances.txtCertificado.getData();
		updateCertificadoGeneral(texto_cer);
	});

    //Guardar para certificado de movilidad
	$("#btnGuardarMovilidad").click(function(){
		var texto_cer = CKEDITOR.instances.txtCertificado.getData();
		updateCertificadoMovilidad(texto_cer);
	});

	//Guardar orden de ingreso
	$("#btnGuardarIngreso").click(function(){
		var texto_cer = CKEDITOR.instances.txtCertificado.getData();
		updateOrdenIngreso(texto_cer);
	});

	$("#btnBuscar").click(function(e){
		e.preventDefault();
		getPaciente();
	});

	$(document).on("click", ".btnSelectPaciente", function(){
		$("#modalPaciente").modal("hide");
		$("#inputPacienteId").val($(this).prop("id"));
		var dato = $(this).prop("name");
		var array1 = dato.split("-");
		$("#inputPacienteNombre").val(array1[0]);

		if($("#inputEdad") != null){
			$("#inputEdad").val(array1[1]);
		}    
		                                                                                                                                    
	});

	$("#frmCertificado").on("submit", function(e){
		e.preventDefault();
		window.location = $("#frmCertificado").attr("data-url") + "/CERTMED/" + $("#cmbMedico").val()
			+ "/" + atob($("#inputPacienteId").val()) + "/" + $("#cmbEspecialidades").val() + "/" + btoa($("#inputCausa").val())
			+ "/" + btoa($("#inputDesde").val()) + "/" + btoa($("#inputHasta").val()) + "/" + btoa($("#inputFecha").val());
	});

	//Certificado ocupacional
	$("#frmCertificadoOcupacional").on("submit", function(e){
		e.preventDefault();
		window.location = $("#frmCertificadoOcupacional").attr("data-url") + "/CERTOCU/" + $("#cmbMedico").val()
			+ "/" + atob($("#inputPacienteId").val()) + "/" + $("#cmbEspecialidades").val() + "/" + btoa($("#inputDiagnostico").val())
			+ "/" + btoa($("#inputActividad").val()) + "/" + btoa($("#inputEdad").val())
			+ "/" + btoa($("#inputNacionalidad").val()) + "/" + btoa($("#inputFecha").val());
	});

	//Certificado general
	$("#frmCertificadoGeneral").on("submit", function(e){
		e.preventDefault();
		window.location = $("#frmCertificadoGeneral").attr("data-url") + "/CERTGEN/" + $("#cmbMedico").val()
			+ "/" + atob($("#inputPacienteId").val()) + "/" + $("#cmbEspecialidades").val() + "/" + btoa($("#inputDiagnostico").val())
			+ "/" + btoa($("#inputEdad").val())
			+ "/" + btoa($("#inputNacionalidad").val()) + "/" + btoa($("#inputFecha").val());
	});
	
	//Certificado de movilidad
	$("#frmCertificadoMovilidad").on("submit", function(e){
		e.preventDefault();
		window.location = $("#frmCertificadoMovilidad").attr("data-url") +"/CERTMOV/"+ $("#cmbMedico").val()
			+ "/" + btoa($("#inputPacienteNombre").val()) + "/" + $("#cmbEspecialidades").val() + "/" + btoa($("#inputCedulaPaciente").val())
			+ "/" + btoa($("#inputFechaEmision").val()) + "/" + btoa($("#inputDiagnostico").val()) + "/" + btoa($("#inputAcompa").val())
			+ "/" + btoa($("#inputCedAcompa").val()) + "/" + btoa($("#inputDestino").val())
			+ "/" + btoa($("#inputDestinatario").val()) + "/" + btoa($("#inputFechaMov").val()) + "/" + btoa($("#inputMotivo").val())
			+ "/" + btoa($("#inputPlaca").val());
	});

	//Orden de ingreso
	$("#frmOrdenIngreso").on("submit", function(e){
		e.preventDefault();
		window.location = $("#frmOrdenIngreso").attr("data-url") + "/ORDING/"+ $("#cmbMedico").val()
			+ "/" + btoa($("#inputPacienteNombre").val()) + "/" + $("#cmbEspecialidades").val() + "/" + btoa($("#inputDestinatario").val())
			+ "/" + btoa($("#inputFechaEmision").val()) + "/" + btoa($("#inputDiagnostico").val()) + "/" + btoa($("#inputExamen").val())
			+ "/" + btoa($("#inputFechaIngreso").val()) + "/" + btoa($("#inputHoraIngreso").val()) + "/" + btoa($("#inputFechaCirugia").val())
			+ "/" + btoa($("#inputHoraCirugia").val());
	});

});
