$(document).ready(function(){

	var agendaMedica = 0;
	var hlunes = 0;
	var hlunes2 = 0;
	var hmartes = 0;
	var hmartes2 = 0;
	var hmiercoles = 0;
	var hmiercoles2 = 0;
	var hjueves = 0;
	var hjueves2 = 0;
	var hviernes = 0;
	var hviernes2 = 0;
	var hsabado = 0;
	var hsabado2 = 0;
	var hdomingo = 0;
	var hdomingo2 = 0;

	var fechaActual = new Date();
	var anio = fechaActual.getFullYear();
	var anio_min = anio - 100;

	$("#inputFechaNacimiento").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
        changeYear: true,
        yearRange: anio_min + ":" + anio,
		currentText: 'Hoy',
		monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
		'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
		monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
		'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
		dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
		dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié;', 'Juv', 'Vie', 'Sáb'],
		dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
	});
	
	$("#inputFechaNacimiento").on("focus", function(){
		$(".ui-datepicker").css({"z-index" : 9999});
	});

	$('#ui-datepicker-div').appendTo($('#modalNewPaciente'));

	$(".icon-plus").tooltip();
	$(".icon-minus").tooltip();

	function loading(bool)
	{
		if(bool == true)
		{
			$("#loading").show();
			$("#horariosAtencion").hide();
		}
		else
		{
			$("#loading").hide();
			$("#horariosAtencion").show();
		}
	}

	function deshabilidaPaciente()
	{
		$(".cita").prop("id", "");
		$(".cita").text("");
	}

	function limpiarCampos()
	{
		$("#inputIdUsuario").val("");
		$("#inputFechaNacimiento").val("");
		$("#inputTipoSangre").val("");
		$("#chkDeportista").prop("checked", false);
		$("#cmbGenero").val("");
		$("#cmbEstadoCivil").val("Otros");
		$("#inputDireccion").val("");
		$("#inputSector").val("");
		$("#inputContacto").val("");
		$("#inputOcupacion").val("");
		$("#inputTrabajo").val("");
		$("#inputCedula").val("");
		$("#inputNombre").val("");
		$("#inputApellido").val("");
		$("#inputTelefono").val("");
		$("#inputEmail").val("");
	}

	$("#cmbTipoIdentificacion").change(function(){
		if($(this).val() == "CED")
		{
			$("#inputCedula").attr("minlength", "1");
			$("#inputCedula").prop("maxlength", 10);
			$("#inputCedula").removeClass("sln");
			$("#inputCedula").addClass("sn");
			$("#inputCedula").val("");
		}
		else if($(this).val() == "RUC")
		{
			$("#inputCedula").attr("minlength", "13");
			$("#inputCedula").prop("maxlength", 13);
			$("#inputCedula").removeClass("sln");
			$("#inputCedula").addClass("sn");
			$("#inputCedula").val("");
		}
		else if($(this).val() == "PAS")
		{
			$("#inputCedula").attr("minlength", "15");
			$("#inputCedula").prop("maxlength", 20);
			$("#inputCedula").removeClass("sn");
			$("#inputCedula").addClass("sln");
			$("#inputCedula").val("");
		}
	});

	/*$(document).on("dragstart", ".cita", function(){
		//$(this).closest(".horario").addClass("disponible");
	});

	$(document).on("dragover", ".horario", function(e){
		e.preventDefault();
	});

	$(document).on("dragenter", ".horario", function(e){
		e.preventDefault();
	});

	$(document).on("dragleave", ".horario", function(e){
		$(this).addClass("horario");
	});

	$(document).on("drop", ".horario", function(e){
		$(this).append($(".cita"));
		$(this).removeClass("horario");
		$(this).addClass("ocupado");
		$(this).children("div").addClass("asignado");
		$(this).children("div").removeClass("cita");
		$(this).children("div").prop("draggable", false);
		$("#inputBuscarPaciente").val("");

		$("#0").html('<div class="cita d100 dcentro" draggable="false"></div>');
		
		crearCitaMedica(atob($(this).children("div").prop("id")), $("#cmbEspecialidades").val(), 
			agendaMedica, $("#calendario").val(), $(this).prop("id"), $(this).children("div"));
	});*/

	$(document).on("click", ".cita", function(){
		if($(this).prop("id") != "")
		{
			$(".asignado").removeClass("cambio");
			$(".asignado").removeClass("seleccionado");
			$(this).addClass("seleccionado");
			$("#divDeleteCita").hide();
		}
	});

	$(document).on("click", ".horario", function(e){
		if($(".cita").hasClass("seleccionado"))
		{
			$(this).append($(".cita"));
			$(this).removeClass("horario");
			$(this).addClass("ocupado");
			$(this).children("div").addClass("asignado");
			$(this).children("div").removeClass("cita");
			$(this).children("div").removeClass("seleccionado");
			$("#inputBuscarPaciente").val("");

			$("#0").html('<div class="cita d100 dcentro"></div>');
						
				crearCitaMedica(atob($(this).children("div").prop("id")), $("#cmbEspecialidades").val(), 
				agendaMedica, $(".day-active").prop("name"), $(this).prop("id"), $(this).children("div"));			
		}

	$(document).on("click", "#btnCancelarObservacionCita", function(e) {
		e.preventDefault();
		$("#observacionCita").val("");
		$("#myModalDescripcion").modal("hide");
	})

		if($(".asignado").hasClass("cambio"))
		{
			$(this).append($(".cambio"));
			$(this).removeClass("horario");
			$(this).addClass("ocupado");

			$(this).children("div").removeClass("seleccionado");
			$("#inputBuscarPaciente").val("");
			$("#divDeleteCita").hide();

			actualizarCitaMedica($("#cmbEspecialidades").val(), $(this).prop("id"), 
				atob($(".cambio").attr("accesskey")), $(this).children("div"));
		}

	});

	$(document).on("click", ".asignado", function(){
		$(".cita").removeClass("seleccionado");
		$(".asignado").removeClass("cambio");
		$(".asignado").removeClass("seleccionado");
		$(this).addClass("cambio");
		$(this).addClass("seleccionado");
		$(this).closest(".ocupado").addClass("cambioHorario");
		$("#divDeleteCita").show();
	});

	$(document).on("click", "#btnDeleteCita", function(){
		if($(".asignado").hasClass("cambio"))
		{
			$("#divDeleteCita").hide();
			$(".cita").removeClass("seleccionado");

			deleteCitaMedica(atob($(".cambio").attr("accesskey")));
		}
	});

	function getCalendario(anio, mes)
	{
		var dat = {
			anio: anio,
			mes: mes
		};

		$.ajax({
			data: dat,
			url: "../recursos/calendario/",
			method: "POST",
			success: function(datos){
				$("#calendario").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getComboEspecialidades()
	{
		var dat = { idMedico: $("#cmbMedicos").val() };

		$.ajax({
			data: dat,
			url: "../combo/especialidades/1",
			method: "POST",
			success: function(datos){
				$("#cmbEspecialidades").html(datos);
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function getUsuarioByCedula(cedula)
	{
		var dat = {
			medico: $("#cmbMedicos").val()
		};

		$.ajax({
			data: dat,
			url: "../recursos/paciente/0/" + cedula,
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos["success"])
				{
					$("#inputCedula").val("");
					$("#inputCedula").focus();
					$(".alert-cedula").show();
				}
				else
				{
					$(".alert-cedula").hide();
				}
			},
			error: function(error){
				console.log(error);
			}
		})
	}

	function getPacienteByCedula(cedula)
	{
		$.ajax({
			data: {
				idMedico: $("#cmbMedicos").val(),
				buscar: $("#inputBuscarPaciente").val()
			},
			url: $("#btnBuscarPaciente").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#infoPacientes").html(datos);
				$("#modalBuscarPaciente").modal("show");
			},
			error: function(error){
				$("#errores").html(error.responseText);
				console.log(error);
			}
		});
	}

	function getDiasLaborables()
	{
		$.ajax({
			data: {},
			url: "../dias/laborables/",
			method: "POST",
			success: function(datos){
				$("#diasLaborables").html(datos);
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function getHorariosAtencion(idAgenda)
	{
		var dat = { agenda: idAgenda };
		
		$.ajax({
			data: dat,
			url: "../horario/medico/",
			method: "POST",
			success: function(datos){
				$("#horarioMedico").html(datos);
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function getHorariosAtencionDia(idAgenda, fecha)
	{
		var dat = { 
			agenda: idAgenda,
			fecha: fecha
		};

		$.ajax({
			data: dat,
			url: "../horario/medico/dia/",
			method: "POST",
			success: function(datos){
				loading(false);
				$("#horariosAtencion").html(datos);
				$(".asignado").tooltip();
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function getAgenda()
	{
		loading(true);

		var dat = { idMedico: $("#cmbMedicos").val() };
		$.ajax({
			data: dat,
			url: "../recursos/agenda/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos["success"])
				{
					agendaMedica = datos["idAgenda"];
					getHorariosAtencionDia(datos["idAgenda"], "");
					getHorariosAtencion(datos["idAgenda"]);
					getHorariosAgenda(datos["idAgenda"]);
				}
				else
				{
					getHorariosAtencion(0);
					getHorariosAtencionDia(0, "");
				}
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getHorarios(idAgenda, idDia)
	{
		var dat = {
			idAgenda: idAgenda,
			idDia: idDia
		};

		$.ajax({
			data: dat,
			url: "../recursos/horariosLaborables/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos["success"])
				{
					$("#cmbMinutos").val(datos["minutos"]);
					if(datos["diasLaborables"]["idDia"] == 1)
					{
						$("#cmbHoraInicio1").val(datos["horaInicio"]);
						$("#cmbHoraFin1").val(datos["horaFin"]);
						hlunes = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio1").prop("disabled", false);
							$("#cmbHoraFin1").prop("disabled", false);
							$("#chkHorario1").prop("checked", true);
						}

						if(datos["horario2"]["idHorario2"] != "" && datos["horario2"]["horaInicio2"] != "" && 
							datos["horario2"]["horaFin2"] != "")
						{
							hlunes2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio1").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin1").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio1").prop("disabled", false);
								$("#cmb2HoraFin1").prop("disabled", false);
								$("#chk2Horario1").prop("checked", true);
								$("#chk2Horario1").closest(".divSegundoHorario").show();
								$("#chkHorario1").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario1").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}

					if(datos["diasLaborables"]["idDia"] == 2)
					{
						$("#cmbHoraInicio2").val(datos["horaInicio"]);
						$("#cmbHoraFin2").val(datos["horaFin"]);
						hmartes = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio2").prop("disabled", false);
							$("#cmbHoraFin2").prop("disabled", false);
							$("#chkHorario2").prop("checked", true);
						}

						if(datos["horario2"]["horaInicio2"] != "" && datos["horario2"]["horaFin2"] != "")
						{
							hmartes2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio2").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin2").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio2").prop("disabled", false);
								$("#cmb2HoraFin2").prop("disabled", false);
								$("#chk2Horario2").prop("checked", true);
								$("#chk2Horario2").closest(".divSegundoHorario").show();
								$("#chkHorario2").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario2").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}

					if(datos["diasLaborables"]["idDia"] == 3)
					{
						$("#cmbHoraInicio3").val(datos["horaInicio"]);
						$("#cmbHoraFin3").val(datos["horaFin"]);
						hmiercoles = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio3").prop("disabled", false);
							$("#cmbHoraFin3").prop("disabled", false);
							$("#chkHorario3").prop("checked", true);
						}

						if(datos["horario2"]["horaInicio2"] != "" && datos["horario2"]["horaFin2"] != "")
						{
							hmiercoles2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio3").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin3").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio3").prop("disabled", false);
								$("#cmb2HoraFin3").prop("disabled", false);
								$("#chk2Horario3").prop("checked", true);
								$("#chk2Horario3").closest(".divSegundoHorario").show();
								$("#chkHorario3").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario3").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}

					if(datos["diasLaborables"]["idDia"] == 4)
					{
						$("#cmbHoraInicio4").val(datos["horaInicio"]);
						$("#cmbHoraFin4").val(datos["horaFin"]);
						hjueves = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio4").prop("disabled", false);
							$("#cmbHoraFin4").prop("disabled", false);
							$("#chkHorario4").prop("checked", true);
						}

						if(datos["horario2"]["horaInicio2"] != "" && datos["horario2"]["horaFin2"] != "")
						{
							hjueves2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio4").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin4").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio4").prop("disabled", false);
								$("#cmb2HoraFin4").prop("disabled", false);
								$("#chk2Horario4").prop("checked", true);
								$("#chk2Horario4").closest(".divSegundoHorario").show();
								$("#chkHorario4").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario4").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}

					if(datos["diasLaborables"]["idDia"] == 5)
					{
						$("#cmbHoraInicio5").val(datos["horaInicio"]);
						$("#cmbHoraFin5").val(datos["horaFin"]);
						hviernes = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio5").prop("disabled", false);
							$("#cmbHoraFin5").prop("disabled", false);
							$("#chkHorario5").prop("checked", true);
						}

						if(datos["horario2"]["horaInicio2"] != "" && datos["horario2"]["horaFin2"] != "")
						{
							hviernes2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio5").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin5").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio5").prop("disabled", false);
								$("#cmb2HoraFin5").prop("disabled", false);
								$("#chk2Horario5").prop("checked", true);
								$("#chk2Horario5").closest(".divSegundoHorario").show();
								$("#chkHorario5").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario5").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}

					if(datos["diasLaborables"]["idDia"] == 6)
					{
						$("#cmbHoraInicio6").val(datos["horaInicio"]);
						$("#cmbHoraFin6").val(datos["horaFin"]);
						hsabado = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio6").prop("disabled", false);
							$("#cmbHoraFin6").prop("disabled", false);
							$("#chkHorario6").prop("checked", true);
						}

						if(datos["horario2"]["horaInicio2"] != "" && datos["horario2"]["horaFin2"] != "")
						{
							hsabado2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio6").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin6").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio6").prop("disabled", false);
								$("#cmb2HoraFin6").prop("disabled", false);
								$("#chk2Horario6").prop("checked", true);
								$("#chk2Horario6").closest(".divSegundoHorario").show();
								$("#chkHorario6").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario6").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}

					if(datos["diasLaborables"]["idDia"] == 7)
					{
						$("#cmbHoraInicio7").val(datos["horaInicio"]);
						$("#cmbHoraFin7").val(datos["horaFin"]);
						hdomingo = datos["id"];

						if(datos["estado"])
						{
							$("#cmbHoraInicio7").prop("disabled", false);
							$("#cmbHoraFin7").prop("disabled", false);
							$("#chkHorario7").prop("checked", true);
						}

						if(datos["horario2"]["horaInicio2"] != "" && datos["horario2"]["horaFin2"] != "")
						{
							hdomingo2 = datos["horario2"]["idHorario2"];
							$("#cmb2HoraInicio7").val(datos["horario2"]["horaInicio2"]);
							$("#cmb2HoraFin7").val(datos["horario2"]["horaFin2"]);

							if(datos["horario2"]["estado"])
							{
								$("#cmb2HoraInicio7").prop("disabled", false);
								$("#cmb2HoraFin7").prop("disabled", false);
								$("#chk2Horario7").prop("checked", true);
								$("#chk2Horario7").closest(".divSegundoHorario").show();
								$("#chkHorario7").closest(".d100").children(".icon-plus").addClass("icon-minus");
								$("#chkHorario7").closest(".d100").children(".icon-plus").removeClass("icon-plus");
							}
						}
					}
				}
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function getHorariosAgenda(idAgenda)
	{
		var dat = {
			idAgenda: idAgenda
		};

		$.ajax({
			data: dat,
			url: "../recursos/horariosLaborables/agenda/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos[0]["success"])
				{
					for (var i = datos.length - 1; i >= 0; i--) {
						getHorarios(idAgenda, datos[i]["idDia"]);
					}
				}
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function crearHorariosMedicos(idMedico, idDia, hinicio, hfin, minutos, orden)
	{
		var dat = {
			idMedico: idMedico,
			idDia: idDia,
			hinicio: hinicio,
			hfin: hfin,
			minutos: minutos,
			orden: orden
		};

		$.ajax({
			data: dat,
			url: "../horario/laborable/create/",
			method: "POST",
			success: function(datos){
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function actualizarHorariosMedicos(idHorario, hinicio, hfin, minutos)
	{
		var dat = {
			idHorario: idHorario,
			hinicio: hinicio,
			hfin: hfin,
			minutos: minutos
		};

		$.ajax({
			data: dat,
			url: "../horario/laborable/update/",
			method: "POST",
			success: function(datos){

			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function updateEstadoHorarioL(id, estado)
	{
		var dat = {
			idHorario: id,
			estado: estado
		};

		$.ajax({
			data: dat,
			url: "../horario/estado/",
			method: "POST",
			success: function(datos){

			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function deleteHorariosMedicos()
	{
		var dat = { idAgenda: agendaMedica };

		$.ajax({
			data: dat,
			url: "../horario/laborable/delete/",
			method: "POST",
			success: function(datos){
				if($("#chkHorario1").prop("checked"))
				{
					var lun_inicio1 = $("#cmbHoraInicio1").val().split(":");
					var lun_fin1 = $("#cmbHoraFin1").val().split(":");

					if(parseInt(lun_inicio1[0]) >= parseInt(lun_fin1[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hlunes !== 0)
							actualizarHorariosMedicos(hlunes, $("#cmbHoraInicio1").val(), 
								$("#cmbHoraFin1").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 1, $("#cmbHoraInicio1").val(), 
								$("#cmbHoraFin1").val(), $("#cmbMinutos").val(), 1);
					}						
				}
				if($("#chk2Horario1").prop("checked"))
				{
					var lun_inicio2 = $("#cmb2HoraInicio1").val().split(":");
					var lun_fin2 = $("#cmb2HoraFin1").val().split(":");

					if(parseInt(lun_inicio2[0]) >= parseInt(lun_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hlunes2 !== 0)
							actualizarHorariosMedicos(hlunes2, $("#cmb2HoraInicio1").val(), 
								$("#cmb2HoraFin1").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 1, $("#cmb2HoraInicio1").val(), 
								$("#cmb2HoraFin1").val(), $("#cmbMinutos").val(), 2);
					}
				}

				if($("#chkHorario2").prop("checked"))
				{
					var mar_inicio1 = $("#cmbHoraInicio2").val().split(":");
					var mar_fin1 = $("#cmbHoraFin2").val().split(":");

					if(parseInt(mar_inicio1[0]) >= parseInt(mar_fin1[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hmartes !== 0)
							actualizarHorariosMedicos(hmartes, $("#cmbHoraInicio2").val(), 
								$("#cmbHoraFin2").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 2, $("#cmbHoraInicio2").val(), 
								$("#cmbHoraFin2").val(), $("#cmbMinutos").val(), 1);
					}
				}
				if($("#chk2Horario2").prop("checked"))
				{
					var mar_inicio2 = $("#cmb2HoraInicio2").val().split(":");
					var mar_fin2 = $("#cmb2HoraFin2").val().split(":");

					if(parseInt(mar_inicio2[0]) >= parseInt(mar_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hmartes2 !== 0)
							actualizarHorariosMedicos(hmartes2, $("#cmb2HoraInicio2").val(), 
								$("#cmb2HoraFin2").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 2, $("#cmb2HoraInicio2").val(), 
								$("#cmb2HoraFin2").val(), $("#cmbMinutos").val(), 2);
					}
				}

				if($("#chkHorario3").prop("checked"))
				{
					var mie_inicio1 = $("#cmbHoraInicio3").val().split(":");
					var mie_fin1 = $("#cmbHoraFin3").val().split(":");

					if(parseInt(mie_inicio1[0]) >= parseInt(mie_fin1[0]))
						alert("Error con la selección de hora de inicio y fin " + $("#cmbHoraInicio3").val() + " " + $("#cmbHoraFin3").val());
					else
					{
						if(hmiercoles !== 0)
							actualizarHorariosMedicos(hmiercoles, $("#cmbHoraInicio3").val(), 
								$("#cmbHoraFin3").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 3, $("#cmbHoraInicio3").val(), 
								$("#cmbHoraFin3").val(), $("#cmbMinutos").val(), 1);
					}
				}
				if($("#chk2Horario3").prop("checked"))
				{
					var mie_inicio2 = $("#cmb2HoraInicio3").val().split(":");
					var mie_fin2 = $("#cmb2HoraFin3").val().split(":");

					if(parseInt(mie_inicio2[0]) >= parseInt(mie_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hmiercoles2 !== 0)
							actualizarHorariosMedicos(hmiercoles2, $("#cmb2HoraInicio3").val(), 
								$("#cmb2HoraFin3").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 3, $("#cmb2HoraInicio3").val(), 
								$("#cmb2HoraFin3").val(), $("#cmbMinutos").val(), 2);
					}
				}

				if($("#chkHorario4").prop("checked"))
				{
					var jue_inicio1 = $("#cmbHoraInicio4").val().split(":");
					var jue_fin1 = $("#cmbHoraFin4").val().split(":");

					if(parseInt(jue_inicio1[0]) >= parseInt(jue_fin1[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hjueves !== 0)
							actualizarHorariosMedicos(hjueves, $("#cmbHoraInicio4").val(), 
								$("#cmbHoraFin4").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 4, $("#cmbHoraInicio4").val(), 
								$("#cmbHoraFin4").val(), $("#cmbMinutos").val(), 1);
					}
				}
				if($("#chk2Horario4").prop("checked"))
				{
					var jue_inicio2 = $("#cmb2HoraInicio4").val().split(":");
					var jue_fin2 = $("#cmb2HoraFin4").val().split(":");

					if(parseInt(jue_inicio2[0]) >= parseInt(jue_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hjueves2 !== 0)
							actualizarHorariosMedicos(hjueves2, $("#cmb2HoraInicio4").val(), 
								$("#cmb2HoraFin4").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 4, $("#cmb2HoraInicio4").val(), 
								$("#cmb2HoraFin4").val(), $("#cmbMinutos").val(), 2);
					}
				}

				if($("#chkHorario5").prop("checked"))
				{
					var vie_inicio1 = $("#cmbHoraInicio5").val().split(":");
					var vie_fin1 = $("#cmbHoraFin5").val().split(":");

					if(parseInt(vie_inicio1[0]) >= parseInt(vie_fin1[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hviernes !== 0)
							actualizarHorariosMedicos(hviernes, $("#cmbHoraInicio5").val(), 
								$("#cmbHoraFin5").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 5, $("#cmbHoraInicio5").val(), 
								$("#cmbHoraFin5").val(), $("#cmbMinutos").val(), 1);
					}
				}
				if($("#chk2Horario5").prop("checked"))
				{
					var vie_inicio2 = $("#cmb2HoraInicio5").val().split(":");
					var vie_fin2 = $("#cmb2HoraFin5").val().split(":");

					if(parseInt(vie_inicio2[0]) >= parseInt(vie_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hviernes2 !== 0)
							actualizarHorariosMedicos(hviernes2, $("#cmb2HoraInicio5").val(), 
								$("#cmb2HoraFin5").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 5, $("#cmb2HoraInicio5").val(), 
								$("#cmb2HoraFin5").val(), $("#cmbMinutos").val(), 2);
					}
				}

				if($("#chkHorario6").prop("checked"))
				{
					var sab_inicio1 = $("#cmbHoraInicio6").val().split(":");
					var sab_fin1 = $("#cmbHoraFin6").val().split(":");

					if(parseInt(sab_inicio1[0]) >= parseInt(sab_fin1[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hsabado !== 0)
							actualizarHorariosMedicos(hsabado, $("#cmbHoraInicio6").val(), 
								$("#cmbHoraFin6").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 6, $("#cmbHoraInicio6").val(), 
								$("#cmbHoraFin6").val(), $("#cmbMinutos").val(), 1);
					}
				}
				if($("#chk2Horario6").prop("checked"))
				{
					var sab_inicio2 = $("#cmb2HoraInicio6").val().split(":");
					var sab_fin2 = $("#cmb2HoraFin6").val().split(":");

					if(parseInt(sab_inicio2[0]) >= parseInt(sab_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hsabado2 !== 0)
							actualizarHorariosMedicos(hsabado2, $("#cmb2HoraInicio6").val(), 
								$("#cmb2HoraFin6").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 6, $("#cmb2HoraInicio6").val(), 
								$("#cmb2HoraFin6").val(), $("#cmbMinutos").val(), 2);
					}
				}

				if($("#chkHorario7").prop("checked"))
				{
					var dom_inicio1 = $("#cmbHoraInicio7").val().split(":");
					var dom_fin1 = $("#cmbHoraFin7").val().split(":");

					if(parseInt(dom_inicio1[0]) >= parseInt(dom_fin1[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hdomingo !== 0)
							actualizarHorariosMedicos(hdomingo, $("#cmbHoraInicio7").val(), 
								$("#cmbHoraFin7").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 7, $("#cmbHoraInicio7").val(), 
								$("#cmbHoraFin7").val(), $("#cmbMinutos").val(), 1);
					}
				}
				if($("#chk2Horario7").prop("checked"))
				{
					var dom_inicio2 = $("#cmb2HoraInicio7").val().split(":");
					var dom_fin2 = $("#cmb2HoraFin7").val().split(":");

					if(parseInt(dom_inicio2[0]) >= parseInt(dom_fin2[0]))
						alert("Error con la selección de hora de inicio y fin");
					else
					{
						if(hdomingo2 !== 0)
							actualizarHorariosMedicos(hdomingo2, $("#cmb2HoraInicio7").val(), 
								$("#cmb2HoraFin7").val(), $("#cmbMinutos").val());
						else
							crearHorariosMedicos($("#cmbMedicos").val(), 7, $("#cmb2HoraInicio7").val(), 
								$("#cmb2HoraFin7").val(), $("#cmbMinutos").val(), 2);
					}
				}
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		});
	}

	function crearPaciente()
	{
		var dat = {
			fechaNacimiento: $("#inputFechaNacimiento").val(),
			seguro: $("#inputAseguradora").val(),
			celular: $("#inputCelular").val(),
			genero: $("#cmbGenero").val(),
			estadoCivil: $("#cmbEstadoCivil").val(),
			direccion: $("#inputDireccion").val(),
			sector: $("#inputSector").val(),
			contacto: $("#inputContacto").val(),
			ocupacion: $("#cmbOcupacion").val(),
			parroquia: $("#cmbParroquia").val(),
			cedula: $("#inputCedula").val(),
			nombre: $("#inputNombre").val(),
			apellido: $("#inputApellido").val(),
			telefono: $("#inputTelefono").val(),
			email: $("#inputEmail").val(),
			medico: $("#cmbMedicos").val(),
			tipo_iden: $("#cmbTipoIdentificacion").val()
		};

		$.ajax({
			data: dat,
			url: "../paciente/crear/",
			method: "POST",
			success: function(datos){
				limpiarCampos();
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function crearCitaMedica(idPaciente, idEspecialidad, idAgenda, fecha, hora, campo)
	{
		var dat = {
			idPaciente: idPaciente,
			idEspecialidad: idEspecialidad,
			idAgenda: idAgenda,
			fecha: fecha,
			hora: hora,
			observacion: $("#observacionCita").val()
		};

		$.ajax({
			data: dat,
			url: "../cita/medica/create/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				$("#observacionCita").val('');
				campo.attr("accesskey", btoa(datos["id"]));
				campo.attr("data-tel", btoa(datos["paciente"]["telefono"]));
				campo.attr("data-cel", btoa(datos["paciente"]["celular"]));
				campo.attr("data-mail", btoa(datos["paciente"]["email"]));
				campo.attr("data-obs", btoa(datos["paciente"]["observacion"]));
				campo.attr("title", "");
				console.log(datos["paciente"]["observacion"]);
				campo.tooltip({
					content: function(){
						var telf = atob(campo.attr("data-tel"));
						var cell = atob(campo.attr("data-cel"));
						var mail = atob(campo.attr("data-mail"));
						var obse = atob(campo.attr("data-obs"));
						var texto = "Teléfono: " + telf + " "
									+ "Celular: " + cell + " "
									+ "Observación: " + obse + " "
									+ "Email: " + mail;
						return texto;
					}
				});
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function actualizarCitaMedica(idEspecialidad, hora, idCitaMedica, campo)
	{
		var dat = {
			idEspecialidad: idEspecialidad,
			hora: hora,
			idCitaMedica: idCitaMedica
		};

		$.ajax({
			data: dat,
			url: "../cita/medica/update/",
			method: "POST",
			success: function(datos){
				campo.removeClass("cambio");
				$(".cambioHorario").addClass("horario");
				$(".cambioHorario").removeClass("ocupado");
				$(".cambioHorario").removeClass("cambioHorario");
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function deleteCitaMedica(id)
	{
		var dat = {
			id: id
		};

		$.ajax({
			data: dat,
			url: "../cita/medica/delete/",
			method: "POST",
			success: function(datos){
				$(".cambioHorario").addClass("horario");
				$(".cambioHorario").removeClass("ocupado");
				$(".cambioHorario").children(".cambio").remove();
				$(".cambioHorario").removeClass("cambioHorario");
			},
			error: function(error){
				/*console.log(error);
				$("#errores").html(error.responseText);*/
				$(".asignado").removeClass("cambio");
				$(".asignado").removeClass("seleccionado");
				$(".cambioHorario").removeClass("cambioHorario");
				$("#mensajeInfoModalInfo").text("No se puede eliminar la cita médica ya que se encuentra en proceso o finalizada");
				$("#myModalInfo").modal("show");
			}
		})
	}

	function getCmbCantones(provincia, id, idParroquia)
	{
		var dat = {
			provincia: provincia,
			id: id
		};

		$.ajax({
			data: dat,
			url: "./../recursos/cantones/cmb/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				$("#cmbCanton").html(datos["cmb"]);
				getCmbParroquias(datos["primerId"], idParroquia);
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function getCmbParroquias(canton, id)
	{
		var dat = {
			canton: canton,
			id: id
		};

		$.ajax({
			data: dat,
			url: "./../recursos/parroquias/cmb/",
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				$("#cmbParroquia").html(datos["cmb"]);
			},
			error: function(error){
				//console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	getComboEspecialidades();
	getCalendario("", "");
	getAgenda();
	getDiasLaborables();
	getCmbCantones($("#cmbProvincia").val(), 0, 0);

	$("#cmbMes").change(function(){
		getCalendario($("#cmbAnio").val(), $(this).val());
	});

	$("#cmbAnio").change(function(){
		getCalendario($(this).val(), $("#cmbMes").val());
	});

	$("#cmbMedicos").change(function(){
		getCalendario("", "");
		var fechaHoy = new Date();
		var mesActual = fechaHoy.getMonth()+1;
		if(parseInt(mesActual) < 10)
			mesActual = "0"+mesActual;
		$("#cmbAnio").val(fechaHoy.getFullYear());
		$("#cmbMes").val(mesActual);

		dateNow = "hoy";
		$("#btnImprimir").prop("href", urlPdfAgenda+"/"+$("#cmbMedicos").val()+"/"+dateNow);

		getComboEspecialidades();
		getAgenda();
		deshabilidaPaciente();
	});

	$("#inputCedula").blur(function(){
		getUsuarioByCedula($(this).val());
	});

	$("#btnBuscarPaciente").click(function(){
		$("#divDeleteCita").hide();
		if($("#inputBuscarPaciente").val() != "")
			getPacienteByCedula($("#inputBuscarPaciente").val());
	});

	$(document).on("click", ".btnDia", function(e){
		e.preventDefault();
		loading(true);
		$(".btnDia").removeClass("day-active");
		$(this).addClass("day-active");
		getHorariosAtencionDia(agendaMedica, $(this).prop("name"));

		dateNow = $(this).prop("name");
		$("#btnImprimir").prop("href", urlPdfAgenda+"/"+$("#cmbMedicos").val()+"/"+dateNow);
		
		var fec = new Date($(this).prop("name"));
		var hoy = new Date();
		$(".cita").removeClass("seleccionado");
		$("#divDeleteCita").hide();

		/*if(fec.getFullYear() < hoy.getFullYear())
		{
			$("#inputBuscarPaciente").val("");
			$("#inputBuscarPaciente").prop("disabled", true);
			deshabilidaPaciente();
		}
		else if(fec.getFullYear() == hoy.getFullYear())
		{
			if(fec.getMonth() < hoy.getMonth())
			{
				$("#inputBuscarPaciente").val("");
				$("#inputBuscarPaciente").prop("disabled", true);
				deshabilidaPaciente();
			}
			else if(fec.getMonth() == hoy.getMonth())
			{
				if((fec.getDate() + 1) < hoy.getDate())
				{
					$("#inputBuscarPaciente").val("");
					$("#inputBuscarPaciente").prop("disabled", true);
					deshabilidaPaciente();
				}
				else
				{
					$("#inputBuscarPaciente").prop("disabled", false);
				}
			}
			else
				$("#inputBuscarPaciente").prop("disabled", false);
		}
		else*/
			$("#inputBuscarPaciente").prop("disabled", false);
	});

	/*$("#calendario").change(function(){
		loading(true);
		getHorariosAtencionDia(agendaMedica, $(this).val());
		
		var fec = new Date($(this).val());
		var hoy = new Date();
		$(".cita").removeClass("seleccionado");
		$("#divDeleteCita").hide();

		if(fec.getFullYear() < hoy.getFullYear())
		{
			$("#inputBuscarPaciente").val("");
			$("#inputBuscarPaciente").prop("disabled", true);
			deshabilidaPaciente();
		}
		else
		{
			if(fec.getMonth() < hoy.getMonth())
			{
				$("#inputBuscarPaciente").val("");
				$("#inputBuscarPaciente").prop("disabled", true);
				deshabilidaPaciente();
			}
			else
			{
				if((fec.getDate() + 1) < hoy.getDate())
				{
					$("#inputBuscarPaciente").val("");
					$("#inputBuscarPaciente").prop("disabled", true);
					deshabilidaPaciente();
				}
				else
				{
					$("#inputBuscarPaciente").prop("disabled", false);
				}
			}
		}
	});*/

	$("#frmCrearPaciente").on("submit", function(e){
		e.preventDefault();
		$("#modalNewPaciente").modal("hide");
		crearPaciente();
	});

	$("#btnEditarHorario").click(function(e){
		$("#modalHorarios").modal("show");
	});

	$(document).on("click", "#btnAgregarHorario", function(e){
		$("#btnEditarHorario").click();
	});

	$(document).on("change", ".chkHorario", function(e){
		if($(this).prop("checked"))
		{
			$(this).closest(".d100").children("select").prop("disabled", false);
		}
		else
		{
			$(this).closest(".d100").children("select").prop("disabled", true);
		}
	});

	$(document).on("change", "#chkHorario1", function(){
		if(hlunes !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hlunes, 1);
			else
				updateEstadoHorarioL(hlunes, 0);
		}
	});

	$(document).on("change", "#chk2Horario1", function(){
		if(hlunes2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hlunes2, 1);
			else
				updateEstadoHorarioL(hlunes2, 0);
		}
	});

	$(document).on("change", "#chkHorario2", function(){
		if(hmartes !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hmartes, 1);
			else
				updateEstadoHorarioL(hmartes, 0);
		}
	});

	$(document).on("change", "#chk2Horario2", function(){
		if(hmartes2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hmartes2, 1);
			else
				updateEstadoHorarioL(hmartes2, 0);
		}
	});

	$(document).on("change", "#chkHorario3", function(){
		if(hmiercoles !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hmiercoles, 1);
			else
				updateEstadoHorarioL(hmiercoles, 0);
		}
	});

	$(document).on("change", "#chk2Horario3", function(){
		if(hmiercoles2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hmiercoles2, 1);
			else
				updateEstadoHorarioL(hmiercoles2, 0);
		}
	});

	$(document).on("change", "#chkHorario4", function(){
		if(hjueves !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hjueves, 1);
			else
				updateEstadoHorarioL(hjueves, 0);
		}
	});

	$(document).on("change", "#chk2Horario4", function(){
		if(hjueves2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hjueves2, 1);
			else
				updateEstadoHorarioL(hjueves2, 0);
		}
	});

	$(document).on("change", "#chkHorario5", function(){
		if(hviernes !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hviernes, 1);
			else
				updateEstadoHorarioL(hviernes, 0);
		}
	});

	$(document).on("change", "#chk2Horario5", function(){
		if(hviernes2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hviernes2, 1);
			else
				updateEstadoHorarioL(hviernes2, 0);
		}
	});

	$(document).on("change", "#chkHorario6", function(){
		if(hsabado !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hsabado, 1);
			else
				updateEstadoHorarioL(hsabado, 0);
		}
	});

	$(document).on("change", "#chk2Horario6", function(){
		if(hsabado2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hsabado2, 1);
			else
				updateEstadoHorarioL(hsabado2, 0);
		}
	});

	$(document).on("change", "#chkHorario7", function(){
		if(hdomingo !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hdomingo, 1);
			else
				updateEstadoHorarioL(hdomingo, 0);
		}
	});

	$(document).on("change", "#chk2Horario7", function(){
		if(hviernes2 !== 0)
		{
			if($(this).prop("checked"))
				updateEstadoHorarioL(hviernes2, 1);
			else
				updateEstadoHorarioL(hviernes2, 0);
		}
	});

	$(document).on("click", ".btnNHorario", function(e){
		if($(this).hasClass("icon-plus"))
		{
			$(this).removeClass("icon-plus");
			$(this).addClass("icon-minus");
			$(this).closest(".d75").children(".divSegundoHorario").slideDown();
		}
		else
		{
			$(this).removeClass("icon-minus");
			$(this).addClass("icon-plus");
			$(this).closest(".d75").children(".divSegundoHorario").slideUp();
			$(this).closest(".d75").children(".divSegundoHorario").children(".chkHorario").prop("checked", false);
			$(this).closest(".d75").children(".divSegundoHorario").children("select").prop("disabled", true);
		}
	});

	$("#btnGuardarHorario").click(function(e){
		e.preventDefault();

		if($("#inputExisteHorario").val() == 0)
		{
			if($("#chkHorario1").prop("checked"))
			{
				if(parseInt($("#cmbHoraInicio1").val()) >= parseInt($("#cmbHoraFin1").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 1, $("#cmbHoraInicio1").val(), 
						$("#cmbHoraFin1").val(), $("#cmbMinutos").val(), 1);
			}
			if($("#chk2Horario1").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio1").val()) >= parseInt($("#cmb2HoraFin1").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 1, $("#cmb2HoraInicio1").val(), 
						$("#cmb2HoraFin1").val(), $("#cmbMinutos").val(), 2);
			}

			if($("#chkHorario2").prop("checked"))
			{
				if(parseInt($("#cmbHoraInicio2").val()) >= parseInt($("#cmbHoraFin2").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 2, $("#cmbHoraInicio2").val(), 
						$("#cmbHoraFin2").val(), $("#cmbMinutos").val(), 1);
			}
			if($("#chk2Horario2").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio2").val()) >= parseInt($("#cmb2HoraFin2").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 2, $("#cmb2HoraInicio2").val(), 
						$("#cmb2HoraFin2").val(), $("#cmbMinutos").val(), 2);
			}

			if($("#chkHorario3").prop("checked"))
			{
				if(parseInt($("#cmbHoraInicio3").val()) >= parseInt($("#cmbHoraFin3").val()))
					alert("Error con la selección de hora de inicio y fin " + $("#cmbHoraInicio3").val() + " " + $("#cmbHoraFin3").val());
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 3, $("#cmbHoraInicio3").val(), 
						$("#cmbHoraFin3").val(), $("#cmbMinutos").val(), 1);
			}
			if($("#chk2Horario3").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio3").val()) >= parseInt($("#cmb2HoraFin3").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 3, $("#cmb2HoraInicio3").val(), 
						$("#cmb2HoraFin3").val(), $("#cmbMinutos").val(), 2);
			}

			if($("#chkHorario4").prop("checked"))
			{
				if(parseInt($("#cmbHoraInicio4").val()) >= parseInt($("#cmbHoraFin4").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 4, $("#cmbHoraInicio4").val(), 
						$("#cmbHoraFin4").val(), $("#cmbMinutos").val(), 1);
			}
			if($("#chk2Horario4").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio4").val()) >= parseInt($("#cmb2HoraFin4").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 4, $("#cmb2HoraInicio4").val(), 
						$("#cmb2HoraFin4").val(), $("#cmbMinutos").val(), 2);
			}

			if($("#chkHorario5").prop("checked"))
			{
				if(parseInt($("#cmbHoraInicio5").val()) >= parseInt($("#cmbHoraFin5").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 5, $("#cmbHoraInicio5").val(), 
						$("#cmbHoraFin5").val(), $("#cmbMinutos").val(), 1);
			}
			if($("#chk2Horario5").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio5").val()) >= parseInt($("#cmb2HoraFin5").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 5, $("#cmb2HoraInicio5").val(), 
						$("#cmb2HoraFin5").val(), $("#cmbMinutos").val(), 2);
			}

			if($("#chkHorario6").prop("checked"))
				if(parseInt($("#cmbHoraInicio6").val()) >= parseInt($("#cmbHoraFin6").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 6, $("#cmbHoraInicio6").val(), 
						$("#cmbHoraFin6").val(), $("#cmbMinutos").val(), 1);
			if($("#chk2Horario6").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio6").val()) >= parseInt($("#cmb2HoraFin6").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 6, $("#cmb2HoraInicio6").val(), 
						$("#cmb2HoraFin6").val(), $("#cmbMinutos").val(), 2);
			}

			if($("#chkHorario7").prop("checked"))
			{
				if(parseInt($("#cmbHoraInicio7").val()) >= parseInt($("#cmbHoraFin7").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 7, $("#cmbHoraInicio7").val(), 
						$("#cmbHoraFin7").val(), $("#cmbMinutos").val(), 1);
			}
			if($("#chk2Horario7").prop("checked"))
			{
				if(parseInt($("#cmb2HoraInicio7").val()) >= parseInt($("#cmb2HoraFin7").val()))
					alert("Error con la selección de hora de inicio y fin");
				else
					crearHorariosMedicos($("#cmbMedicos").val(), 7, $("#cmb2HoraInicio7").val(), 
						$("#cmb2HoraFin7").val(), $("#cmbMinutos").val(), 2);
			}
		}
		else
		{
			deleteHorariosMedicos();
		}

		$("#modalHorarios").modal("hide");
		/*loading(true);
		var contador = 0;
		var interval = null;
		var intervalFun = function(){
			contador++;
			if(contador == 8)
			{
				getHorariosAtencionDia(agendaMedica, $(".day-active").prop("name"));
				getHorariosAtencion(agendaMedica);
			}
			if(contador > 8)
				clearInterval(interval);
		}
		interval = setInterval(intervalFun, 1000);*/
	});

	$(document).on("click", "#btnNewPaciente", function(e){
		deshabilidaPaciente();
		$("#modalNewPaciente").modal("show");
		$("#modalBuscarPaciente").modal("hide");
	});

	$(document).on("click", ".btnSelectPaciente", function(){
		$("#modalBuscarPaciente").modal("hide");
		$(".cita").prop("id", $(this).prop("id"));
		$(".cita").text($(this).prop("name") + " - " + $("#cmbEspecialidades option:selected").text());
	});

	$(document).on("hidden.bs.modal", "#modalHorarios", function(){
		loading(true);
		var contador = 0;
		var interval = null;
		var intervalFun = function(){
			contador++;
			if(contador == 6)
			{
				getHorariosAtencionDia(agendaMedica, $(".day-active").prop("name"));
				getHorariosAtencion(agendaMedica);
			}
			if(contador > 8)
				clearInterval(interval);
		}
		interval = setInterval(intervalFun, 1000);
	});

	$(document).on("change", "#cmbProvincia", function(){
		getCmbCantones($(this).val(),0.,0);
	});

	$(document).on("change", "#cmbCanton", function(){
		getCmbParroquias($(this).val(), 0);
	});

	$("#btnImprimir").prop("href", urlPdfAgenda+"/"+$("#cmbMedicos").val()+"/"+dateNow);

	$(document).on("mouseenter", ".asignado", function(){
		$(this).tooltip({
			content: function(){
				var telf = atob($(this).attr("data-tel"));
				var cell = atob($(this).attr("data-cel"));
				var mail = atob($(this).attr("data-mail"));
				var obse = atob($(this).attr("data-obs"));
				var texto = "<strong>Teléfono: </strong>" + telf + "<br>"
							+ "<strong>Celular: </strong>" + cell + "<br>"
							+ "<strong>Email: </strong>" + mail + "<br>"
							+ "<strong>Observación: </strong>" + obse;
				return texto;
			}
		});
	});

	/*$(function() {
		$.widget( "custom.combobox", {
			_create: function() {
				this.wrapper = $( "<span class='form-control pad0'>" )
				.insertAfter( this.element );

				this.element.hide();
				this._createAutocomplete();
				//this._createShowAllButton();
			},

			_createAutocomplete: function() {
				var selected = this.element.children( ":selected" ),
				value = selected.val() ? selected.text() : "";

				this.input = $( "<input id='inputProvincia' required>" )
				.appendTo( this.wrapper )
				.val( value )
				.attr( "title", "" )
				.addClass("form-control")
				.prop("placeholder", "")
				.autocomplete({
					delay: 0,
					minLength: 3,
					source: $.proxy( this, "_source" )
				})
				.tooltip({
					classes: {
					"ui-tooltip": "ui-state-highlight"
					}
				});

				this._on( this.input, {
					autocompleteselect: function( event, ui ) {
						ui.item.option.selected = true;
						this._trigger( "select", event, {
							item: ui.item.option
						});
					},
					autocompletechange: "_removeIfInvalid"
				});
			},

			_source: function( request, response ) {
				var matcher = new RegExp( $.ui.autocomplete.escapeRegex(request.term), "i" );
				response( this.element.children( "option" ).map(function() {
					var text = $( this ).text();
					if ( this.value && ( !request.term || matcher.test(text) ) )
					return {
						label: text,
						value: text,
						option: this
					};
				}) );
			},

			_removeIfInvalid: function( event, ui ) {

				// Selected an item, nothing to do
				if ( ui.item ) {
					return;
				}

				// Search for a match (case-insensitive)
				var value = this.input.val(),
				valueLowerCase = value.toLowerCase(),
				valid = false;
				this.element.children( "option" ).each(function() {
					if ( $( this ).text().toLowerCase() === valueLowerCase ) {
						this.selected = valid = true;
						return false;
					}
				});

				// Found a match, nothing to do
				if ( valid ) {
					return;
				}

				// Remove invalid value
				this.input
				.val("")
				.attr( "title", value + " no coincide con ningún elemento" )
				.tooltip( "open" );
				this.element.val( "" );
				this._delay(function() {
					this.input.tooltip( "close" ).attr( "title", "" );
				}, 2500 );
				this.input.autocomplete( "instance" ).term = "";
			},

			_destroy: function() {
				this.wrapper.remove();
				this.element.show();
			}
		});

		$( "#cmbProvincia" ).combobox();
	});*/

});