$(document).ready(function(){

	var pag = 0;
	var pagRes = 0;
	var f = new Date();

	var año_min = f.getFullYear() - 100;

	$("#inputFechaNacimiento").datepicker({
		dateFormat: "yy-mm-dd",
		changeMonth: true,
        changeYear: true,
        yearRange: año_min + ":" + f.getFullYear()
	});

	function soloNumeros(campo){
		campo.keyup(function(){
			this.value = (this.value + '').replace(/[^0-9]/g, '');
		});
	}

	function soloNumerosDecimales(campo){
		campo.keyup(function(){
			this.value = (this.value + '').replace(/[^0-9.]/g, '');
		});
	}

	function soloLetras(campo)
	{
		campo.keyup(function(){
			this.value = (this.value + '').replace(/[^a-zA-Z]/g, '');
		});
	}

	function soloLetrasAcentos(campo)
	{
		campo.keyup(function(){
			this.value = (this.value + '').replace(/[^a-z A-ZÑñáéíóú]/g, '');
		});
	}

	$("#inputPassword").keyup(function(){
		$("#inputPasswordSha256").val(sha256($(this).val()));
	});
	
	$("#cmbTipousuario").change(function(){

		if($(this).val() == 1)
		{
			$("#frmAdministrador").slideDown();
			$("#frmCodigoMedico").slideUp();
			$(".divMedico").addClass("d-none");
			$("#frmAsistente").slideUp();
			$("#frmFechas").slideUp();
			$(".inputAdmin").prop("required", true);
			$(".inputMedico").prop("required", false);
		}
		else if($(this).val() == 2)
		{
			$("#frmAdministrador").slideUp();
			$("#frmCodigoMedico").slideDown();
			$(".divMedico").removeClass("d-none");
			$("#frmAsistente").slideUp();
			$("#frmFechas").slideDown();
			$(".inputAdmin").prop("required", false);
			$(".inputMedico").prop("required", true);
		}
		else if($(this).val() == 3)
		{
			$("#frmAdministrador").slideUp();
			$("#frmCodigoMedico").slideUp();
			$(".divMedico").addClass("d-none");
			$("#frmAsistente").slideDown();
			$("#frmFechas").slideDown();
			$(".inputAdmin").prop("required", false);
			$(".inputMedico").prop("required", false);
			$("#cmbPeriodo").prop("required", true);
		}
	});

	$("#rdbFacturarSi").change(function(){
		if($(this).prop("checked"))
		{
			$("#divFacturacion").slideDown();
			$("#cmbInstitucion").prop("required", true);
		}
	});

	$("#rdbFacturarNo").change(function(){
		if($(this).prop("checked"))
		{
			$("#divFacturacion").slideUp();
			$("#cmbInstitucion").prop("required", false);
			$("#cmbInstitucion").val("");
			$(".divInstitucion").addClass("d0");
			$(".inputFacturacion").prop("required", false);
		}
	});

	$("#cmbInstitucion").change(function(){
		if($(this).val() == 0)
		{
			$(".divInstitucion").removeClass("d0");
			$(".inputFacturacion").prop("required", true);
		}
		else
		{
			$(".divInstitucion").addClass("d0");
			$(".inputFacturacion").prop("required", false);
		}
	});
	
	$("#inputPasswd1").keyup(function(){
		if($(this).val().length > 0)
		{
			if($(this).val() == $("#inputPasswd2").val())
				$("#btnSavePaswd").prop("disabled", false);
			else
				$("#btnSavePaswd").prop("disabled", true);
		}
		else
			$("#btnSavePaswd").prop("disabled", true);
	});

	$("#inputPasswd2").keyup(function(){
		if($(this).val().length > 0)
		{
			if($(this).val() == $("#inputPasswd1").val())
				$("#btnSavePaswd").prop("disabled", false);
			else
				$("#btnSavePaswd").prop("disabled", true);
		}
		else
			$("#btnSavePaswd").prop("disabled", true);
	});

	$("#formAltaUsuario").keypress(function(e){
		if(e.which == 13){
			return false;
		}
	})

	$("#formUpdatePasswd").keypress(function(e){
		if(e.which == 13){
			return false;
		}
	})

	function updateUsuario(codmedico, direccion, nomComercial,
		facturar, ruc_medico, nro_establ, ptoEmision, tip_contrib, nro_contrib,
		institucion, razon_social, telf_institucion, cell_institucion, email_institucion, dir_matriz, dir_establ,
		firma_elec, clave_firma)
	{
		var dat = {
			cedula: $("#inputCedula").val(),
			username: $("#inputUsername").val(),
			nombres: $("#inputNombres").val(),
			apellidos: $("#inputApellidos").val(),
			telefono: $("#inputTelefonocon").val(),
			mail: $("#inputMail").val(),
			codmedico: codmedico,
			direccion: direccion,
			nomComercial: nomComercial,
			tipo_iden: $("#cmbTipoIdentificacion").val(),
			facturar: facturar,
			ruc_medico: ruc_medico,
			nro_establ: nro_establ,
			ptoEmision: ptoEmision,
			tip_contrib: tip_contrib,
			nro_contrib: nro_contrib,
			institucion: institucion,
			razon_social: razon_social,
			telf_institucion: telf_institucion,
			cell_institucion: cell_institucion,
			email_institucion: email_institucion,
			dir_matriz: dir_matriz,
			dir_establ: dir_establ,
			firma_elec: firma_elec,
			clave_firma: clave_firma
		};

		$.ajax({
			data: dat,
			url: $("#formAltaUsuario").attr("action"),
			method: "POST",
			success: function(datos){
				alert(datos);
				window.location = $("#btnCancel").prop("href");
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function updatePassUser()
	{
		var dat = {
			passwd1: sha256($("#inputPasswd1").val())
		};

		$.ajax({
			data: dat,
			url: $("#formUpdatePasswd").attr("action"),
			method: "POST",
			success: function(datos){
				alert(datos);
			},
			error: function(error){
				console.log(error);
			}
		});
	}

	function catalogoUsuarios(pagina, buscar)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 20,
				buscar: buscar
			},
			url: $("#catalogUser").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#catalogUser").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function catalogoUsuariosResponsive(pagina, buscar)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 5,
				buscar: buscar
			},
			url: $("#catalogUserRes").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#catalogUserRes").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function catalogoAsistentes(pagina)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 20
			},
			url: $("#catalogAsist").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#catalogAsist").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		})
	}

	function catalogoAsistentesResponsive(pagina)
	{
		$.ajax({
			data: {
				pagina: pagina,
				cantidad: 5
			},
			url: $("#tablaAsistentesResponsive").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#tablaAsistentesResponsive").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function updateEstadoUser(url, campo)
	{
		$.ajax({
			data: {},
			url: url,
			method: "POST",
			success: function(datos){
				if(datos == 0)
				{
					campo.removeClass("btn-success");
					campo.removeClass("Activo");
					campo.addClass("btn-danger");
					campo.addClass("Inactivo");
					campo.text("Inactivo");
				}
				else
				{
					campo.removeClass("btn-danger");
					campo.removeClass("Inactivo");
					campo.addClass("btn-success");
					campo.addClass("Activo");
					campo.text("Activo");
				}
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText);
			}
		});
	}

	function deleteUser(url)
	{
		$.ajax({
			data: {},
			url: url,
			method: "POST",
			success: function(){
				catalogoUsuarios(pag, "");
				catalogoUsuariosResponsive(pagRes, "");
				$("#btnCancelDel").click();
			},
			error: function(error){
				console.log(error.responseText);
			}
		});
	}

	function createAsistenteMedico(idAsistente, idMedico)
	{
		var dat = {
			idAsistente: idAsistente,
			idMedico: idMedico
		};

		$.ajax({
			data: dat,
			url: $("#data-url").val(),
			method: "POST",
			success: function(datos){
				window.location = $("#lkRepAsistente").attr("data-url");
			},
			error: function(error){
				$("#errores").html(error.responseText);
			}
		})
	}

	function getUsuarioByCedula(cedula)
	{
		var dat = {
			cedula: cedula
		};

		$.ajax({
			data: dat,
			url: $("#inputNewCedula").attr("data-url"),
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos["success"])
				{
					if(datos["rol"] == 4)
						$(".alert-cedula").hide();
					else
					{
						$("#inputNewCedula").val("");
						$("#inputNewCedula").focus();
						$(".alert-cedula").show();
					}
				}
				else
				{
					$(".alert-cedula").hide();
				}
			},
			error: function(error){
				console.log(error);
			}
		})
	}

	function getUsuarioByLogin(loginusuario)
	{
		var dat = {
			loginusuario: loginusuario
		};

		$.ajax({
			data: dat,
			url: $("#inputNombreUsuario").attr("data-url"),
			method: "POST",
			dataType: "JSON",
			success: function(datos){
				if(datos["success"])
				{
					$("#inputNombreUsuario").val("");
					$("#inputNombreUsuario").focus();
					$(".alert-usuario").show();
				}
				else
				{
					$(".alert-usuario").hide();
				}
			},
			error: function(error){
				console.log(error);
			}
		})
	}

	function getChkEspecialidad()
	{
		var dat = {
			medico: $("#ulEspecialidades").attr("data-id")
		};

		$.ajax({
			data: dat,
			url: $("#ulEspecialidades").attr("data-url"),
			method: "POST",
			success: function(datos){
				$("#ulEspecialidades").html(datos);
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function createEspecialidadMedico(especialidad)
	{
		var dat = {
			medico: $("#ulEspecialidades").attr("data-id"),
			especialidad: especialidad
		};

		$.ajax({
			data: dat,
			url: "../create/especialidad/medico/",
			method: "POST",
			success: function(datos){
				console.log(datos)
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function deleteEspecialidadMedico(especialidad)
	{
		var dat = {
			medico: $("#ulEspecialidades").attr("data-id"),
			especialidad: especialidad
		};

		$.ajax({
			data: dat,
			url: "../delete/especialidad/medico/",
			method: "POST",
			success: function(datos){
				console.log(datos)
			},
			error: function(error){
				console.log(error);
				$("#errores").html(error.responseText)
			}
		});
	}

	function buscarTabla(texto)
	{
		$("#table_usuarios tbody tr").each(function(){
			var existe = false;
			$(this).each(function(){
				if($(this).text().toLowerCase().indexOf(texto.toLowerCase()) >= 0)
				{
					existe = true;
				}
			});

			if(existe == true)
				$(this).show();
			else
				$(this).hide();
		});
	}

	function buscarTablaResponsive(texto)
	{
		$("#table_usuarios_responsive tbody").each(function(){
			var existe = false;
			$(this).each(function(){
				if($(this).text().toLowerCase().indexOf(texto.toLowerCase()) >= 0)
				{
					existe = true;
				}
			});

			if(existe == true)
				$(this).show();
			else
				$(this).hide();
		});
	}

	catalogoUsuarios(0, "");
	catalogoUsuariosResponsive(0, "");
	catalogoAsistentes(0);
	catalogoAsistentesResponsive(0);
	getChkEspecialidad();

	$("#inputNewCedula").blur(function(){
		getUsuarioByCedula($(this).val());
	});

	$("#inputNombreUsuario").blur(function(){
		getUsuarioByLogin($(this).val());
	});

	$(".dropdown dt a").on('click', function() {
	  	$(".dropdown dd ul").slideToggle("fast");
	});

	$(".dropdown dd ul li a").on('click', function() {
	  	$(".dropdown dd ul").hide();
	});

	$(document).bind('click', function(e) {
	  	var $clicked = $(e.target);
	  	if (!$clicked.parents().hasClass("dropdown"))
	  		$(".dropdown dd ul").hide();
	});

	$(document).on("change", "#rdbOptionsRadios1", function(){
		if($(this).prop("checked"))
		{
			$(".divAsistente").slideDown();
			$("#inputAsistente").prop("required", true);
		}
	});

	$(document).on("change", "#rdbOptionsRadios2", function(){
		if($(this).prop("checked"))
		{
			$(".divAsistente").slideUp();
			$("#inputAsistente").prop("required", false);
		}
	});

	/*$("#inputIdAsistente").change(function(){
		var asistente = $("#dtlItems option[value=" + $(this).val() + "]").attr("data-id");
		$("#inputIdAsistenteOculto").val(asistente);
	});*/

	$("#formAltaUsuario").on("submit", function(e){
		e.preventDefault();
		$("#btnGuardar").prop("disabled", true);

		if($("#inputRol").val() == 1)
		{
			updateUsuario("0", "", "", "", "", "", "", "", "",
				"", "", "", "", "", "", "", "", "");
		}
		else if($("#inputRol").val() == 2)
		{
			if($("#rdbFacturarSi").prop("checked"))
			{
				updateUsuario($("#inputCodmedico").val(), $("#inputDireccion").val(), $("#inputNombreComercial").val(), 
					"si", $("#inputRuc").val(), $("#inputNroEstabl").val(), 
					$("#inputPtoEmision").val(), $("#cmbTipoContribuyente").val(), $("#inputNroContri").val(),
					$("#cmbInstitucion").val(), $("#inputRazonSocial").val(), $("#inputTelfInst").val(), 
					$("#inputCellInst").val(),	$("#inputEmailInst").val(), $("#inputDirMatriz").val(),
					$("#inputDirEstabl").val(), $("#inputFirma").val(), $("#inputClaveFirma").val());
			}

			if($("#rdbFacturarNo").prop("checked"))
			{
				updateUsuario($("#inputCodmedico").val(), $("#inputDireccion").val(), $("#inputNombreComercial").val(),
					"no", "", "", "", "", "",
					"", "", "", "", "", "", "", "", "");
			}
				
		}
		else if($("#inputRol").val() == 3)
		{
			updateUsuario("0", "", "", "", "", "", "", "", "",
				"", "", "", "", "", "", "", "", "");
		}
		
	});

	$("#btnSavePaswd").click(function(e){
		e.preventDefault();
		$("#btnCancelPass").click();
		updatePassUser();
	});

	$(document).on("click", ".btnDeleteUser", function(e){
		e.preventDefault();
		$("#modalDeleteUser").modal("show");
		$("#inputLink").val($(this).prop("href"));
	});

	$("#btnDelete").click(function(){
		deleteUser($("#inputLink").val());
	});

	$("#btnCancelDel").click(function(){
		$("#inputLink").val("");
	});

	$(document).on("click", ".btnEstado", function(e){
		e.preventDefault();

		if($(this).hasClass("Activo"))
			updateEstadoUser("../updateEstado/" + $(this).prop("name") + "/0", $(".u" + $(this).prop("name")));
		else
			updateEstadoUser("../updateEstado/" + $(this).prop("name") + "/1", $(".u" + $(this).prop("name")));
	});

	$(document).on("click", ".btnAsignar", function(e){
		e.preventDefault();
		createAsistenteMedico($(this).prop("name"), $("#inputIdMedico").val());
	});

	$("#inputDropdownMenuE").click(function(){
		$(".dropdown-menu").css({
			"z-index": 9999
		});
	});

	$(document).on("change", ".chkEspecialidad", function(){
		if($(this).prop("checked"))
			createEspecialidadMedico($(this).val());
		else
			deleteEspecialidadMedico($(this).val());
	});

	$("#cmbTipoIdentificacion").change(function(){
		if($(this).val() == "CED")
		{
			$("#inputNewCedula").attr("minlength", "1");
			$("#inputNewCedula").prop("maxlength", 10);
			$("#inputNewCedula").removeClass("sln");
			$("#inputNewCedula").addClass("sn");
			$("#inputNewCedula").val("");

			$("#inputCedula").attr("minlength", "1");
			$("#inputCedula").prop("maxlength", 10);
			$("#inputCedula").removeClass("sln");
			$("#inputCedula").addClass("sn");
			$("#inputCedula").val("");
		}
		else if($(this).val() == "RUC")
		{
			$("#inputNewCedula").attr("minlength", "13");
			$("#inputNewCedula").prop("maxlength", 13);
			$("#inputNewCedula").removeClass("sln");
			$("#inputNewCedula").addClass("sn");
			$("#inputNewCedula").val("");

			$("#inputCedula").attr("minlength", "13");
			$("#inputCedula").prop("maxlength", 13);
			$("#inputCedula").removeClass("sln");
			$("#inputCedula").addClass("sn");
			$("#inputCedula").val("");
		}
		else if($(this).val() == "PAS")
		{
			$("#inputNewCedula").attr("minlength", "15");
			$("#inputNewCedula").prop("maxlength", 20);
			$("#inputNewCedula").removeClass("sn");
			$("#inputNewCedula").addClass("sln");
			$("#inputNewCedula").val("");

			$("#inputCedula").attr("minlength", "15");
			$("#inputCedula").prop("maxlength", 20);
			$("#inputCedula").removeClass("sn");
			$("#inputCedula").addClass("sln");
			$("#inputCedula").val("");
		}

	});

	//////////////FIRMA ELECTRONICA///////////////
	$("#flFirmaElectronica").change(function(){
		subirFirma();
	});

	//////////////PAGINACIONES////////////////////

	$(document).on("keyup", "#txtBuscar", function(){
		catalogoUsuarios(0, $(this).val());
	});

	$(document).on("keyup", "#txtBuscarRes", function(){
		catalogoUsuariosResponsive(0, $(this).val());
	});

	$(document).on("click", "#tablaUsuarios .paginacion .page-link", function(e){
		e.preventDefault();
		pag = $(this).prop("id");
		catalogoUsuarios(pag, $("#txtBuscar").val());
	});

	$(document).on("click", "#tablaUsuariosResponsive .paginacion_responsive .page-link", function(e){
		e.preventDefault();
		pagRes = $(this).prop("id");
		catalogoUsuariosResponsive(pagRes, $("#txtBuscarRes").val());
	});

	$(document).on("click", "#tablaAsistentes .paginacion .page-link", function(e){
		e.preventDefault();
		pag = $(this).prop("id");
		catalogoAsistentes(pag);
	});

	$(document).on("click", "#tablaAsistentesResponsive .paginacion_responsive .page-link", function(e){
		e.preventDefault();
		pagRes = $(this).prop("id");
		catalogoAsistentesResponsive(pagRes);
	});

});