<?php

namespace LoginBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Usuario
 *
 * @ORM\Table(name="usuario")
 * @ORM\Entity(repositoryClass="LoginBundle\Repository\UsuarioRepository")
 */
class Usuario
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_usuario", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Administrador", mappedBy="idUsuario")
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Asistente", mappedBy="idUsuario")
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Medico", mappedBy="idUsuario")
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Paciente", mappedBy="idUsuario")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Rol")
     * @ORM\JoinColumn(name="id_rol_usuario", referencedColumnName="id_rol_usuario")
     */
    private $rolUsuario;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Asistente")
     * @ORM\JoinColumn(name="id_asistente", referencedColumnName="id_asistente", nullable=true, onDelete="CASCADE")
     */
    private $idAsistente;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Administrador")
     * @ORM\JoinColumn(name="id_administrador", referencedColumnName="id_administrador", nullable=true, onDelete="CASCADE")
     */
    private $idAdministrador;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente", nullable=true, onDelete="CASCADE")
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico", nullable=true, onDelete="CASCADE")
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="cedula_usuario", type="string", length=20, unique=true)
     */
    private $cedula;

    /**
     * @var string
     *
     * @ORM\Column(name="login_usuario", type="string", length=30, unique=true)
     */
    private $login;

    /**
     * @var string
     *
     * @ORM\Column(name="password_usuario", type="string", length=70)
     */
    private $password;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_usuario", type="string", length=40)
     */
    private $nombre;

    /**
     * @var string
     *
     * @ORM\Column(name="apellido_usuario", type="string", length=40)
     */
    private $apellido;

    /**
     * @var string
     *
     * @ORM\Column(name="hash_usuario", type="string", length=70)
     */
    private $hash;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_usuario", type="boolean")
     */
    private $estado;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_usuario", type="string", length=100)
     */
    private $telefono;

    /**
     * @var string
     *
     * @ORM\Column(name="correo_usuario", type="string", length=40)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="tip_id_usuario", type="string", length=5)
     */
    private $tipoIdentificacion;

    /**
     * @var string
     *
     * @ORM\Column(name="foto_usuario", type="string", length=100)
     */
    private $foto;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set rolUsuario
     *
     * @param integer $rolUsuario
     *
     * @return Usuario
     */
    public function setRolUsuario($rolUsuario)
    {
        $this->rolUsuario = $rolUsuario;

        return $this;
    }

    /**
     * Get rolUsuario
     *
     * @return int
     */
    public function getRolUsuario()
    {
        return $this->rolUsuario;
    }

    /**
     * Set idAsistente
     *
     * @param integer $idAsistente
     *
     * @return Usuario
     */
    public function setIdAsistente($idAsistente)
    {
        $this->idAsistente = $idAsistente;

        return $this;
    }

    /**
     * Get idAsistente
     *
     * @return int
     */
    public function getIdAsistente()
    {
        return $this->idAsistente;
    }

    /**
     * Set idAdministrador
     *
     * @param integer $idAdministrador
     *
     * @return Usuario
     */
    public function setIdAdministrador($idAdministrador)
    {
        $this->idAdministrador = $idAdministrador;

        return $this;
    }

    /**
     * Get idAdministrador
     *
     * @return int
     */
    public function getIdAdministrador()
    {
        return $this->idAdministrador;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return Usuario
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return Usuario
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set cedula
     *
     * @param string $cedula
     *
     * @return Usuario
     */
    public function setCedula($cedula)
    {
        $this->cedula = $cedula;

        return $this;
    }

    /**
     * Get cedula
     *
     * @return string
     */
    public function getCedula()
    {
        return $this->cedula;
    }

    /**
     * Set login
     *
     * @param string $login
     *
     * @return Usuario
     */
    public function setLogin($login)
    {
        $this->login = $login;

        return $this;
    }

    /**
     * Get login
     *
     * @return string
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * Set password
     *
     * @param string $password
     *
     * @return Usuario
     */
    public function setPassword($password)
    {
        $this->password = $password;

        return $this;
    }

    /**
     * Get password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return Usuario
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set apellido
     *
     * @param string $apellido
     *
     * @return Usuario
     */
    public function setApellido($apellido)
    {
        $this->apellido = $apellido;

        return $this;
    }

    /**
     * Get apellido
     *
     * @return string
     */
    public function getApellido()
    {
        return $this->apellido;
    }

    /**
     * Set hash
     *
     * @param string $hash
     *
     * @return Usuario
     */
    public function setHash($hash)
    {
        $this->hash = $hash;

        return $this;
    }

    /**
     * Get hash
     *
     * @return string
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return Usuario
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set telefono
     *
     * @param string $telefono
     *
     * @return Usuario
     */
    public function setTelefono($telefono)
    {
        $this->telefono = $telefono;

        return $this;
    }

    /**
     * Get telefono
     *
     * @return string
     */
    public function getTelefono()
    {
        return $this->telefono;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Usuario
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set tipoIdentificacion
     *
     * @param string $tipoIdentificacion
     *
     * @return Usuario
     */
    public function setTipoIdentificacion($tipoIdentificacion)
    {
        $this->tipoIdentificacion = $tipoIdentificacion;

        return $this;
    }

    /**
     * Get tipoIdentificacion
     *
     * @return string
     */
    public function getTipoIdentificacion()
    {
        return $this->tipoIdentificacion;
    }

    /**
     * Set foto
     *
     * @param string $foto
     *
     * @return Usuario
     */
    public function setFoto($foto)
    {
        $this->foto = $foto;

        return $this;
    }

    /**
     * Get foto
     *
     * @return string
     */
    public function getFoto()
    {
        return $this->foto;
    }
}

