<?php

namespace LoginBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\Storage\PhpBridgeSessionStorage;
use AdministradorBundle\Entity\RegistroLogin;

class RolController extends Controller
{
	/**
	 * @Route("/rol/{user}", name="roles")
	 */
	public function rolAction($user)
	{
		$em = $this->getDoctrine()->getManager();
		$repository = $em->getRepository("LoginBundle:Usuario");
		$usuario = $repository->find($user);

		$session = new Session();
        $session->set("rol", $usuario->getRolUsuario()->getId());
        $session->set("usuario", $usuario->getId());
        $session->start();

        if($session->isStarted() && $session->has("rol"))
        {
        	if($usuario->getRolUsuario()->getId() == 1)
				return $this->redirectToRoute("homeAdmin");
			elseif($usuario->getRolUsuario()->getId() == 2 || $usuario->getRolUsuario()->getId() == 3)
			{
				$em = $this->getDoctrine()->getManager();

				$registro = new RegistroLogin();
				$registro->setIdUsuario($usuario);
				$registro->setFecha(date("Y-m-d"));
				$registro->setHora(date("H:i:s"));

				$em->persist($registro);
				$em->flush();
				
				return $this->redirectToRoute("homeUsuario");
			}
			else
				return $this->redirectToRoute("logout");
        }
	}

}
