<?php

namespace LoginBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\Storage\PhpBridgeSessionStorage;

class LoginController extends Controller
{
	/**
     * @Route("/", name="loginHome")
     */
    public function indexAction(Request $request)
    {
        if($request->getSession()->isStarted() == true)
        {
            $request->getSession()->migrate(true);
            $request->getSession()->invalidate();
            //return $this->redirectToRoute('logout');
            return $this->render('@Login/Default/index.html.twig');
        }
        else
            return $this->render('@Login/Default/index.html.twig');
    }

    /**
     * @Route("/login/", name="login")
     */
    public function loginAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $repository = $em->getRepository("LoginBundle:Usuario");

        $usuario = $repository->findOneBy(array(
            'login' => $request->get("usuario"), 
            "password" => $request->get("pass")));

        
        if($usuario)
        {
            if($usuario->getEstado() == false)
                return $this->redirectToRoute("loginHome", array("msg" => base64_encode(3), "user" => base64_encode($usuario->getNombre()." ".$usuario->getApellido())));
            else
                return $this->redirectToRoute("roles", array("user" => $usuario->getId()));
        }
        else
            return $this->redirectToRoute("loginHome", array("msg" => base64_encode(1)));
    }

    /**
     * @Route("/logout/", name="logout")
     */
    public function logoutAction(Request $request)
    {
        $request->getSession()->remove("rol");
        $request->getSession()->remove("usuario");
       
        return $this->redirectToRoute("loginHome");
    }

    /**
     * @Route("/recuperar/pass/", name="recuperarPass")
     */
    public function recuperarPassAction()
    {
        return $this->render('@Login/Default/pass.html.twig');
    }

    /**
     * @Route("/usuario/pass/datos/", name="datosUsuarioPass")
     */
    public function datosUsuarioPassAction()
    {
        $em = $this->getDoctrine()->getManager();
        $query = "select u from LoginBundle:Usuario u where u.rolUsuario in(1, 2, 3) and u.estado = true and u.cedula = '".$_POST["cedula"]."'";
        $usuario = $em->createQuery($query)->getSingleResult();
        $mail = $_POST["mail"];

        if($usuario)
        {
            if($usuario->getEmail() === $mail)
            {
                $message = (new \Swift_Message('Programamed - Nueva Contraseña'))
                ->setFrom('tecentel@tecentel.com')
                ->setTo($usuario->getEmail())
                ->setBody(
                    $this->renderView("@Login/Mail/mail.html.twig", array("usuario" => $usuario)), 'text/html'
                );
                $this->get('mailer')->send($message);
                return new Response("ok");
            }
            else
                return new Response("nokc");
        }
        else
            return new Response("nok");
    }

    /**
     * @Route("/usuario/new/pass/{user}", name="usuarioNewPass")
     */
    public function newPassUsuarioAction($user=0)
    {
        return $this->render("@Login/Default/new.pass.html.twig", array("user" => $user));
    }

}
