<?php

namespace LoginBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\Storage\PhpBridgeSessionStorage;
use AgendaBundle\Entity\CitaMedica;
use AdministradorBundle\Entity\Paciente;
use LoginBundle\Entity\Usuario;
use AgendaBundle\Entity\HistoriaClinica;
use AgendaBundle\Entity\AntecedentesPersonales;
use AgendaBundle\Entity\AntecedentesFamiliares;
use AgendaBundle\Entity\AntecedentesGinecobstetricos;
use LoginBundle\Entity\Jsonprueba;

class AgendacionController extends Controller
{
    /**
     * @Route("/agendacion/", name="agendacionHome")
     */
    public function indexAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $especialidades = $em
            ->getRepository('AdministradorBundle:Especialidades')
            ->findBy(['estado' => true]);
        //echo sizeof($especialidades);

        return $this->render('@Login/Default/agendacion.html.twig', [
            'datos' => $especialidades,
        ]);
    }

    /**
     * @Route("/agendacion/especialidad/{idEspecialidad}/{nombreEspecialidad}", name="agendacionEspecialidad")
     */
    public function getMedicosEspecialidad(
        Request $request,
        $idEspecialidad = 0,
        $nombreEspecialidad = ''
    ) {
        if ($idEspecialidad == 0 || $nombreEspecialidad == '') {
            return $this->redirectToRoute('logout');
        } else {
            $em = $this->getDoctrine()->getManager();
            /* echo sizeof($medicosEspecialidad); */
            $query =
                /* 'select em, me from AdministradorBundle:MedicoEspecialidad em join em.idMedico me where em.idEspecialidad = ' .
                $idEspecialidad .
                ''; */
                'select em, me from AdministradorBundle:MedicoEspecialidad em join em.idMedico me join me.idUsuario us 
                where em.idEspecialidad = '.$idEspecialidad.' and us.estado = true';
            $medicosEspecialidad = $em->createQuery($query)->getResult();
            //dump($medicosEspecialidad);

            return $this->render('@Login/Default/especialidad.html.twig', [
                'especialidad' => $idEspecialidad,
                'nombreEspecialidad' => $nombreEspecialidad,
                'data' => $medicosEspecialidad,
            ]);
        }
    }

    /**
     * @Route("/agendacion/calendario/{idMedico}/{especialidad}/{medico}/{idEspecialidad}", name="agendacionCalendarioMedico")
     */
    public function getCalendarioMedico(
        Request $request,
        $idMedico = 0,
        $especialidad = '',
        $medico = '',
        $idEspecialidad
    ) {
        if ($idMedico == 0 || $especialidad == '' || $medico == '' || $idEspecialidad == null) {
            return $this->redirectToRoute('logout');
        } else {
            return $this->render('@Login/Default/calendarioAgenda.html.twig', [
                'medico' => $idMedico,
                'especialidad' => $especialidad,
                'nombreMedico' => $medico,
                'idEspecialidad' => $idEspecialidad
            ]);
        }
    }

    /**
     * @Route("/agendacion/dia/", name="agendacionDia")
     */
    public function readHorarioMedicoDiaAction()
    {
    	$em = $this->getDoctrine()->getManager();
        $pfecha = date("Y-m-d");
        if($_POST["fecha"] != "")
            $pfecha = $_POST["fecha"];

        $dia = date("N", strtotime($pfecha));
    	$horario = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $_POST["agenda"], "idDiasLaborables" => $dia, "estado" => true), array("orden" => "ASC"));

    	$html = "";
    	if(!$horario)
    	{
    		$html .= '<div class="d100 dcentro pad20">
                        <button class="btn btn-primary" id="btnAgregarHorario">Agregar días y horarios de atención del médico</button>
                    </div>';
    	}
    	else
    	{
            $varAux = 0;
            foreach($horario as $row)
            {
                $atencion = $em->getRepository("AgendaBundle:AgendaHL")->findBy(array("idHorarioLaborable" => $row->getId()), array("idHorarioLaborable" => "ASC", "id" => "ASC"));

                foreach($atencion as $fila)
                {
                    $citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->findOneBy(array("idAgenda" => $_POST["agenda"], "fecha" => $pfecha, "hora" => $fila->getHora()));
                    if($citaMedica)
                    {
                        if($citaMedica->getIdEstadoCita()->getId() == 4){
                            $tooltip = "En proceso de confirmación";
                            $asignado = '<div class="d100 dcentro pendiente" title="'.$tooltip.'" data-tel="tel" data-cel="cel" data-mail="mail" >'.$tooltip.'</div>';
                        }else{
                            //$tooltip = "Teléfono: ".$citaMedica->getIdPaciente()->getTelefono()." Celular: ".$citaMedica->getIdPaciente()->getIdUsuario()->getTelefono()." Email: ".$citaMedica->getIdPaciente()->getIdUsuario()->getEmail();
                            //$tooltip = "Horario ya agendado";
                            //$asignado = '<div class="d100 dcentro asignado" title="'.$tooltip.'" id="'.base64_encode($citaMedica->getIdPaciente()->getId()).'" accesskey="'.base64_encode($citaMedica->getId()).'" data-tel="'.base64_encode($citaMedica->getIdPaciente()->getTelefono()).'" data-cel="'.base64_encode($citaMedica->getIdPaciente()->getIdUsuario()->getTelefono()).'" data-mail="'.base64_encode($citaMedica->getIdPaciente()->getIdUsuario()->getEmail()).'" >'.$citaMedica->getIdPaciente()->getIdUsuario()->getApellido().' '.$citaMedica->getIdPaciente()->getIdUsuario()->getNombre().' - '.$citaMedica->getIdEspecialidad()->getNombre().'</div>';
                            $asignado = '<div class="d100 dcentro asignado" title="Horario ya agendado" data-tel="tel" data-cel="cel" data-mail="mail" >Horario ya agendado</div>';
                        }
                    }
                    else
                    {
                        $asignado = '<div class="d100 dcentro disponible" title="Disponible" data-tel="tel" data-cel="cel" data-mail="mail" >Disponible</div>';
                    }

                    $html .= '<div class="d50 pad5-v dcentro">
                                <div class="d20 pad5 text-right"><label>'.$fila->getHora().'</label></div>
                                <div class="d80 pad5"><div class="d100 mar0 pad5 '.(($asignado == '<div class="d100 dcentro disponible" title="Disponible" data-tel="tel" data-cel="cel" data-mail="mail" >Disponible</div>' ? "horario" : "ocupado")).'" id="'.$fila->getId().'">'.$asignado.'</div></div>
                            </div>';
                    $varAux = $varAux + 1;
                }
            }
    	}
    	return new Response($html);
    }

    /**
     * @Route("/agendacion/login/reserva", name="agendacionReservacion")
     */
    public function agendacionLogin(){
        $em = $this->getDoctrine()->getManager();
        $idMedico = $_POST["medico"];
        $celular = $_POST["celular"];
        $cedula = $_POST["cedula"];
        $idEspecialidad = $_POST["especialidad"];
        $idAgenda = $_POST["agenda"];
        $fecha = $_POST["fecha"];
        $idHora = $_POST["hora"];

        $status = "Error";
        $usuario = "";

        if($celular == '' && $cedula == ''){
            $status = "Error";
        }else{
            $usuario = $em->getRepository("LoginBundle:Usuario")->findOneBy(array("telefono" => $celular, "cedula" => $cedula));
            if($usuario){
                if($usuario->getIdPaciente() != null){
                    $paciente = $em->getRepository("AdministradorBundle:Paciente")->find($usuario->getIdPaciente()->getId());
                    $especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($idEspecialidad);
                    $estadoCita = $em->getRepository("AgendaBundle:EstadoCitaMedica")->find(4);
                    $agenda = $em->getRepository("AgendaBundle:Agenda")->find($idAgenda);
                    $hora = $em->getRepository("AgendaBundle:AgendaHL")->find($idHora);
                    $citaMedica = new CitaMedica();

                    if($idMedico == $paciente->getIdMedico()->getId()){
                        $citaMedica->setIdPaciente($paciente);
                    }else{
                        $pacienteNuevo = $em->getRepository("AdministradorBundle:Paciente")->findOneBy(array("idMedico" => $idMedico, "idUsuario" => $usuario->getId()));
                        if($pacienteNuevo){
                            $citaMedica->setIdPaciente($pacienteNuevo); 
                        }else{
                            $medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedico);
                            $nuevoPaciente = new Paciente();
                            $nuevoPaciente->setIdUsuario($usuario);
                            $nuevoPaciente->setIdMedico($medico);
                            $nuevoPaciente->setFechaRegistro(date('Y-m-d'));
                            $nuevoPaciente->setFechaNacimiento($paciente->getFechaNacimiento());
                            $nuevoPaciente->setGenero($paciente->getGenero());
                            $nuevoPaciente->setEstadoCivil($paciente->getEstadoCivil());
                            $nuevoPaciente->setDireccion($paciente->getDireccion());
                            $nuevoPaciente->setSector($paciente->getSector());
                            $nuevoPaciente->setContacto($paciente->getContacto());
                            $nuevoPaciente->setOcupacion($paciente->getOcupacion());
                            $nuevoPaciente->setAseguradora($paciente->getAseguradora());
                            $nuevoPaciente->setTelefono($paciente->getTelefono());
                            $em->persist($nuevoPaciente);
                            
                            $citaMedica->setIdPaciente($nuevoPaciente);

                            $codigoHc = "";
                            if($nuevoPaciente->getId() < 10)
                                $codigoHc = "00000".$nuevoPaciente->getId();
                            elseif($nuevoPaciente->getId() < 100)
                                $codigoHc = "0000".$nuevoPaciente->getId();
                            elseif($nuevoPaciente->getId() < 1000)
                                $codigoHc = "000".$nuevoPaciente->getId();
                            elseif($nuevoPaciente->getId() < 10000)
                                $codigoHc = "00".$nuevoPaciente->getId();
                            elseif($nuevoPaciente->getId() < 100000)
                                $codigoHc = "0".$nuevoPaciente->getId();
                            elseif($nuevoPaciente->getId() < 1000000)
                                $codigoHc = $nuevoPaciente->getId();

                            $historiaClinica = new HistoriaClinica();
                            $historiaClinica->setIdPaciente($nuevoPaciente);
                            $historiaClinica->setNumeroHc($codigoHc);
                            $historiaClinica->setFechaCreacion(date("Y-m-d"));
                            $em->persist($historiaClinica);

                            $antecedentesPersonales = new AntecedentesPersonales();
                            $antecedentesPersonales->setIdPaciente($nuevoPaciente);
                            $em->persist($antecedentesPersonales);

                            $antecedentesFamiliares = new AntecedentesFamiliares();
                            $antecedentesFamiliares->setIdPaciente($nuevoPaciente);
                            $em->persist($antecedentesFamiliares);

                            if($paciente->getGenero() == "Femenino")
                            {
                                $antecedentesGine = new AntecedentesGinecobstetricos();
                                $antecedentesGine->setIdPaciente($nuevoPaciente);
                                $em->persist($antecedentesGine);
                            }
                            $em->flush(); 
                        }
                    }

                    $citaMedica->setIdEspecialidad($especialidad);
                    $citaMedica->setIdEstadoCita($estadoCita);
                    $citaMedica->setIdAgenda($agenda);
                    $citaMedica->setFecha($fecha);
                    $citaMedica->setHora($hora->getHora());
                    $citaMedica->setFactura(false);
                    $em->persist($citaMedica);
                    $em->flush(); 
                    $status = "Success";
                }
            } 
        }
        $json = [
            "status" => $status,
            "usuario" => $usuario
        ];
        $response = new Response();
        $response->setContent(json_encode($json));
        $response->headers->set('Content-Type', 'application/json');
        //return new Response(json_encode($json));
        return $response;
    }

    /**
     * @Route("/agendacion/registro/reserva", name="agendaRegistroReservacion")
     */
    public function agendacionRegistro(){
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $idMedico = $_POST["medico"];
        $celular = $_POST["celular"];
        $cedula = $_POST["cedula"];
        $idEspecialidad = $_POST["especialidad"];
        $idAgenda = $_POST["agenda"];
        $fecha = $_POST["fecha"];
        $idHora = $_POST["hora"];

        $correo = $_POST["correo"];
        $nombres = $_POST["nombres"];
        $apellidos = $_POST["apellidos"];
        $direccion = $_POST["direccion"];
        $genero = $_POST["genero"];
        $status = "Error";
        
        if($correo != '' && $nombres != '' && $apellidos != '' && $direccion != ''){
            $rolUsuario = $em->getRepository("LoginBundle:Rol")->find(4);
            $medico = $em->getRepository("AdministradorBundle:Medico")->find($idMedico);

            $especialidad = $em->getRepository("AdministradorBundle:Especialidades")->find($idEspecialidad);
            $estadoCita = $em->getRepository("AgendaBundle:EstadoCitaMedica")->find(4);
            $agenda = $em->getRepository("AgendaBundle:Agenda")->find($idAgenda);
            $hora = $em->getRepository("AgendaBundle:AgendaHL")->find($idHora);

            try{
                $usuario = new Usuario();
                $usuario->setRolUsuario($rolUsuario);
                $usuario->setCedula($cedula);
                $usuario->setNombre($nombres);
                $usuario->setApellido($apellidos);
                $usuario->setTelefono($celular);
                $usuario->setEmail($correo);
                $usuario->setEstado(true);
                $usuario->setTipoIdentificacion('CED');
                $em->persist($usuario);
                $em->flush();

                $paciente = new Paciente();
                $paciente->setIdUsuario($usuario);
                $paciente->setIdMedico($medico);
                $paciente->setDireccion($direccion);
                $paciente->setTelefono($celular);
                $paciente->setFechaRegistro(date('Y-m-d'));
                $em->persist($paciente);
                $em->flush(); 

                $usuario->setIdPaciente($paciente);

                $codigoHc = "";
                if($paciente->getId() < 10)
                    $codigoHc = "00000".$paciente->getId();
                elseif($paciente->getId() < 100)
                    $codigoHc = "0000".$paciente->getId();
                elseif($paciente->getId() < 1000)
                    $codigoHc = "000".$paciente->getId();
                elseif($paciente->getId() < 10000)
                    $codigoHc = "00".$paciente->getId();
                elseif($paciente->getId() < 100000)
                    $codigoHc = "0".$paciente->getId();
                elseif($paciente->getId() < 1000000)
                    $codigoHc = $paciente->getId();

                $historiaClinica = new HistoriaClinica();
                $historiaClinica->setIdPaciente($paciente);
                $historiaClinica->setNumeroHc($codigoHc);
                $historiaClinica->setFechaCreacion(date("Y-m-d"));
                $em->persist($historiaClinica);

                $antecedentesPersonales = new AntecedentesPersonales();
                $antecedentesPersonales->setIdPaciente($paciente);
                $em->persist($antecedentesPersonales);

                $antecedentesFamiliares = new AntecedentesFamiliares();
                $antecedentesFamiliares->setIdPaciente($paciente);
                $em->persist($antecedentesFamiliares);

                if($genero == "Femenino")
                {
                    $antecedentesGine = new AntecedentesGinecobstetricos();
                    $antecedentesGine->setIdPaciente($paciente);
                    $em->persist($antecedentesGine);
                }
                $em->flush(); 

                $citaMedica = new CitaMedica();
                $citaMedica->setIdPaciente($paciente);
                $citaMedica->setIdEspecialidad($especialidad);
                $citaMedica->setIdEstadoCita($estadoCita);
                $citaMedica->setIdAgenda($agenda);
                $citaMedica->setFecha($fecha);
                $citaMedica->setHora($hora->getHora());
                $citaMedica->setFactura(false);
                $em->persist($citaMedica);
                $em->flush(); 

                $em->getConnection()->commit();

                $status = "Success";
            }
            
            catch(Exception $e){
                $em->getConnection()->rollBack();
                $status = "Error";
            }
            
        }

        $json = [
            "status" => $status
        ];
        $response = new Response();
        $response->setContent(json_encode($json));
        $response->headers->set('Content-Type', 'application/json');
        //return new Response(json_encode($json));
        return $response;
    }

    /**
     * @Route("/agendacion/filtracion/especialidad", name="agendacionEspecialidadFiltrado")
     */
    public function getMedicosEspecialidadProvincia(Request $request) {
        $em = $this->getDoctrine()->getManager();
        $provincia = $_POST["provincia"];
        $idEspecialidad = $_POST["especialidad"];
        $nombreEspecialidad = $_POST["nombreEspecialidad"];
        $nombre2 = str_replace(' ', '%20', $nombreEspecialidad);
        $status = "Error";
        $query =
            /* "select em, me from AdministradorBundle:MedicoEspecialidad em join em.idMedico me join me.idUsuario us where em.idEspecialidad 
            = ".$idEspecialidad." and us.estado = true and me.provincia = '".$provincia."'"; */
            "select em, me from AdministradorBundle:MedicoEspecialidad em join em.idMedico me join me.idUsuario us where em.idEspecialidad 
            = ".$idEspecialidad." and me.provincia = '".$provincia."' and us.estado = true";
        $medicosEspecialidad = $em->createQuery($query)->getResult();
        $val = count($medicosEspecialidad);
        //echo($val);
        $html = "";
        if($medicosEspecialidad){
            foreach ($medicosEspecialidad as $row){
                $html.="<div class='col-12 col-md-6 col-xl-4 mb-4'>";
                $html .= "<div class='d100 dcentro'>";
                $html .= "<img class='d-inline-block' style='height: 350px; width:auto;'";
                $html .= "src='http://localhost/ProgramamedDemo/16/web/".$row->getIdMedico()->getUrlImgAgenda()."'/>";
                $html .= "<button class='btn btn-primary mt-3' style='width:350px'";
                $nombreAux = str_replace(' ', '%20', $row->getIdMedico()->getIdUsuario()->getNombre());
                $apellidoAux = str_replace(' ', '%20', $row->getIdMedico()->getIdUsuario()->getApellido());
                $url = "../../calendario/".$row->getIdMedico()->getId()."/".$nombre2."/".$nombreAux."%20".$apellidoAux."/".$idEspecialidad."";
                $html .= "onclick=location.href='".$url."'>";
                $html .= "".$row->getIdMedico()->getIdUsuario()->getNombre()." ".$row->getIdMedico()->getIdUsuario()->getApellido()."";
                $html .= "</button>";
                $html .= "</div>";
                $html .= "</div>";
            }
        }
        $status = "Success";
        $json = [
            "status" => $status,
            "datos" => $medicosEspecialidad,
            "html" => $html
        ];
        $response = new Response();
        $response->setContent(json_encode($json));
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    ///////////////////////////API'S PARA MOVIL///////////////////////////////
    /**
     * @Route("/agendacion/api/loginMedico", name="agendaApiLoginMedico",  methods={"POST"})
     */
    public function apiLoginMedico(Request $request){
        try{
            $em = $this->getDoctrine()->getManager();
            $status = 'Error';
            $data = json_decode($request->getContent(), true);
            $datos = '';
            $correo = "";
            $cedula = "";
            $nombre = "";
            $apellido= "";
            if($data){
               $correo = $data['correo'];
               $cedula = $data['cedula']; 
            }
            $idMedico = 0;

            $repository = $em->getRepository("LoginBundle:Usuario");
            $usuario = $repository->findOneBy(array(
                "email" => $correo,
                "cedula" => $cedula,
                "rolUsuario" => 2,
                "estado" => true
            ));
            if($usuario){
                if($usuario->getIdMedico() != null){
                    $medico = $em->getRepository("AdministradorBundle:Medico")->find($usuario->getIdMedico()->getId());
                    $status = "Success";
                    $nombre = $usuario->getNombre();
                    $apellido = $usuario->getApellido();
                    $idMedico = $medico->getId();
                } 
            }
            $json = [
                'status' => $status, 
                'medico' => $nombre.' '.$apellido,
                'id' => $idMedico
            ];
            $response = new Response();
            $response->setContent(json_encode($json));
            $response->headers->set('Content-Type', 'application/json');
            return $response;
        }catch(Exception $e){
            $status = 'Error';
            $json = ['status' => $status, 'data' => 'Error'];
            $response = new Response();
            $response->setContent(json_encode($json));
            $response->headers->set('Content-Type', 'application/json');
            return $response;
        }
    }

    /**
     * @Route("/agendacion/api/agendaMedico", name="agendaApiAgendaMedico",  methods={"GET", "POST"})
     */
    public function apiGetAgendaMedico(Request $request){
        try{
            $em = $this->getDoctrine()->getManager();
            $status = 'Error';
            $data = json_decode($request->getContent(), true);
            $respuesta = "";
            $parametroFecha = date("Y-m-d");
            $parametroMedico = 0;
            $horario = "";
            if($data){
                $parametroFecha = $data['fecha'];
                $parametroMedico = $data['medico'];
            }
            $parametroFecha2 = strftime("%F", strtotime($parametroFecha));
            $parametroFecha = $parametroFecha2;
            
            $dia = date("N", strtotime($parametroFecha));
            $agenda = $em->getRepository("AgendaBundle:Agenda")->findOneBy(array("idMedico" => $parametroMedico));
            if($agenda){
                $horario = $em->getRepository("AgendaBundle:HorariosLaborables")->findBy(array("idAgenda" => $agenda->getId(),
                "idDiasLaborables" => $dia, "estado" =>true), array("orden" => "ASC"));
            }
            if(!$horario){
                $respuesta = "No existe horario disponible";
            }
            else{
                $varAux = 0;
                $arrayHoras = array();
                $horas = 0;
                $ids = 0;
                $nombres = "";
                $estados = 0;
                $auxContador = 0;
                foreach($horario as $row){
                   $atencion = $em->getRepository("AgendaBundle:AgendaHL")->findBy(array("idHorarioLaborable" => $row->getId()), array("idHorarioLaborable" => "ASC", "id" => "ASC")); 
                    foreach($atencion as $fila){
                        $citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->findOneBy(array("idAgenda" => $agenda->getId(), "fecha" => $parametroFecha, "hora" => $fila->getHora()));
                        if($citaMedica){
                            $ids = $citaMedica->getId();
                            $nombres = $citaMedica->getIdPaciente()->getIdUsuario()->getApellido().' '.$citaMedica->getIdPaciente()->getIdUsuario()->getNombre();
                            $estados = $citaMedica->getIdEstadoCita()->getId();
                        }
                        else{
                            $ids = 0;
                            $nombres = '';
                            $estados = 0;
                        }
                        $auxJson = "{\"id\":".$auxContador.", \"agenda\":".$ids.", \"nombre\":\"".$nombres."\", \"estado\":".$estados.", \"hora\":\"".$fila->getHora()."\"}";
                        array_push($arrayHoras, $auxJson);
                        $auxContador++;
                    }
                }
            }
            $status = 'Success';
            $json = [
                'status' => $status,
                'datos' =>$arrayHoras,
            ];
            $response = new Response();
            $response->setContent(json_encode($json));
            $response->headers->set('Content-Type', 'application/json');
            return $response;
        }
        catch(Exception $e){
            $status = 'Error';
            $json = ['status' => $status, 'data' => 'Error'];
            $response = new Response();
            $response->setContent(json_encode($json));
            $response->headers->set('Content-Type', 'application/json');
            return $response;
        }
    }

    /**
     * @Route("/agendacion/api/estadoCita", name="agendaApiSetEstadoCita",  methods={"POST"})
     */
    public function apiSetEstadoCita(Request $request){
        try{
            $em = $this->getDoctrine()->getEntityManager();
            $status = 'Error';
            $data = json_decode($request->getContent(), true);
            $parametroCita = 0;
            $parametroOpcion = "cancelar";
            if($data){
                $parametroCita = $data['cita'];
                $parametroOpcion = $data['opcion'];
                $cita = $em->getRepository("AgendaBundle:CitaMedica")->findOneBy(array("id" => $parametroCita));
                if($cita){
                    if($parametroOpcion == 'aceptar'){
                        $estadoCita = $em->getRepository("AgendaBundle:EstadoCitaMedica")->find(1);
                        $cita->setIdEstadoCita($estadoCita);
                    }else if($parametroOpcion == 'cancelar'){
                        $em->remove($cita);
                    }
                    $em->flush(); 
                    $status = 'Success';
                }
                
            }
            $json = [
                'status' => $status
            ];
            $response = new Response();
            $response->setContent(json_encode($json));
            $response->headers->set('Content-Type', 'application/json');
            return $response;
        }
        catch(Exception $e){
            $status = 'Error';
            $json = ['status' =>$status, 'data' => 'Error'];
            $response = new Response();
            $response->setContent(json_encode($json));
            $response->headers->set('Content-Type', 'application/json');
            return $response;
        }
    }


}
