<?php

namespace FacturacionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * InfoTributaria
 *
 * @ORM\Table(name="info_tributaria")
 * @ORM\Entity(repositoryClass="FacturacionBundle\Repository\InfoTributariaRepository")
 */
class InfoTributaria
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_infot", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="Factura")
     * @ORM\JoinColumn(name="id_factura", referencedColumnName="id_factura")
     */
    private $idFactura;

    /**
     * @var int
     *
     * @ORM\Column(name="ambiente_factura", type="integer")
     */
    private $ambienteFactura;

    /**
     * @var int
     *
     * @ORM\Column(name="tipo_emision", type="integer")
     */
    private $tipoEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="razon_social", type="string", length=200)
     */
    private $razonSocial;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_comercial", type="string", length=200)
     */
    private $nombreComercial;

    /**
     * @var string
     *
     * @ORM\Column(name="clave_acceso", type="string", length=50)
     */
    private $claveAcceso;

    /**
     * @var string
     *
     * @ORM\Column(name="num_autorizacion", type="string", length=50)
     */
    private $numAutorizacion;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_documento", type="string", length=5)
     */
    private $codigoDocumento;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_estable", type="string", length=5)
     */
    private $numeroEstable;

    /**
     * @var string
     *
     * @ORM\Column(name="punto_emision", type="string", length=10)
     */
    private $puntoEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_matriz", type="string", length=300)
     */
    private $direccionMatriz;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idFactura
     *
     * @param integer $idFactura
     *
     * @return InfoTributaria
     */
    public function setIdFactura($idFactura)
    {
        $this->idFactura = $idFactura;

        return $this;
    }

    /**
     * Get idFactura
     *
     * @return int
     */
    public function getIdFactura()
    {
        return $this->idFactura;
    }

    /**
     * Set ambienteFactura
     *
     * @param integer $ambienteFactura
     *
     * @return InfoTributaria
     */
    public function setAmbienteFactura($ambienteFactura)
    {
        $this->ambienteFactura = $ambienteFactura;

        return $this;
    }

    /**
     * Get ambienteFactura
     *
     * @return int
     */
    public function getAmbienteFactura()
    {
        return $this->ambienteFactura;
    }

    /**
     * Set tipoEmision
     *
     * @param integer $tipoEmision
     *
     * @return InfoTributaria
     */
    public function setTipoEmision($tipoEmision)
    {
        $this->tipoEmision = $tipoEmision;

        return $this;
    }

    /**
     * Get tipoEmision
     *
     * @return int
     */
    public function getTipoEmision()
    {
        return $this->tipoEmision;
    }

    /**
     * Set razonSocial
     *
     * @param string $razonSocial
     *
     * @return InfoTributaria
     */
    public function setRazonSocial($razonSocial)
    {
        $this->razonSocial = $razonSocial;

        return $this;
    }

    /**
     * Get razonSocial
     *
     * @return string
     */
    public function getRazonSocial()
    {
        return $this->razonSocial;
    }

    /**
     * Set nombreComercial
     *
     * @param string $nombreComercial
     *
     * @return InfoTributaria
     */
    public function setNombreComercial($nombreComercial)
    {
        $this->nombreComercial = $nombreComercial;

        return $this;
    }

    /**
     * Get nombreComercial
     *
     * @return string
     */
    public function getNombreComercial()
    {
        return $this->nombreComercial;
    }

    /**
     * Set claveAcceso
     *
     * @param string $claveAcceso
     *
     * @return InfoTributaria
     */
    public function setClaveAcceso($claveAcceso)
    {
        $this->claveAcceso = $claveAcceso;

        return $this;
    }

    /**
     * Get claveAcceso
     *
     * @return string
     */
    public function getClaveAcceso()
    {
        return $this->claveAcceso;
    }

    /**
     * Set numAutorizacion
     *
     * @param string $numAutorizacion
     *
     * @return InfoTributaria
     */
    public function setNumAutorizacion($numAutorizacion)
    {
        $this->numAutorizacion = $numAutorizacion;

        return $this;
    }

    /**
     * Get numAutorizacion
     *
     * @return string
     */
    public function getNumAutorizacion()
    {
        return $this->numAutorizacion;
    }

    /**
     * Set codigoDocumento
     *
     * @param string $codigoDocumento
     *
     * @return InfoTributaria
     */
    public function setCodigoDocumento($codigoDocumento)
    {
        $this->codigoDocumento = $codigoDocumento;

        return $this;
    }

    /**
     * Get codigoDocumento
     *
     * @return string
     */
    public function getCodigoDocumento()
    {
        return $this->codigoDocumento;
    }

    /**
     * Set numeroEstable
     *
     * @param string $numeroEstable
     *
     * @return InfoTributaria
     */
    public function setNumeroEstable($numeroEstable)
    {
        $this->numeroEstable = $numeroEstable;

        return $this;
    }

    /**
     * Get numeroEstable
     *
     * @return string
     */
    public function getNumeroEstable()
    {
        return $this->numeroEstable;
    }

    /**
     * Set puntoEmision
     *
     * @param string $puntoEmision
     *
     * @return InfoTributaria
     */
    public function setPuntoEmision($puntoEmision)
    {
        $this->puntoEmision = $puntoEmision;

        return $this;
    }

    /**
     * Get puntoEmision
     *
     * @return string
     */
    public function getPuntoEmision()
    {
        return $this->puntoEmision;
    }

    /**
     * Set direccionMatriz
     *
     * @param string $direccionMatriz
     *
     * @return InfoTributaria
     */
    public function setDireccionMatriz($direccionMatriz)
    {
        $this->direccionMatriz = $direccionMatriz;

        return $this;
    }

    /**
     * Get direccionMatriz
     *
     * @return string
     */
    public function getDireccionMatriz()
    {
        return $this->direccionMatriz;
    }
}

