<?php

namespace FacturacionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * InfoAdicional
 *
 * @ORM\Table(name="info_adicional")
 * @ORM\Entity(repositoryClass="FacturacionBundle\Repository\InfoAdicionalRepository")
 */
class InfoAdicional
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_infoa", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="Factura")
     * @ORM\JoinColumn(name="id_factura", referencedColumnName="id_factura")
     */
    private $idFactura;

    /**
     * @var string
     *
     * @ORM\Column(name="med_referido_factura", type="string", length=255)
     */
    private $medReferidoFactura;

    /**
     * @var string
     *
     * @ORM\Column(name="promocion_factura", type="string", length=300)
     */
    private $promocionFactura;

    /**
     * @var string
     *
     * @ORM\Column(name="copago_factura", type="string", length=150)
     */
    private $copagoFactura;

    /**
     * @var string
     *
     * @ORM\Column(name="titular_seguro", type="string", length=255)
     */
    private $titularSeguro;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idFactura
     *
     * @param integer $idFactura
     *
     * @return InfoAdicional
     */
    public function setIdFactura($idFactura)
    {
        $this->idFactura = $idFactura;

        return $this;
    }

    /**
     * Get idFactura
     *
     * @return int
     */
    public function getIdFactura()
    {
        return $this->idFactura;
    }

    /**
     * Set medReferidoFactura
     *
     * @param string $medReferidoFactura
     *
     * @return InfoAdicional
     */
    public function setMedReferidoFactura($medReferidoFactura)
    {
        $this->medReferidoFactura = $medReferidoFactura;

        return $this;
    }

    /**
     * Get medReferidoFactura
     *
     * @return string
     */
    public function getMedReferidoFactura()
    {
        return $this->medReferidoFactura;
    }

    /**
     * Set promocionFactura
     *
     * @param string $promocionFactura
     *
     * @return InfoAdicional
     */
    public function setPromocionFactura($promocionFactura)
    {
        $this->promocionFactura = $promocionFactura;

        return $this;
    }

    /**
     * Get promocionFactura
     *
     * @return string
     */
    public function getPromocionFactura()
    {
        return $this->promocionFactura;
    }

    /**
     * Set copagoFactura
     *
     * @param string $copagoFactura
     *
     * @return InfoAdicional
     */
    public function setCopagoFactura($copagoFactura)
    {
        $this->copagoFactura = $copagoFactura;

        return $this;
    }

    /**
     * Get copagoFactura
     *
     * @return string
     */
    public function getCopagoFactura()
    {
        return $this->copagoFactura;
    }

    /**
     * Set titularSeguro
     *
     * @param string $titularSeguro
     *
     * @return InfoAdicional
     */
    public function setTitularSeguro($titularSeguro)
    {
        $this->titularSeguro = $titularSeguro;

        return $this;
    }

    /**
     * Get titularSeguro
     *
     * @return string
     */
    public function getTitularSeguro()
    {
        return $this->titularSeguro;
    }
}

