<?php

namespace FacturacionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Factura
 *
 * @ORM\Table(name="factura")
 * @ORM\Entity(repositoryClass="FacturacionBundle\Repository\FacturaRepository")
 */
class Factura
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_factura", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="InfoTributaria", mappedBy="idFactura")
     * @ORM\OneToOne(targetEntity="InfoAdicional", mappedBy="idFactura")
     * @ORM\OneToMany(targetEntity="DetalleFactura", mappedBy="idFactura")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="TipoPago")
     * @ORM\JoinColumn(name="id_tipo_pago", referencedColumnName="id_tipo_pago")
     */
    private $idTipoPago;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AgendaBundle\Entity\CitaMedica")
     * @ORM\JoinColumn(name="id_cita_medica", referencedColumnName="id_cita_medica")
     */
    private $idCitaMedica;

    /**
     * @var string
     *
     * @ORM\Column(name="nro_factura", type="string", length=30)
     */
    private $nroFactura;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_emision", type="string", length=20)
     */
    private $fechaEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_estable", type="string", length=300)
     */
    private $direccionEstab;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_contribuyente", type="string", length=15)
     */
    private $tipoContribuyente;

    /**
     * @var string
     *
     * @ORM\Column(name="nro_contribuyente", type="string", length=10)
     */
    private $nroContribuyente;

    /**
     * @var string
     *
     * @ORM\Column(name="obl_contabilidad", type="string", length=3)
     */
    private $oblContabilidad;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_iden_comprador", type="string", length=3)
     */
    private $tipoIdenComprador;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_cliente", type="string", length=250)
     */
    private $nombreCliente;

    /**
     * @var string
     *
     * @ORM\Column(name="dni_cliente", type="string", length=20)
     */
    private $dniCliente;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_cliente", type="string", length=15)
     */
    private $telefonoCliente;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_cliente", type="string", length=300)
     */
    private $direccionCliente;

    /**
     * @var string
     *
     * @ORM\Column(name="email_cliente", type="string", length=300)
     */
    private $emailCliente;

    /**
     * @var string
     *
     * @ORM\Column(name="totsin_impuesto", type="decimal", precision=10, scale=2)
     */
    private $totsinImpuesto;

    /**
     * @var string
     *
     * @ORM\Column(name="total_iva0", type="decimal", precision=10, scale=2)
     */
    private $totalIva0;

    /**
     * @var string
     *
     * @ORM\Column(name="total_iva12", type="decimal", precision=10, scale=2)
     */
    private $totalIva12;

    /**
     * @var string
     *
     * @ORM\Column(name="subtotal_factura", type="decimal", precision=10, scale=2)
     */
    private $subtotal;

    /**
     * @var string
     *
     * @ORM\Column(name="descuento_factura", type="decimal", precision=10, scale=2)
     */
    private $descuento;

    /**
     * @var string
     *
     * @ORM\Column(name="impuesto_factura", type="decimal", precision=10, scale=2)
     */
    private $impuesto;

    /**
     * @var string
     *
     * @ORM\Column(name="total_factura", type="decimal", precision=10, scale=2)
     */
    private $total;

    /**
     * @var int
     *
     * @ORM\Column(name="plazo_pago", type="integer")
     */
    private $plazoPago;

    /**
     * @var string
     *
     * @ORM\Column(name="unidad_tiempo", type="string", length=20)
     */
    private $unidadTiempo;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Institucion")
     * @ORM\JoinColumn(name="id_institucion", referencedColumnName="id_institucion")
     */
    private $idInstitucion;

    /**
     * @var string
     *
     * @ORM\Column(name="estado_factura", type="string", length=10)
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idTipoPago
     *
     * @param integer $idTipoPago
     *
     * @return Factura
     */
    public function setIdTipoPago($idTipoPago)
    {
        $this->idTipoPago = $idTipoPago;

        return $this;
    }

    /**
     * Get idTipoPago
     *
     * @return int
     */
    public function getIdTipoPago()
    {
        return $this->idTipoPago;
    }

    /**
     * Set idCitaMedica
     *
     * @param integer $idCitaMedica
     *
     * @return Factura
     */
    public function setIdCitaMedica($idCitaMedica)
    {
        $this->idCitaMedica = $idCitaMedica;

        return $this;
    }

    /**
     * Get idCitaMedica
     *
     * @return int
     */
    public function getIdCitaMedica()
    {
        return $this->idCitaMedica;
    }

    /**
     * Set nroFactura
     *
     * @param string $nroFactura
     *
     * @return Factura
     */
    public function setNroFactura($nroFactura)
    {
        $this->nroFactura = $nroFactura;

        return $this;
    }

    /**
     * Get nroFactura
     *
     * @return string
     */
    public function getNroFactura()
    {
        return $this->nroFactura;
    }

    /**
     * Set fechaEmision
     *
     * @param string $fechaEmision
     *
     * @return Factura
     */
    public function setFechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;

        return $this;
    }

    /**
     * Get fechaEmision
     *
     * @return string
     */
    public function getFechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * Set direccionEstab
     *
     * @param string $direccionEstab
     *
     * @return Factura
     */
    public function setDireccionEstab($direccionEstab)
    {
        $this->direccionEstab = $direccionEstab;

        return $this;
    }

    /**
     * Get direccionEstab
     *
     * @return string
     */
    public function getDireccionEstab()
    {
        return $this->direccionEstab;
    }

    /**
     * Set tipoContribuyente
     *
     * @param string $tipoContribuyente
     *
     * @return Factura
     */
    public function setTipoContribuyente($tipoContribuyente)
    {
        $this->tipoContribuyente = $tipoContribuyente;

        return $this;
    }

    /**
     * Get tipoContribuyente
     *
     * @return string
     */
    public function getTipoContribuyente()
    {
        return $this->tipoContribuyente;
    }

    /**
     * Set nroContribuyente
     *
     * @param string $nroContribuyente
     *
     * @return Factura
     */
    public function setNroContribuyente($nroContribuyente)
    {
        $this->nroContribuyente = $nroContribuyente;

        return $this;
    }

    /**
     * Get nroContribuyente
     *
     * @return string
     */
    public function getNroContribuyente()
    {
        return $this->nroContribuyente;
    }

    /**
     * Set oblContabilidad
     *
     * @param string $oblContabilidad
     *
     * @return Factura
     */
    public function setOblContabilidad($oblContabilidad)
    {
        $this->oblContabilidad = $oblContabilidad;

        return $this;
    }

    /**
     * Get oblContabilidad
     *
     * @return string
     */
    public function getOblContabilidad()
    {
        return $this->oblContabilidad;
    }

    /**
     * Set tipoIdenComprador
     *
     * @param string $tipoIdenComprador
     *
     * @return Factura
     */
    public function setTipoIdenComprador($tipoIdenComprador)
    {
        $this->tipoIdenComprador = $tipoIdenComprador;

        return $this;
    }

    /**
     * Get tipoIdenComprador
     *
     * @return string
     */
    public function getTipoIdenComprador()
    {
        return $this->tipoIdenComprador;
    }

    /**
     * Set nombreCliente
     *
     * @param string $nombreCliente
     *
     * @return Factura
     */
    public function setNombreCliente($nombreCliente)
    {
        $this->nombreCliente = $nombreCliente;

        return $this;
    }

    /**
     * Get nombreCliente
     *
     * @return string
     */
    public function getNombreCliente()
    {
        return $this->nombreCliente;
    }

    /**
     * Set dniCliente
     *
     * @param string $dniCliente
     *
     * @return Factura
     */
    public function setDniCliente($dniCliente)
    {
        $this->dniCliente = $dniCliente;

        return $this;
    }

    /**
     * Get dniCliente
     *
     * @return string
     */
    public function getDniCliente()
    {
        return $this->dniCliente;
    }

    /**
     * Set telefonoCliente
     *
     * @param string $telefonoCliente
     *
     * @return Factura
     */
    public function setTelefonoCliente($telefonoCliente)
    {
        $this->telefonoCliente = $telefonoCliente;

        return $this;
    }

    /**
     * Get telefonoCliente
     *
     * @return string
     */
    public function getTelefonoCliente()
    {
        return $this->telefonoCliente;
    }

    /**
     * Set direccionCliente
     *
     * @param string $direccionCliente
     *
     * @return Factura
     */
    public function setDireccionCliente($direccionCliente)
    {
        $this->direccionCliente = $direccionCliente;

        return $this;
    }

    /**
     * Get direccionCliente
     *
     * @return string
     */
    public function getDireccionCliente()
    {
        return $this->direccionCliente;
    }

    /**
     * Set emailCliente
     *
     * @param string $emailCliente
     *
     * @return Factura
     */
    public function setEmailCliente($emailCliente)
    {
        $this->emailCliente = $emailCliente;

        return $this;
    }

    /**
     * Get emailCliente
     *
     * @return string
     */
    public function getEmailCliente()
    {
        return $this->emailCliente;
    }

    /**
     * Set totsinImpuesto
     *
     * @param string $totsinImpuesto
     *
     * @return Factura
     */
    public function setTotsinImpuesto($totsinImpuesto)
    {
        $this->totsinImpuesto = $totsinImpuesto;

        return $this;
    }

    /**
     * Get totsinImpuesto
     *
     * @return string
     */
    public function getTotsinImpuesto()
    {
        return $this->totsinImpuesto;
    }

    /**
     * Set totalIva0
     *
     * @param string $totalIva0
     *
     * @return Factura
     */
    public function setTotalIva0($totalIva0)
    {
        $this->totalIva0 = $totalIva0;

        return $this;
    }

    /**
     * Get totalIva0
     *
     * @return string
     */
    public function getTotalIva0()
    {
        return $this->totalIva0;
    }

    /**
     * Set totalIva12
     *
     * @param string $totalIva12
     *
     * @return Factura
     */
    public function setTotalIva12($totalIva12)
    {
        $this->totalIva12 = $totalIva12;

        return $this;
    }

    /**
     * Get totalIva12
     *
     * @return string
     */
    public function getTotalIva12()
    {
        return $this->totalIva12;
    }

    /**
     * Set subtotal
     *
     * @param string $subtotal
     *
     * @return Factura
     */
    public function setSubtotal($subtotal)
    {
        $this->subtotal = $subtotal;

        return $this;
    }

    /**
     * Get subtotal
     *
     * @return string
     */
    public function getSubtotal()
    {
        return $this->subtotal;
    }

    /**
     * Set descuento
     *
     * @param string $descuento
     *
     * @return Factura
     */
    public function setDescuento($descuento)
    {
        $this->descuento = $descuento;

        return $this;
    }

    /**
     * Get descuento
     *
     * @return string
     */
    public function getDescuento()
    {
        return $this->descuento;
    }

    /**
     * Set impuesto
     *
     * @param string $impuesto
     *
     * @return Factura
     */
    public function setImpuesto($impuesto)
    {
        $this->impuesto = $impuesto;

        return $this;
    }

    /**
     * Get impuesto
     *
     * @return string
     */
    public function getImpuesto()
    {
        return $this->impuesto;
    }

    /**
     * Set total
     *
     * @param string $total
     *
     * @return Factura
     */
    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    /**
     * Get total
     *
     * @return string
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * Set plazoPago
     *
     * @param integer $plazoPago
     *
     * @return Factura
     */
    public function setPlazoPago($plazoPago)
    {
        $this->plazoPago = $plazoPago;

        return $this;
    }

    /**
     * Get plazoPago
     *
     * @return int
     */
    public function getPlazoPago()
    {
        return $this->plazoPago;
    }

    /**
     * Set unidadTiempo
     *
     * @param string $unidadTiempo
     *
     * @return Factura
     */
    public function setUnidadTiempo($unidadTiempo)
    {
        $this->unidadTiempo = $unidadTiempo;

        return $this;
    }

    /**
     * Get unidadTiempo
     *
     * @return string
     */
    public function getUnidadTiempo()
    {
        return $this->unidadTiempo;
    }

    /**
     * Set idInstitucion
     *
     * @param integer $idInstitucion
     *
     * @return Factura
     */
    public function setIdInstitucion($idInstitucion)
    {
        $this->idInstitucion = $idInstitucion;

        return $this;
    }

    /**
     * Get idInstitucion
     *
     * @return int
     */
    public function getIdInstitucion()
    {
        return $this->idInstitucion;
    }

    /**
     * Set estado
     *
     * @param string $estado
     *
     * @return Factura
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

