<?php

namespace FacturacionBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DetalleFactura
 *
 * @ORM\Table(name="detalle_factura")
 * @ORM\Entity(repositoryClass="FacturacionBundle\Repository\DetalleFacturaRepository")
 */
class DetalleFactura
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_detalle_fac", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="Factura", mappedBy="idTipoPago")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Factura")
     * @ORM\JoinColumn(name="id_factura", referencedColumnName="id_factura")
     */
    private $idFactura;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_principal", type="string", length=10)
     */
    private $codigoPrincipal;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_auxiliar", type="string", length=10)
     */
    private $codigoAuxiliar;

    /**
     * @var string
     *
     * @ORM\Column(name="cantidad_detalle_fac", type="string", length=255)
     */
    private $cantidadDetalleFac;

    /**
     * @var string
     *
     * @ORM\Column(name="descripcion_detalle_fac", type="string", length=200)
     */
    private $descripcionDetalleFac;

    /**
     * @var string
     *
     * @ORM\Column(name="valor_unitario", type="decimal", precision=10, scale=2)
     */
    private $valorUnitario;

    /**
     * @var string
     *
     * @ORM\Column(name="valor_impuesto", type="decimal", precision=10, scale=2)
     */
    private $valorImpuesto;

    /**
     * @var string
     *
     * @ORM\Column(name="valor_total", type="decimal", precision=10, scale=2)
     */
    private $valorTotal;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_impuesto", type="string", length=3)
     */
    private $codigoImpuesto;

    /**
     * @var string
     *
     * @ORM\Column(name="codpor_impuesto", type="string", length=3)
     */
    private $codporImpuesto;

    /**
     * @var string
     *
     * @ORM\Column(name="valor_descuento", type="decimal", precision=10, scale=2)
     */
    private $valorDescuento;

    /**
     * @var string
     *
     * @ORM\Column(name="codpor_descuento", type="string", length=3)
     */
    private $codporDescuento;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idFactura
     *
     * @param integer $idFactura
     *
     * @return DetalleFactura
     */
    public function setIdFactura($idFactura)
    {
        $this->idFactura = $idFactura;

        return $this;
    }

    /**
     * Get idFactura
     *
     * @return int
     */
    public function getIdFactura()
    {
        return $this->idFactura;
    }

    /**
     * Set codigoPrincipal
     *
     * @param string $codigoPrincipal
     *
     * @return DetalleFactura
     */
    public function setCodigoPrincipal($codigoPrincipal)
    {
        $this->codigoPrincipal = $codigoPrincipal;

        return $this;
    }

    /**
     * Get codigoPrincipal
     *
     * @return string
     */
    public function getCodigoPrincipal()
    {
        return $this->codigoPrincipal;
    }

    /**
     * Set codigoAuxiliar
     *
     * @param string $codigoAuxiliar
     *
     * @return DetalleFactura
     */
    public function setCodigoAuxiliar($codigoAuxiliar)
    {
        $this->codigoAuxiliar = $codigoAuxiliar;

        return $this;
    }

    /**
     * Get codigoAuxiliar
     *
     * @return string
     */
    public function getCodigoAuxiliar()
    {
        return $this->codigoAuxiliar;
    }

    /**
     * Set cantidadDetalleFac
     *
     * @param string $cantidadDetalleFac
     *
     * @return DetalleFactura
     */
    public function setCantidadDetalleFac($cantidadDetalleFac)
    {
        $this->cantidadDetalleFac = $cantidadDetalleFac;

        return $this;
    }

    /**
     * Get cantidadDetalleFac
     *
     * @return string
     */
    public function getCantidadDetalleFac()
    {
        return $this->cantidadDetalleFac;
    }

    /**
     * Set descripcionDetalleFac
     *
     * @param string $descripcionDetalleFac
     *
     * @return DetalleFactura
     */
    public function setDescripcionDetalleFac($descripcionDetalleFac)
    {
        $this->descripcionDetalleFac = $descripcionDetalleFac;

        return $this;
    }

    /**
     * Get descripcionDetalleFac
     *
     * @return string
     */
    public function getDescripcionDetalleFac()
    {
        return $this->descripcionDetalleFac;
    }

    /**
     * Set valorUnitario
     *
     * @param string $valorUnitario
     *
     * @return DetalleFactura
     */
    public function setValorUnitario($valorUnitario)
    {
        $this->valorUnitario = $valorUnitario;

        return $this;
    }

    /**
     * Get valorUnitario
     *
     * @return string
     */
    public function getValorUnitario()
    {
        return $this->valorUnitario;
    }

    /**
     * Set valorImpuesto
     *
     * @param string $valorImpuesto
     *
     * @return DetalleFactura
     */
    public function setValorImpuesto($valorImpuesto)
    {
        $this->valorImpuesto = $valorImpuesto;

        return $this;
    }

    /**
     * Get valorImpuesto
     *
     * @return string
     */
    public function getValorImpuesto()
    {
        return $this->valorImpuesto;
    }

    /**
     * Set valorTotal
     *
     * @param string $valorTotal
     *
     * @return DetalleFactura
     */
    public function setValorTotal($valorTotal)
    {
        $this->valorTotal = $valorTotal;

        return $this;
    }

    /**
     * Get valorTotal
     *
     * @return string
     */
    public function getValorTotal()
    {
        return $this->valorTotal;
    }

    /**
     * Set codigoImpuesto
     *
     * @param string $codigoImpuesto
     *
     * @return DetalleFactura
     */
    public function setCodigoImpuesto($codigoImpuesto)
    {
        $this->codigoImpuesto = $codigoImpuesto;

        return $this;
    }

    /**
     * Get codigoImpuesto
     *
     * @return string
     */
    public function getCodigoImpuesto()
    {
        return $this->codigoImpuesto;
    }

    /**
     * Set codporImpuesto
     *
     * @param string $codporImpuesto
     *
     * @return DetalleFactura
     */
    public function setCodporImpuesto($codporImpuesto)
    {
        $this->codporImpuesto = $codporImpuesto;

        return $this;
    }

    /**
     * Get codporImpuesto
     *
     * @return string
     */
    public function getCodporImpuesto()
    {
        return $this->codporImpuesto;
    }

    /**
     * Set valorDescuento
     *
     * @param string $valorDescuento
     *
     * @return DetalleFactura
     */
    public function setValorDescuento($valorDescuento)
    {
        $this->valorDescuento = $valorDescuento;

        return $this;
    }

    /**
     * Get valorDescuento
     *
     * @return string
     */
    public function getValorDescuento()
    {
        return $this->valorDescuento;
    }

    /**
     * Set codporDescuento
     *
     * @param string $codporDescuento
     *
     * @return DetalleFactura
     */
    public function setCodporDescuento($codporDescuento)
    {
        $this->codporDescuento = $codporDescuento;

        return $this;
    }

    /**
     * Get codporDescuento
     *
     * @return string
     */
    public function getCodporDescuento()
    {
        return $this->codporDescuento;
    }
}

