<?php

namespace FacturacionBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use FacturacionBundle\Entity\Factura;
use FacturacionBundle\Entity\InfoAdicional;
use FacturacionBundle\Entity\InfoTributaria;
use FacturacionBundle\Entity\DetalleFactura;
use \DOMDocument;
use \Swift_Attachment;

class FacturacionController extends Controller
{
	/**
	 * @Route("/", name="homeFactura")
	 */
	public function indexAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
			return $this->render("@Facturacion/Default/index.html.twig", array(
				"usuario" => $usuario, "noticias" => $noticias
			));
		}
	}

	/**
	 * @Route("/pendientes/", name="facturasPendientes")
	 */
	public function facturasPendientesAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
                $medico = $em->getRepository("AdministradorBundle:Medico")->findOneBy(array("idUsuario" => $usuario->getId()));
            }
            else
                $medico = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $usuario->getIdAsistente()->getId()));

			return $this->render("@Facturacion/Default/pendiente.html.twig", array(
				"usuario" => $usuario, "noticias" => $noticias, "medico" => $medico
			));
		}
	}

	/**
	 * @Route("/cobradas/", name="facturasCobradas")
	 */
	public function facturasCobradasAction(Request $request)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
                $medico = $em->getRepository("AdministradorBundle:Medico")->findOneBy(array("idUsuario" => $usuario->getId()));
            }
            else
                $medico = $em->getRepository("AdministradorBundle:AsistenteMedico")->findBy(array("idAsistente" => $usuario->getIdAsistente()->getId()));

			return $this->render("@Facturacion/Default/cobrada.html.twig", array(
				"usuario" => $usuario, "noticias" => $noticias, "medico" => $medico
			));
		}
	}

	/**
	 * @Route("/factura/{idCitaMedica}/", name="facturaCita")
	 */
	public function facturaAction(Request $request, $idCitaMedica)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }

            $tipoPago = $em->getRepository("FacturacionBundle:TipoPago")->findBy(array("estado" => true));
			$citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->find(base64_decode($idCitaMedica));

			$codigoNumerico = '';
			for($i = 0; $i < 8; $i++)
			{
				$codigoNumerico .= ''.rand(0, 9);
			}

			$mod11Sum = ($codigoNumerico[0] * 3) + ($codigoNumerico[1] * 2) + ($codigoNumerico[2] * 7) + ($codigoNumerico[3] * 6) + ($codigoNumerico[4] * 5) + ($codigoNumerico[5] * 4) + ($codigoNumerico[6] * 3) + ($codigoNumerico[7] * 2);
			$mod11 = $mod11Sum % 11;
			$verificador = 11 - $mod11;
			if($verificador == 11)
				$verificador = 0;
			elseif($verificador == 10)
				$verificador = 1;

			if($citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getTipoContribuyente() == "PER_NAT_SC")
				$contribuyente = "Persona Natural Obligada a llevar Contabilidad";
			elseif($citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getTipoContribuyente() == "PER_NAT_NC")
				$contribuyente = "Persona Natural No Obligada a llevar Contabilidad";
			elseif($citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getTipoContribuyente() == "PER_JUD")
				$contribuyente = "Persona Juridica";
			elseif($citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getTipoContribuyente() == "CON_ESP")
				$contribuyente = "Contribuyente Especial";

			$fechaEmision = date("dmY");
			$tipoComprobante = "01";
			$ruc = $citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getRuc();

			$serie = $citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getNumeroEstabl().$citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getPuntoEmision();
			$query = "select count(f.id) from FacturacionBundle:Factura f where f.idInstitucion = :institucion";
			$facturas = $em->createQuery($query)->setParameter("institucion", $citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getId())->getSingleScalarResult();
			$nroFacturas = $facturas + 1;
			if($nroFacturas > 0 && $nroFacturas < 10)
				$comprobante = "00000000".$nroFacturas;
			elseif($nroFacturas >= 10 && $nroFacturas < 100)
				$comprobante = "0000000".$nroFacturas;
			elseif($nroFacturas >= 100 && $nroFacturas < 1000)
				$comprobante = "000000".$nroFacturas;
			elseif($nroFacturas >= 1000 && $nroFacturas < 10000)
				$comprobante = "00000".$nroFacturas;
			elseif($nroFacturas >= 10000 && $nroFacturas < 100000)
				$comprobante = "0000".$nroFacturas;
			elseif($nroFacturas >= 100000 && $nroFacturas < 1000000)
				$comprobante = "000".$nroFacturas;
			elseif($nroFacturas >= 1000000 && $nroFacturas < 10000000)
				$comprobante = "00".$nroFacturas;
			elseif($nroFacturas >= 10000000 && $nroFacturas < 100000000)
				$comprobante = "0".$nroFacturas;
			elseif($nroFacturas >= 100000000)
				$comprobante = $nroFacturas;

			//pruebas 1 - produccion 2
			$ambiente = 1;
			//normal 1
			$emision = 1; 

			return $this->render("@Facturacion/Default/factura.html.twig", array(
				"usuario" => $usuario, 
				"noticias" => $noticias,
				"tipoPago" => $tipoPago,
				"citaMedica" => $citaMedica,
				"fecha" => date("Y-m-d"),
				"fechaEmision" => $fechaEmision,
				"tipoComprobante" => $tipoComprobante,
				"contribuyente" => $contribuyente,
				"ruc" => $ruc,
				"ambiente" => $ambiente,
				"serie" => $serie,
				"comprobante" => $comprobante,
				"codigoNumerico" => $codigoNumerico,
				"emision" => $emision,
				"verificador" => $verificador
			));
		}
	}

	/**
	 * @Route("/factura/ver/{idFactura}/", name="verFactura")
	 */
	public function verFacturaAction(Request $request, $idFactura)
	{
		if(!$request->getSession()->has("rol") || $request->getSession()->get("rol") == 1)
			return $this->redirectToRoute("logout");
		else
		{
			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("LoginBundle:Usuario")->find($request->getSession()->get("usuario"));
			$noticias = "";
            if($request->getSession()->get("rol") == 2)
            {
                $queryNot = "select n from AdministradorBundle:Noticas n order by n.id desc";
                $noticias = $em->createQuery($queryNot)->setMaxResults(1)->getResult();
            }
			$infoAdicionalFac = $em->getRepository("FacturacionBundle:InfoAdicional")->findOneBy(array(
				"idFactura" => base64_decode($idFactura)
			));
			$infoTributariaFac = $em->getRepository("FacturacionBundle:InfoTributaria")->findOneBy(array(
				"idFactura" => base64_decode($idFactura)
			));
			$detalleFactura = $em->getRepository("FacturacionBundle:DetalleFactura")->findBy(array(
				"idFactura" => base64_decode($idFactura)
			));

			if($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "PER_NAT_SC")
				$contribuyente = "Persona Natural Obligada a llevar Contabilidad";
			elseif($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "PER_NAT_NC")
				$contribuyente = "Persona Natural No Obligada a llevar Contabilidad";
			elseif($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "PER_JUD")
				$contribuyente = "Persona Juridica";
			elseif($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "CON_ESP")
				$contribuyente = "Contribuyente Especial";

			return $this->render("@Facturacion/Default/ver.factura.html.twig", array(
				"usuario" => $usuario,
				"noticias" => $noticias,
				"contribuyente" => $contribuyente,
				"detalleFactura" => $detalleFactura,
				"infoAdicional" => $infoAdicionalFac,
				"infoTributaria" => $infoTributariaFac
			));
		}
	}

	/**
	 * @Route("/facturas/pendientes/", name="getFacturasPendientes")
	 */
	public function getFacturasPendientes()
	{
		$em = $this->getDoctrine()->getManager();
		$agenda = $em->getRepository("AgendaBundle:Agenda")->findOneBy(array("idMedico" => $_POST["medico"]));
		$html = '';

		if($agenda)
		{
			if($agenda->getIdMedico()->getFactura())
			{
				$citasMedicas = $em->getRepository("AgendaBundle:CitaMedica")->findBy(array("factura" => false, "idAgenda" => $agenda->getId()));

				if($citasMedicas)
				{
					$html .= '<table class="table table-borded">
		            <thead class="thead-light">
		                <tr>
		                    <th>Cita Médica</th><th>Info. Paciente</th><th></th>
		                </tr>
		            </thead><tbody>';

		            foreach($citasMedicas as $row)
		            {
		            	$edad = "";
		                if($row->getIdPaciente()->getFechaNacimiento() != null)
		                {
		                    $fechaHoy = date_create(date("Y-m-d"));
		                    $fechaNac = date_create($row->getIdPaciente()->getFechaNacimiento());
		                    $resultado = date_diff($fechaNac, $fechaHoy);
		                    $edad = $resultado->format('%y')." años";
		                }

		            	$html .= '<tr>
						<td>'.$row->getFecha().'<br>'.$row->getHora().'</td>
						<td>
							'.$row->getIdPaciente()->getIdUsuario()->getNombre().' '.$row->getIdPaciente()->getIdUsuario()->getApellido().'<br>
							'.$row->getIdPaciente()->getIdUsuario()->getCedula().'<br>
							'.$row->getIdPaciente()->getGenero().'<br>
							'.$edad.'
						</td>
						<td><a href="../factura/'.base64_encode($row->getId()).'/" class="btn btn-link text-dark"><span class="icon-file-text"></span> Cobrar</a></td>
						</tr>';
		            }

		            $html .= '</tbody></table>';
				}
				else
				{
					$html .= '<h5 class="text-center">No tiene citas médicas pendientes de cobro.</h5>';
				}
			}
			else
			{
				$html .= '<h5 class="text-center">El médico no se encuentra habilitado para realizar facturación electrónica.</h5>';
			}
		}

		return new Response($html);
	}

	/**
	 * @Route("/facturas/cobradas/", name="getFacturasCobradas")
	 */
	public function getFacturasCobradas()
	{
		$em = $this->getDoctrine()->getManager();
		$medico = $em->getRepository("AdministradorBundle:Medico")->find($_POST["medico"]);
		$facturas = $em->getRepository("FacturacionBundle:Factura")->findBy(array("idInstitucion" => $medico->getIdInstitucion()->getId(), "estado" => "FAC_COB"));
		$html = '';

		if($facturas)
		{
			$html .= '<table class="table table-borded">
            <thead class="thead-light">
                <tr>
                    <th>Cita Médica</th><th>Info. Paciente</th><th></th>
                </tr>
            </thead><tbody>';

            foreach($facturas as $row)
            {
            	$edad = "";
                if($row->getIdCitaMedica()->getIdPaciente()->getFechaNacimiento() != null)
                {
                    $fechaHoy = date_create(date("Y-m-d"));
                    $fechaNac = date_create($row->getIdCitaMedica()->getIdPaciente()->getFechaNacimiento());
                    $resultado = date_diff($fechaNac, $fechaHoy);
                    $edad = $resultado->format('%y')." años";
                }

            	$html .= '<tr>
				<td>'.$row->getIdCitaMedica()->getFecha().'<br>'.$row->getIdCitaMedica()->getHora().'</td>
				<td>
					'.$row->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getNombre().' '.$row->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getApellido().'<br>
					'.$row->getIdCitaMedica()->getIdPaciente()->getIdUsuario()->getCedula().'<br>
					'.$row->getIdCitaMedica()->getIdPaciente()->getGenero().'<br>
					'.$edad.'
				</td>
				<td><a href="../factura/ver/'.base64_encode($row->getId()).'/" class="btn btn-link text-dark"><span class="icon-clipboard"></span> Ver</a></td>
				</tr>';
            }

            $html .= '</tbody></table>';
		}

		return new Response($html);
	}

	/**
	 * @Route("/facturar/cita/", name="facturarCitaMedica")
	 */
	public function facturarCitaMedica(Request $request)
	{
		$em = $this->getDoctrine()->getManager();

		$factura = $em->getRepository("FacturacionBundle:Factura")->find($_POST["factura"]);

		$infoAdicional = new InfoAdicional();
		$infoAdicional->setIdFactura($factura);
		$infoAdicional->setMedReferidoFactura($_POST["medReferido"]);
		$infoAdicional->setPromocionFactura($_POST["promocion"]);
		$infoAdicional->setCopagoFactura($_POST["copago"]);
		$infoAdicional->setTitularSeguro($_POST["titSeguro"]);

		$em->persist($infoAdicional);

		$infoTributaria = new InfoTributaria();
		$infoTributaria->setIdFactura($factura);
		$infoTributaria->setAmbienteFactura($_POST["ambiente"]);
		$infoTributaria->setTipoEmision($_POST["emision"]);
		$infoTributaria->setRazonSocial($factura->getIdInstitucion()->getRazonSocial());
		$infoTributaria->setNombreComercial($factura->getIdInstitucion()->getNombreComercial());
		$infoTributaria->setClaveAcceso($_POST["claveAcceso"]);
		$infoTributaria->setNumAutorizacion($_POST["claveAcceso"]);
		$infoTributaria->setCodigoDocumento("01");
		$infoTributaria->setNumeroEstable($factura->getIdInstitucion()->getNumeroEstabl());
		$infoTributaria->setPuntoEmision($factura->getIdInstitucion()->getPuntoEmision());
		$infoTributaria->setDireccionMatriz($factura->getIdInstitucion()->getDireccionMatriz());

		$em->persist($infoTributaria);

		$tipoPago = $em->getRepository("FacturacionBundle:TipoPago")->findOneBy(array("codigo" => $_POST["tipoPago"]));

		$factura->setIdTipoPago($tipoPago);
		$factura->setFechaEmision($_POST["fechaEmision"]);

		if($factura->getIdInstitucion()->getDireccionEstabl() == null || $factura->getIdInstitucion()->getDireccionEstabl() == "")
			$factura->setDireccionEstab($factura->getIdInstitucion()->getDireccionMatriz());
		else
			$factura->setDireccionEstab($factura->getIdInstitucion()->getDireccionEstabl());

		$factura->setTipoContribuyente($factura->getIdInstitucion()->getTipoContribuyente());
		$factura->setNroContribuyente($factura->getIdInstitucion()->getNroContribuyente());
		$factura->setOblContabilidad($factura->getIdInstitucion()->getOblContabilidad());

		if($_POST["tipIdenClie"] == "CED")
			$factura->setTipoIdenComprador("05");
		elseif($_POST["tipIdenClie"] == "RUC")
			$factura->setTipoIdenComprador("04");
		elseif($_POST["tipIdenClie"] == "PAS")
			$factura->setTipoIdenComprador("06");

		$factura->setNombreCliente($_POST["nomClie"]);
		$factura->setDniCliente($_POST["idenClie"]);
		$factura->setTelefonoCliente($_POST["telfClie"]);
		$factura->setDireccionCliente($_POST["dirClie"]);
		$factura->setEmailCliente($_POST["emailClie"]);
		$factura->setPlazoPago($_POST["plazo"]);
		$factura->setUnidadTiempo($_POST["uniTiempo"]);

		$totIva0 = $em->createQuery("select sum(d.valorUnitario) from FacturacionBundle:DetalleFactura d where d.idFactura = :factura and d.codigoImpuesto = '0'")->setParameter("factura", $factura->getId())->getSingleScalarResult();
		$totIva12 = $em->createQuery("select sum(d.valorUnitario) from FacturacionBundle:DetalleFactura d where d.idFactura = :factura and d.codigoImpuesto = '2'")->setParameter("factura", $factura->getId())->getSingleScalarResult();
		$totSinImp = $em->createQuery("select sum(d.valorUnitario) from FacturacionBundle:DetalleFactura d where d.idFactura = :factura and d.codigoImpuesto = '7'")->setParameter("factura", $factura->getId())->getSingleScalarResult();
		$totDesc = $em->createQuery("select sum(d.valorDescuento) from FacturacionBundle:DetalleFactura d where d.idFactura = :factura")->setParameter("factura", $factura->getId())->getSingleScalarResult();
		$totImpu = $em->createQuery("select sum(d.valorImpuesto) from FacturacionBundle:DetalleFactura d where d.idFactura = :factura")->setParameter("factura", $factura->getId())->getSingleScalarResult();

		$subtotal = $totIva12 + $totIva0 + $totSinImp;
		$total = $subtotal + $totImpu - $totDesc;

		$factura->setTotsinImpuesto($totSinImp);
		$factura->setTotalIva0($totIva0);
		$factura->setTotalIva12($totIva12);
		$factura->setSubtotal($subtotal);
		$factura->setDescuento($totDesc);
		$factura->setImpuesto($totImpu);
		$factura->setTotal($total);
		$factura->setEstado("FAC_COB");

		$citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->find($factura->getIdCitaMedica()->getId());
		$citaMedica->setFactura(true);

		$em->flush();


		$infoAdicionalFac = $em->getRepository("FacturacionBundle:InfoAdicional")->findOneBy(array(
				"idFactura" => $factura->getId()
		));
		$infoTributariaFac = $em->getRepository("FacturacionBundle:InfoTributaria")->findOneBy(array(
			"idFactura" => $factura->getId()
		));
		$detalleFacturaFac = $em->getRepository("FacturacionBundle:DetalleFactura")->findBy(array(
			"idFactura" => $factura->getId()
		));

		if($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "PER_NAT_SC")
			$contribuyente = "Persona Natural Obligada a llevar Contabilidad";
		elseif($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "PER_NAT_NC")
			$contribuyente = "Persona Natural No Obligada a llevar Contabilidad";
		elseif($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "PER_JUD")
			$contribuyente = "Persona Juridica";
		elseif($infoTributariaFac->getIdFactura()->getIdInstitucion()->getTipoContribuyente() == "CON_ESP")
			$contribuyente = "Contribuyente Especial";

		$html = $this->renderView("@Facturacion/Default/facturapdf.html.twig", array(
			"contribuyente" => $contribuyente,
			"detalleFactura" => $detalleFacturaFac,
			"infoAdicional" => $infoAdicionalFac,
			"infoTributaria" => $infoTributariaFac
		));

		$filename = md5($factura->getIdInstitucion()->getId()."-".$factura->getIdCitaMedica()->getIdAgenda()->getIdMedico()->getId()."-".$factura->getNroFactura());
		file_put_contents("6973e3e05f3cea01fbdedd4/facturas/".$filename.".pdf", $this->get('knp_snappy.pdf')->getOutputFromHtml($html));
		chmod("6973e3e05f3cea01fbdedd4/facturas/".$filename.'.pdf', 0777);

		//DOCUMENTO XML
		$xml = new DomDocument('1.0', 'UTF-8');
//		$xml->standalone         = false;
		$xml->preserveWhiteSpace = false;

		$FacturaXml = $xml->createElement('Factura');
		$FacturaXml = $xml->appendChild($FacturaXml);


		// INFORMACION TRIBUTARIA.
			$infoTributariaXml = $xml->createElement('infoTributaria');
			$infoTributariaXml = $FacturaXml->appendChild($infoTributariaXml);
			$cbc = $xml->createElement('ambiente', $infoTributariaFac->getAmbienteFactura());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('tipoEmision', $infoTributariaFac->getTipoEmision());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('razonSocial', $infoTributariaFac->getRazonSocial());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('nombreComercial', $infoTributariaFac->getNombreComercial());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('ruc', $factura->getIdInstitucion()->getRuc());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('claveAcceso', $infoTributariaFac->getClaveAcceso());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('codDoc', $infoTributariaFac->getCodigoDocumento());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('estab', $infoTributariaFac->getNumeroEstable());
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('ptoEmi', $infoTributariaFac->getPuntoEmision());
			$cbc = $infoTributariaXml->appendChild($cbc);

			$nFac = explode("-", $factura->getNroFactura());
			$cbc = $xml->createElement('secuencial', $nFac[2]);
			$cbc = $infoTributariaXml->appendChild($cbc);
			$cbc = $xml->createElement('dirMatriz', $infoTributariaFac->getDireccionMatriz());
			$cbc = $infoTributariaXml->appendChild($cbc);

		// INFORMACIOO DE FACTURA.
			$infoFacturaXml = $xml->createElement('infoFactura');
			$infoFacturaXml = $FacturaXml->appendChild($infoFacturaXml);
			$cbc = $xml->createElement('fechaEmision', $factura->getFechaEmision());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('dirEstablecimiento', $factura->getDireccionEstab());
			$cbc = $infoFacturaXml->appendChild($cbc);
			//$cbc = $xml->createElement('contribuyenteEspecial', $factura->getNroContribuyente());
			$cbc = $xml->createElement(str_replace(" ", "", $contribuyente), $factura->getNroContribuyente());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('obligadoContabilidad', $factura->getOblContabilidad());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('tipoIdentificacionComprador', $factura->getTipoIdenComprador());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('razonSocialComprador', $factura->getNombreCliente());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('identificacionComprador', $factura->getDniCliente());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('totalSinImpuestos', $factura->getTotsinImpuesto());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('totalDescuento', $factura->getDescuento());
			$cbc = $infoFacturaXml->appendChild($cbc);


			$totalConImpuestosXml = $xml->createElement('totalConImpuestos');
			$totalConImpuestosXml = $infoFacturaXml->appendChild($totalConImpuestosXml);
			$totalImpuestoXml = $xml->createElement('totalImpuesto');
			$totalImpuestoXml = $totalConImpuestosXml->appendChild($totalImpuestoXml);

			if($factura->getTotalIva0() != null)
			{
				$cbc = $xml->createElement('codigo', '0');
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('codigoPorcentaje', '0');
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('descuentoAdicional', '0');
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('baseImponible', $factura->getTotalIva0());
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('valor', '0');
				$cbc = $totalImpuestoXml->appendChild($cbc);
			}
			
			if($factura->getTotalIva12() != null)
			{
				$cbc = $xml->createElement('codigo', '2');
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('codigoPorcentaje', '12');
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('descuentoAdicional', '0');
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('baseImponible', $factura->getTotalIva12());
				$cbc = $totalImpuestoXml->appendChild($cbc);
				$cbc = $xml->createElement('valor', $factura->getImpuesto());
				$cbc = $totalImpuestoXml->appendChild($cbc);
			}	

			$cbc = $xml->createElement('propina', '0');
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('importeTotal', $factura->getTotal());
			$cbc = $infoFacturaXml->appendChild($cbc);
			$cbc = $xml->createElement('moneda', 'DOLAR');
			$cbc = $infoFacturaXml->appendChild($cbc);

			$pagosXml = $xml->createElement('pagos');
			$pagosXml = $infoFacturaXml->appendChild($pagosXml);
			$pagoXml = $xml->createElement('pago');
			$pagoXml = $pagosXml->appendChild($pagoXml);
			$cbc = $xml->createElement('formaPago', $factura->getIdTipoPago()->getCodigo());
			$cbc = $pagoXml->appendChild($cbc);
			$cbc = $xml->createElement('total', $factura->getTotal());

		//DETALLES DE LA FACTURA.
			$detallesXml = $xml->createElement('detalles');
			$detallesXml = $FacturaXml->appendChild($detallesXml);


		foreach ($detalleFacturaFac as $row) 
		{
			$detalleXml = $xml->createElement('detalle');
			$detalleXml = $detallesXml->appendChild($detalleXml);
			$cbc = $xml->createElement('codigoPrincipal', $factura->getIdCitaMedica()->getId());
			$cbc = $detalleXml->appendChild($cbc);
			$cbc = $xml->createElement('codigoAuxiliar', $row->getId());
			$cbc = $detalleXml->appendChild($cbc);
			$cbc = $xml->createElement('descripcion', $row->getDescripcionDetalleFac());
			$cbc = $detalleXml->appendChild($cbc);
			$cbc = $xml->createElement('cantidad', $row->getCantidadDetalleFac());
			$cbc = $detalleXml->appendChild($cbc);
			$cbc = $xml->createElement('precioUnitario', $row->getValorUnitario());
			$cbc = $detalleXml->appendChild($cbc);
			$cbc = $xml->createElement('descuento', $row->getValorDescuento());
			$cbc = $detalleXml->appendChild($cbc);
			$cbc = $xml->createElement('precioTotalSinImpuesto', $row->getValorUnitario());
			$cbc = $detalleXml->appendChild($cbc);

			$impuestosXml = $xml->createElement('impuestos');
			$impuestosXml = $detalleXml->appendChild($impuestosXml);
			$impuestoXml = $xml->createElement('impuesto');
			$impuestoXml = $impuestosXml->appendChild($impuestoXml);
			$cbc = $xml->createElement('codigo', $row->getCodigoImpuesto());
			$cbc = $impuestoXml->appendChild($cbc);
			$cbc = $xml->createElement('codigoPorcentaje', $row->getCodporImpuesto());
			$cbc = $impuestoXml->appendChild($cbc);
			$cbc = $xml->createElement('tarifa', $row->getCodporImpuesto());
			$cbc = $impuestoXml->appendChild($cbc);
			$cbc = $xml->createElement('baseImponible', $row->getValorUnitario());
			$cbc = $impuestoXml->appendChild($cbc);
			$cbc = $xml->createElement('valor', $row->getValorImpuesto());
			$cbc = $impuestoXml->appendChild($cbc);
		}

		$infoAdicionalXml = $xml->createElement('infoAdicional');
		$infoAdicionalXml = $FacturaXml->appendChild($infoAdicionalXml);
		$cbc = $xml->createElement('campoAdicional', $factura->getTelefonoCliente());
		$cbc->setAttribute('nombre', 'telfCliente');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$cbc = $xml->createElement('campoAdicional', $factura->getEmailCliente());
		$cbc->setAttribute('nombre', 'emailCliente');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$cbc = $xml->createElement('campoAdicional', $factura->getDireccionCliente());
		$cbc->setAttribute('nombre', 'direccionCliente');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$cbc = $xml->createElement('campoAdicional', $infoAdicionalFac->getMedReferidoFactura());
		$cbc->setAttribute('nombre', 'medicoReferido');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$cbc = $xml->createElement('campoAdicional', $infoAdicionalFac->getPromocionFactura());
		$cbc->setAttribute('nombre', 'promocion');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$cbc = $xml->createElement('campoAdicional', $infoAdicionalFac->getTitularSeguro());
		$cbc->setAttribute('nombre', 'tituloSeguro');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$cbc = $xml->createElement('campoAdicional', $infoAdicionalFac->getCopagoFactura());
		$cbc->setAttribute('nombre', 'copago');
		$cbc = $infoAdicionalXml->appendChild($cbc);

		$xml->formatOutput = true;
		$strings_xml = $xml->saveXML();

		$xml->save("6973e3e05f3cea01fbdedd4/facturas/".$filename.'.xml');
		chmod("6973e3e05f3cea01fbdedd4/facturas/".$filename.'.xml', 0777);


		return new Response(base64_encode("6973e3e05f3cea01fbdedd4/facturas/".$filename));
	}

	/**
	 * @Route("/facturar/cita/detalle/", name="facturarDetalleCitaMedica")
	 */
	public function facturarDetalleCitaMedica()
	{
		$em = $this->getDoctrine()->getManager();
		$citaMedica = $em->getRepository("AgendaBundle:CitaMedica")->find($_POST["citaMedica"]);

		$query = "select count(f.id) from FacturacionBundle:Factura f where f.idInstitucion = :institucion";
		$facturas = $em->createQuery($query)->setParameter("institucion", $citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getId())->getSingleScalarResult();
		
		//codigo_establecimiento - codigo_punto_emision
		$numFactura = $citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getNumeroEstabl()."-".$citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion()->getPuntoEmision()."-";
		$nroFacturas = $facturas + 1;
		if($nroFacturas > 0 && $nroFacturas < 10)
			$nroFactua = $numFactura."00000000".$nroFacturas;
		elseif($nroFacturas >= 10 && $nroFacturas < 100)
			$nroFactua = $numFactura."0000000".$nroFacturas;
		elseif($nroFacturas >= 100 && $nroFacturas < 1000)
			$nroFactua = $numFactura."000000".$nroFacturas;
		elseif($nroFacturas >= 1000 && $nroFacturas < 10000)
			$nroFactua = $numFactura."00000".$nroFacturas;
		elseif($nroFacturas >= 10000 && $nroFacturas < 100000)
			$nroFactua = $numFactura."0000".$nroFacturas;
		elseif($nroFacturas >= 100000 && $nroFacturas < 1000000)
			$nroFactua = $numFactura."000".$nroFacturas;
		elseif($nroFacturas >= 1000000 && $nroFacturas < 10000000)
			$nroFactua = $numFactura."00".$nroFacturas;
		elseif($nroFacturas >= 10000000 && $nroFacturas < 100000000)
			$nroFactua = $numFactura."0".$nroFacturas;
		elseif($nroFacturas >= 100000000)
			$nroFactua = $numFactura.$nroFacturas;

		$factura = new Factura();
		$factura->setNroFactura($nroFactua);
		$factura->setIdCitaMedica($citaMedica);
		$factura->setIdInstitucion($citaMedica->getIdAgenda()->getIdMedico()->getIdInstitucion());
		$factura->setEstado("FAC_PEN");

		$em->persist($factura);

		for ($i = 0; $i < count($_POST["inputDetTot"]); $i++) 
		{
			$detalleFactura = new DetalleFactura();
			$detalleFactura->setIdFactura($factura);
			$detalleFactura->setCodigoPrincipal($factura->getIdCitaMedica()->getId());
			$detalleFactura->setCodigoAuxiliar($_POST["inputCodAux"][$i]);
			$detalleFactura->setCantidadDetalleFac(1);
			$detalleFactura->setDescripcionDetalleFac($_POST["inputDetDescrip"][$i]);
			$detalleFactura->setCodporImpuesto($_POST["inputDetPIva"][$i]);
			$detalleFactura->setCodporDescuento($_POST["inputDetPDes"][$i]);

			if(is_numeric($_POST["inputDetVal"][$i]))
				$detalleFactura->setValorUnitario($_POST["inputDetVal"][$i]);

			if(is_numeric($_POST["inputDetIva"][$i]))
				$detalleFactura->setValorImpuesto($_POST["inputDetIva"][$i]);

			if(is_numeric($_POST["inputDetDesc"][$i]))
				$detalleFactura->setValorDescuento($_POST["inputDetDesc"][$i]);

			if(is_numeric($_POST["inputDetTot"][$i]))
				$detalleFactura->setValorTotal($_POST["inputDetTot"][$i]);

			if($_POST["inputDetPIva"][$i] == "0")
				$detalleFactura->setCodigoImpuesto("0");
			elseif($_POST["inputDetPIva"][$i] == "12")
				$detalleFactura->setCodigoImpuesto("2");
			elseif($_POST["inputDetPIva"][$i] == "14")
				$detalleFactura->setCodigoImpuesto("3");
			else
				$detalleFactura->setCodigoImpuesto("7");

			$em->persist($detalleFactura);
		}

		$em->flush();
		return new Response($factura->getId());
	}

	/**
	 * @Route("/factura/firmar/comprobante/{rutaFactura}/{idFactura}", name="firmarFactura")
	 */
	public function firmarFacturaAction(Request $request, $rutaFactura = "", $idFactura = 0)
	{
		$em = $this->getDoctrine()->getManager();
		$factura = $em->getRepository("FacturacionBundle:Factura")->find(base64_decode($idFactura));
		$ruta = $rutaFactura;
		return $this->render("@Facturacion/Default/firmar.html.twig", array(
			"ruta" => $ruta,
			"factura" => $factura
		));
	}

	/**
	 * @Route("/factura/enviar/{idFactura}", name="enviarFactura")
	 */
	public function enviarFactura($idFactura = 0)
	{
		$em = $this->getDoctrine()->getManager();
		$factura = $em->getRepository("FacturacionBundle:Factura")->find(base64_decode($idFactura));
		
		unlink(base64_decode($_POST["ruta"]).".xml");
		$xmlFirmado = fopen(base64_decode($_POST["ruta"]).".xml", 'w');
		fwrite($xmlFirmado, base64_decode($_POST["xml"]).".xml");
		fclose($xmlFirmado);
		
		$message = (new \Swift_Message('Factura electrónica '.$factura->getIdInstitucion()->getRazonSocial()))
        ->setFrom($factura->getEmailCliente())
        ->setTo($factura->getEmailCliente())
        ->setBody($this->renderView("@Facturacion/Mail/mail.html.twig", array("factura" => $factura)), 'text/html')
        ->attach(Swift_Attachment::fromPath(base64_decode($_POST["ruta"]).".pdf"))
        ->attach(Swift_Attachment::fromPath(base64_decode($_POST["ruta"]).".xml"));

        $this->get('mailer')->send($message);
        return new Response("ok");
	}
}
