<?php

namespace ComprasBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;

class CarritoController extends Controller
{
	/**
	 * @Route("/", name="carritoHome")
	 */
	public function indexAction(Request $request)
	{
		return $this->render("@Compras/Default/index.html.twig");
	}

	/**
	 * @Route("/mail/", name="mailCompra")
	 */
	public function enviarMail()
	{
		$datos = array(
			"nombre" => $_POST["nombre"],
			"celular" => $_POST["celular"],
			"email" => $_POST["email"],
			"codigo" => $_POST["codigo"],
			"valor_c" => $_POST["valor_c"],
			"ticket" => $_POST["ticket"],
			"fecha" => date("Y-m-d H:i:s")
		);
		$message = (new \Swift_Message("Compra de licencia"))
        ->setFrom($datos["email"])
        ->setTo("info@programamed.com")
        ->setBody($this->renderView("@Compras/Default/mail.html.twig", array("datos" => $datos)), 'text/html');

        $this->get('mailer')->send($message);
        return new Response("ok");
	}
}
