<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TipoDiagnostico
 *
 * @ORM\Table(name="tipo_diagnostico")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\TipoDiagnosticoRepository")
 */
class TipoDiagnostico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_tipo_diagnostico", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="ResumenHistoriaDiagnostico", mappedBy="idTipoDiagnostico")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_diagnostico", type="string", length=15)
     */
    private $nombre;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_diagnostico", type="string", length=10)
     */
    private $codigo;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_diagnostico", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return TipoDiagnostico
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return TipoDiagnostico
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return TipoDiagnostico
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

