<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RutinaMesociclo
 *
 * @ORM\Table(name="rutina_mesociclo")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\RutinaMesocicloRepository")
 */
class RutinaMesociclo {
    /**
     * @var int
     *
     * @ORM\Column(name="id_rutina_mesociclo", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AgendaBundle\Entity\FormularioMesociclo")
     * @ORM\JoinColumn(name="id_formulario_mesociclo", referencedColumnName="id_form_mesociclo")
     */
    private $idMesociclo;

    /**
     * @var int
     *
     * @ORM\Column(name="dia_rutina", type="integer", nullable=true)
     */
    private $dia;

    /**
     * @var string
     *
     * @ORM\Column(name="calentamiento_tipo", type="string", length=30, nullable=true)
     */
    private $calentamientoTipo;

    /**
     * @var string
     *
     * @ORM\Column(name="calentamiento_t", type="string", length=10, nullable=true)
     */
    private $calentamientoT;

    /**
     * @var string
     *
     * @ORM\Column(name="serie", type="string", length=10, nullable=true)
     */
    private $serie;

    /**
     * @var string
     *
     * @ORM\Column(name="aerobico_t", type="string", length=10, nullable=true)
     */
    private $aerobicoT;

   /**
     * @var string
     *
     * @ORM\Column(name="aerobico_tipo", type="string", length=50, nullable=true)
     */
    private $aerobicoTipo;

    /**
     * @var string
     *
     * @ORM\Column(name="aerobico_fc", type="string", length=10, nullable=true)
     */
    private $areobicoFc;

    /**
     * @var string
     *
     * @ORM\Column(name="estiramiento", type="string", length=10, nullable=true)
     */
    private $estiramiento;

    /**
     * @var string
     *
     * @ORM\Column(name="total", type="string", length=10, nullable=true)
     */
    private $total;

    /**
     * @var string
     *
     * @ORM\Column(name="si_no_km", type="string", length=10, nullable=true)
     */
    private $siNo;

    //GETTERS AND SETTERS
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idMesociclo
     *
     * @param integer $idMesociclo
     *
     * @return RutinaMesociclo
     */
    public function setIdMesociclo($idMesociclo)
    {
        $this->idMesociclo = $idMesociclo;
        return $this;
    }

    /**
     * Get idMesociclo
     *
     * @return int
     */
    public function getIdMesociclo()
    {
        return $this->idMesociclo;
    }

    //----------------------------------------------------------------
    /**
     * Set dia
     *
     * @param integer $dia
     *
     * @return RutinaMesociclo
     */
    public function setDia($dia)
    {
        $this->dia = $dia;
        return $this;
    }

    /**
     * Get dia
     *
     * @return int
     */
    public function getDia()
    {
        return $this->dia;
    }

    /**
     * Set calentamientoTipo
     *
     * @param string $calentamientoTipo
     *
     * @return RutinaMesociclo
     */
    public function setCalentamientoTipo($calentamientoTipo)
    {
        $this->calentamientoTipo = $calentamientoTipo;
        return $this;
    }

    /**
     * Get calentamientoTipo
     *
     * @return string
     */
    public function getCalentamientoTipo()
    {
        return $this->calentamientoTipo;
    }

    /**
     * Set calentamientoT
     *
     * @param string $calentamientoT
     *
     * @return RutinaMesociclo
     */
    public function setCalentamientoT($calentamientoT)
    {
        $this->calentamientoT = $calentamientoT;
        return $this;
    }

    /**
     * Get calentamientoT
     *
     * @return string
     */
    public function getCalentamientoT()
    {
        return $this->calentamientoT;
    }

    /**
     * Set serie
     *
     * @param string $serie
     *
     * @return RutinaMesociclo
     */
    public function setSerie($serie)
    {
        $this->serie = $serie;
        return $this;
    }

    /**
     * Get serie
     *
     * @return string
     */
    public function getSerie()
    {
        return $this->serie;
    }

    /**
     * Set aerobicoT
     *
     * @param string $aerobicoT
     *
     * @return RutinaMesociclo
     */
    public function setAerobicoT($aerobicoT)
    {
        $this->aerobicoT = $aerobicoT;
        return $this;
    }

    /**
     * Get aerobicoT
     *
     * @return string
     */
    public function getAerobicoT()
    {
        return $this->aerobicoT;
    }

    /**
     * Set aerobicoTipo
     *
     * @param string $aerobicoTipo
     *
     * @return RutinaMesociclo
     */
    public function setAerobicoTipo($aerobicoTipo)
    {
        $this->aerobicoTipo = $aerobicoTipo;
        return $this;
    }

    /**
     * Get aerobicoTipo
     *
     * @return string
     */
    public function getAerobicoTipo()
    {
        return $this->aerobicoTipo;
    }

    /**
     * Set areobicoFc
     *
     * @param string $areobicoFc
     *
     * @return RutinaMesociclo
     */
    public function setAreobicoFc($areobicoFc)
    {
        $this->areobicoFc = $areobicoFc;
        return $this;
    }

    /**
     * Get areobicoFc
     *
     * @return string
     */
    public function getAreobicoFc()
    {
        return $this->areobicoFc;
    }

    /**
     * Set estiramiento
     *
     * @param string $estiramiento
     *
     * @return RutinaMesociclo
     */
    public function setEstiramiento($estiramiento)
    {
        $this->estiramiento = $estiramiento;
        return $this;
    }

    /**
     * Get estiramiento
     *
     * @return string
     */
    public function getEstiramiento()
    {
        return $this->estiramiento;
    }

    /**
     * Set total
     *
     * @param string $total
     *
     * @return RutinaMesociclo
     */
    public function setTotal($total)
    {
        $this->total = $total;
        return $this;
    }

    /**
     * Get total
     *
     * @return string
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * Set siNo
     *
     * @param string $siNo
     *
     * @return RutinaMesociclo
     */
    public function setSiNo($siNo)
    {
        $this->siNo = $siNo;
        return $this;
    }

    /**
     * Get siNo
     *
     * @return string
     */
    public function getSiNo()
    {
        return $this->siNo;
    }
}
