<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ResumenHistoriaMedicamento
 *
 * @ORM\Table(name="resumen_historia_medicamento")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ResumenHistoriaMedicamentoRepository")
 */
class ResumenHistoriaMedicamento
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_res_his_med", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Medicamento")
     * @ORM\JoinColumn(name="id_medicamento", referencedColumnName="id_medicamento")
     */
    private $idMedicamento;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var int
     *
     * @ORM\Column(name="cantidad_medicamento", type="integer")
     */
    private $cantidadMedicamento;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_medicamento", type="string", length=200)
     */
    private $indicacionesMedicamento;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_pedido", type="string", length=10)
     */
    private $tipoPedido;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idMedicamento
     *
     * @param integer $idMedicamento
     *
     * @return ResumenHistoriaMedicamento
     */
    public function setIdMedicamento($idMedicamento)
    {
        $this->idMedicamento = $idMedicamento;

        return $this;
    }

    /**
     * Get idMedicamento
     *
     * @return int
     */
    public function getIdMedicamento()
    {
        return $this->idMedicamento;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return ResumenHistoriaMedicamento
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set cantidadMedicamento
     *
     * @param integer $cantidadMedicamento
     *
     * @return ResumenHistoriaMedicamento
     */
    public function setCantidadMedicamento($cantidadMedicamento)
    {
        $this->cantidadMedicamento = $cantidadMedicamento;

        return $this;
    }

    /**
     * Get cantidadMedicamento
     *
     * @return int
     */
    public function getCantidadMedicamento()
    {
        return $this->cantidadMedicamento;
    }

    /**
     * Set indicacionesMedicamento
     *
     * @param string $indicacionesMedicamento
     *
     * @return ResumenHistoriaMedicamento
     */
    public function setIndicacionesMedicamento($indicacionesMedicamento)
    {
        $this->indicacionesMedicamento = $indicacionesMedicamento;

        return $this;
    }

    /**
     * Get indicacionesMedicamento
     *
     * @return string
     */
    public function getIndicacionesMedicamento()
    {
        return $this->indicacionesMedicamento;
    }

    /**
     * Set tipoPedido
     *
     * @param string $tipoPedido
     *
     * @return ResumenHistoriaImagen
     */
    public function setTipoPedido($tipoPedido)
    {
        $this->tipoPedido = $tipoPedido;

        return $this;
    }

    /**
     * Get tipoPedido
     *
     * @return string
     */
    public function getTipoPedido()
    {
        return $this->tipoPedido;
    }
}

