<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ResumenHistoriaLab
 *
 * @ORM\Table(name="resumen_historia_lab")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ResumenHistoriaLabRepository")
 */
class ResumenHistoriaLab
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_res_his_lab", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="PedidoExaComplemt")
     * @ORM\JoinColumn(name="id_exa_comple", referencedColumnName="id_exa_comple")
     */
    private $idExaComple;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_examen", type="string", length=15)
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_pedido", type="string", length=10)
     */
    private $tipoPedido;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idExaComple
     *
     * @param integer $idExaComple
     *
     * @return ResumenHistoriaLab
     */
    public function setIdExaComple($idExaComple)
    {
        $this->idExaComple = $idExaComple;

        return $this;
    }

    /**
     * Get idExaComple
     *
     * @return int
     */
    public function getIdExaComple()
    {
        return $this->idExaComple;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return ResumenHistoriaLab
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return ResumenHistoriaLab
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set tipoPedido
     *
     * @param string $tipoPedido
     *
     * @return ResumenHistoriaImagen
     */
    public function setTipoPedido($tipoPedido)
    {
        $this->tipoPedido = $tipoPedido;

        return $this;
    }

    /**
     * Get tipoPedido
     *
     * @return string
     */
    public function getTipoPedido()
    {
        return $this->tipoPedido;
    }
}

