<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ResumenHistoriaImagen
 *
 * @ORM\Table(name="resumen_historia_imagen")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ResumenHistoriaImagenRepository")
 */
class ResumenHistoriaImagen
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_res_his_imagen", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="PedidoImagen")
     * @ORM\JoinColumn(name="id_pedido_imagen", referencedColumnName="id_pedido_imagen")
     */
    private $idPedidoImagen;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_examen", type="string", length=15)
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_pedido", type="string", length=10)
     */
    private $tipoPedido;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPedidoImagen
     *
     * @param integer $idPedidoImagen
     *
     * @return ResumenHistoriaImagen
     */
    public function setIdPedidoImagen($idPedidoImagen)
    {
        $this->idPedidoImagen = $idPedidoImagen;

        return $this;
    }

    /**
     * Get idPedidoImagen
     *
     * @return int
     */
    public function getIdPedidoImagen()
    {
        return $this->idPedidoImagen;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return ResumenHistoriaImagen
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return ResumenHistoriaImagen
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set tipoPedido
     *
     * @param string $tipoPedido
     *
     * @return ResumenHistoriaImagen
     */
    public function setTipoPedido($tipoPedido)
    {
        $this->tipoPedido = $tipoPedido;

        return $this;
    }

    /**
     * Get tipoPedido
     *
     * @return string
     */
    public function getTipoPedido()
    {
        return $this->tipoPedido;
    }
}

