<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ResumenHistoriaDiagnostico
 *
 * @ORM\Table(name="resumen_historia_diagnostico")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ResumenHistoriaDiagnosticoRepository")
 */
class ResumenHistoriaDiagnostico
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_res_his_diag", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="CieDiez")
     * @ORM\JoinColumn(name="id_cie_diez", referencedColumnName="id_cie_diez")
     */
    private $idCieDiez;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="TipoDiagnostico")
     * @ORM\JoinColumn(name="id_tipo_diagnostico", referencedColumnName="id_tipo_diagnostico")
     */
    private $idTipoDiagnostico;

    /**
     * @var string
     *
     * @ORM\Column(name="diagnostico", type="string", length=200)
     */
    private $diagnostico;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idCieDiez
     *
     * @param integer $idCieDiez
     *
     * @return ResumenHistoriaDiagnostico
     */
    public function setIdCieDiez($idCieDiez)
    {
        $this->idCieDiez = $idCieDiez;

        return $this;
    }

    /**
     * Get idCieDiez
     *
     * @return int
     */
    public function getIdCieDiez()
    {
        return $this->idCieDiez;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return ResumenHistoriaDiagnostico
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set idTipoDiagnostico
     *
     * @param integer $idTipoDiagnostico
     *
     * @return ResumenHistoriaDiagnostico
     */
    public function setIdTipoDiagnostico($idTipoDiagnostico)
    {
        $this->idTipoDiagnostico = $idTipoDiagnostico;

        return $this;
    }

    /**
     * Get idTipoDiagnostico
     *
     * @return int
     */
    public function getIdTipoDiagnostico()
    {
        return $this->idTipoDiagnostico;
    }

    /**
     * Set diagnostico
     *
     * @param string $diagnostico
     *
     * @return ResumenHistoriaDiagnostico
     */
    public function setDiagnostico($diagnostico)
    {
        $this->diagnostico = $diagnostico;

        return $this;
    }

    /**
     * Get diagnostico
     *
     * @return string
     */
    public function getDiagnostico()
    {
        return $this->diagnostico;
    }
}

