<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ResumenHistoriaClinica
 *
 * @ORM\Table(name="resumen_historia_clinica")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ResumenHistoriaClinicaRepository")
 */
class ResumenHistoriaClinica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_resumen_hc", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="DetalleHistoriaClinica", mappedBy="idResumenHc")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="HistoriaClinica")
     * @ORM\JoinColumn(name="id_historia_clinica", referencedColumnName="id_historia_clinica")
     */
    private $idHistoriaClinica;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="CitaMedica")
     * @ORM\JoinColumn(name="id_cita_medica", referencedColumnName="id_cita_medica")
     */
    private $idCitaMedica;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico")
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="motivo_consulta", type="text", nullable=true)
     */
    private $motivoConsulta;

    /**
     * @var string
     *
     * @ORM\Column(name="enfermedad_actual", type="text", nullable=true)
     */
    private $enfermedadActual;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_medicas", type="text", nullable=true)
     */
    private $indicaciones;

    /**
     * @var string
     *
     * @ORM\Column(name="planificacion", type="text", nullable=true)
     */
    private $planificacion;

    /**
     * @var string
     *
     * @ORM\Column(name="evo_subjetivo", type="text", nullable=true)
     */
    private $evolucionSubjetiva;

    /**
     * @var string
     *
     * @ORM\Column(name="evo_objetivo", type="text", nullable=true)
     */
    private $evolucionObjetiva;

    /**
     * @var string
     *
     * @ORM\Column(name="evo_apreciacion", type="text", nullable=true)
     */
    private $apreciacion;

    /**
     * @var string
     *
     * @ORM\Column(name="evo_planes", type="text", nullable=true)
     */
    private $planes;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_imagen", type="text", nullable=true)
     */
    private $indicacionesImagen;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_examen", type="text", nullable=true)
     */
    private $indicacionesExamen;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_complem", type="text", nullable=true)
     */
    private $indicacionesComplem;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_evo_imagen", type="text", nullable=true)
     */
    private $indicacionesEvoImagen;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_evo_examen", type="text", nullable=true)
     */
    private $indicacionesEvoExamen;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_evo_complem", type="text", nullable=true)
     */
    private $indicacionesEvoComplem;

    /**
     * @var string
     *
     * @ORM\Column(name="indicaciones_receta", type="text", nullable=true)
     */
    private $indicacionesReceta;

    /**
     * @var int
     *
     * @ORM\Column(name="bandera_receta", type="integer")
     */
    private $numeroReceta;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idHistoriaClinica
     *
     * @param integer $idHistoriaClinica
     *
     * @return ResumenHistoriaClinica
     */
    public function setIdHistoriaClinica($idHistoriaClinica)
    {
        $this->idHistoriaClinica = $idHistoriaClinica;

        return $this;
    }

    /**
     * Get idHistoriaClinica
     *
     * @return int
     */
    public function getIdHistoriaClinica()
    {
        return $this->idHistoriaClinica;
    }

    /**
     * Set idCitaMedica
     *
     * @param integer $idCitaMedica
     *
     * @return ResumenHistoriaClinica
     */
    public function setIdCitaMedica($idCitaMedica)
    {
        $this->idCitaMedica = $idCitaMedica;

        return $this;
    }

    /**
     * Get idCitaMedica
     *
     * @return int
     */
    public function getIdCitaMedica()
    {
        return $this->idCitaMedica;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return ResumenHistoriaClinica
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set motivoConsulta
     *
     * @param string $motivoConsulta
     *
     * @return ResumenHistoriaClinica
     */
    public function setMotivoConsulta($motivoConsulta)
    {
        $this->motivoConsulta = $motivoConsulta;

        return $this;
    }

    /**
     * Get motivoConsulta
     *
     * @return string
     */
    public function getMotivoConsulta()
    {
        return $this->motivoConsulta;
    }

    /**
     * Set enfermedadActual
     *
     * @param string $enfermedadActual
     *
     * @return ResumenHistoriaClinica
     */
    public function setEnfermedadActual($enfermedadActual)
    {
        $this->enfermedadActual = $enfermedadActual;

        return $this;
    }

    /**
     * Get enfermedadActual
     *
     * @return string
     */
    public function getEnfermedadActual()
    {
        return $this->enfermedadActual;
    }

    /**
     * Set indicaciones
     *
     * @param string $indicaciones
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicaciones($indicaciones)
    {
        $this->indicaciones = $indicaciones;

        return $this;
    }

    /**
     * Get indicaciones
     *
     * @return string
     */
    public function getIndicaciones()
    {
        return $this->indicaciones;
    }

    /**
     * Set planificacion
     *
     * @param string $planificacion
     *
     * @return ResumenHistoriaClinica
     */
    public function setPlanificacion($planificacion)
    {
        $this->planificacion = $planificacion;

        return $this;
    }

    /**
     * Get planificacion
     *
     * @return string
     */
    public function getPlanificacion()
    {
        return $this->planificacion;
    }

    /**
     * Set evolucionSubjetiva
     *
     * @param string $evolucionSubjetiva
     *
     * @return ResumenHistoriaClinica
     */
    public function setEvolucionSubjetiva($evolucionSubjetiva)
    {
        $this->evolucionSubjetiva = $evolucionSubjetiva;

        return $this;
    }

    /**
     * Get evolucionSubjetiva
     *
     * @return string
     */
    public function getEvolucionSubjetiva()
    {
        return $this->evolucionSubjetiva;
    }

    /**
     * Set evolucionObjetiva
     *
     * @param string $evolucionObjetiva
     *
     * @return ResumenHistoriaClinica
     */
    public function setEvolucionObjetiva($evolucionObjetiva)
    {
        $this->evolucionObjetiva = $evolucionObjetiva;

        return $this;
    }

    /**
     * Get evolucionObjetiva
     *
     * @return string
     */
    public function getEvolucionObjetiva()
    {
        return $this->evolucionObjetiva;
    }

    /**
     * Set apreciacion
     *
     * @param string $apreciacion
     *
     * @return ResumenHistoriaClinica
     */
    public function setApreciacion($apreciacion)
    {
        $this->apreciacion = $apreciacion;

        return $this;
    }

    /**
     * Get apreciacion
     *
     * @return string
     */
    public function getApreciacion()
    {
        return $this->apreciacion;
    }

    /**
     * Set planes
     *
     * @param string $planes
     *
     * @return ResumenHistoriaClinica
     */
    public function setPlanes($planes)
    {
        $this->planes = $planes;

        return $this;
    }

    /**
     * Get planes
     *
     * @return string
     */
    public function getPlanes()
    {
        return $this->planes;
    }

    /**
     * Set indicacionesImagen
     *
     * @param string $indicacionesImagen
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesImagen($indicacionesImagen)
    {
        $this->indicacionesImagen = $indicacionesImagen;

        return $this;
    }

    /**
     * Get indicacionesImagen
     *
     * @return string
     */
    public function getIndicacionesImagen()
    {
        return $this->indicacionesImagen;
    }

    /**
     * Set indicacionesExamen
     *
     * @param string $indicacionesExamen
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesExamen($indicacionesExamen)
    {
        $this->indicacionesExamen = $indicacionesExamen;

        return $this;
    }

    /**
     * Get indicacionesExamen
     *
     * @return string
     */
    public function getIndicacionesExamen()
    {
        return $this->indicacionesExamen;
    }

    /**
     * Set indicacionesComplem
     *
     * @param string $indicacionesComplem
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesComplem($indicacionesComplem)
    {
        $this->indicacionesComplem = $indicacionesComplem;

        return $this;
    }

    /**
     * Get indicacionesComplem
     *
     * @return string
     */
    public function getIndicacionesComplem()
    {
        return $this->indicacionesComplem;
    }

    /**
     * Set indicacionesEvoImagen
     *
     * @param string $indicacionesEvoImagen
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesEvoImagen($indicacionesEvoImagen)
    {
        $this->indicacionesEvoImagen = $indicacionesEvoImagen;

        return $this;
    }

    /**
     * Get indicacionesEvoImagen
     *
     * @return string
     */
    public function getIndicacionesEvoImagen()
    {
        return $this->indicacionesEvoImagen;
    }

    /**
     * Set indicacionesEvoExamen
     *
     * @param string $indicacionesEvoExamen
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesEvoExamen($indicacionesEvoExamen)
    {
        $this->indicacionesEvoExamen = $indicacionesEvoExamen;

        return $this;
    }

    /**
     * Get indicacionesEvoExamen
     *
     * @return string
     */
    public function getIndicacionesEvoExamen()
    {
        return $this->indicacionesEvoExamen;
    }

    /**
     * Set indicacionesEvoComplem
     *
     * @param string $indicacionesEvoComplem
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesEvoComplem($indicacionesEvoComplem)
    {
        $this->indicacionesEvoComplem = $indicacionesEvoComplem;

        return $this;
    }

    /**
     * Get indicacionesEvoComplem
     *
     * @return string
     */
    public function getIndicacionesEvoComplem()
    {
        return $this->indicacionesEvoComplem;
    }

    /**
     * Set indicacionesReceta
     *
     * @param string $indicacionesReceta
     *
     * @return ResumenHistoriaClinica
     */
    public function setIndicacionesReceta($indicacionesReceta)
    {
        $this->indicacionesReceta = $indicacionesReceta;

        return $this;
    }

    /**
     * Get indicacionesReceta
     *
     * @return string
     */
    public function getIndicacionesReceta()
    {
        return $this->indicacionesReceta;
    }
    
    /**
     * Set numeroReceta
     *
     * @param integer $numeroReceta
     *
     * @return ResumenHistoriaClinica
     */
    public function setNumeroReceta($numeroReceta)
    {
        $this->numeroReceta = $numeroReceta;
        return $this;
    }

    /**
     * Get numeroReceta
     *
     * @return int
     */
    public function getNumeroReceta()
    {
        return $this->numeroReceta;
    }
}

