<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ResumenExamenComp
 *
 * @ORM\Table(name="resumen_examen_comp")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ResumenExamenCompRepository")
 */
class ResumenExamenComp
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_res_exa_comp", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_exam_comp", type="string", length=250)
     */
    private $nombre;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_examen", type="string", length=15)
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_pedido", type="string", length=10)
     */
    private $tipoPedido;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return ResumenExamenComp
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return ResumenExamenComp
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return ResumenExamenComp
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set tipoPedido
     *
     * @param string $tipoPedido
     *
     * @return ResumenHistoriaImagen
     */
    public function setTipoPedido($tipoPedido)
    {
        $this->tipoPedido = $tipoPedido;

        return $this;
    }

    /**
     * Get tipoPedido
     *
     * @return string
     */
    public function getTipoPedido()
    {
        return $this->tipoPedido;
    }
}

