<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PuntosEspecialidad
 *
 * @ORM\Table(name="puntos_especialidad")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\PuntosEspecialidadRepository")
 */
class PuntosEspecialidad
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_punto_especialidad", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Especialidades")
     * @ORM\JoinColumn(name="id_especialidad", referencedColumnName="id_especialidad")
     */
    private $idEspecialidad;

    /**
     * @var int
     *
     * @ORM\Column(name="id_medico", type="integer")
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="puntos", type="text")
     */
    private $puntos;

    /**
     * @var string
     *
     * @ORM\Column(name="observaciones", type="text")
     */
    private $observaciones;

    /**
     * @var string
     *
     * @ORM\Column(name="campos_adicional", type="text")
     */
    private $camposAdicional;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return PuntosEspecialidad
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idEspecialidad
     *
     * @param integer $idEspecialidad
     *
     * @return PuntosEspecialidad
     */
    public function setIdEspecialidad($idEspecialidad)
    {
        $this->idEspecialidad = $idEspecialidad;

        return $this;
    }

    /**
     * Get idEspecialidad
     *
     * @return int
     */
    public function getIdEspecialidad()
    {
        return $this->idEspecialidad;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return PuntosEspecialidad
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set puntos
     *
     * @param string $puntos
     *
     * @return PuntosEspecialidad
     */
    public function setPuntos($puntos)
    {
        $this->puntos = $puntos;

        return $this;
    }

    /**
     * Get puntos
     *
     * @return string
     */
    public function getPuntos()
    {
        return $this->puntos;
    }

    /**
     * Set observaciones
     *
     * @param string $observaciones
     *
     * @return PuntosEspecialidad
     */
    public function setObservaciones($observaciones)
    {
        $this->observaciones = $observaciones;

        return $this;
    }

    /**
     * Get observaciones
     *
     * @return string
     */
    public function getObservaciones()
    {
        return $this->observaciones;
    }

    /**
     * Set camposAdicional
     *
     * @param string $camposAdicional
     *
     * @return PuntosEspecialidad
     */
    public function setCamposAdicional($camposAdicional)
    {
        $this->camposAdicional = $camposAdicional;

        return $this;
    }

    /**
     * Get camposAdicional
     *
     * @return string
     */
    public function getCamposAdicional()
    {
        return $this->camposAdicional;
    }
}

