<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NutricionFormulario
 *
 * @ORM\Table(name="nutricion_formulario")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\NutricionFormularioRepository")
 */

 class NutricionFormulario
 {
    /**
     * @var int
     *
     * @ORM\Column(name="id_form_nutricion", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente", nullable=true)
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico", nullable=true)
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_emision", type="string", length=50, nullable=true)
     */
    private $fechaEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_paciente", type="string", length=50, nullable=true)
     */
    private $nombrePaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="edad_paciente", type="string", length=10, nullable=true)
     */
    private $edadPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="cedula_paciente", type="string", length=13, nullable=true)
     */
    private $cedulaPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="celular_paciente", type="string", length=15, nullable=true)
     */
    private $celularPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="identificacion_paciente", type="string", length=300, nullable=true)
     */
    private $identificacionPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="app_clinicos", type="string", length=300, nullable=true)
     */
    private $appClinicos;

    /**
     * @var string
     *
     * @ORM\Column(name="app_alergias", type="string", length=300, nullable=true)
     */
    private $appAlergias;

    /**
     * @var string
     *
     * @ORM\Column(name="app_quirurgicos", type="string", length=300, nullable=true)
     */
    private $appQuirurgicos;

    /**
     * @var string
     *
     * @ORM\Column(name="app_ippeso", type="string", length=300, nullable=true)
     */
    private $appIppeso;

    /**
     * @var string
     *
     * @ORM\Column(name="app_gastrointestinales", type="string", length=300, nullable=true)
     */
    private $appGastrointestinales;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_apetito", type="string", length=300, nullable=true)
     */
    private $haafApetito;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_consumo", type="string", length=300, nullable=true)
     */
    private $haafConsumo;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_intolerancia", type="string", length=300, nullable=true)
     */
    private $haafIntolerancia;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_agua", type="string", length=300, nullable=true)
     */
    private $haafAgua;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_sal", type="string", length=300, nullable=true)
     */
    private $haafSal;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_azucar", type="string", length=300, nullable=true)
     */
    private $haafAzucar;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_aversiones", type="string", length=300, nullable=true)
     */
    private $haafAversiones;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_alcohol", type="string", length=300, nullable=true)
     */
    private $haafAlcohol;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_tabaco", type="string", length=300, nullable=true)
     */
    private $haafTabaco;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_drogas", type="string", length=300, nullable=true)
     */
    private $haafDrogas;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_cafe", type="string", length=300, nullable=true)
     */
    private $haafCafe;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_actividad", type="string", length=300, nullable=true)
     */
    private $haafActividad;

    /**
     * @var string
     *
     * @ORM\Column(name="da_peso", type="string", length=300, nullable=true)
     */
    private $daPeso;

    /**
     * @var string
     *
     * @ORM\Column(name="da_talla", type="string", length=300, nullable=true)
     */
    private $daTalla;

    /**
     * @var string
     *
     * @ORM\Column(name="da_a_nutricionales", type="string", length=300, nullable=true)
     */
    private $daANutricionales;

    /**
     * @var string
     *
     * @ORM\Column(name="da_peso_acumulado", type="string", length=300, nullable=true)
     */
    private $daPesoAcumulado;

    /**
     * @var string
     *
     * @ORM\Column(name="da_imc", type="string", length=300, nullable=true)
     */
    private $daImc;

    /**
     * @var string
     *
     * @ORM\Column(name="da_musculo", type="string", length=300, nullable=true)
     */
    private $daMusculo;

    /**
     * @var string
     *
     * @ORM\Column(name="da_g_u_anio", type="string", length=300, nullable=true)
     */
    private $daGUAnio;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_desayuno", type="string", length=300, nullable=true)
     */
    private $ihaDesayuno;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_mm", type="string", length=300, nullable=true)
     */
    private $ihaMm;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_almuerzo", type="string", length=300, nullable=true)
     */
    private $ihaAlmuerzo;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_mt", type="string", length=300, nullable=true)
     */
    private $ihaMt;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_cena", type="string", length=300, nullable=true)
     */
    private $ihaCena;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_diagnostico_n", type="string", length=300, nullable=true)
     */
    private $ihaDiagnosticoN;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_recomendacion_n", type="string", length=300, nullable=true)
     */
    private $ihaRecomendacionN;

    /**
     * @var string
     *
     * @ORM\Column(name="iha_plan_n", type="string", length=300, nullable=true)
     */
    private $ihaPlanN;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_medico", type="string", length=300, nullable=true)
     */
    private $nombreMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="especialidad_medico", type="string", length=300, nullable=true)
     */
    private $especialidadMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_medico", type="string", length=15, nullable=true)
     */
    private $telefonoMedico;

    //---------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return NutricionFormulario
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;
        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return NutricionFormulario
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;
        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set fechaEmision
     *
     * @param string $fechaEmision
     *
     * @return NutricionFormulario
     */
    public function setfechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
        return $this;
    }

    /**
     * Get fechaEmision
     *
     * @return string
     */
    public function getfechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * Set nombrePaciente
     *
     * @param string $nombrePaciente
     *
     * @return NutricionFormulario
     */
    public function setnombrePaciente($nombrePaciente)
    {
        $this->nombrePaciente = $nombrePaciente;
        return $this;
    }

    /**
     * Get nombrePaciente
     *
     * @return string
     */
    public function getnombrePaciente()
    {
        return $this->nombrePaciente;
    }

    /**
     * Set edadPaciente
     *
     * @param string $edadPaciente
     *
     * @return NutricionFormulario
     */
    public function setedadPaciente($edadPaciente)
    {
        $this->edadPaciente = $edadPaciente;
        return $this;
    }

    /**
     * Get edadPaciente
     *
     * @return string
     */
    public function getedadPaciente()
    {
        return $this->edadPaciente;
    }

    /**
     * Set cedulaPaciente
     *
     * @param string $cedulaPaciente
     *
     * @return NutricionFormulario
     */
    public function setcedulaPaciente($cedulaPaciente)
    {
        $this->cedulaPaciente = $cedulaPaciente;
        return $this;
    }

    /**
     * Get cedulaPaciente
     *
     * @return string
     */
    public function getcedulaPaciente()
    {
        return $this->cedulaPaciente;
    }

    /**
     * Set celularPaciente
     *
     * @param string $celularPaciente
     *
     * @return NutricionFormulario
     */
    public function setcelularPaciente($celularPaciente)
    {
        $this->celularPaciente = $celularPaciente;
        return $this;
    }

    /**
     * Get celularPaciente
     *
     * @return string
     */
    public function getcelularPaciente()
    {
        return $this->celularPaciente;
    }

    /**
     * Set identificacionPaciente
     *
     * @param string $identificacionPaciente
     *
     * @return NutricionFormulario
     */
    public function setidentificacionPaciente($identificacionPaciente)
    {
        $this->identificacionPaciente = $identificacionPaciente;
        return $this;
    }

    /**
     * Get identificacionPaciente
     *
     * @return string
     */
    public function getidentificacionPaciente()
    {
        return $this->identificacionPaciente;
    }

    /**
     * Set appClinicos
     *
     * @param string $appClinicos
     *
     * @return NutricionFormulario
     */
    public function setappClinicos($appClinicos)
    {
        $this->appClinicos = $appClinicos;
        return $this;
    }

    /**
     * Get appClinicos
     *
     * @return string
     */
    public function getappClinicos()
    {
        return $this->appClinicos;
    }

    /**
     * Set appAlergias
     *
     * @param string $appAlergias
     *
     * @return NutricionFormulario
     */
    public function setappAlergias($appAlergias)
    {
        $this->appAlergias = $appAlergias;
        return $this;
    }

    /**
     * Get appAlergias
     *
     * @return string
     */
    public function getappAlergias()
    {
        return $this->appAlergias;
    }

    /**
     * Set appQuirurgicos
     *
     * @param string $appQuirurgicos
     *
     * @return NutricionFormulario
     */
    public function setappQuirurgicos($appQuirurgicos)
    {
        $this->appQuirurgicos = $appQuirurgicos;
        return $this;
    }

    /**
     * Get appQuirurgicos
     *
     * @return string
     */
    public function getappQuirurgicos()
    {
        return $this->appQuirurgicos;
    }

    /**
     * Set appIppeso
     *
     * @param string $appIppeso
     *
     * @return NutricionFormulario
     */
    public function setappIppeso($appIppeso)
    {
        $this->appIppeso = $appIppeso;
        return $this;
    }

    /**
     * Get appIppeso
     *
     * @return string
     */
    public function getappIppeso()
    {
        return $this->appIppeso;
    }

    /**
     * Set appGastrointestinales
     *
     * @param string $appGastrointestinales
     *
     * @return NutricionFormulario
     */
    public function setappGastrointestinales($appGastrointestinales)
    {
        $this->appGastrointestinales = $appGastrointestinales;
        return $this;
    }

    /**
     * Get appGastrointestinales
     *
     * @return string
     */
    public function getappGastrointestinales()
    {
        return $this->appGastrointestinales;
    }

    /**
     * Set haafApetito
     *
     * @param string $haafApetito
     *
     * @return NutricionFormulario
     */
    public function sethaafApetito($haafApetito)
    {
        $this->haafApetito = $haafApetito;
        return $this;
    }

    /**
     * Get haafApetito
     *
     * @return string
     */
    public function gethaafApetito()
    {
        return $this->haafApetito;
    }

    /**
     * Set haafConsumo
     *
     * @param string $haafConsumo
     *
     * @return NutricionFormulario
     */
    public function sethaafConsumo($haafConsumo)
    {
        $this->haafConsumo = $haafConsumo;
        return $this;
    }

    /**
     * Get haafConsumo
     *
     * @return string
     */
    public function gethaafConsumo()
    {
        return $this->haafConsumo;
    }

    /**
     * Set haafIntolerancia
     *
     * @param string $haafIntolerancia
     *
     * @return NutricionFormulario
     */
    public function sethaafIntolerancia($haafIntolerancia)
    {
        $this->haafIntolerancia = $haafIntolerancia;
        return $this;
    }

    /**
     * Get haafIntolerancia
     *
     * @return string
     */
    public function gethaafIntolerancia()
    {
        return $this->haafIntolerancia;
    }

    /**
     * Set haafAgua
     *
     * @param string $haafAgua
     *
     * @return NutricionFormulario
     */
    public function sethaafAgua($haafAgua)
    {
        $this->haafAgua = $haafAgua;
        return $this;
    }

    /**
     * Get haafAgua
     *
     * @return string
     */
    public function gethaafAgua()
    {
        return $this->haafAgua;
    }

    /**
     * Set haafSal
     *
     * @param string $haafSal
     *
     * @return NutricionFormulario
     */
    public function sethaafSal($haafSal)
    {
        $this->haafSal = $haafSal;
        return $this;
    }

    /**
     * Get haafSal
     *
     * @return string
     */
    public function gethaafSal()
    {
        return $this->haafSal;
    }

    /**
     * Set haafAzucar
     *
     * @param string $haafAzucar
     *
     * @return NutricionFormulario
     */
    public function sethaafAzucar($haafAzucar)
    {
        $this->haafAzucar = $haafAzucar;
        return $this;
    }

    /**
     * Get haafAzucar
     *
     * @return string
     */
    public function gethaafAzucar()
    {
        return $this->haafAzucar;
    }

    /**
     * Set haafAversiones
     *
     * @param string $haafAversiones
     *
     * @return NutricionFormulario
     */
    public function sethaafAversiones($haafAversiones)
    {
        $this->haafAversiones = $haafAversiones;
        return $this;
    }

    /**
     * Get haafAversiones
     *
     * @return string
     */
    public function gethaafAversiones()
    {
        return $this->haafAversiones;
    }

    /**
     * Set haafAlcohol
     *
     * @param string $haafAlcohol
     *
     * @return NutricionFormulario
     */
    public function sethaafAlcohol($haafAlcohol)
    {
        $this->haafAlcohol = $haafAlcohol;
        return $this;
    }

    /**
     * Get haafAlcohol
     *
     * @return string
     */
    public function gethaafAlcohol()
    {
        return $this->haafAlcohol;
    }

    /**
     * Set haafTabaco
     *
     * @param string $haafTabaco
     *
     * @return NutricionFormulario
     */
    public function sethaafTabaco($haafTabaco)
    {
        $this->haafTabaco = $haafTabaco;
        return $this;
    }

    /**
     * Get haafTabaco
     *
     * @return string
     */
    public function gethaafTabaco()
    {
        return $this->haafTabaco;
    }

    /**
     * Set haafDrogas
     *
     * @param string $haafDrogas
     *
     * @return NutricionFormulario
     */
    public function sethaafDrogas($haafDrogas)
    {
        $this->haafDrogas = $haafDrogas;
        return $this;
    }

    /**
     * Get haafDrogas
     *
     * @return string
     */
    public function gethaafDrogas()
    {
        return $this->haafDrogas;
    }

    /**
     * Set haafCafe
     *
     * @param string $haafCafe
     *
     * @return NutricionFormulario
     */
    public function sethaafCafe($haafCafe)
    {
        $this->haafCafe = $haafCafe;
        return $this;
    }

    /**
     * Get haafCafe
     *
     * @return string
     */
    public function gethaafCafe()
    {
        return $this->haafCafe;
    }

    /**
     * Set haafActividad
     *
     * @param string $haafActividad
     *
     * @return NutricionFormulario
     */
    public function sethaafActividad($haafActividad)
    {
        $this->haafActividad = $haafActividad;
        return $this;
    }

    /**
     * Get haafActividad
     *
     * @return string
     */
    public function gethaafActividad()
    {
        return $this->haafActividad;
    }

    /**
     * Set daPeso
     *
     * @param string $daPeso
     *
     * @return NutricionFormulario
     */
    public function setdaPeso($daPeso)
    {
        $this->daPeso = $daPeso;
        return $this;
    }

    /**
     * Get daPeso
     *
     * @return string
     */
    public function getdaPeso()
    {
        return $this->daPeso;
    }

    /**
     * Set daTalla
     *
     * @param string $daTalla
     *
     * @return NutricionFormulario
     */
    public function setdaTalla($daTalla)
    {
        $this->daTalla = $daTalla;
        return $this;
    }

    /**
     * Get daTalla
     *
     * @return string
     */
    public function getdaTalla()
    {
        return $this->daTalla;
    }

    /**
     * Set daANutricionales
     *
     * @param string $daANutricionales
     *
     * @return NutricionFormulario
     */
    public function setdaANutricionales($daANutricionales)
    {
        $this->daANutricionales = $daANutricionales;
        return $this;
    }

    /**
     * Get daANutricionales
     *
     * @return string
     */
    public function getdaANutricionales()
    {
        return $this->daANutricionales;
    }

    /**
     * Set daPesoAcumulado
     *
     * @param string $daPesoAcumulado
     *
     * @return NutricionFormulario
     */
    public function setdaPesoAcumulado($daPesoAcumulado)
    {
        $this->daPesoAcumulado = $daPesoAcumulado;
        return $this;
    }

    /**
     * Get daPesoAcumulado
     *
     * @return string
     */
    public function getdaPesoAcumulado()
    {
        return $this->daPesoAcumulado;
    }

    /**
     * Set daImc
     *
     * @param string $daImc
     *
     * @return NutricionFormulario
     */
    public function setdaImc($daImc)
    {
        $this->daImc = $daImc;
        return $this;
    }

    /**
     * Get daImc
     *
     * @return string
     */
    public function getdaImc()
    {
        return $this->daImc;
    }

    /**
     * Set daMusculo
     *
     * @param string $daMusculo
     *
     * @return NutricionFormulario
     */
    public function setdaMusculo($daMusculo)
    {
        $this->daMusculo = $daMusculo;
        return $this;
    }

    /**
     * Get daMusculo
     *
     * @return string
     */
    public function getdaMusculo()
    {
        return $this->daMusculo;
    }

    /**
     * Set daGUAnio
     *
     * @param string $daGUAnio
     *
     * @return NutricionFormulario
     */
    public function setdaGUAnio($daGUAnio)
    {
        $this->daGUAnio = $daGUAnio;
        return $this;
    }

    /**
     * Get daGUAnio
     *
     * @return string
     */
    public function getdaGUAnio()
    {
        return $this->daGUAnio;
    }

    /**
     * Set ihaDesayuno
     *
     * @param string $ihaDesayuno
     *
     * @return NutricionFormulario
     */
    public function setihaDesayuno($ihaDesayuno)
    {
        $this->ihaDesayuno = $ihaDesayuno;
        return $this;
    }

    /**
     * Get ihaDesayuno
     *
     * @return string
     */
    public function getihaDesayuno()
    {
        return $this->ihaDesayuno;
    }

    /**
     * Set ihaMm
     *
     * @param string $ihaMm
     *
     * @return NutricionFormulario
     */
    public function setihaMm($ihaMm)
    {
        $this->ihaMm = $ihaMm;
        return $this;
    }

    /**
     * Get ihaMm
     *
     * @return string
     */
    public function getihaMm()
    {
        return $this->ihaMm;
    }

    /**
     * Set ihaAlmuerzo
     *
     * @param string $ihaAlmuerzo
     *
     * @return NutricionFormulario
     */
    public function setihaAlmuerzo($ihaAlmuerzo)
    {
        $this->ihaAlmuerzo = $ihaAlmuerzo;
        return $this;
    }

    /**
     * Get ihaAlmuerzo
     *
     * @return string
     */
    public function getihaAlmuerzo()
    {
        return $this->ihaAlmuerzo;
    }

    /**
     * Set ihaMt
     *
     * @param string $ihaMt
     *
     * @return NutricionFormulario
     */
    public function setihaMt($ihaMt)
    {
        $this->ihaMt = $ihaMt;
        return $this;
    }

    /**
     * Get ihaMt
     *
     * @return string
     */
    public function getihaMt()
    {
        return $this->ihaMt;
    }

    /**
     * Set ihaCena
     *
     * @param string $ihaCena
     *
     * @return NutricionFormulario
     */
    public function setihaCena($ihaCena)
    {
        $this->ihaCena = $ihaCena;
        return $this;
    }

    /**
     * Get ihaCena
     *
     * @return string
     */
    public function getihaCena()
    {
        return $this->ihaCena;
    }

    /**
     * Set ihaDiagnosticoN
     *
     * @param string $ihaDiagnosticoN
     *
     * @return NutricionFormulario
     */
    public function setihaDiagnosticoN($ihaDiagnosticoN)
    {
        $this->ihaDiagnosticoN = $ihaDiagnosticoN;
        return $this;
    }

    /**
     * Get ihaDiagnosticoN
     *
     * @return string
     */
    public function getihaDiagnosticoN()
    {
        return $this->ihaDiagnosticoN;
    }

    /**
     * Set ihaRecomendacionN
     *
     * @param string $ihaRecomendacionN
     *
     * @return NutricionFormulario
     */
    public function setihaRecomendacionN($ihaRecomendacionN)
    {
        $this->ihaRecomendacionN = $ihaRecomendacionN;
        return $this;
    }

    /**
     * Get ihaRecomendacionN
     *
     * @return string
     */
    public function getihaRecomendacionN()
    {
        return $this->ihaRecomendacionN;
    }

    /**
     * Set ihaPlanN
     *
     * @param string $ihaPlanN
     *
     * @return NutricionFormulario
     */
    public function setihaPlanN($ihaPlanN)
    {
        $this->ihaPlanN = $ihaPlanN;
        return $this;
    }

    /**
     * Get ihaPlanN
     *
     * @return string
     */
    public function getihaPlanN()
    {
        return $this->ihaPlanN;
    }

    /**
     * Set nombreMedico
     *
     * @param string $nombreMedico
     *
     * @return NutricionFormulario
     */
    public function setnombreMedico($nombreMedico)
    {
        $this->nombreMedico = $nombreMedico;
        return $this;
    }

    /**
     * Get nombreMedico
     *
     * @return string
     */
    public function getnombreMedico()
    {
        return $this->nombreMedico;
    }

    /**
     * Set especialidadMedico
     *
     * @param string $especialidadMedico
     *
     * @return NutricionFormulario
     */
    public function setespecialidadMedico($especialidadMedico)
    {
        $this->especialidadMedico = $especialidadMedico;
        return $this;
    }

    /**
     * Get especialidadMedico
     *
     * @return string
     */
    public function getespecialidadMedico()
    {
        return $this->especialidadMedico;
    }

    /**
     * Set telefonoMedico
     *
     * @param string $telefonoMedico
     *
     * @return NutricionFormulario
     */
    public function settelefonoMedico($telefonoMedico)
    {
        $this->telefonoMedico = $telefonoMedico;
        return $this;
    }

    /**
     * Get telefonoMedico
     *
     * @return string
     */
    public function gettelefonoMedico()
    {
        return $this->telefonoMedico;
    }


 }
