<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ImagenVideoEspecialidad
 *
 * @ORM\Table(name="imagen_video_especialidad")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\ImagenVideoEspecialidadRepository")
 */
class ImagenVideoEspecialidad
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_img_video", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Especialidades")
     * @ORM\JoinColumn(name="id_especialidad", referencedColumnName="id_especialidad")
     */
    private $idEspecialidad;

    /**
     * @var string
     *
     * @ORM\Column(name="url_img_video", type="text")
     */
    private $urlImgVideo;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_img_video", type="string", length=5)
     */
    private $tipoImgVideo;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_img_video", type="boolean")
     */
    private $estado;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return ImagenVideoEspecialidad
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idEspecialidad
     *
     * @param integer $idEspecialidad
     *
     * @return ImagenVideoEspecialidad
     */
    public function setIdEspecialidad($idEspecialidad)
    {
        $this->idEspecialidad = $idEspecialidad;

        return $this;
    }

    /**
     * Get idEspecialidad
     *
     * @return int
     */
    public function getIdEspecialidad()
    {
        return $this->idEspecialidad;
    }

    /**
     * Set urlImgVideo
     *
     * @param string $urlImgVideo
     *
     * @return ImagenVideoEspecialidad
     */
    public function setUrlImgVideo($urlImgVideo)
    {
        $this->urlImgVideo = $urlImgVideo;

        return $this;
    }

    /**
     * Get urlImgVideo
     *
     * @return string
     */
    public function getUrlImgVideo()
    {
        return $this->urlImgVideo;
    }

    /**
     * Set tipoImgVideo
     *
     * @param string $tipoImgVideo
     *
     * @return ImagenVideoEspecialidad
     */
    public function setTipoImgVideo($tipoImgVideo)
    {
        $this->tipoImgVideo = $tipoImgVideo;

        return $this;
    }

    /**
     * Get tipoImgVideo
     *
     * @return string
     */
    public function getTipoImgVideo()
    {
        return $this->tipoImgVideo;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return ImagenVideoEspecialidad
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

