<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * HorariosLaborables
 *
 * @ORM\Table(name="horario_laborable")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\HorariosLaborablesRepository")
 */
class HorariosLaborables
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_horario_laborable", type="integer")
     * @ORM\OneToMany(targetEntity="AgendaHL", mappedBy="idHorarioLaborable")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="DiasLaborables")
     * @ORM\JoinColumn(name="id_dias_laborables", referencedColumnName="id_dias_laborables")
     */
    private $idDiasLaborables;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Agenda")
     * @ORM\JoinColumn(name="id_agenda", referencedColumnName="id_agenda")
     */
    private $idAgenda;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_inicio_horario_l", type="string", length=15)
     */
    private $horaInicio;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_fin_horario_l", type="string", length=15)
     */
    private $horaFin;

    /**
     * @var int
     *
     * @ORM\Column(name="minutos_horario_laborable", type="integer")
     */
    private $minutos;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_horario_laborable", type="boolean")
     */
    private $estado;

    /**
     * @var int
     *
     * @ORM\Column(name="orden_horario_laborable", type="integer")
     */
    private $orden;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idDiasLaborables
     *
     * @param integer $idDiasLaborables
     *
     * @return HorariosLaborables
     */
    public function setIdDiasLaborables($idDiasLaborables)
    {
        $this->idDiasLaborables = $idDiasLaborables;

        return $this;
    }

    /**
     * Get idDiasLaborables
     *
     * @return integer
     */
    public function getIdDiasLaborables()
    {
        return $this->idDiasLaborables;
    }

    /**
     * Set idAgenda
     *
     * @param integer $idAgenda
     *
     * @return AgendaHL
     */
    public function setIdAgenda($idAgenda)
    {
        $this->idAgenda = $idAgenda;

        return $this;
    }

    /**
     * Get idAgenda
     *
     * @return int
     */
    public function getIdAgenda()
    {
        return $this->idAgenda;
    }

    /**
     * Set horaInicio
     *
     * @param string $horaInicio
     *
     * @return HorariosLaborables
     */
    public function setHoraInicio($horaInicio)
    {
        $this->horaInicio = $horaInicio;

        return $this;
    }

    /**
     * Get horaInicio
     *
     * @return string
     */
    public function getHoraInicio()
    {
        return $this->horaInicio;
    }

    /**
     * Set horaFin
     *
     * @param string $horaFin
     *
     * @return HorariosLaborables
     */
    public function setHoraFin($horaFin)
    {
        $this->horaFin = $horaFin;

        return $this;
    }

    /**
     * Get horaFin
     *
     * @return string
     */
    public function getHoraFin()
    {
        return $this->horaFin;
    }

    /**
     * Set minutos
     *
     * @param integer $minutos
     *
     * @return HorariosLaborables
     */
    public function setMinutos($minutos)
    {
        $this->minutos = $minutos;

        return $this;
    }

    /**
     * Get minutos
     *
     * @return int
     */
    public function getMinutos()
    {
        return $this->minutos;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return HorariosLaborables
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set orden
     *
     * @param integer $orden
     *
     * @return HorariosLaborables
     */
    public function setOrden($orden)
    {
        $this->orden = $orden;

        return $this;
    }

    /**
     * Get orden
     *
     * @return int
     */
    public function getOrden()
    {
        return $this->orden;
    }
}

