<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * HistoriaClinica
 *
 * @ORM\Table(name="historia_clinica")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\HistoriaClinicaRepository")
 */
class HistoriaClinica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_historia_clinica", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="ResumenHistoriaClinica", mappedBy="idHistoriaClinica")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_hc", type="string", length=20)
     */
    private $numeroHc;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_creacion_hc", type="string", length=15)
     */
    private $fechaCreacion;

    /**
     * @var string
     *
     * @ORM\Column(name="pdf_historia_c", type="text", nullable=true)
     */
    private $pdfHistoria;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return HistoriaClinica
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set numeroHc
     *
     * @param string $numeroHc
     *
     * @return HistoriaClinica
     */
    public function setNumeroHc($numeroHc)
    {
        $this->numeroHc = $numeroHc;

        return $this;
    }

    /**
     * Get numeroHc
     *
     * @return string
     */
    public function getNumeroHc()
    {
        return $this->numeroHc;
    }

    /**
     * Set fechaCreacion
     *
     * @param string $fechaCreacion
     *
     * @return HistoriaClinica
     */
    public function setFechaCreacion($fechaCreacion)
    {
        $this->fechaCreacion = $fechaCreacion;

        return $this;
    }

    /**
     * Get fechaCreacion
     *
     * @return string
     */
    public function getFechaCreacion()
    {
        return $this->fechaCreacion;
    }

    /**
     * Set pdfHistoria
     *
     * @param string $pdfHistoria
     *
     * @return HistoriaClinica
     */
    public function setPdfHistoria($pdfHistoria)
    {
        $this->pdfHistoria = $pdfHistoria;

        return $this;
    }

    /**
     * Get pdfHistoria
     *
     * @return string
     */
    public function getPdfHistoria()
    {
        return $this->pdfHistoria;
    }
}

