<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FormularioSeguridad
 *
 * @ORM\Table(name="formulario_seguridad")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\FormularioSeguridadRepository")
 */
class FormularioSeguridad {
    /**
     * @var int
     *
     * @ORM\Column(name="id_form_seguridad", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico")
     */
    private $idMedico;

    /**
     * @var bool
     *
     * @ORM\Column(name="cabello", type="boolean", nullable=true)
     */
    private $cabello;

    /**
     * @var bool
     *
     * @ORM\Column(name="piel", type="boolean", nullable=true)
     */
    private $piel;

    /**
     * @var bool
     *
     * @ORM\Column(name="perfume", type="boolean", nullable=true)
     */
    private $perfume;

    /**
     * @var bool
     *
     * @ORM\Column(name="unia", type="boolean", nullable=true)
     */
    private $unia;

    /**
     * @var bool
     *
     * @ORM\Column(name="maquillaje", type="boolean", nullable=true)
     */
    private $maquillaje;

   /**
     * @var bool
     *
     * @ORM\Column(name="joya", type="boolean", nullable=true)
     */
    private $joya;

    /**
     * @var bool
     *
     * @ORM\Column(name="protesis", type="boolean", nullable=true)
     */
    private $protesis;

    /**
     * @var bool
     *
     * @ORM\Column(name="lente", type="boolean")
     */
    private $lente;

    /**
     * @var bool
     *
     * @ORM\Column(name="toalla", type="boolean", nullable=true)
     */
    private $toalla;

    /**
     * @var string
     *
     * @ORM\Column(name="observacion_seguridad", type="text", nullable=true)
     */
    private $observacion;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_emision", type="string", length=50, nullable=true)
     */
    private $fecha;

     /**
     * @var string
     *
     * @ORM\Column(name="nombre_paciente", type="string", length=100, nullable=true)
     */
    private $nombrePaciente;

    //GETTERS AND SETTERS
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return FormularioSeguridad
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;
        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return FormularioSeguridad
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;
        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    //----------------------------------------------------------------
    /**
     * Set cabello
     *
     * @param boolean $cabello
     *
     * @return FormularioSeguridad
     */
    public function setCabello($cabello)
    {
        $this->cabello = $cabello;
        return $this;
    }

    /**
     * Get cabello
     *
     * @return bool
     */
    public function getCabello()
    {
        return $this->cabello;
    }

    /**
     * Set piel
     *
     * @param boolean $piel
     *
     * @return FormularioSeguridad
     */
    public function setPiel($piel)
    {
        $this->piel = $piel;
        return $this;
    }

    /**
     * Get piel
     *
     * @return bool
     */
    public function getPiel()
    {
        return $this->piel;
    }

    /**
     * Set perfume
     *
     * @param boolean $perfume
     *
     * @return FormularioSeguridad
     */
    public function setPerfume($perfume)
    {
        $this->perfume = $perfume;
        return $this;
    }

    /**
     * Get perfume
     *
     * @return bool
     */
    public function getPerfume()
    {
        return $this->perfume;
    }

    /**
     * Set unia
     *
     * @param boolean $unia
     *
     * @return FormularioSeguridad
     */
    public function setUnia($unia)
    {
        $this->unia = $unia;
        return $this;
    }

    /**
     * Get unia
     *
     * @return bool
     */
    public function getUnia()
    {
        return $this->unia;
    }

    /**
     * Set maquillaje
     *
     * @param boolean $maquillaje
     *
     * @return FormularioSeguridad
     */
    public function setMaquillaje($maquillaje)
    {
        $this->maquillaje = $maquillaje;
        return $this;
    }

    /**
     * Get maquillaje
     *
     * @return bool
     */
    public function getMaquillaje()
    {
        return $this->maquillaje;
    }

    /**
     * Set joya
     *
     * @param boolean $joya
     *
     * @return FormularioSeguridad
     */
    public function setJoya($joya)
    {
        $this->joya = $joya;
        return $this;
    }

    /**
     * Get joya
     *
     * @return bool
     */
    public function getJoya()
    {
        return $this->joya;
    }

    /**
     * Set protesis
     *
     * @param boolean $protesis
     *
     * @return FormularioSeguridad
     */
    public function setProtesis($protesis)
    {
        $this->protesis = $protesis;
        return $this;
    }

    /**
     * Get protesis
     *
     * @return bool
     */
    public function getProtesis()
    {
        return $this->protesis;
    }

    /**
     * Set lente
     *
     * @param boolean $lente
     *
     * @return FormularioSeguridad
     */
    public function setLente($lente)
    {
        $this->lente = $lente;
        return $this;
    }

    /**
     * Get lente
     *
     * @return bool
     */
    public function getLente()
    {
        return $this->lente;
    }

    /**
     * Set toalla
     *
     * @param boolean $toalla
     *
     * @return FormularioSeguridad
     */
    public function setToalla($toalla)
    {
        $this->toalla = $toalla;
        return $this;
    }

    /**
     * Get toalla
     *
     * @return bool
     */
    public function getToalla()
    {
        return $this->toalla;
    }

    /**
     * Set observacion
     *
     * @param string $observacion
     *
     * @return FormularioSeguridad
     */
    public function setObservacion($observacion)
    {
        $this->observacion = $observacion;
        return $this;
    }

    /**
     * Get observacion
     *
     * @return string
     */
    public function getObservacion()
    {
        return $this->observacion;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return FormularioSeguridad
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;
        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }


    /**
     * Set nombrePaciente
     *
     * @param string $nombrePaciente
     *
     * @return FormularioSeguridad
     */
    public function setNombrePaciente($nombrePaciente)
    {
        $this->nombrePaciente = $nombrePaciente;
        return $this;
    }

    /**
     * Get nombrePaciente
     *
     * @return string
     */
    public function getNombrePaciente()
    {
        return $this->nombrePaciente;
    }

}
