<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FormularioPsicologia
 *
 * @ORM\Table(name="formulario_psicologia")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\FormularioPsicologiaRepository")
 */
class FormularioPsicologia {
    /**
     * @var int
     *
     * @ORM\Column(name="id_form_psicologia", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente", nullable=true)
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico", nullable=true)
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_emision", type="string", length=50, nullable=true)
     */
    private $fechaEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_paciente", type="string", length=50, nullable=true)
     */
    private $nombrePaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="edad_paciente", type="string", length=10, nullable=true)
     */
    private $edadPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="cedula_paciente", type="string", length=13, nullable=true)
     */
    private $cedulaPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="celular_paciente", type="string", length=15, nullable=true)
     */
    private $celularPaciente;

   /**
     * @var string
     *
     * @ORM\Column(name="identificacion_paciente", type="string", length=300, nullable=true)
     */
    private $identificacionPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="app_clinicos", type="string", length=300, nullable=true)
     */
    private $appClinicos;

    /**
     * @var string
     *
     * @ORM\Column(name="app_alergias", type="string", length=300, nullable=true)
     */
    private $appAlergias;

    /**
     * @var string
     *
     * @ORM\Column(name="app_quirurgicos", type="string", length=300, nullable=true)
     */
    private $appQuirurgicos;

    /**
     * @var string
     *
     * @ORM\Column(name="app_psiquiatricos", type="string", length=300, nullable=true)
     */
    private $appPsiquiatricos;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_alcohol", type="string", length=300, nullable=true)
     */
    private $haafAlcohol;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_tabaco", type="string", length=300, nullable=true)
     */
    private $haafTabaco;

    /**
     * @var string
     *
     * @ORM\Column(name="haaf_drogas", type="string", length=300, nullable=true)
     */
    private $haafDrogas;

    /**
     * @var string
     *
     * @ORM\Column(name="apf_clinicos", type="string", length=300, nullable=true)
     */
    private $apfClinicos;

    /**
     * @var string
     *
     * @ORM\Column(name="apf_psiquiatricos", type="string", length=300, nullable=true)
     */
    private $apfPsiquiatricos;

    /**
     * @var string
     *
     * @ORM\Column(name="psicobiografia", type="text", nullable=true)
     */
    private $psicobiografia;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_ninez", type="text", nullable=true)
     */
    private $bioNinez;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_adolescencia", type="text", nullable=true)
     */
    private $bioAdolescencia;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_adultez", type="text", nullable=true)
     */
    private $bioAdultez;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_etapa_escolar", type="text", nullable=true)
     */
    private $bioEtapaEscolar;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_etapa_laboral", type="text", nullable=true)
     */
    private $bioEtapaLaboral;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_etapa_sentimental", type="text", nullable=true)
     */
    private $bioEtapaSentimental;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_rasgos_personalidad", type="text", nullable=true)
     */
    private $bioRasgosPersonalidad;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_motivo_consulta", type="text", nullable=true)
     */
    private $bioMotivoConsulta;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_enfermedad_actual", type="text", nullable=true)
     */
    private $bioEnfermedadActual;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_examen_psicopatologico", type="text", nullable=true)
     */
    private $bioExamenPsicopatologico;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_test_aplicado", type="string", length=300, nullable=true)
     */
    private $bioTestAplicado;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_imprension_diagnostica", type="string", length=300, nullable=true)
     */
    private $bioImprensionDiagnostica;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_analisis", type="text", nullable=true)
     */
    private $bioAnalisis;

    /**
     * @var string
     *
     * @ORM\Column(name="bio_plan", type="string", length=300, nullable=true)
     */
    private $bioPlan;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_medico", type="string", length=300, nullable=true)
     */
    private $nombreMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="especialidad_medico", type="string", length=300, nullable=true)
     */
    private $especialidadMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_medico", type="string", length=15, nullable=true)
     */
    private $telefonoMedico;

    //GETTERS AND SETTERS
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return FormularioPsicologia
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;
        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return FormularioPsicologia
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;
        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    //----------------------------------------------------------------
    /**
     * Set fechaEmision
     *
     * @param string $fechaEmision
     *
     * @return FormularioPsicologia
     */
    public function setfechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
        return $this;
    }

    /**
     * Get fechaEmision
     *
     * @return string
     */
    public function getfechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * Set nombrePaciente
     *
     * @param string $nombrePaciente
     *
     * @return FormularioPsicologia
     */
    public function setnombrePaciente($nombrePaciente)
    {
        $this->nombrePaciente = $nombrePaciente;
        return $this;
    }

    /**
     * Get nombrePaciente
     *
     * @return string
     */
    public function getnombrePaciente()
    {
        return $this->nombrePaciente;
    }

    /**
     * Set edadPaciente
     *
     * @param string $edadPaciente
     *
     * @return FormularioPsicologia
     */
    public function setedadPaciente($edadPaciente)
    {
        $this->edadPaciente = $edadPaciente;
        return $this;
    }

    /**
     * Get edadPaciente
     *
     * @return string
     */
    public function getedadPaciente()
    {
        return $this->edadPaciente;
    }

    /**
     * Set cedulaPaciente
     *
     * @param string $cedulaPaciente
     *
     * @return FormularioPsicologia
     */
    public function setcedulaPaciente($cedulaPaciente)
    {
        $this->cedulaPaciente = $cedulaPaciente;
        return $this;
    }

    /**
     * Get cedulaPaciente
     *
     * @return string
     */
    public function getcedulaPaciente()
    {
        return $this->cedulaPaciente;
    }

    /**
     * Set celularPaciente
     *
     * @param string $celularPaciente
     *
     * @return FormularioPsicologia
     */
    public function setcelularPaciente($celularPaciente)
    {
        $this->celularPaciente = $celularPaciente;
        return $this;
    }

    /**
     * Get celularPaciente
     *
     * @return string
     */
    public function getcelularPaciente()
    {
        return $this->celularPaciente;
    }

    /**
     * Set identificacionPaciente
     *
     * @param string $identificacionPaciente
     *
     * @return FormularioPsicologia
     */
    public function setidentificacionPaciente($identificacionPaciente)
    {
        $this->identificacionPaciente = $identificacionPaciente;
        return $this;
    }

    /**
     * Get identificacionPaciente
     *
     * @return string
     */
    public function getidentificacionPaciente()
    {
        return $this->identificacionPaciente;
    }

      /**
     * Set appClinicos
     *
     * @param string $appClinicos
     *
     * @return FormularioPsicologia
     */
    public function setappClinicos($appClinicos)
    {
        $this->appClinicos = $appClinicos;
        return $this;
    }

    /**
     * Get appClinicos
     *
     * @return string
     */
    public function getappClinicos()
    {
        return $this->appClinicos;
    }

    /**
     * Set appAlergias
     *
     * @param string $appAlergias
     *
     * @return FormularioPsicologia
     */
    public function setappAlergias($appAlergias)
    {
        $this->appAlergias = $appAlergias;
        return $this;
    }

    /**
     * Get appAlergias
     *
     * @return string
     */
    public function getappAlergias()
    {
        return $this->appAlergias;
    }

    /**
     * Set appQuirurgicos
     *
     * @param string $appQuirurgicos
     *
     * @return FormularioPsicologia
     */
    public function setappQuirurgicos($appQuirurgicos)
    {
        $this->appQuirurgicos = $appQuirurgicos;
        return $this;
    }

    /**
     * Get appQuirurgicos
     *
     * @return string
     */
    public function getappQuirurgicos()
    {
        return $this->appQuirurgicos;
    }

    /**
     * Set appPsiquiatricos
     *
     * @param string $appPsiquiatricos
     *
     * @return FormularioPsicologia
     */
    public function setappPsiquiatricos($appPsiquiatricos)
    {
        $this->appPsiquiatricos = $appPsiquiatricos;
        return $this;
    }

    /**
     * Get appPsiquiatricos
     *
     * @return string
     */
    public function getappPsiquiatricos()
    {
        return $this->appPsiquiatricos;
    }

    /**
     * Set haafAlcohol
     *
     * @param string $haafAlcohol
     *
     * @return FormularioPsicologia
     */
    public function sethaafAlcohol($haafAlcohol)
    {
        $this->haafAlcohol = $haafAlcohol;
        return $this;
    }

    /**
     * Get haafAlcohol
     *
     * @return string
     */
    public function gethaafAlcohol()
    {
        return $this->haafAlcohol;
    }

    /**
     * Set haafTabaco
     *
     * @param string $haafTabaco
     *
     * @return FormularioPsicologia
     */
    public function sethaafTabaco($haafTabaco)
    {
        $this->haafTabaco = $haafTabaco;
        return $this;
    }

    /**
     * Get haafTabaco
     *
     * @return string
     */
    public function gethaafTabaco()
    {
        return $this->haafTabaco;
    }

    /**
     * Set haafDrogas
     *
     * @param string $haafDrogas
     *
     * @return FormularioPsicologia
     */
    public function sethaafDrogas($haafDrogas)
    {
        $this->haafDrogas = $haafDrogas;
        return $this;
    }

    /**
     * Get haafDrogas
     *
     * @return string
     */
    public function gethaafDrogas()
    {
        return $this->haafDrogas;
    }

    /**
     * Set apfClinicos
     *
     * @param string $apfClinicos
     *
     * @return FormularioPsicologia
     */
    public function setapfClinicos($apfClinicos)
    {
        $this->apfClinicos = $apfClinicos;
        return $this;
    }

    /**
     * Get apfClinicos
     *
     * @return string
     */
    public function getapfClinicos()
    {
        return $this->apfClinicos;
    }

    /**
     * Set apfPsiquiatricos
     *
     * @param string $apfPsiquiatricos
     *
     * @return FormularioPsicologia
     */
    public function setapfPsiquiatricos($apfPsiquiatricos)
    {
        $this->apfPsiquiatricos = $apfPsiquiatricos;
        return $this;
    }

    /**
     * Get apfPsiquiatricos
     *
     * @return string
     */
    public function getapfPsiquiatricos()
    {
        return $this->apfPsiquiatricos;
    }

    /**
     * Set psicobiografia
     *
     * @param string $psicobiografia
     *
     * @return FormularioPsicologia
     */
    public function setpsicobiografia($psicobiografia)
    {
        $this->psicobiografia = $psicobiografia;
        return $this;
    }

    /**
     * Get psicobiografia
     *
     * @return string
     */
    public function getpsicobiografia()
    {
        return $this->psicobiografia;
    }

    /**
     * Set bioNinez
     *
     * @param string $bioNinez
     *
     * @return FormularioPsicologia
     */
    public function setbioNinez($bioNinez)
    {
        $this->bioNinez = $bioNinez;
        return $this;
    }

    /**
     * Get bioNinez
     *
     * @return string
     */
    public function getbioNinez()
    {
        return $this->bioNinez;
    }

    /**
     * Set bioAdolescencia
     *
     * @param string $bioAdolescencia
     *
     * @return FormularioPsicologia
     */
    public function setbioAdolescencia($bioAdolescencia)
    {
        $this->bioAdolescencia = $bioAdolescencia;
        return $this;
    }

    /**
     * Get bioAdolescencia
     *
     * @return string
     */
    public function getbioAdolescencia()
    {
        return $this->bioAdolescencia;
    }

    /**
     * Set bioAdultez
     *
     * @param string $bioAdultez
     *
     * @return FormularioPsicologia
     */
    public function setbioAdultez($bioAdultez)
    {
        $this->bioAdultez = $bioAdultez;
        return $this;
    }

    /**
     * Get bioAdultez
     *
     * @return string
     */
    public function getbioAdultez()
    {
        return $this->bioAdultez;
    }

    /**
     * Set bioEtapaEscolar
     *
     * @param string $bioEtapaEscolar
     *
     * @return FormularioPsicologia
     */
    public function setbioEtapaEscolar($bioEtapaEscolar)
    {
        $this->bioEtapaEscolar = $bioEtapaEscolar;
        return $this;
    }

    /**
     * Get bioEtapaEscolar
     *
     * @return string
     */
    public function getbioEtapaEscolar()
    {
        return $this->bioEtapaEscolar;
    }

    /**
     * Set bioEtapaLaboral
     *
     * @param string $bioEtapaLaboral
     *
     * @return FormularioPsicologia
     */
    public function setbioEtapaLaboral($bioEtapaLaboral)
    {
        $this->bioEtapaLaboral = $bioEtapaLaboral;
        return $this;
    }

    /**
     * Get bioEtapaLaboral
     *
     * @return string
     */
    public function getbioEtapaLaboral()
    {
        return $this->bioEtapaLaboral;
    }

    /**
     * Set bioEtapaSentimental
     *
     * @param string $procedimiento
     *
     * @return FormularioPsicologia
     */
    public function setbioEtapaSentimental($bioEtapaSentimental)
    {
        $this->bioEtapaSentimental = bioEtapaSentimental;

        return $this;
    }

    /**
     * Get bioEtapaSentimental
     *
     * @return string
     */
    public function getbioEtapaSentimental()
    {
        return $this->bioEtapaSentimental;
    }

    /**
     * Set bioRasgosPersonalidad
     *
     * @param string $bioRasgosPersonalidad
     *
     * @return FormularioPsicologia
     */
    public function setbioRasgosPersonalidad($bioRasgosPersonalidad)
    {
        $this->bioRasgosPersonalidad = $bioRasgosPersonalidad;
        return $this;
    }

    /**
     * Get bioRasgosPersonalidad
     *
     * @return string
     */
    public function getbioRasgosPersonalidad()
    {
        return $this->bioRasgosPersonalidad;
    }

    /**
     * Set bioMotivoConsulta
     *
     * @param string $bioMotivoConsulta
     *
     * @return FormularioPsicologia
     */
    public function setbioMotivoConsulta($bioMotivoConsulta)
    {
        $this->bioMotivoConsulta = $bioMotivoConsulta;
        return $this;
    }

    /**
     * Get bioMotivoConsulta
     *
     * @return string
     */
    public function getbioMotivoConsulta()
    {
        return $this->bioMotivoConsulta;
    }

    /**
     * Set bioEnfermedadActual
     *
     * @param string $bioEnfermedadActual
     *
     * @return FormularioPsicologia
     */
    public function setbioEnfermedadActual($bioEnfermedadActual)
    {
        $this->bioEnfermedadActual = $bioEnfermedadActual;
        return $this;
    }

    /**
     * Get bioEnfermedadActual
     *
     * @return string
     */
    public function getbioEnfermedadActual()
    {
        return $this->bioEnfermedadActual;
    }

    /**
     * Set bioExamenPsicopatologico
     *
     * @param string $bioExamenPsicopatologico
     *
     * @return FormularioPsicologia
     */
    public function setbioExamenPsicopatologico($bioExamenPsicopatologico)
    {
        $this->bioExamenPsicopatologico = $bioExamenPsicopatologico;
        return $this;
    }

    /**
     * Get bioExamenPsicopatologico
     *
     * @return string
     */
    public function getbioExamenPsicopatologico()
    {
        return $this->bioExamenPsicopatologico;
    }

    /**
     * Set bioTestAplicado
     *
     * @param string $bioTestAplicado
     *
     * @return FormularioPsicologia
     */
    public function setbioTestAplicado($bioTestAplicado)
    {
        $this->bioTestAplicado = $bioTestAplicado;
        return $this;
    }

    /**
     * Get bioTestAplicado
     *
     * @return string
     */
    public function getbioTestAplicado()
    {
        return $this->bioTestAplicado;
    }

    /**
     * Set bioImprensionDiagnostica
     *
     * @param string $bioImprensionDiagnostica
     *
     * @return FormularioPsicologia
     */
    public function setbioImprensionDiagnostica($bioImprensionDiagnostica)
    {
        $this->bioImprensionDiagnostica = $bioImprensionDiagnostica;
        return $this;
    }

    /**
     * Get bioImprensionDiagnostica
     *
     * @return string
     */
    public function getbioImprensionDiagnostica()
    {
        return $this->bioImprensionDiagnostica;
    }

    /**
     * Set bioAnalisis
     *
     * @param string $bioAnalisis
     *
     * @return FormularioPsicologia
     */
    public function setbioAnalisis($bioAnalisis)
    {
        $this->bioAnalisis = $bioAnalisis;
        return $this;
    }

    /**
     * Get bioAnalisis
     *
     * @return string
     */
    public function getbioAnalisis()
    {
        return $this->bioAnalisis;
    }

    /**
     * Set bioPlan
     *
     * @param string $bioPlan
     *
     * @return FormularioPsicologia
     */
    public function setbioPlan($bioPlan)
    {
        $this->bioPlan = $bioPlan;
        return $this;
    }

    /**
     * Get bioPlan
     *
     * @return string
     */
    public function getbioPlan()
    {
        return $this->bioPlan;
    }

    /**
     * Set nombreMedico
     *
     * @param string $nombreMedico
     *
     * @return FormularioPsicologia
     */
    public function setnombreMedico($nombreMedico)
    {
        $this->nombreMedico = $nombreMedico;
        return $this;
    }

    /**
     * Get nombreMedico
     *
     * @return string
     */
    public function getnombreMedico()
    {
        return $this->nombreMedico;
    }

    /**
     * Set especialidadMedico
     *
     * @param string $especialidadMedico
     *
     * @return FormularioPsicologia
     */
    public function setespecialidadMedico($especialidadMedico)
    {
        $this->especialidadMedico = $especialidadMedico;
        return $this;
    }

    /**
     * Get especialidadMedico
     *
     * @return string
     */
    public function getespecialidadMedico()
    {
        return $this->especialidadMedico;
    }

    /**
     * Set telefonoMedico
     *
     * @param string $telefonoMedico
     *
     * @return FormularioPsicologia
     */
    public function settelefonoMedico($telefonoMedico)
    {
        $this->telefonoMedico = $telefonoMedico;
        return $this;
    }

    /**
     * Get telefonoMedico
     *
     * @return string
     */
    public function gettelefonoMedico()
    {
        return $this->telefonoMedico;
    }


}
