<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FormularioMesociclo
 *
 * @ORM\Table(name="formulario_mesociclo")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\FormularioMesocicloRepository")
 */
class FormularioMesociclo {
    /**
     * @var int
     *
     * @ORM\Column(name="id_form_mesociclo", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente", nullable=true)
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico", nullable=true)
     */
    private $idMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_emision", type="string", length=50, nullable=true)
     */
    private $fechaEmision;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_paciente", type="string", length=100, nullable=true)
     */
    private $nombrePaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_documento", type="string", length=100, nullable=true)
     */
    private $nombreDocumento;

    //GETTERS AND SETTERS
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return FormularioMesociclo
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;
        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return FormularioMesociclo
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;
        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    //----------------------------------------------------------------
    /**
     * Set fechaEmision
     *
     * @param string $fechaEmision
     *
     * @return FormularioMesociclo
     */
    public function setfechaEmision($fechaEmision)
    {
        $this->fechaEmision = $fechaEmision;
        return $this;
    }

    /**
     * Get fechaEmision
     *
     * @return string
     */
    public function getfechaEmision()
    {
        return $this->fechaEmision;
    }

    /**
     * Set nombrePaciente
     *
     * @param string $nombrePaciente
     *
     * @return FormularioMesociclo
     */
    public function setnombrePaciente($nombrePaciente)
    {
        $this->nombrePaciente = $nombrePaciente;
        return $this;
    }

    /**
     * Get nombrePaciente
     *
     * @return string
     */
    public function getnombrePaciente()
    {
        return $this->nombrePaciente;
    }

    /**
     * Set nombreDocumento
     *
     * @param string $nombreDocumento
     *
     * @return FormularioMesociclo
     */
    public function setNombreDocumento($nombreDocumento)
    {
        $this->nombreDocumento = $nombreDocumento;
        return $this;
    }

    /**
     * Get nombreDocumento
     *
     * @return string
     */
    public function getNombreDocumento()
    {
        return $this->nombreDocumento;
    }
}
