<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Formulario053
 *
 * @ORM\Table(name="formulario053")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\Formulario053Repository")
 */
class Formulario053
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_form053", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente", nullable=true)
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico", nullable=true)
     */
    private $idMedico;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AgendaBundle\Entity\CieDiez")
     * @ORM\JoinColumn(name="id_cie_diez", referencedColumnName="id_cie_diez", nullable=true)
     */
    private $idCieDiez;

    /**
     * @var string
     *
     * @ORM\Column(name="apellido_paterno_form053", type="string", length=25, nullable=true)
     */
    private $apellidoPaterno;
    
    /**
     * @var string
     *
     * @ORM\Column(name="apellido_materno_form053", type="string", length=25, nullable=true)
     */
    private $apellidoMaterno;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_paciente_form053", type="string", length=80, nullable=true)
     */
    private $nombres;

    /**
     * @var string
     *
     * @ORM\Column(name="dia_paciente_form053", type="string", length=10, nullable=true)
     */
    private $diaPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="mes_paciente_form053", type="string", length=10, nullable=true)
     */
    private $mesPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="anio_paciente_form053", type="string", length=10, nullable=true)
     */
    private $anioPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="edad_paciente_form053", type="string", length=10, nullable=true)
     */
    private $edadPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="genero_paciente_form053", type="string", length=20, nullable=true)
     */
    private $generoPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="nacionalidad_paciente_form053", type="string", length=25, nullable=true)
     */
    private $nacionalidadPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="pais_paciente_form053", type="string", length=25, nullable=true)
     */
    private $paisPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="cedula_paciente_form053", type="string", length=15, nullable=true)
     */
    private $cedulaPaciente;


    /**
     * @var string
     *
     * @ORM\Column(name="provincia_paciente_form053", type="string", length=50, nullable=true)
     */
    private $provinciaPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="canton_paciente_form053", type="string", length=50, nullable=true)
     */
    private $cantonPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="parroquia_paciente_form053", type="string", length=50, nullable=true)
     */
    private $parroquiaPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="direccion_paciente_form053", type="string", length=300, nullable=true)
     */
    private $direccionPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="telefono_paciente_form053", type="string", length=15, nullable=true)
     */
    private $telefonoPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_documento_form053", type="string", length=25, nullable=true)
     */
    private $tipoDocumento;

    /**
     * @var string
     *
     * @ORM\Column(name="entidad_institucion_form053", type="string", length=50, nullable=true)
     */
    private $entidadInstitucion;

     /**
     * @var string
     *
     * @ORM\Column(name="historia_institucion_form053", type="string", length=30, nullable=true)
     */
    private $historiaClinica;

     /**
     * @var string
     *
     * @ORM\Column(name="establecimiento_institucion_form053", type="string", length=80, nullable=true)
     */
    private $establecimientoInstitucion;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_institucion_form053", type="string", length=50, nullable=true)
     */
    private $tipoInstitucion;

    /**
     * @var string
     *
     * @ORM\Column(name="distrito_institucion_form053", type="string", length=50, nullable=true)
     */
    private $distritoInstitucion;

    /**
     * @var string
     *
     * @ORM\Column(name="servicio_institucion_form053", type="string", length=50, nullable=true)
     */
    private $servicioInstitucion;

    /**
     * @var string
     *
     * @ORM\Column(name="especialidad_institucion_form053", type="string", length=50, nullable=true)
     */
    private $especialidadInstitucion;

    /**
     * @var string
     *
     * @ORM\Column(name="entidad_remitente_form053", type="string", length=80, nullable=true)
     */
    private $entidadRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="establecimiento_remitente_form053", type="string", length=80, nullable=true)
     */
    private $establecimientoRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="servicio_remitente_form053", type="string", length=50, nullable=true)
     */
    private $servicioRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="especialidad_remitente_form053", type="string", length=50, nullable=true)
     */
    private $especialidadRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="dia_remitente_form053", type="string", length=10, nullable=true)
     */
    private $diaRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="mes_remitente_form053", type="string", length=10, nullable=true)
     */
    private $mesRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="anio_remitente_form053", type="string", length=10, nullable=true)
     */
    private $anioRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_remitente_form053", type="string", length=50, nullable=true)
     */
    private $tipoRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="distrito_remitente_form053", type="string", length=50, nullable=true)
     */
    private $distritoRemitente;

    /**
     * @var string
     *
     * @ORM\Column(name="motivo_ref_deri_form053", type="string", length=80, nullable=true)
     */
    private $motivoRef;

    /**
     * @var string
     *
     * @ORM\Column(name="resumen_cuadro_form053", type="text", nullable=true)
     */
    private $resumenCuadro;

    /**
     * @var string
     *
     * @ORM\Column(name="hallazgos_reldiag_form053", type="text", nullable=true)
     */
    private $hallazgosRelevantes;

    /*-----------------------------------------------------------------------------*/

    /**
     * @var string
     *
     * @ORM\Column(name="tratamientos_terareal_form053", type="text", nullable=true)
     */
    private $tratamientoProcedimiento;

    /**
     * @var string
     *
     * @ORM\Column(name="diagnostico_form053", type="string", length=300, nullable=true)
     */
    private $diagnostico;

    /**
     * @var string
     *
     * @ORM\Column(name="cie10_form053", type="string", length=300, nullable=true)
     */
    private $cie10Form053;

    /**
     * @var string
     *
     * @ORM\Column(name="pre_form053", type="string", length=80, nullable=true)
     */
    private $pre;

    /**
     * @var string
     *
     * @ORM\Column(name="def_form053", type="string", length=80, nullable=true)
     */
    private $def;

    /**
     * @var string
     *
     * @ORM\Column(name="tratamientos_estableci_form053", type="text", nullable=true)
     */
    private $tratamientoRecomendado;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_profesional",  type="string", length=80, nullable=true)
     */
    private $nombreMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="codigomsp_profesional",  type="string", length=200, nullable=true)
     */
    private $codigoMSPMedico;

    /**
     * @var string
     *
     * @ORM\Column(name="referencia_justificada_form053", type="string", length=80, nullable=true)
     */
    private $referenciaJustificada;

    /*-----------------------------MÉTODOS GET Y SET----------------------------*/
    
    /**
     * Set cie10Form053
     *
     * @param string $cie10Form053
     *
     * @return Formulario053
     */
    public function setcie10Form053($cie10Form053)
    {
        $this->cie10Form053 = $cie10Form053;
        return $this;
    }

    /**
     * Get cie10Form053
     *
     * @return string
     */
    public function getcie10Form053()
    {
        return $this->cie10Form053;
    }

    
    /**
     * Set telefonoPaciente
     *
     * @param string $telefonoPaciente
     *
     * @return Formulario053
     */
    public function settelefonoPaciente($telefonoPaciente)
    {
        $this->telefonoPaciente = $telefonoPaciente;
        return $this;
    }

    /**
     * Get telefonoPaciente
     *
     * @return string
     */
    public function gettelefonoPaciente()
    {
        return $this->telefonoPaciente;
    }


    /**
     * Set direccionPaciente
     *
     * @param string $direccionPaciente
     *
     * @return Formulario053
     */
    public function setdireccionPaciente($direccionPaciente)
    {
        $this->direccionPaciente = $direccionPaciente;
        return $this;
    }

    /**
     * Get direccionPaciente
     *
     * @return string
     */
    public function getdireccionPaciente()
    {
        return $this->direccionPaciente;
    }
    
    
    /**
     * Set cedulaPaciente
     *
     * @param string $cedulaPaciente
     *
     * @return Formulario053
     */
    public function setcedulaPaciente($cedulaPaciente)
    {
        $this->cedulaPaciente = $cedulaPaciente;
        return $this;
    }

    /**
     * Get cedulaPaciente
     *
     * @return string
     */
    public function getcedulaPaciente()
    {
        return $this->cedulaPaciente;
    }

    /**
     * Set codigoMSPMedico
     *
     * @param string $codigoMSPMedico
     *
     * @return Formulario053
     */
    public function setcodigoMSPMedico($codigoMSPMedico)
    {
        $this->codigoMSPMedico = $codigoMSPMedico;
        return $this;
    }

    /**
     * Get codigoMSPMedico
     *
     * @return string
     */
    public function getcodigoMSPMedico()
    {
        return $this->codigoMSPMedico;
    }

    /**
     * Set nombreMedico
     *
     * @param string $nombreMedico
     *
     * @return Formulario053
     */
    public function setnombreMedico($nombreMedico)
    {
        $this->nombreMedico = $nombreMedico;
        return $this;
    }

    /**
     * Get nombreMedico
     *
     * @return string
     */
    public function getnombreMedico()
    {
        return $this->nombreMedico;
    }

    /**
     * Set generoPaciente
     *
     * @param string $generoPaciente
     *
     * @return Formulario053
     */
    public function setgeneroPaciente($generoPaciente)
    {
        $this->generoPaciente = $generoPaciente;
        return $this;
    }

    /**
     * Get generoPaciente
     *
     * @return string
     */
    public function getgeneroPaciente()
    {
        return $this->generoPaciente;
    }

    /**
     * Set edadPaciente
     *
     * @param string $edadPaciente
     *
     * @return Formulario053
     */
    public function setedadPaciente($edadPaciente)
    {
        $this->edadPaciente = $edadPaciente;
        return $this;
    }

    /**
     * Get edadPaciente
     *
     * @return string
     */
    public function getedadPaciente()
    {
        return $this->edadPaciente;
    }


    /**
     * Set mesPaciente
     *
     * @param string $mesPaciente
     *
     * @return Formulario053
     */
    public function setmesPaciente($mesPaciente)
    {
        $this->mesPaciente = $mesPaciente;
        return $this;
    }

    /**
     * Get mesPaciente
     *
     * @return string
     */
    public function getmesPaciente()
    {
        return $this->mesPaciente;
    }

    /**
     * Set anioPaciente
     *
     * @param string $anioPaciente
     *
     * @return Formulario053
     */
    public function setanioPaciente($anioPaciente)
    {
        $this->anioPaciente = $anioPaciente;
        return $this;
    }

    /**
     * Get anioPaciente
     *
     * @return string
     */
    public function getanioPaciente()
    {
        return $this->anioPaciente;
    }



    /**
     * Set diaPaciente
     *
     * @param string $diaPaciente
     *
     * @return Formulario053
     */
    public function setdiaPaciente($diaPaciente)
    {
        $this->diaPaciente = $diaPaciente;
        return $this;
    }

    /**
     * Get diaPaciente
     *
     * @return string
     */
    public function getdiaPaciente()
    {
        return $this->diaPaciente;
    }

    /**
     * Set nombres
     *
     * @param string $nombres
     *
     * @return Formulario053
     */
    public function setnombres($nombres)
    {
        $this->nombres = $nombres;
        return $this;
    }

    /**
     * Get nombres
     *
     * @return string
     */
    public function getnombres()
    {
        return $this->nombres;
    }

    /**
     * Set tratamientoProcedimiento
     *
     * @param string $tratamientoProcedimiento
     *
     * @return Formulario053
     */
    public function settratamientoProcedimiento($tratamientoProcedimiento)
    {
        $this->tratamientoProcedimiento = $tratamientoProcedimiento;
        return $this;
    }

    /**
     * Get tratamientoProcedimiento
     *
     * @return string
     */
    public function gettratamientoProcedimiento()
    {
        return $this->tratamientoProcedimiento;
    }

    /**
     * Set diagnostico
     *
     * @param string $diagnostico
     *
     * @return Formulario053
     */
    public function setdiagnostico($diagnostico)
    {
        $this->diagnostico = $diagnostico;
        return $this;
    }

    /**
     * Get diagnostico
     *
     * @return string
     */
    public function getdiagnostico()
    {
        return $this->diagnostico;
    }

    /**
     * Set pre
     *
     * @param string $pre
     *
     * @return Formulario053
     */
    public function setpre($pre)
    {
        $this->pre = $pre;
        return $this;
    }

    /**
     * Get pre
     *
     * @return string
     */
    public function getpre()
    {
        return $this->pre;
    }

    /**
     * Set def
     *
     * @param string $def
     *
     * @return Formulario053
     */
    public function setdef($def)
    {
        $this->def = $def;
        return $this;
    }

    /**
     * Get def
     *
     * @return string
     */
    public function getdef()
    {
        return $this->def;
    }

    /**
     * Set tratamientoRecomendado
     *
     * @param string $tratamientoRecomendado
     *
     * @return Formulario053
     */
    public function settratamientoRecomendado($tratamientoRecomendado)
    {
        $this->tratamientoRecomendado = $tratamientoRecomendado;
        return $this;
    }

    /**
     * Get tratamientoRecomendado
     *
     * @return string
     */
    public function gettratamientoRecomendado()
    {
        return $this->tratamientoRecomendado;
    }

    /**
     * Set referenciaJustificada
     *
     * @param string $referenciaJustificada
     *
     * @return Formulario053
     */
    public function setreferenciaJustificada($referenciaJustificada)
    {
        $this->referenciaJustificada = $referenciaJustificada;
        return $this;
    }

    /**
     * Get referenciaJustificada
     *
     * @return string
     */
    public function getreferenciaJustificada()
    {
        return $this->referenciaJustificada;
    }

    /*-----------------------------------------------------------------------------*/

    /**
     * Set hallazgosRelevantes
     *
     * @param string $hallazgosRelevantes
     *
     * @return Formulario053
     */
    public function sethallazgosRelevantes($hallazgosRelevantes)
    {
        $this->hallazgosRelevantes = $hallazgosRelevantes;
        return $this;
    }

    /**
     * Get hallazgosRelevantes
     *
     * @return string
     */
    public function gethallazgosRelevantes()
    {
        return $this->hallazgosRelevantes;
    }

    /**
     * Set resumenCuadro
     *
     * @param string $resumenCuadro
     *
     * @return Formulario053
     */
    public function setresumenCuadro($resumenCuadro)
    {
        $this->resumenCuadro = $resumenCuadro;
        return $this;
    }

    /**
     * Get resumenCuadro
     *
     * @return string
     */
    public function getresumenCuadro()
    {
        return $this->resumenCuadro;
    }

    
    /**
     * Set motivoRef
     *
     * @param string $motivoRef
     *
     * @return Formulario053
     */
    public function setmotivoRef($motivoRef)
    {
        $this->motivoRef = $motivoRef;
        return $this;
    }

    /**
     * Get motivoRef
     *
     * @return string
     */
    public function getmotivoRef()
    {
        return $this->motivoRef;
    }

    /**
     * Set distritoRemitente
     *
     * @param string $distritoRemitente
     *
     * @return Formulario053
     */
    public function setdistritoRemitente($distritoRemitente)
    {
        $this->distritoRemitente = $distritoRemitente;
        return $this;
    }

    /**
     * Get distritoRemitente
     *
     * @return string
     */
    public function getdistritoRemitente()
    {
        return $this->distritoRemitente;
    }

    /**
     * Set tipoRemitente
     *
     * @param string $tipoRemitente
     *
     * @return Formulario053
     */
    public function settipoRemitente($tipoRemitente)
    {
        $this->tipoRemitente = $tipoRemitente;
        return $this;
    }

    /**
     * Get tipoRemitente
     *
     * @return string
     */
    public function gettipoRemitente()
    {
        return $this->tipoRemitente;
    }

     /**
     * Set anioRemitente
     *
     * @param string $anioRemitente
     *
     * @return Formulario053
     */
    public function setanioRemitente($anioRemitente)
    {
        $this->anioRemitente = $anioRemitente;
        return $this;
    }

    /**
     * Get anioRemitente
     *
     * @return string
     */
    public function getanioRemitente()
    {
        return $this->anioRemitente;
    }

     /**
     * Set mesRemitente
     *
     * @param string $mesRemitente
     *
     * @return Formulario053
     */
    public function setmesRemitente($mesRemitente)
    {
        $this->mesRemitente = $mesRemitente;
        return $this;
    }

    /**
     * Get mesRemitente
     *
     * @return string
     */
    public function getmesRemitente()
    {
        return $this->mesRemitente;
    }

    /**
     * Set diaRemitente
     *
     * @param string $diaRemitente
     *
     * @return Formulario053
     */
    public function setdiaRemitente($diaRemitente)
    {
        $this->diaRemitente = $diaRemitente;
        return $this;
    }

    /**
     * Get diaRemitente
     *
     * @return string
     */
    public function getdiaRemitente()
    {
        return $this->diaRemitente;
    }

    /**
     * Set especialidadRemitente
     *
     * @param string $especialidadRemitente
     *
     * @return Formulario053
     */
    public function setespecialidadRemitente($especialidadRemitente)
    {
        $this->especialidadRemitente = $especialidadRemitente;
        return $this;
    }

    /**
     * Get especialidadRemitente
     *
     * @return string
     */
    public function getespecialidadRemitente()
    {
        return $this->especialidadRemitente;
    }

    /**
     * Set servicioRemitente
     *
     * @param string $servicioRemitente
     *
     * @return Formulario053
     */
    public function setservicioRemitente($servicioRemitente)
    {
        $this->servicioRemitente = $servicioRemitente;
        return $this;
    }

    /**
     * Get servicioRemitente
     *
     * @return string
     */
    public function getservicioRemitente()
    {
        return $this->servicioRemitente;
    }

    /**
     * Set establecimientoRemitente
     *
     * @param string $establecimientoRemitente
     *
     * @return Formulario053
     */
    public function setestablecimientoRemitente($establecimientoRemitente)
    {
        $this->establecimientoRemitente = $establecimientoRemitente;
        return $this;
    }

    /**
     * Get establecimientoRemitente
     *
     * @return string
     */
    public function getestablecimientoRemitente()
    {
        return $this->establecimientoRemitente;
    }

    /**
     * Set entidadRemitente
     *
     * @param string $entidadRemitente
     *
     * @return Formulario053
     */
    public function setentidadRemitente($entidadRemitente)
    {
        $this->entidadRemitente = $entidadRemitente;
        return $this;
    }

    /**
     * Get entidadRemitente
     *
     * @return string
     */
    public function getentidadRemitente()
    {
        return $this->entidadRemitente;
    }

    /**
     * Set especialidadInstitucion
     *
     * @param string $especialidadInstitucion
     *
     * @return Formulario053
     */
    public function setespecialidadInstitucion($especialidadInstitucion)
    {
        $this->especialidadInstitucion = $especialidadInstitucion;
        return $this;
    }

    /**
     * Get especialidadInstitucion
     *
     * @return string
     */
    public function getespecialidadInstitucion()
    {
        return $this->especialidadInstitucion;
    }

    /**
     * Set servicioInstitucion
     *
     * @param string $servicioInstitucion
     *
     * @return Formulario053
     */
    public function setservicioInstitucion($servicioInstitucion)
    {
        $this->servicioInstitucion = $servicioInstitucion;
        return $this;
    }

    /**
     * Get servicioInstitucion
     *
     * @return string
     */
    public function getservicioInstitucion()
    {
        return $this->servicioInstitucion;
    }

    /**
     * Set distritoInstitucion
     *
     * @param string $distritoInstitucion
     *
     * @return Formulario053
     */
    public function setdistritoInstitucion($distritoInstitucion)
    {
        $this->distritoInstitucion = $distritoInstitucion;
        return $this;
    }

    /**
     * Get distritoInstitucion
     *
     * @return string
     */
    public function getdistritoInstitucion()
    {
        return $this->distritoInstitucion;
    }
    
    /**
     * Set tipoInstitucion
     *
     * @param string $tipoInstitucion
     *
     * @return Formulario053
     */
    public function settipoInstitucion($tipoInstitucion)
    {
        $this->tipoInstitucion = $tipoInstitucion;
        return $this;
    }

    /**
     * Get tipoInstitucion
     *
     * @return string
     */
    public function gettipoInstitucion()
    {
        return $this->tipoInstitucion;
    }

    /**
     * Set establecimientoInstitucion
     *
     * @param string $establecimientoInstitucion
     *
     * @return Formulario053
     */
    public function setestablecimientoInstitucion($establecimientoInstitucion)
    {
        $this->establecimientoInstitucion = $establecimientoInstitucion;
        return $this;
    }

    /**
     * Get establecimientoInstitucion
     *
     * @return string
     */
    public function getestablecimientoInstitucion()
    {
        return $this->establecimientoInstitucion;
    }

    /**
     * Set historiaClinica
     *
     * @param string $historiaClinica
     *
     * @return Formulario053
     */
    public function sethistoriaClinica($historiaClinica)
    {
        $this->historiaClinica = $historiaClinica;
        return $this;
    }

    /**
     * Get historiaClinica
     *
     * @return string
     */
    public function gethistoriaClinica()
    {
        return $this->historiaClinica;
    }

    /**
     * Set entidadInstitucion
     *
     * @param string $entidadInstitucion
     *
     * @return Formulario053
     */
    public function setentidadInstitucion($entidadInstitucion)
    {
        $this->entidadInstitucion = $entidadInstitucion;
        return $this;
    }

    /**
     * Get entidadInstitucion
     *
     * @return string
     */
    public function getentidadInstitucion()
    {
        return $this->entidadInstitucion;
    }

    /**
     * Set tipoDocumento
     *
     * @param string $tipoDocumento
     *
     * @return Formulario053
     */
    public function settipoDocumento($tipoDocumento)
    {
        $this->tipoDocumento = $tipoDocumento;
        return $this;
    }

    /**
     * Get tipoDocumento
     *
     * @return string
     */
    public function gettipoDocumento()
    {
        return $this->tipoDocumento;
    }

    /**
     * Set parroquiaPaciente
     *
     * @param string $parroquiaPaciente
     *
     * @return Formulario053
     */
    public function setparroquiaPaciente($parroquiaPaciente)
    {
        $this->parroquiaPaciente = $parroquiaPaciente;
        return $this;
    }

    /**
     * Get parroquiaPaciente
     *
     * @return string
     */
    public function getparroquiaPaciente()
    {
        return $this->parroquiaPaciente;
    }

    /**
     * Set cantonPaciente
     *
     * @param string $cantonPaciente
     *
     * @return Formulario053
     */
    public function setcantonPaciente($cantonPaciente)
    {
        $this->cantonPaciente = $cantonPaciente;
        return $this;
    }

    /**
     * Get cantonPaciente
     *
     * @return string
     */
    public function getcantonPaciente()
    {
        return $this->cantonPaciente;
    }

    /**
     * Set provinciaPaciente
     *
     * @param string $provinciaPaciente
     *
     * @return Formulario053
     */
    public function setprovinciaPaciente($provinciaPaciente)
    {
        $this->provinciaPaciente = $provinciaPaciente;
        return $this;
    }

    /**
     * Get provinciaPaciente
     *
     * @return string
     */
    public function getprovinciaPaciente()
    {
        return $this->provinciaPaciente;
    }

    /**
     * Set paisPaciente
     *
     * @param string $paisPaciente
     *
     * @return Formulario053
     */
    public function setpaisPaciente($paisPaciente)
    {
        $this->paisPaciente = $paisPaciente;
        return $this;
    }

    /**
     * Get paisPaciente
     *
     * @return string
     */
    public function getpaisPaciente()
    {
        return $this->paisPaciente;
    }

    /**
     * Set nacionalidadPaciente
     *
     * @param string $nacionalidadPaciente
     *
     * @return Formulario053
     */
    public function setnacionalidadPaciente($nacionalidadPaciente)
    {
        $this->nacionalidadPaciente = $nacionalidadPaciente;
        return $this;
    }

    /**
     * Get nacionalidadPaciente
     *
     * @return string
     */
    public function getnacionalidadPaciente()
    {
        return $this->nacionalidadPaciente;
    }

    /**
     * Set apellidoMaterno
     *
     * @param string $apellidoMaterno
     *
     * @return Formulario053
     */
    public function setapellidoMaterno($apellidoMaterno)
    {
        $this->apellidoMaterno = $apellidoMaterno;
        return $this;
    }

    /**
     * Get apellidoMaterno
     *
     * @return string
     */
    public function getapellidoMaterno()
    {
        return $this->apellidoMaterno;
    }

    /**
     * Set apellidoPaterno
     *
     * @param string $apellidoPaterno
     *
     * @return Formulario053
     */
    public function setapellidoPaterno($apellidoPaterno)
    {
        $this->apellidoPaterno = $apellidoPaterno;
        return $this;
    }

    /**
     * Get apellidoPaterno
     *
     * @return string
     */
    public function getapellidoPaterno()
    {
        return $this->apellidoPaterno;
    }


/*SON LOS PRIMEROS QUE VAN BIEN*/ 
    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return Formulario053
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;
        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return Formulario053
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;
        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set idCieDiez
     *
     * @param integer $idCieDiez
     *
     * @return Formulario053
     */
    public function setIdCieDiez($idCieDiez)
    {
        $this->idCieDiez = $idCieDiez;

        return $this;
    }

    /**
     * Get idCieDiez
     *
     * @return int
     */
    public function getIdCieDiez()
    {
        return $this->idCieDiez;
    }
    

}

