<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Formulario024
 *
 * @ORM\Table(name="formulario024")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\Formulario024Repository")
 */
class Formulario024
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_form024", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente", nullable=true)
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Medico")
     * @ORM\JoinColumn(name="id_medico", referencedColumnName="id_medico", nullable=true)
     */
    private $idMedico;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AgendaBundle\Entity\CieDiez")
     * @ORM\JoinColumn(name="id_cie_diez", referencedColumnName="id_cie_diez", nullable=true)
     */
    private $idCieDiez;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_form024", type="string", length=20, nullable=true)
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_form024", type="string", length=10, nullable=true)
     */
    private $hora;

    /**
     * @var string
     *
     * @ORM\Column(name="procedimiento_form024", type="text", nullable=true)
     */
    private $procedimiento;

    /**
     * @var string
     *
     * @ORM\Column(name="detalle_proc_form024", type="text", nullable=true)
     */
    private $detalleProc;

    /**
     * @var string
     *
     * @ORM\Column(name="realizacion_proc_form024", type="text", nullable=true)
     */
    private $realizacionProc;

    /**
     * @var string
     *
     * @ORM\Column(name="grafico_proc_form024", type="text", nullable=true)
     */
    private $graficoProc;

    /**
     * @var string
     *
     * @ORM\Column(name="duracion_proc_form024", type="text", nullable=true)
     */
    private $duracionProc;

    /**
     * @var string
     *
     * @ORM\Column(name="beneficios_proc_form024", type="text", nullable=true)
     */
    private $beneficiosProc;

    /**
     * @var string
     *
     * @ORM\Column(name="riesgos_leves_form024", type="text", nullable=true)
     */
    private $riesgosLeves;

    /**
     * @var string
     *
     * @ORM\Column(name="riesgos_graves_form024", type="text", nullable=true)
     */
    private $riesgosGraves;

    /**
     * @var string
     *
     * @ORM\Column(name="otros_riesgos_form_024", type="text", nullable=true)
     */
    private $otrosRiesgos;

    /**
     * @var string
     *
     * @ORM\Column(name="alternativas_proc_form024", type="text", nullable=true)
     */
    private $alternativasProc;

    /**
     * @var string
     *
     * @ORM\Column(name="despues_proc_form024", type="text", nullable=true)
     */
    private $despuesProc;

    /**
     * @var string
     *
     * @ORM\Column(name="consec_noproc_form024", type="text", nullable=true)
     */
    private $consecNoproc;

    /**
     * @var bool
     *
     * @ORM\Column(name="acepta_form024", type="boolean", nullable=true)
     */
    private $acepta;

    /**
     * @var bool
     *
     * @ORM\Column(name="revocatoria_proc", type="boolean", nullable=true)
     */
    private $revocatoria;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_testigo_form024", type="string", length=255, nullable=true)
     */
    private $nombreTestigo;

    /**
     * @var string
     *
     * @ORM\Column(name="cedula_testigo_form024", type="string", length=20, nullable=true)
     */
    private $cedulaTestigo;

    /**
     * @var string
     *
     * @ORM\Column(name="atencion_form024", type="string", length=255, nullable=true)
     */
    private $atencion;

    /**
     * @var string
     *
     * @ORM\Column(name="servicio_form024", type="string", length=255, nullable=true)
     */
    private $servicio;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_form_form024", type="boolean", nullable=true)
     */
    private $estadoForm;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_nombre_a_form024", type="string", length=255, nullable=true)
     */
    private $rpNombreA;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_cedula_a_form024", type="string", length=20, nullable=true)
     */
    private $rpCedulaA;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_parentesco_a_form024", type="string", length=255, nullable=true)
     */
    private $rpParentescoA;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_nombre_n_form024", type="string", length=255, nullable=true)
     */
    private $rpNombreN;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_cedula_n_form024", type="string", length=20, nullable=true)
     */
    private $rpCedulaN;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_parentesco_n_form024", type="string", length=255, nullable=true)
     */
    private $rpParentescoN;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_nombre_r_form024", type="string", length=255, nullable=true)
     */
    private $rpNombreR;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_cedula_r_form024", type="string", length=20, nullable=true)
     */
    private $rpCedulaR;

    /**
     * @var string
     *
     * @ORM\Column(name="rl_parentesco_r_form024", type="string", length=255, nullable=true)
     */
    private $rpParentescoR;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_r_form024", type="string", length=20, nullable=true)
     */
    private $fechaR;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_r_form024", type="string", length=10, nullable=true)
     */
    private $horaR;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return Formulario024
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idMedico
     *
     * @param integer $idMedico
     *
     * @return Formulario024
     */
    public function setIdMedico($idMedico)
    {
        $this->idMedico = $idMedico;

        return $this;
    }

    /**
     * Get idMedico
     *
     * @return int
     */
    public function getIdMedico()
    {
        return $this->idMedico;
    }

    /**
     * Set idCieDiez
     *
     * @param integer $idCieDiez
     *
     * @return Formulario024
     */
    public function setIdCieDiez($idCieDiez)
    {
        $this->idCieDiez = $idCieDiez;

        return $this;
    }

    /**
     * Get idCieDiez
     *
     * @return int
     */
    public function getIdCieDiez()
    {
        return $this->idCieDiez;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return Formulario024
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set hora
     *
     * @param string $hora
     *
     * @return Formulario024
     */
    public function setHora($hora)
    {
        $this->hora = $hora;

        return $this;
    }

    /**
     * Get hora
     *
     * @return string
     */
    public function getHora()
    {
        return $this->hora;
    }

    /**
     * Set procedimiento
     *
     * @param string $procedimiento
     *
     * @return Formulario024
     */
    public function setProcedimiento($procedimiento)
    {
        $this->procedimiento = $procedimiento;

        return $this;
    }

    /**
     * Get procedimiento
     *
     * @return string
     */
    public function getProcedimiento()
    {
        return $this->procedimiento;
    }

    /**
     * Set detalleProc
     *
     * @param string $detalleProc
     *
     * @return Formulario024
     */
    public function setDetalleProc($detalleProc)
    {
        $this->detalleProc = $detalleProc;

        return $this;
    }

    /**
     * Get detalleProc
     *
     * @return string
     */
    public function getDetalleProc()
    {
        return $this->detalleProc;
    }

    /**
     * Set realizacionProc
     *
     * @param string $realizacionProc
     *
     * @return Formulario024
     */
    public function setRealizacionProc($realizacionProc)
    {
        $this->realizacionProc = $realizacionProc;

        return $this;
    }

    /**
     * Get realizacionProc
     *
     * @return string
     */
    public function getRealizacionProc()
    {
        return $this->realizacionProc;
    }

    /**
     * Set graficoProc
     *
     * @param string $graficoProc
     *
     * @return Formulario024
     */
    public function setGraficoProc($graficoProc)
    {
        $this->graficoProc = $graficoProc;

        return $this;
    }

    /**
     * Get graficoProc
     *
     * @return string
     */
    public function getGraficoProc()
    {
        return $this->graficoProc;
    }

    /**
     * Set duracionProc
     *
     * @param string $duracionProc
     *
     * @return Formulario024
     */
    public function setDuracionProc($duracionProc)
    {
        $this->duracionProc = $duracionProc;

        return $this;
    }

    /**
     * Get duracionProc
     *
     * @return string
     */
    public function getDuracionProc()
    {
        return $this->duracionProc;
    }

    /**
     * Set beneficiosProc
     *
     * @param string $beneficiosProc
     *
     * @return Formulario024
     */
    public function setBeneficiosProc($beneficiosProc)
    {
        $this->beneficiosProc = $beneficiosProc;

        return $this;
    }

    /**
     * Get beneficiosProc
     *
     * @return string
     */
    public function getBeneficiosProc()
    {
        return $this->beneficiosProc;
    }

    /**
     * Set riesgosLeves
     *
     * @param string $riesgosLeves
     *
     * @return Formulario024
     */
    public function setRiesgosLeves($riesgosLeves)
    {
        $this->riesgosLeves = $riesgosLeves;

        return $this;
    }

    /**
     * Get riesgosLeves
     *
     * @return string
     */
    public function getRiesgosLeves()
    {
        return $this->riesgosLeves;
    }

    /**
     * Set riesgosGraves
     *
     * @param string $riesgosGraves
     *
     * @return Formulario024
     */
    public function setRiesgosGraves($riesgosGraves)
    {
        $this->riesgosGraves = $riesgosGraves;

        return $this;
    }

    /**
     * Get riesgosGraves
     *
     * @return string
     */
    public function getRiesgosGraves()
    {
        return $this->riesgosGraves;
    }

    /**
     * Set otrosRiesgos
     *
     * @param string $otrosRiesgos
     *
     * @return Formulario024
     */
    public function setOtrosRiesgos($otrosRiesgos)
    {
        $this->otrosRiesgos = $otrosRiesgos;

        return $this;
    }

    /**
     * Get otrosRiesgos
     *
     * @return string
     */
    public function getOtrosRiesgos()
    {
        return $this->otrosRiesgos;
    }

    /**
     * Set alternativasProc
     *
     * @param string $alternativasProc
     *
     * @return Formulario024
     */
    public function setAlternativasProc($alternativasProc)
    {
        $this->alternativasProc = $alternativasProc;

        return $this;
    }

    /**
     * Get alternativasProc
     *
     * @return string
     */
    public function getAlternativasProc()
    {
        return $this->alternativasProc;
    }

    /**
     * Set despuesProc
     *
     * @param string $despuesProc
     *
     * @return Formulario024
     */
    public function setDespuesProc($despuesProc)
    {
        $this->despuesProc = $despuesProc;

        return $this;
    }

    /**
     * Get despuesProc
     *
     * @return string
     */
    public function getDespuesProc()
    {
        return $this->despuesProc;
    }

    /**
     * Set consecNoproc
     *
     * @param string $consecNoproc
     *
     * @return Formulario024
     */
    public function setConsecNoproc($consecNoproc)
    {
        $this->consecNoproc = $consecNoproc;

        return $this;
    }

    /**
     * Get consecNoproc
     *
     * @return string
     */
    public function getConsecNoproc()
    {
        return $this->consecNoproc;
    }

    /**
     * Set acepta
     *
     * @param boolean $acepta
     *
     * @return Formulario024
     */
    public function setAcepta($acepta)
    {
        $this->acepta = $acepta;

        return $this;
    }

    /**
     * Get acepta
     *
     * @return bool
     */
    public function getAcepta()
    {
        return $this->acepta;
    }

    /**
     * Set revocatoria
     *
     * @param boolean $revocatoria
     *
     * @return Formulario024
     */
    public function setRevocatoria($revocatoria)
    {
        $this->revocatoria = $revocatoria;

        return $this;
    }

    /**
     * Get revocatoria
     *
     * @return bool
     */
    public function getRevocatoria()
    {
        return $this->revocatoria;
    }

    /**
     * Set nombreTestigo
     *
     * @param string $nombreTestigo
     *
     * @return Formulario024
     */
    public function setNombreTestigo($nombreTestigo)
    {
        $this->nombreTestigo = $nombreTestigo;

        return $this;
    }

    /**
     * Get nombreTestigo
     *
     * @return string
     */
    public function getNombreTestigo()
    {
        return $this->nombreTestigo;
    }

    /**
     * Set cedulaTestigo
     *
     * @param string $cedulaTestigo
     *
     * @return Formulario024
     */
    public function setCedulaTestigo($cedulaTestigo)
    {
        $this->cedulaTestigo = $cedulaTestigo;

        return $this;
    }

    /**
     * Get cedulaTestigo
     *
     * @return string
     */
    public function getCedulaTestigo()
    {
        return $this->cedulaTestigo;
    }

    /**
     * Set atencion
     *
     * @param string $atencion
     *
     * @return Formulario024
     */
    public function setAtencion($atencion)
    {
        $this->atencion = $atencion;

        return $this;
    }

    /**
     * Get atencion
     *
     * @return string
     */
    public function getAtencion()
    {
        return $this->atencion;
    }

    /**
     * Set servicio
     *
     * @param string $servicio
     *
     * @return Formulario024
     */
    public function setServicio($servicio)
    {
        $this->servicio = $servicio;

        return $this;
    }

    /**
     * Get servicio
     *
     * @return string
     */
    public function getServicio()
    {
        return $this->servicio;
    }

    /**
     * Set estadoForm
     *
     * @param boolean $estadoForm
     *
     * @return Formulario024
     */
    public function setEstadoForm($estadoForm)
    {
        $this->estadoForm = $estadoForm;

        return $this;
    }

    /**
     * Get estadoForm
     *
     * @return bool
     */
    public function getEstadoForm()
    {
        return $this->estadoForm;
    }

    /**
     * Set rpNombreA
     *
     * @param string $rpNombreA
     *
     * @return Formulario024
     */
    public function setRpNombreA($rpNombreA)
    {
        $this->rpNombreA = $rpNombreA;

        return $this;
    }

    /**
     * Get rpNombreA
     *
     * @return string
     */
    public function getRpNombreA()
    {
        return $this->rpNombreA;
    }

    /**
     * Set rpCedulaA
     *
     * @param string $rpCedulaA
     *
     * @return Formulario024
     */
    public function setRpCedulaA($rpCedulaA)
    {
        $this->rpCedulaA = $rpCedulaA;

        return $this;
    }

    /**
     * Get rpCedulaA
     *
     * @return string
     */
    public function getRpCedulaA()
    {
        return $this->rpCedulaA;
    }

    /**
     * Set rpParentescoA
     *
     * @param string $rpParentescoA
     *
     * @return Formulario024
     */
    public function setRpParentescoA($rpParentescoA)
    {
        $this->rpParentescoA = $rpParentescoA;

        return $this;
    }

    /**
     * Get rpParentescoA
     *
     * @return string
     */
    public function getRpParentescoA()
    {
        return $this->rpParentescoA;
    }

    /**
     * Set rpNombreN
     *
     * @param string $rpNombreN
     *
     * @return Formulario024
     */
    public function setRpNombreN($rpNombreN)
    {
        $this->rpNombreN = $rpNombreN;

        return $this;
    }

    /**
     * Get rpNombreN
     *
     * @return string
     */
    public function getRpNombreN()
    {
        return $this->rpNombreN;
    }

    /**
     * Set rpCedulaN
     *
     * @param string $rpCedulaN
     *
     * @return Formulario024
     */
    public function setRpCedulaN($rpCedulaN)
    {
        $this->rpCedulaN = $rpCedulaN;

        return $this;
    }

    /**
     * Get rpCedulaN
     *
     * @return string
     */
    public function getRpCedulaN()
    {
        return $this->rpCedulaN;
    }

    /**
     * Set rpParentescoN
     *
     * @param string $rpParentescoN
     *
     * @return Formulario024
     */
    public function setRpParentescoN($rpParentescoN)
    {
        $this->rpParentescoN = $rpParentescoN;

        return $this;
    }

    /**
     * Get rpParentescoN
     *
     * @return string
     */
    public function getRpParentescoN()
    {
        return $this->rpParentescoN;
    }

    /**
     * Set rpNombreR
     *
     * @param string $rpNombreR
     *
     * @return Formulario024
     */
    public function setRpNombreR($rpNombreR)
    {
        $this->rpNombreR = $rpNombreR;

        return $this;
    }

    /**
     * Get rpNombreR
     *
     * @return string
     */
    public function getRpNombreR()
    {
        return $this->rpNombreR;
    }

    /**
     * Set rpCedulaR
     *
     * @param string $rpCedulaR
     *
     * @return Formulario024
     */
    public function setRpCedulaR($rpCedulaR)
    {
        $this->rpCedulaR = $rpCedulaR;

        return $this;
    }

    /**
     * Get rpCedulaR
     *
     * @return string
     */
    public function getRpCedulaR()
    {
        return $this->rpCedulaR;
    }

    /**
     * Set rpParentescoR
     *
     * @param string $rpParentescoR
     *
     * @return Formulario024
     */
    public function setRpParentescoR($rpParentescoR)
    {
        $this->rpParentescoR = $rpParentescoR;

        return $this;
    }

    /**
     * Get rpParentescoR
     *
     * @return string
     */
    public function getRpParentescoR()
    {
        return $this->rpParentescoR;
    }

    /**
     * Set fechaR
     *
     * @param string $fechaR
     *
     * @return Formulario024
     */
    public function setFechaR($fechaR)
    {
        $this->fechaR = $fechaR;

        return $this;
    }

    /**
     * Get fechaR
     *
     * @return string
     */
    public function getFechaR()
    {
        return $this->fechaR;
    }

    /**
     * Set horaR
     *
     * @param string $horaR
     *
     * @return Formulario024
     */
    public function setHoraR($horaR)
    {
        $this->horaR = $horaR;

        return $this;
    }

    /**
     * Get horaR
     *
     * @return string
     */
    public function getHoraR()
    {
        return $this->horaR;
    }
}

