<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EvolucionSignosVitales
 *
 * @ORM\Table(name="evolucion_signos_vitales")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\EvolucionSignosVitalesRepository")
 */
class EvolucionSignosVitales
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_evo_sigvit", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="EvolucionMedica")
     * @ORM\JoinColumn(name="id_evolucion", referencedColumnName="id_evolucion")
     */
    private $idEvolucion;

    /**
     * @var string
     *
     * @ORM\Column(name="presion_asistolica_sv", type="string", length=20, nullable=true)
     */
    private $presionAsistolicaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="presion_diastolica_sv", type="string", length=20, nullable=true)
     */
    private $presionDiastolicaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="frecuencia_cardia_sv", type="string", length=20, nullable=true)
     */
    private $frecuenciaCardiaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="frecuencia_respira_sv", type="string", length=20, nullable=true)
     */
    private $frecuenciaRespiraSv;

    /**
     * @var string
     *
     * @ORM\Column(name="temperatura_bucal_sv", type="string", length=20, nullable=true)
     */
    private $temperaturaBucalSv;

    /**
     * @var string
     *
     * @ORM\Column(name="temperatura_axilar_sv", type="string", length=20, nullable=true)
     */
    private $temperaturaAxilarSv;

    /**
     * @var string
     *
     * @ORM\Column(name="peso_sv", type="string", length=20, nullable=true)
     */
    private $pesoSv;

    /**
     * @var string
     *
     * @ORM\Column(name="conversion_sv", type="string", length=20, nullable=true)
     */
    private $conversionSv;

    /**
     * @var string
     *
     * @ORM\Column(name="talla_sv", type="string", length=20, nullable=true)
     */
    private $tallaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="indice_masa_corp_sv", type="string", length=20, nullable=true)
     */
    private $indiceMasaCorpSv;

    /**
     * @var string
     *
     * @ORM\Column(name="perimetro_cefilico_sv", type="string", length=20)
     */
    private $perimetroCefilicoSv;

    /**
     * @var string
     *
     * @ORM\Column(name="saturacion_oxigeno_sv", type="string", length=20, nullable=true)
     */
    private $saturacionOxigenoSv;

    /**
     * @var string
     *
     * @ORM\Column(name="perimetro_abdomina_sv", type="string", length=20, nullable=true)
     */
    private $perimetroAbdominalSv;

    /**
     * @var string
     *
     * @ORM\Column(name="temperatura_alt_sv", type="string", length=20, nullable=true)
     */
    private $temperaturaAltSv;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_sangre_sv", type="string", length=20, nullable=true)
     */
    private $tipoSangreSv;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idEvolucion
     *
     * @param integer $idEvolucion
     *
     * @return EvolucionSignosVitales
     */
    public function setIdEvolucion($idEvolucion)
    {
        $this->idEvolucion = $idEvolucion;

        return $this;
    }

    /**
     * Get idEvolucion
     *
     * @return int
     */
    public function getIdEvolucion()
    {
        return $this->idEvolucion;
    }

    /**
     * Set presionAsistolicaSv
     *
     * @param string $presionAsistolicaSv
     *
     * @return EvolucionSignosVitales
     */
    public function setPresionAsistolicaSv($presionAsistolicaSv)
    {
        $this->presionAsistolicaSv = $presionAsistolicaSv;

        return $this;
    }

    /**
     * Get presionAsistolicaSv
     *
     * @return string
     */
    public function getPresionAsistolicaSv()
    {
        return $this->presionAsistolicaSv;
    }

    /**
     * Set presionDiastolicaSv
     *
     * @param string $presionDiastolicaSv
     *
     * @return EvolucionSignosVitales
     */
    public function setPresionDiastolicaSv($presionDiastolicaSv)
    {
        $this->presionDiastolicaSv = $presionDiastolicaSv;

        return $this;
    }

    /**
     * Get presionDiastolicaSv
     *
     * @return string
     */
    public function getPresionDiastolicaSv()
    {
        return $this->presionDiastolicaSv;
    }

    /**
     * Set frecuenciaCardiaSv
     *
     * @param string $frecuenciaCardiaSv
     *
     * @return EvolucionSignosVitales
     */
    public function setFrecuenciaCardiaSv($frecuenciaCardiaSv)
    {
        $this->frecuenciaCardiaSv = $frecuenciaCardiaSv;

        return $this;
    }

    /**
     * Get frecuenciaCardiaSv
     *
     * @return string
     */
    public function getFrecuenciaCardiaSv()
    {
        return $this->frecuenciaCardiaSv;
    }

    /**
     * Set frecuenciaRespiraSv
     *
     * @param string $frecuenciaRespiraSv
     *
     * @return EvolucionSignosVitales
     */
    public function setFrecuenciaRespiraSv($frecuenciaRespiraSv)
    {
        $this->frecuenciaRespiraSv = $frecuenciaRespiraSv;

        return $this;
    }

    /**
     * Get frecuenciaRespiraSv
     *
     * @return string
     */
    public function getFrecuenciaRespiraSv()
    {
        return $this->frecuenciaRespiraSv;
    }

    /**
     * Set temperaturaBucalSv
     *
     * @param string $temperaturaBucalSv
     *
     * @return EvolucionSignosVitales
     */
    public function setTemperaturaBucalSv($temperaturaBucalSv)
    {
        $this->temperaturaBucalSv = $temperaturaBucalSv;

        return $this;
    }

    /**
     * Get temperaturaBucalSv
     *
     * @return string
     */
    public function getTemperaturaBucalSv()
    {
        return $this->temperaturaBucalSv;
    }

    /**
     * Set temperaturaAxilarSv
     *
     * @param string $temperaturaAxilarSv
     *
     * @return EvolucionSignosVitales
     */
    public function setTemperaturaAxilarSv($temperaturaAxilarSv)
    {
        $this->temperaturaAxilarSv = $temperaturaAxilarSv;

        return $this;
    }

    /**
     * Get temperaturaAxilarSv
     *
     * @return string
     */
    public function getTemperaturaAxilarSv()
    {
        return $this->temperaturaAxilarSv;
    }

    /**
     * Set pesoSv
     *
     * @param string $pesoSv
     *
     * @return EvolucionSignosVitales
     */
    public function setPesoSv($pesoSv)
    {
        $this->pesoSv = $pesoSv;

        return $this;
    }

    /**
     * Get pesoSv
     *
     * @return string
     */
    public function getPesoSv()
    {
        return $this->pesoSv;
    }

    /**
     * Set conversionSv
     *
     * @param string $conversionSv
     *
     * @return EvolucionSignosVitales
     */
    public function setConversionSv($conversionSv)
    {
        $this->conversionSv = $conversionSv;

        return $this;
    }

    /**
     * Get conversionSv
     *
     * @return string
     */
    public function getConversionSv()
    {
        return $this->conversionSv;
    }

    /**
     * Set tallaSv
     *
     * @param string $tallaSv
     *
     * @return EvolucionSignosVitales
     */
    public function setTallaSv($tallaSv)
    {
        $this->tallaSv = $tallaSv;

        return $this;
    }

    /**
     * Get tallaSv
     *
     * @return string
     */
    public function getTallaSv()
    {
        return $this->tallaSv;
    }

    /**
     * Set indiceMasaCorpSv
     *
     * @param string $indiceMasaCorpSv
     *
     * @return EvolucionSignosVitales
     */
    public function setIndiceMasaCorpSv($indiceMasaCorpSv)
    {
        $this->indiceMasaCorpSv = $indiceMasaCorpSv;

        return $this;
    }

    /**
     * Get indiceMasaCorpSv
     *
     * @return string
     */
    public function getIndiceMasaCorpSv()
    {
        return $this->indiceMasaCorpSv;
    }

    /**
     * Set perimetroCefilicoSv
     *
     * @param string $perimetroCefilicoSv
     *
     * @return EvolucionSignosVitales
     */
    public function setPerimetroCefilicoSv($perimetroCefilicoSv)
    {
        $this->perimetroCefilicoSv = $perimetroCefilicoSv;

        return $this;
    }

    /**
     * Get perimetroCefilicoSv
     *
     * @return string
     */
    public function getPerimetroCefilicoSv()
    {
        return $this->perimetroCefilicoSv;
    }

    /**
     * Set saturacionOxigenoSv
     *
     * @param string $saturacionOxigenoSv
     *
     * @return EvolucionSignosVitales
     */
    public function setSaturacionOxigenoSv($saturacionOxigenoSv)
    {
        $this->saturacionOxigenoSv = $saturacionOxigenoSv;

        return $this;
    }

    /**
     * Get saturacionOxigenoSv
     *
     * @return string
     */
    public function getSaturacionOxigenoSv()
    {
        return $this->saturacionOxigenoSv;
    }

    /**
     * Set perimetroAbdominalSv
     *
     * @param string $perimetroAbdominalSv
     *
     * @return EvolucionSignosVitales
     */
    public function setPerimetroAbdominalSv($perimetroAbdominalSv)
    {
        $this->perimetroAbdominalSv = $perimetroAbdominalSv;

        return $this;
    }

    /**
     * Get perimetroAbdominalSv
     *
     * @return string
     */
    public function getPerimetroAbdominalSv()
    {
        return $this->perimetroAbdominalSv;
    }

    /**
     * Set temperaturaAltSv
     *
     * @param string $temperaturaAltSv
     *
     * @return EvolucionSignosVitales
     */
    public function setTemperaturaAltSv($temperaturaAltSv)
    {
        $this->temperaturaAltSv = $temperaturaAltSv;

        return $this;
    }

    /**
     * Get temperaturaAltSv
     *
     * @return string
     */
    public function getTemperaturaAltSv()
    {
        return $this->temperaturaAltSv;
    }

    /**
     * Set tipoSangreSv
     *
     * @param string $tipoSangreSv
     *
     * @return EvolucionSignosVitales
     */
    public function setTipoSangreSv($tipoSangreSv)
    {
        $this->tipoSangreSv = $tipoSangreSv;

        return $this;
    }

    /**
     * Get tipoSangreSv
     *
     * @return string
     */
    public function getTipoSangreSv()
    {
        return $this->tipoSangreSv;
    }
}

