<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EvolucionMedica
 *
 * @ORM\Table(name="evolucion_medica")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\EvolucionMedicaRepository")
 */
class EvolucionMedica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_evolucion", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="EvolucionSignosVitales", mappedBy="idEvolucion")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_evolucion", type="string", length=20)
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_evolucion", type="string", length=10)
     */
    private $hora;
    /**
     * @var string
     *
     * @ORM\Column(name="evolucion_objetiva", type="text", nullable=true)
     */
    private $evolucionObjetiva;

    /**
     * @var string
     *
     * @ORM\Column(name="evolucion_subjetiva", type="text", nullable=true)
     */
    private $evolucionSubjetiva;

    /**
     * @var string
     *
     * @ORM\Column(name="apreciacion_evolucion", type="text", nullable=true)
     */
    private $apreciacionEvolucion;

    /**
     * @var string
     *
     * @ORM\Column(name="planes_evolucion", type="text", nullable=true)
     */
    private $planesEvolucion;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return EvolucionMedica
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return EvolucionMedica
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set hora
     *
     * @param string $hora
     *
     * @return EvolucionMedica
     */
    public function setHora($hora)
    {
        $this->hora = $hora;

        return $this;
    }

    /**
     * Get hora
     *
     * @return string
     */
    public function getHora()
    {
        return $this->hora;
    }

    /**
     * Set evolucionObjetiva
     *
     * @param string $evolucionObjetiva
     *
     * @return EvolucionMedica
     */
    public function setEvolucionObjetiva($evolucionObjetiva)
    {
        $this->evolucionObjetiva = $evolucionObjetiva;

        return $this;
    }

    /**
     * Get evolucionObjetiva
     *
     * @return string
     */
    public function getEvolucionObjetiva()
    {
        return $this->evolucionObjetiva;
    }

    /**
     * Set evolucionSubjetiva
     *
     * @param string $evolucionSubjetiva
     *
     * @return EvolucionMedica
     */
    public function setEvolucionSubjetiva($evolucionSubjetiva)
    {
        $this->evolucionSubjetiva = $evolucionSubjetiva;

        return $this;
    }

    /**
     * Get evolucionSubjetiva
     *
     * @return string
     */
    public function getEvolucionSubjetiva()
    {
        return $this->evolucionSubjetiva;
    }

    /**
     * Set apreciacionEvolucion
     *
     * @param string $apreciacionEvolucion
     *
     * @return EvolucionMedica
     */
    public function setApreciacionEvolucion($apreciacionEvolucion)
    {
        $this->apreciacionEvolucion = $apreciacionEvolucion;

        return $this;
    }

    /**
     * Get apreciacionEvolucion
     *
     * @return string
     */
    public function getApreciacionEvolucion()
    {
        return $this->apreciacionEvolucion;
    }

    /**
     * Set planesEvolucion
     *
     * @param string $planesEvolucion
     *
     * @return EvolucionMedica
     */
    public function setPlanesEvolucion($planesEvolucion)
    {
        $this->planesEvolucion = $planesEvolucion;

        return $this;
    }

    /**
     * Get planesEvolucion
     *
     * @return string
     */
    public function getPlanesEvolucion()
    {
        return $this->planesEvolucion;
    }
}

