<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EstadoCitaMedica
 *
 * @ORM\Table(name="estado_cita_medica")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\EstadoCitaMedicaRepository")
 */
class EstadoCitaMedica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_estado_cita_medica", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="CitaMedica", mappedBy="idEstadoCita")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_es_cita_medica", type="string", length=20)
     */
    private $nombre;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_es_cita_medica", type="string", length=10)
     */
    private $codigo;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_es_cita_medica", type="boolean")
     */
    private $estado;

    /**
     * @var string
     *
     * @ORM\Column(name="boton_es_cita_medica", type="string", length=15)
     */
    private $boton;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return EstadoCitaMedica
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return EstadoCitaMedica
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return EstadoCitaMedica
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set boton
     *
     * @param string $boton
     *
     * @return EstadoCitaMedica
     */
    public function setBoton($boton)
    {
        $this->boton = $boton;

        return $this;
    }

    /**
     * Get boton
     *
     * @return string
     */
    public function getBoton()
    {
        return $this->boton;
    }
}

