<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DiasLaborables
 *
 * @ORM\Table(name="dias_laborables")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\DiasLaborablesRepository")
 */
class DiasLaborables
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_dias_laborables", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="HorariosLaborables", mappedBy="idDiasLaborables")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_dias_laborables", type="string", length=20)
     */
    private $nombre;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_dias_laborables", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return DiasLaborables
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return DiasLaborables
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

