<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * DetalleHistoriaClinica
 *
 * @ORM\Table(name="detalle_historia_clinica")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\DetalleHistoriaClinicaRepository")
 */
class DetalleHistoriaClinica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_detalle_hc", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="ResumenHistoriaClinica")
     * @ORM\JoinColumn(name="id_resumen_hc", referencedColumnName="id_resumen_hc")
     */
    private $idResumenHc;

    /**
     * @var string
     *
     * @ORM\Column(name="presion_asistolica_sv", type="string", length=20, nullable=true)
     */
    private $presionSistolicaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="presion_diastolica_sv", type="string", length=20, nullable=true)
     */
    private $presionDiastolicaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="frecuencia_cardia_sv", type="string", length=20, nullable=true)
     */
    private $frecuenciaCardiacaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="frecuencia_respira_sv", type="string", length=20, nullable=true)
     */
    private $frecuenciaRespiraSv;

    /**
     * @var string
     *
     * @ORM\Column(name="temperatura_bucal_sv", type="string", length=20, nullable=true)
     */
    private $temperaturaBucalSv;

    /**
     * @var string
     *
     * @ORM\Column(name="temperatura_axilar_sv", type="string", length=20, nullable=true)
     */
    private $temperaturaAxilarSv;

    /**
     * @var string
     *
     * @ORM\Column(name="peso_sv", type="string", length=20, nullable=true)
     */
    private $pesoSv;

    /**
     * @var string
     *
     * @ORM\Column(name="conversion_sv", type="string", length=20, nullable=true)
     */
    private $conversionSv;

    /**
     * @var string
     *
     * @ORM\Column(name="talla_sv", type="string", length=20, nullable=true)
     */
    private $tallaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="indice_masa_corp_sv", type="string", length=20, nullable=true)
     */
    private $indiceMasaCorpSv;

    /**
     * @var string
     *
     * @ORM\Column(name="perimetro_cefilico_sv", type="string", length=20, nullable=true)
     */
    private $perimetroCefilicoSv;

    /**
     * @var string
     *
     * @ORM\Column(name="saturacion_oxigeno_sv", type="string", length=20, nullable=true)
     */
    private $saturacionOxigenoSv;

    /**
     * @var string
     *
     * @ORM\Column(name="perimetro_abdomina_sv", type="string", length=20, nullable=true)
     */
    private $perimetroAbdominaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="temperatura_alt_sv", type="string", length=20, nullable=true)
     */
    private $temperaturaAltaSv;

    /**
     * @var string
     *
     * @ORM\Column(name="organos_sentidos_os", type="string", length=400, nullable=true)
     */
    private $organosSentidosOs;

    /**
     * @var string
     *
     * @ORM\Column(name="respiratorio_os", type="string", length=400, nullable=true)
     */
    private $respiratorioOs;

    /**
     * @var string
     *
     * @ORM\Column(name="cardio_vascular_os", type="string", length=400, nullable=true)
     */
    private $cardioVascularOs;

    /**
     * @var string
     *
     * @ORM\Column(name="digestivo_os", type="string", length=400, nullable=true)
     */
    private $digestivoOs;

    /**
     * @var string
     *
     * @ORM\Column(name="genital_os", type="string", length=400, nullable=true)
     */
    private $genitalOs;

    /**
     * @var string
     *
     * @ORM\Column(name="urinario_os", type="string", length=400, nullable=true)
     */
    private $urinarioOs;

    /**
     * @var string
     *
     * @ORM\Column(name="muscul_esquel_os", type="string", length=400, nullable=true)
     */
    private $musculEsquelOs;

    /**
     * @var string
     *
     * @ORM\Column(name="endocr_metabo_os", type="string", length=400, nullable=true)
     */
    private $endocrMetaboOs;

    /**
     * @var string
     *
     * @ORM\Column(name="neurologico_os", type="string", length=400, nullable=true)
     */
    private $neurologicoOs;

    /**
     * @var string
     *
     * @ORM\Column(name="mental_os", type="string", length=400, nullable=true)
     */
    private $mentalOs;

    /**
     * @var string
     *
     * @ORM\Column(name="hemato_linfatico_os", type="string", length=400, nullable=true)
     */
    private $hematoLinfaticoOs;

    /**
     * @var string
     *
     * @ORM\Column(name="otros_os", type="string", length=400, nullable=true)
     */
    private $otrosOs;

    /**
     * @var string
     *
     * @ORM\Column(name="piel_faneras_efr", type="string", length=400, nullable=true)
     */
    private $pielFanerasEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="columna_verte_efr", type="string", length=400, nullable=true)
     */
    private $columnaVerteEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="cabeza_efr", type="string", length=400, nullable=true)
     */
    private $cabezaEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="ingle_perine_efr", type="string", length=400, nullable=true)
     */
    private $inglePerineEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="ojos_efr", type="string", length=400, nullable=true)
     */
    private $ojosEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="miembros_sup_efr", type="string", length=400, nullable=true)
     */
    private $miembrosSupEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="oidos_efr", type="string", length=400, nullable=true)
     */
    private $oidosEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="miembros_infe_efr", type="string", length=400, nullable=true)
     */
    private $miembrosInfeEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="nariz_efr", type="string", length=400, nullable=true)
     */
    private $narizEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="organos_sentido_efr", type="string", length=400, nullable=true)
     */
    private $organosSentidosEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="boca_efr", type="string", length=400, nullable=true)
     */
    private $bocaEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="pulmonar_efr", type="string", length=400, nullable=true)
     */
    private $pulmonarEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="oro_faringe_efr", type="string", length=400, nullable=true)
     */
    private $oroFaringeEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="cardiaco_efr", type="string", length=400, nullable=true)
     */
    private $cardiacoEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="cuello_tiroides_efr", type="string", length=400, nullable=true)
     */
    private $cuelloTiroidesEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="musculo_esque_efr", type="string", length=400, nullable=true)
     */
    private $musculoEsqueEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="axilas_mamas_efr", type="string", length=400, nullable=true)
     */
    private $axilasMamasEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="hematolinfatico_efr", type="string", length=400, nullable=true)
     */
    private $hematolinfaticoEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="torax_efr", type="string", length=400, nullable=true)
     */
    private $toraxEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="neurologico_efr", type="string", length=400, nullable=true)
     */
    private $neurologicoEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="abdomen_efr", type="string", length=400, nullable=true)
     */
    private $abdomenEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="vascular_perife_efr", type="string", length=400, nullable=true)
     */
    private $vascularPerifeEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="genitales_efr", type="string", length=400, nullable=true)
     */
    private $genitalesEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="exam_ano_rec_efr", type="string", length=400, nullable=true)
     */
    private $examAnoRecEfr;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_sangre_sv", type="string", length=20, nullable=true)
     */
    private $tipoSangreSv;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idResumenHc
     *
     * @param integer $idResumenHc
     *
     * @return DetalleHistoriaClinica
     */
    public function setIdResumenHc($idResumenHc)
    {
        $this->idResumenHc = $idResumenHc;

        return $this;
    }

    /**
     * Get idResumenHc
     *
     * @return int
     */
    public function getIdResumenHc()
    {
        return $this->idResumenHc;
    }

    /**
     * Set presionSistolicaSv
     *
     * @param string $presionSistolicaSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setPresionSistolicaSv($presionSistolicaSv)
    {
        $this->presionSistolicaSv = $presionSistolicaSv;

        return $this;
    }

    /**
     * Get presionSistolicaSv
     *
     * @return string
     */
    public function getPresionSistolicaSv()
    {
        return $this->presionSistolicaSv;
    }

    /**
     * Set presionDiastolicaSv
     *
     * @param string $presionDiastolicaSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setPresionDiastolicaSv($presionDiastolicaSv)
    {
        $this->presionDiastolicaSv = $presionDiastolicaSv;

        return $this;
    }

    /**
     * Get presionDiastolicaSv
     *
     * @return string
     */
    public function getPresionDiastolicaSv()
    {
        return $this->presionDiastolicaSv;
    }

    /**
     * Set frecuenciaCardiacaSv
     *
     * @param string $frecuenciaCardiacaSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setFrecuenciaCardiacaSv($frecuenciaCardiacaSv)
    {
        $this->frecuenciaCardiacaSv = $frecuenciaCardiacaSv;

        return $this;
    }

    /**
     * Get frecuenciaCardiacaSv
     *
     * @return string
     */
    public function getFrecuenciaCardiacaSv()
    {
        return $this->frecuenciaCardiacaSv;
    }

    /**
     * Set frecuenciaRespiraSv
     *
     * @param string $frecuenciaRespiraSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setFrecuenciaRespiraSv($frecuenciaRespiraSv)
    {
        $this->frecuenciaRespiraSv = $frecuenciaRespiraSv;

        return $this;
    }

    /**
     * Get frecuenciaRespiraSv
     *
     * @return string
     */
    public function getFrecuenciaRespiraSv()
    {
        return $this->frecuenciaRespiraSv;
    }

    /**
     * Set temperaturaBucalSv
     *
     * @param string $temperaturaBucalSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setTemperaturaBucalSv($temperaturaBucalSv)
    {
        $this->temperaturaBucalSv = $temperaturaBucalSv;

        return $this;
    }

    /**
     * Get temperaturaBucalSv
     *
     * @return string
     */
    public function getTemperaturaBucalSv()
    {
        return $this->temperaturaBucalSv;
    }

    /**
     * Set temperaturaAxilarSv
     *
     * @param string $temperaturaAxilarSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setTemperaturaAxilarSv($temperaturaAxilarSv)
    {
        $this->temperaturaAxilarSv = $temperaturaAxilarSv;

        return $this;
    }

    /**
     * Get temperaturaAxilarSv
     *
     * @return string
     */
    public function getTemperaturaAxilarSv()
    {
        return $this->temperaturaAxilarSv;
    }

    /**
     * Set pesoSv
     *
     * @param string $pesoSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setPesoSv($pesoSv)
    {
        $this->pesoSv = $pesoSv;

        return $this;
    }

    /**
     * Get pesoSv
     *
     * @return string
     */
    public function getPesoSv()
    {
        return $this->pesoSv;
    }

    /**
     * Set conversionSv
     *
     * @param string $conversionSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setConversionSv($conversionSv)
    {
        $this->conversionSv = $conversionSv;

        return $this;
    }

    /**
     * Get conversionSv
     *
     * @return string
     */
    public function getConversionSv()
    {
        return $this->conversionSv;
    }

    /**
     * Set tallaSv
     *
     * @param string $tallaSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setTallaSv($tallaSv)
    {
        $this->tallaSv = $tallaSv;

        return $this;
    }

    /**
     * Get tallaSv
     *
     * @return string
     */
    public function getTallaSv()
    {
        return $this->tallaSv;
    }

    /**
     * Set indiceMasaCorpSv
     *
     * @param string $indiceMasaCorpSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setIndiceMasaCorpSv($indiceMasaCorpSv)
    {
        $this->indiceMasaCorpSv = $indiceMasaCorpSv;

        return $this;
    }

    /**
     * Get indiceMasaCorpSv
     *
     * @return string
     */
    public function getIndiceMasaCorpSv()
    {
        return $this->indiceMasaCorpSv;
    }

    /**
     * Set perimetroCefilicoSv
     *
     * @param string $perimetroCefilicoSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setPerimetroCefilicoSv($perimetroCefilicoSv)
    {
        $this->perimetroCefilicoSv = $perimetroCefilicoSv;

        return $this;
    }

    /**
     * Get perimetroCefilicoSv
     *
     * @return string
     */
    public function getPerimetroCefilicoSv()
    {
        return $this->perimetroCefilicoSv;
    }

    /**
     * Set saturacionOxigenoSv
     *
     * @param string $saturacionOxigenoSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setSaturacionOxigenoSv($saturacionOxigenoSv)
    {
        $this->saturacionOxigenoSv = $saturacionOxigenoSv;

        return $this;
    }

    /**
     * Get saturacionOxigenoSv
     *
     * @return string
     */
    public function getSaturacionOxigenoSv()
    {
        return $this->saturacionOxigenoSv;
    }

    /**
     * Set perimetroAbdominaSv
     *
     * @param string $perimetroAbdominaSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setPerimetroAbdominaSv($perimetroAbdominaSv)
    {
        $this->perimetroAbdominaSv = $perimetroAbdominaSv;

        return $this;
    }

    /**
     * Get perimetroAbdominaSv
     *
     * @return string
     */
    public function getPerimetroAbdominaSv()
    {
        return $this->perimetroAbdominaSv;
    }

    /**
     * Set temperaturaAltaSv
     *
     * @param string $temperaturaAltaSv
     *
     * @return DetalleHistoriaClinica
     */
    public function setTemperaturaAltaSv($temperaturaAltaSv)
    {
        $this->temperaturaAltaSv = $temperaturaAltaSv;

        return $this;
    }

    /**
     * Get temperaturaAltaSv
     *
     * @return string
     */
    public function getTemperaturaAltaSv()
    {
        return $this->temperaturaAltaSv;
    }

    /**
     * Set organosSentidosOs
     *
     * @param string $organosSentidosOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setOrganosSentidosOs($organosSentidosOs)
    {
        $this->organosSentidosOs = $organosSentidosOs;

        return $this;
    }

    /**
     * Get organosSentidosOs
     *
     * @return string
     */
    public function getOrganosSentidosOs()
    {
        return $this->organosSentidosOs;
    }

    /**
     * Set respiratorioOs
     *
     * @param string $respiratorioOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setRespiratorioOs($respiratorioOs)
    {
        $this->respiratorioOs = $respiratorioOs;

        return $this;
    }

    /**
     * Get respiratorioOs
     *
     * @return string
     */
    public function getRespiratorioOs()
    {
        return $this->respiratorioOs;
    }

    /**
     * Set cardioVascularOs
     *
     * @param string $cardioVascularOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setCardioVascularOs($cardioVascularOs)
    {
        $this->cardioVascularOs = $cardioVascularOs;

        return $this;
    }

    /**
     * Get cardioVascularOs
     *
     * @return string
     */
    public function getCardioVascularOs()
    {
        return $this->cardioVascularOs;
    }

    /**
     * Set digestivoOs
     *
     * @param string $digestivoOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setDigestivoOs($digestivoOs)
    {
        $this->digestivoOs = $digestivoOs;

        return $this;
    }

    /**
     * Get digestivoOs
     *
     * @return string
     */
    public function getDigestivoOs()
    {
        return $this->digestivoOs;
    }

    /**
     * Set genitalOs
     *
     * @param string $genitalOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setGenitalOs($genitalOs)
    {
        $this->genitalOs = $genitalOs;

        return $this;
    }

    /**
     * Get genitalOs
     *
     * @return string
     */
    public function getGenitalOs()
    {
        return $this->genitalOs;
    }

    /**
     * Set urinarioOs
     *
     * @param string $urinarioOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setUrinarioOs($urinarioOs)
    {
        $this->urinarioOs = $urinarioOs;

        return $this;
    }

    /**
     * Get urinarioOs
     *
     * @return string
     */
    public function getUrinarioOs()
    {
        return $this->urinarioOs;
    }

    /**
     * Set musculEsquelOs
     *
     * @param string $musculEsquelOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setMusculEsquelOs($musculEsquelOs)
    {
        $this->musculEsquelOs = $musculEsquelOs;

        return $this;
    }

    /**
     * Get musculEsquelOs
     *
     * @return string
     */
    public function getMusculEsquelOs()
    {
        return $this->musculEsquelOs;
    }

    /**
     * Set endocrMetaboOs
     *
     * @param string $endocrMetaboOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setEndocrMetaboOs($endocrMetaboOs)
    {
        $this->endocrMetaboOs = $endocrMetaboOs;

        return $this;
    }

    /**
     * Get endocrMetaboOs
     *
     * @return string
     */
    public function getEndocrMetaboOs()
    {
        return $this->endocrMetaboOs;
    }

    /**
     * Set neurologicoOs
     *
     * @param string $neurologicoOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setNeurologicoOs($neurologicoOs)
    {
        $this->neurologicoOs = $neurologicoOs;

        return $this;
    }

    /**
     * Get neurologicoOs
     *
     * @return string
     */
    public function getNeurologicoOs()
    {
        return $this->neurologicoOs;
    }

    /**
     * Set mentalOs
     *
     * @param string $mentalOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setMentalOs($mentalOs)
    {
        $this->mentalOs = $mentalOs;

        return $this;
    }

    /**
     * Get mentalOs
     *
     * @return string
     */
    public function getMentalOs()
    {
        return $this->mentalOs;
    }

    /**
     * Set hematoLinfaticoOs
     *
     * @param string $hematoLinfaticoOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setHematoLinfaticoOs($hematoLinfaticoOs)
    {
        $this->hematoLinfaticoOs = $hematoLinfaticoOs;

        return $this;
    }

    /**
     * Get hematoLinfaticoOs
     *
     * @return string
     */
    public function getHematoLinfaticoOs()
    {
        return $this->hematoLinfaticoOs;
    }

    /**
     * Set otrosOs
     *
     * @param string $otrosOs
     *
     * @return DetalleHistoriaClinica
     */
    public function setOtrosOs($otrosOs)
    {
        $this->otrosOs = $otrosOs;

        return $this;
    }

    /**
     * Get otrosOs
     *
     * @return string
     */
    public function getOtrosOs()
    {
        return $this->otrosOs;
    }

    /**
     * Set pielFanerasEfr
     *
     * @param string $pielFanerasEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setPielFanerasEfr($pielFanerasEfr)
    {
        $this->pielFanerasEfr = $pielFanerasEfr;

        return $this;
    }

    /**
     * Get pielFanerasEfr
     *
     * @return string
     */
    public function getPielFanerasEfr()
    {
        return $this->pielFanerasEfr;
    }

    /**
     * Set columnaVerteEfr
     *
     * @param string $columnaVerteEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setColumnaVerteEfr($columnaVerteEfr)
    {
        $this->columnaVerteEfr = $columnaVerteEfr;

        return $this;
    }

    /**
     * Get columnaVerteEfr
     *
     * @return string
     */
    public function getColumnaVerteEfr()
    {
        return $this->columnaVerteEfr;
    }

    /**
     * Set cabezaEfr
     *
     * @param string $cabezaEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setCabezaEfr($cabezaEfr)
    {
        $this->cabezaEfr = $cabezaEfr;

        return $this;
    }

    /**
     * Get cabezaEfr
     *
     * @return string
     */
    public function getCabezaEfr()
    {
        return $this->cabezaEfr;
    }

    /**
     * Set inglePerineEfr
     *
     * @param string $inglePerineEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setInglePerineEfr($inglePerineEfr)
    {
        $this->inglePerineEfr = $inglePerineEfr;

        return $this;
    }

    /**
     * Get inglePerineEfr
     *
     * @return string
     */
    public function getInglePerineEfr()
    {
        return $this->inglePerineEfr;
    }

    /**
     * Set ojosEfr
     *
     * @param string $ojosEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setOjosEfr($ojosEfr)
    {
        $this->ojosEfr = $ojosEfr;

        return $this;
    }

    /**
     * Get ojosEfr
     *
     * @return string
     */
    public function getOjosEfr()
    {
        return $this->ojosEfr;
    }

    /**
     * Set miembrosSupEfr
     *
     * @param string $miembrosSupEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setMiembrosSupEfr($miembrosSupEfr)
    {
        $this->miembrosSupEfr = $miembrosSupEfr;

        return $this;
    }

    /**
     * Get miembrosSupEfr
     *
     * @return string
     */
    public function getMiembrosSupEfr()
    {
        return $this->miembrosSupEfr;
    }

    /**
     * Set oidosEfr
     *
     * @param string $oidosEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setOidosEfr($oidosEfr)
    {
        $this->oidosEfr = $oidosEfr;

        return $this;
    }

    /**
     * Get oidosEfr
     *
     * @return string
     */
    public function getOidosEfr()
    {
        return $this->oidosEfr;
    }

    /**
     * Set miembrosInfeEfr
     *
     * @param string $miembrosInfeEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setMiembrosInfeEfr($miembrosInfeEfr)
    {
        $this->miembrosInfeEfr = $miembrosInfeEfr;

        return $this;
    }

    /**
     * Get miembrosInfeEfr
     *
     * @return string
     */
    public function getMiembrosInfeEfr()
    {
        return $this->miembrosInfeEfr;
    }

    /**
     * Set narizEfr
     *
     * @param string $narizEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setNarizEfr($narizEfr)
    {
        $this->narizEfr = $narizEfr;

        return $this;
    }

    /**
     * Get narizEfr
     *
     * @return string
     */
    public function getNarizEfr()
    {
        return $this->narizEfr;
    }

    /**
     * Set organosSentidosEfr
     *
     * @param string $organosSentidosEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setOrganosSentidosEfr($organosSentidosEfr)
    {
        $this->organosSentidosEfr = $organosSentidosEfr;

        return $this;
    }

    /**
     * Get organosSentidosEfr
     *
     * @return string
     */
    public function getOrganosSentidosEfr()
    {
        return $this->organosSentidosEfr;
    }

    /**
     * Set bocaEfr
     *
     * @param string $bocaEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setBocaEfr($bocaEfr)
    {
        $this->bocaEfr = $bocaEfr;

        return $this;
    }

    /**
     * Get bocaEfr
     *
     * @return string
     */
    public function getBocaEfr()
    {
        return $this->bocaEfr;
    }

    /**
     * Set pulmonarEfr
     *
     * @param string $pulmonarEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setPulmonarEfr($pulmonarEfr)
    {
        $this->pulmonarEfr = $pulmonarEfr;

        return $this;
    }

    /**
     * Get pulmonarEfr
     *
     * @return string
     */
    public function getPulmonarEfr()
    {
        return $this->pulmonarEfr;
    }

    /**
     * Set oroFaringeEfr
     *
     * @param string $oroFaringeEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setOroFaringeEfr($oroFaringeEfr)
    {
        $this->oroFaringeEfr = $oroFaringeEfr;

        return $this;
    }

    /**
     * Get oroFaringeEfr
     *
     * @return string
     */
    public function getOroFaringeEfr()
    {
        return $this->oroFaringeEfr;
    }

    /**
     * Set cardiacoEfr
     *
     * @param string $cardiacoEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setCardiacoEfr($cardiacoEfr)
    {
        $this->cardiacoEfr = $cardiacoEfr;

        return $this;
    }

    /**
     * Get cardiacoEfr
     *
     * @return string
     */
    public function getCardiacoEfr()
    {
        return $this->cardiacoEfr;
    }

    /**
     * Set cuelloTiroidesEfr
     *
     * @param string $cuelloTiroidesEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setCuelloTiroidesEfr($cuelloTiroidesEfr)
    {
        $this->cuelloTiroidesEfr = $cuelloTiroidesEfr;

        return $this;
    }

    /**
     * Get cuelloTiroidesEfr
     *
     * @return string
     */
    public function getCuelloTiroidesEfr()
    {
        return $this->cuelloTiroidesEfr;
    }

    /**
     * Set musculoEsqueEfr
     *
     * @param string $musculoEsqueEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setMusculoEsqueEfr($musculoEsqueEfr)
    {
        $this->musculoEsqueEfr = $musculoEsqueEfr;

        return $this;
    }

    /**
     * Get musculoEsqueEfr
     *
     * @return string
     */
    public function getMusculoEsqueEfr()
    {
        return $this->musculoEsqueEfr;
    }

    /**
     * Set axilasMamasEfr
     *
     * @param string $axilasMamasEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setAxilasMamasEfr($axilasMamasEfr)
    {
        $this->axilasMamasEfr = $axilasMamasEfr;

        return $this;
    }

    /**
     * Get axilasMamasEfr
     *
     * @return string
     */
    public function getAxilasMamasEfr()
    {
        return $this->axilasMamasEfr;
    }

    /**
     * Set hematolinfaticoEfr
     *
     * @param string $hematolinfaticoEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setHematolinfaticoEfr($hematolinfaticoEfr)
    {
        $this->hematolinfaticoEfr = $hematolinfaticoEfr;

        return $this;
    }

    /**
     * Get hematolinfaticoEfr
     *
     * @return string
     */
    public function getHematolinfaticoEfr()
    {
        return $this->hematolinfaticoEfr;
    }

    /**
     * Set toraxEfr
     *
     * @param string $toraxEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setToraxEfr($toraxEfr)
    {
        $this->toraxEfr = $toraxEfr;

        return $this;
    }

    /**
     * Get toraxEfr
     *
     * @return string
     */
    public function getToraxEfr()
    {
        return $this->toraxEfr;
    }

    /**
     * Set neurologicoEfr
     *
     * @param string $neurologicoEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setNeurologicoEfr($neurologicoEfr)
    {
        $this->neurologicoEfr = $neurologicoEfr;

        return $this;
    }

    /**
     * Get neurologicoEfr
     *
     * @return string
     */
    public function getNeurologicoEfr()
    {
        return $this->neurologicoEfr;
    }

    /**
     * Set abdomenEfr
     *
     * @param string $abdomenEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setAbdomenEfr($abdomenEfr)
    {
        $this->abdomenEfr = $abdomenEfr;

        return $this;
    }

    /**
     * Get abdomenEfr
     *
     * @return string
     */
    public function getAbdomenEfr()
    {
        return $this->abdomenEfr;
    }

    /**
     * Set vascularPerifeEfr
     *
     * @param string $vascularPerifeEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setVascularPerifeEfr($vascularPerifeEfr)
    {
        $this->vascularPerifeEfr = $vascularPerifeEfr;

        return $this;
    }

    /**
     * Get vascularPerifeEfr
     *
     * @return string
     */
    public function getVascularPerifeEfr()
    {
        return $this->vascularPerifeEfr;
    }

    /**
     * Set genitalesEfr
     *
     * @param string $genitalesEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setGenitalesEfr($genitalesEfr)
    {
        $this->genitalesEfr = $genitalesEfr;

        return $this;
    }

    /**
     * Get genitalesEfr
     *
     * @return string
     */
    public function getGenitalesEfr()
    {
        return $this->genitalesEfr;
    }

    /**
     * Set examAnoRecEfr
     *
     * @param string $examAnoRecEfr
     *
     * @return DetalleHistoriaClinica
     */
    public function setExamAnoRecEfr($examAnoRecEfr)
    {
        $this->examAnoRecEfr = $examAnoRecEfr;

        return $this;
    }

    /**
     * Get examAnoRecEfr
     *
     * @return string
     */
    public function getExamAnoRecEfr()
    {
        return $this->examAnoRecEfr;
    }

    /**
     * Set tipoSangreSv
     *
     * @param string $tipoSangreSv
     *
     * @return EvolucionSignosVitales
     */
    public function setTipoSangreSv($tipoSangreSv)
    {
        $this->tipoSangreSv = $tipoSangreSv;

        return $this;
    }

    /**
     * Get tipoSangreSv
     *
     * @return string
     */
    public function getTipoSangreSv()
    {
        return $this->tipoSangreSv;
    }
}

