<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CitaMedica
 *
 * @ORM\Table(name="cita_medica")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\CitaMedicaRepository")
 */
class CitaMedica
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_cita_medica", type="integer")
     * @ORM\Id
     * @ORM\OneToOne(targetEntity="ResumenHistoriaClinica", mappedBy="idCitaMedica")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Especialidades")
     * @ORM\JoinColumn(name="id_especialidad", referencedColumnName="id_especialidad")
     */
    private $idEspecialidad;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="EstadoCitaMedica")
     * @ORM\JoinColumn(name="id_estado_cita_medica", referencedColumnName="id_estado_cita_medica")
     */
    private $idEstadoCita;

    /**
     * @var int
     *
     * @ORM\Column(name="id_resumen_hc", type="integer", nullable=true)
     */
    private $idDetalleHC;

    /**
     * @var int
     *
     * @ORM\ManyToOne(targetEntity="Agenda")
     * @ORM\JoinColumn(name="id_agenda", referencedColumnName="id_agenda")
     */
    private $idAgenda;

    /**
     * @var string
     *
     * @ORM\Column(name="fecha_cita_medica", type="string", length=20)
     */
    private $fecha;

    /**
     * @var string
     *
     * @ORM\Column(name="observacion_cita_medica", type="string", length=500)
     */
    private $observacion;

    /**
     * @var string
     *
     * @ORM\Column(name="hora_cita_medica", type="string", length=10)
     */
    private $hora;

    /**
     * @var bool
     *
     * @ORM\Column(name="factura_cita_medica", type="boolean")
     */
    private $factura;



    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param integer $idPaciente
     *
     * @return CitaMedica
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set idEspecialidad
     *
     * @param integer $idEspecialidad
     *
     * @return CitaMedica
     */
    public function setIdEspecialidad($idEspecialidad)
    {
        $this->idEspecialidad = $idEspecialidad;

        return $this;
    }

    /**
     * Get idEspecialidad
     *
     * @return int
     */
    public function getIdEspecialidad()
    {
        return $this->idEspecialidad;
    }

    /**
     * Set idEstadoCita
     *
     * @param integer $idEstadoCita
     *
     * @return CitaMedica
     */
    public function setIdEstadoCita($idEstadoCita)
    {
        $this->idEstadoCita = $idEstadoCita;

        return $this;
    }

    /**
     * Get idEstadoCita
     *
     * @return int
     */
    public function getIdEstadoCita()
    {
        return $this->idEstadoCita;
    }

    /**
     * Set idDetalleHC
     *
     * @param integer $idDetalleHC
     *
     * @return CitaMedica
     */
    public function setIdDetalleHC($idDetalleHC)
    {
        $this->idDetalleHC = $idDetalleHC;

        return $this;
    }

    /**
     * Get idDetalleHC
     *
     * @return int
     */
    public function getIdDetalleHC()
    {
        return $this->idDetalleHC;
    }

    /**
     * Set idAgenda
     *
     * @param integer $idAgenda
     *
     * @return CitaMedica
     */
    public function setIdAgenda($idAgenda)
    {
        $this->idAgenda = $idAgenda;

        return $this;
    }

    /**
     * Get idAgenda
     *
     * @return int
     */
    public function getIdAgenda()
    {
        return $this->idAgenda;
    }

    /**
     * Set fecha
     *
     * @param string $fecha
     *
     * @return CitaMedica
     */
    public function setFecha($fecha)
    {
        $this->fecha = $fecha;

        return $this;
    }

    /**
     * Get fecha
     *
     * @return string
     */
    public function getFecha()
    {
        return $this->fecha;
    }

    /**
     * Set observacion
     *
     * @param string $observacion
     *
     * @return CitaMedica
     */
    public function setObservacion($observacion)
    {
        $this->observacion = $observacion;

        return $this;
    }

    /**
     * Get observacion
     *
     * @return string
     */
    public function getObservacion()
    {
        return $this->observacion;
    }

    /**
     * Set hora
     *
     * @param string $hora
     *
     * @return CitaMedica
     */
    public function setHora($hora)
    {
        $this->hora = $hora;

        return $this;
    }

    /**
     * Get hora
     *
     * @return string
     */
    public function getHora()
    {
        return $this->hora;
    }

    /**
     * Set factura
     *
     * @param boolean $factura
     *
     * @return CieDiez
     */
    public function setFactura($factura)
    {
        $this->factura = $factura;

        return $this;
    }

    /**
     * Get factura
     *
     * @return bool
     */
    public function getFactura()
    {
        return $this->factura;
    }
}

