<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CieDiez
 *
 * @ORM\Table(name="cie_diez")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\CieDiezRepository")
 */
class CieDiez
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_cie_diez", type="integer")
     * @ORM\Id
     * @ORM\OneToMany(targetEntity="ResumenHistoriaDiagnostico", mappedBy="idCieDiez")
     * @ORM\OneToMany(targetEntity="Formulario024", mappedBy="idCieDiez")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nombre_cie_diez", type="string", length=300)
     */
    private $nombre;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo_cie_diez", type="string", length=10)
     */
    private $codigo;

    /**
     * @var bool
     *
     * @ORM\Column(name="estado_cie_diez", type="boolean")
     */
    private $estado;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nombre
     *
     * @param string $nombre
     *
     * @return CieDiez
     */
    public function setNombre($nombre)
    {
        $this->nombre = $nombre;

        return $this;
    }

    /**
     * Get nombre
     *
     * @return string
     */
    public function getNombre()
    {
        return $this->nombre;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     *
     * @return CieDiez
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set estado
     *
     * @param boolean $estado
     *
     * @return CieDiez
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return bool
     */
    public function getEstado()
    {
        return $this->estado;
    }
}

