<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntecedentesPersonales
 *
 * @ORM\Table(name="antecedentes_personales")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\AntecedentesPersonalesRepository")
 */
class AntecedentesPersonales
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_antecedente_p", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_alerg_antecedente_p", type="string", length=400, nullable=true)
     */
    private $alergicas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_card_antecedente_p", type="string", length=400, nullable=true)
     */
    private $cardiacas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_orgsen_antecedente_p", type="string", length=400, nullable=true)
     */
    private $organosSentidos;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_ostart_antecedente_p", type="string", length=400, nullable=true)
     */
    private $osteoarticular;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_conduc_antecedente_p", type="string", length=400, nullable=true)
     */
    private $conducta;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_piel_antecedente_p", type="string", length=400, nullable=true)
     */
    private $piel;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_diges_antecedente_p", type="string", length=400, nullable=true)
     */
    private $digestivas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_quir_antecedente_p", type="string", length=400, nullable=true)
     */
    private $quirurgicas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_hemat_antecedente_p", type="string", length=400, nullable=true)
     */
    private $hematolinfaticas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_resp_antecedente_p", type="string", length=400, nullable=true)
     */
    private $respiratorias;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_metab_antecedente_p", type="string", length=400, nullable=true)
     */
    private $metabolicas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_sexual_antecedente_p", type="string", length=400, nullable=true)
     */
    private $transimisionSexual;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_neuro_antecedente_p", type="string", length=400, nullable=true)
     */
    private $neurologicas;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_genit_antecedente_p", type="string", length=400, nullable=true)
     */
    private $urogenitales;

    /**
     * @var string
     *
     * @ORM\Column(name="otra_antecedente_p", type="string", length=400, nullable=true)
     */
    private $otraPatologica;

    /**
     * @var string
     *
     * @ORM\Column(name="vacunas_antecedente_p", type="string", length=400, nullable=true)
     */
    private $vacunas;

    /**
     * @var string
     *
     * @ORM\Column(name="perinatal_antecedente_p", type="string", length=400, nullable=true)
     */
    private $perinatal;

    /**
     * @var string
     *
     * @ORM\Column(name="infancia_antecedente_p", type="string", length=400, nullable=true)
     */
    private $infancia;

    /**
     * @var string
     *
     * @ORM\Column(name="adolecencia_antecedente_p", type="string", length=400, nullable=true)
     */
    private $adolecencia;

    /**
     * @var string
     *
     * @ORM\Column(name="desarrollo_antecedente_p", type="string", length=400, nullable=true)
     */
    private $desarrollo;

    /**
     * @var string
     *
     * @ORM\Column(name="otra_peda_antecedente_p", type="string", length=400, nullable=true)
     */
    private $otroPediatrico;

    /**
     * @var string
     *
     * @ORM\Column(name="tabaco_antecedente_p", type="string", length=400, nullable=true)
     */
    private $tabaco;

    /**
     * @var string
     *
     * @ORM\Column(name="dieta_antecedente_p", type="string", length=400, nullable=true)
     */
    private $dieta;

    /**
     * @var string
     *
     * @ORM\Column(name="alcohol_antecedente_p", type="string", length=400, nullable=true)
     */
    private $alcohol;

    /**
     * @var string
     *
     * @ORM\Column(name="religion_antecedente_p", type="string", length=400, nullable=true)
     */
    private $religion;

    /**
     * @var string
     *
     * @ORM\Column(name="drogas_antecedente_p", type="string", length=400, nullable=true)
     */
    private $drogas;

    /**
     * @var string
     *
     * @ORM\Column(name="tenden_sexu_antecedente_p", type="string", length=400, nullable=true)
     */
    private $tendenciaSexual;

    /**
     * @var string
     *
     * @ORM\Column(name="urinario_antecedente_p", type="string", length=400, nullable=true)
     */
    private $urinario;

    /**
     * @var string
     *
     * @ORM\Column(name="rie_social_antecedente_p", type="string", length=400, nullable=true)
     */
    private $riesgoSocial;

    /**
     * @var string
     *
     * @ORM\Column(name="defecatorio_antecedente_p", type="string", length=400, nullable=true)
     */
    private $defecatorio;

    /**
     * @var string
     *
     * @ORM\Column(name="rie_laboral_antecedente_p", type="string", length=400, nullable=true)
     */
    private $riesgoLaboral;

    /**
     * @var string
     *
     * @ORM\Column(name="act_fisica_antecedente_p", type="string", length=400, nullable=true)
     */
    private $actividadFisica;

    /**
     * @var string
     *
     * @ORM\Column(name="rie_familiar_antecedente_p", type="string", length=400, nullable=true)
     */
    private $riesgoFamiliar;

    /**
     * @var string
     *
     * @ORM\Column(name="otra_habi_antecedente_p", type="string", length=400, nullable=true)
     */
    private $otroHabito;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param \int $idPaciente
     *
     * @return Paciente
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return \int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set alergicas
     *
     * @param string $alergicas
     *
     * @return AntecedentesPersonales
     */
    public function setAlergicas($alergicas)
    {
        $this->alergicas = $alergicas;

        return $this;
    }

    /**
     * Get alergicas
     *
     * @return string
     */
    public function getAlergicas()
    {
        return $this->alergicas;
    }

    /**
     * Set cardiacas
     *
     * @param string $cardiacas
     *
     * @return AntecedentesPersonales
     */
    public function setCardiacas($cardiacas)
    {
        $this->cardiacas = $cardiacas;

        return $this;
    }

    /**
     * Get cardiacas
     *
     * @return string
     */
    public function getCardiacas()
    {
        return $this->cardiacas;
    }

    /**
     * Set organosSentidos
     *
     * @param string $organosSentidos
     *
     * @return AntecedentesPersonales
     */
    public function setOrganosSentidos($organosSentidos)
    {
        $this->organosSentidos = $organosSentidos;

        return $this;
    }

    /**
     * Get organosSentidos
     *
     * @return string
     */
    public function getOrganosSentidos()
    {
        return $this->organosSentidos;
    }

    /**
     * Set osteoarticular
     *
     * @param string $osteoarticular
     *
     * @return AntecedentesPersonales
     */
    public function setOsteoarticular($osteoarticular)
    {
        $this->osteoarticular = $osteoarticular;

        return $this;
    }

    /**
     * Get osteoarticular
     *
     * @return string
     */
    public function getOsteoarticular()
    {
        return $this->osteoarticular;
    }

    /**
     * Set conducta
     *
     * @param string $conducta
     *
     * @return AntecedentesPersonales
     */
    public function setConducta($conducta)
    {
        $this->conducta = $conducta;

        return $this;
    }

    /**
     * Get conducta
     *
     * @return string
     */
    public function getConducta()
    {
        return $this->conducta;
    }

    /**
     * Set piel
     *
     * @param string $piel
     *
     * @return AntecedentesPersonales
     */
    public function setPiel($piel)
    {
        $this->piel = $piel;

        return $this;
    }

    /**
     * Get piel
     *
     * @return string
     */
    public function getPiel()
    {
        return $this->piel;
    }

    /**
     * Set digestivas
     *
     * @param string $digestivas
     *
     * @return AntecedentesPersonales
     */
    public function setDigestivas($digestivas)
    {
        $this->digestivas = $digestivas;

        return $this;
    }

    /**
     * Get digestivas
     *
     * @return string
     */
    public function getDigestivas()
    {
        return $this->digestivas;
    }

    /**
     * Set quirurgicas
     *
     * @param string $quirurgicas
     *
     * @return AntecedentesPersonales
     */
    public function setQuirurgicas($quirurgicas)
    {
        $this->quirurgicas = $quirurgicas;

        return $this;
    }

    /**
     * Get quirurgicas
     *
     * @return string
     */
    public function getQuirurgicas()
    {
        return $this->quirurgicas;
    }

    /**
     * Set hematolinfaticas
     *
     * @param string $hematolinfaticas
     *
     * @return AntecedentesPersonales
     */
    public function setHematolinfaticas($hematolinfaticas)
    {
        $this->hematolinfaticas = $hematolinfaticas;

        return $this;
    }

    /**
     * Get hematolinfaticas
     *
     * @return string
     */
    public function getHematolinfaticas()
    {
        return $this->hematolinfaticas;
    }

    /**
     * Set respiratorias
     *
     * @param string $respiratorias
     *
     * @return AntecedentesPersonales
     */
    public function setRespiratorias($respiratorias)
    {
        $this->respiratorias = $respiratorias;

        return $this;
    }

    /**
     * Get respiratorias
     *
     * @return string
     */
    public function getRespiratorias()
    {
        return $this->respiratorias;
    }

    /**
     * Set metabolicas
     *
     * @param string $metabolicas
     *
     * @return AntecedentesPersonales
     */
    public function setMetabolicas($metabolicas)
    {
        $this->metabolicas = $metabolicas;

        return $this;
    }

    /**
     * Get metabolicas
     *
     * @return string
     */
    public function getMetabolicas()
    {
        return $this->metabolicas;
    }

    /**
     * Set transimisionSexual
     *
     * @param string $transimisionSexual
     *
     * @return AntecedentesPersonales
     */
    public function setTransimisionSexual($transimisionSexual)
    {
        $this->transimisionSexual = $transimisionSexual;

        return $this;
    }

    /**
     * Get transimisionSexual
     *
     * @return string
     */
    public function getTransimisionSexual()
    {
        return $this->transimisionSexual;
    }

    /**
     * Set neurologicas
     *
     * @param string $neurologicas
     *
     * @return AntecedentesPersonales
     */
    public function setNeurologicas($neurologicas)
    {
        $this->neurologicas = $neurologicas;

        return $this;
    }

    /**
     * Get neurologicas
     *
     * @return string
     */
    public function getNeurologicas()
    {
        return $this->neurologicas;
    }

    /**
     * Set urogenitales
     *
     * @param string $urogenitales
     *
     * @return AntecedentesPersonales
     */
    public function setUrogenitales($urogenitales)
    {
        $this->urogenitales = $urogenitales;

        return $this;
    }

    /**
     * Get urogenitales
     *
     * @return string
     */
    public function getUrogenitales()
    {
        return $this->urogenitales;
    }

    /**
     * Set otraPatologica
     *
     * @param string $otraPatologica
     *
     * @return AntecedentesPersonales
     */
    public function setOtraPatologica($otraPatologica)
    {
        $this->otraPatologica = $otraPatologica;

        return $this;
    }

    /**
     * Get otraPatologica
     *
     * @return string
     */
    public function getOtraPatologica()
    {
        return $this->otraPatologica;
    }

    /**
     * Set vacunas
     *
     * @param string $vacunas
     *
     * @return AntecedentesPersonales
     */
    public function setVacunas($vacunas)
    {
        $this->vacunas = $vacunas;

        return $this;
    }

    /**
     * Get vacunas
     *
     * @return string
     */
    public function getVacunas()
    {
        return $this->vacunas;
    }

    /**
     * Set perinatal
     *
     * @param string $perinatal
     *
     * @return AntecedentesPersonales
     */
    public function setPerinatal($perinatal)
    {
        $this->perinatal = $perinatal;

        return $this;
    }

    /**
     * Get perinatal
     *
     * @return string
     */
    public function getPerinatal()
    {
        return $this->perinatal;
    }

    /**
     * Set infancia
     *
     * @param string $infancia
     *
     * @return AntecedentesPersonales
     */
    public function setInfancia($infancia)
    {
        $this->infancia = $infancia;

        return $this;
    }

    /**
     * Get infancia
     *
     * @return string
     */
    public function getInfancia()
    {
        return $this->infancia;
    }

    /**
     * Set adolecencia
     *
     * @param string $adolecencia
     *
     * @return AntecedentesPersonales
     */
    public function setAdolecencia($adolecencia)
    {
        $this->adolecencia = $adolecencia;

        return $this;
    }

    /**
     * Get adolecencia
     *
     * @return string
     */
    public function getAdolecencia()
    {
        return $this->adolecencia;
    }

    /**
     * Set desarrollo
     *
     * @param string $desarrollo
     *
     * @return AntecedentesPersonales
     */
    public function setDesarrollo($desarrollo)
    {
        $this->desarrollo = $desarrollo;

        return $this;
    }

    /**
     * Get desarrollo
     *
     * @return string
     */
    public function getDesarrollo()
    {
        return $this->desarrollo;
    }

    /**
     * Set otroPediatrico
     *
     * @param string $otroPediatrico
     *
     * @return AntecedentesPersonales
     */
    public function setOtroPediatrico($otroPediatrico)
    {
        $this->otroPediatrico = $otroPediatrico;

        return $this;
    }

    /**
     * Get otroPediatrico
     *
     * @return string
     */
    public function getOtroPediatrico()
    {
        return $this->otroPediatrico;
    }

    /**
     * Set tabaco
     *
     * @param string $tabaco
     *
     * @return AntecedentesPersonales
     */
    public function setTabaco($tabaco)
    {
        $this->tabaco = $tabaco;

        return $this;
    }

    /**
     * Get tabaco
     *
     * @return string
     */
    public function getTabaco()
    {
        return $this->tabaco;
    }

    /**
     * Set dieta
     *
     * @param string $dieta
     *
     * @return AntecedentesPersonales
     */
    public function setDieta($dieta)
    {
        $this->dieta = $dieta;

        return $this;
    }

    /**
     * Get dieta
     *
     * @return string
     */
    public function getDieta()
    {
        return $this->dieta;
    }

    /**
     * Set alcohol
     *
     * @param string $alcohol
     *
     * @return AntecedentesPersonales
     */
    public function setAlcohol($alcohol)
    {
        $this->alcohol = $alcohol;

        return $this;
    }

    /**
     * Get alcohol
     *
     * @return string
     */
    public function getAlcohol()
    {
        return $this->alcohol;
    }

    /**
     * Set religion
     *
     * @param string $religion
     *
     * @return AntecedentesPersonales
     */
    public function setReligion($religion)
    {
        $this->religion = $religion;

        return $this;
    }

    /**
     * Get religion
     *
     * @return string
     */
    public function getReligion()
    {
        return $this->religion;
    }

    /**
     * Set drogas
     *
     * @param string $drogas
     *
     * @return AntecedentesPersonales
     */
    public function setDrogas($drogas)
    {
        $this->drogas = $drogas;

        return $this;
    }

    /**
     * Get drogas
     *
     * @return string
     */
    public function getDrogas()
    {
        return $this->drogas;
    }

    /**
     * Set tendenciaSexual
     *
     * @param string $tendenciaSexual
     *
     * @return AntecedentesPersonales
     */
    public function setTendenciaSexual($tendenciaSexual)
    {
        $this->tendenciaSexual = $tendenciaSexual;

        return $this;
    }

    /**
     * Get tendenciaSexual
     *
     * @return string
     */
    public function getTendenciaSexual()
    {
        return $this->tendenciaSexual;
    }

    /**
     * Set urinario
     *
     * @param string $urinario
     *
     * @return AntecedentesPersonales
     */
    public function setUrinario($urinario)
    {
        $this->urinario = $urinario;

        return $this;
    }

    /**
     * Get urinario
     *
     * @return string
     */
    public function getUrinario()
    {
        return $this->urinario;
    }

    /**
     * Set riesgoSocial
     *
     * @param string $riesgoSocial
     *
     * @return AntecedentesPersonales
     */
    public function setRiesgoSocial($riesgoSocial)
    {
        $this->riesgoSocial = $riesgoSocial;

        return $this;
    }

    /**
     * Get riesgoSocial
     *
     * @return string
     */
    public function getRiesgoSocial()
    {
        return $this->riesgoSocial;
    }

    /**
     * Set defecatorio
     *
     * @param string $defecatorio
     *
     * @return AntecedentesPersonales
     */
    public function setDefecatorio($defecatorio)
    {
        $this->defecatorio = $defecatorio;

        return $this;
    }

    /**
     * Get defecatorio
     *
     * @return string
     */
    public function getDefecatorio()
    {
        return $this->defecatorio;
    }

    /**
     * Set riesgoLaboral
     *
     * @param string $riesgoLaboral
     *
     * @return AntecedentesPersonales
     */
    public function setRiesgoLaboral($riesgoLaboral)
    {
        $this->riesgoLaboral = $riesgoLaboral;

        return $this;
    }

    /**
     * Get riesgoLaboral
     *
     * @return string
     */
    public function getRiesgoLaboral()
    {
        return $this->riesgoLaboral;
    }

    /**
     * Set actividadFisica
     *
     * @param string $actividadFisica
     *
     * @return AntecedentesPersonales
     */
    public function setActividadFisica($actividadFisica)
    {
        $this->actividadFisica = $actividadFisica;

        return $this;
    }

    /**
     * Get actividadFisica
     *
     * @return string
     */
    public function getActividadFisica()
    {
        return $this->actividadFisica;
    }

    /**
     * Set riesgoFamiliar
     *
     * @param string $riesgoFamiliar
     *
     * @return AntecedentesPersonales
     */
    public function setRiesgoFamiliar($riesgoFamiliar)
    {
        $this->riesgoFamiliar = $riesgoFamiliar;

        return $this;
    }

    /**
     * Get riesgoFamiliar
     *
     * @return string
     */
    public function getRiesgoFamiliar()
    {
        return $this->riesgoFamiliar;
    }

    /**
     * Set otroHabito
     *
     * @param string $otroHabito
     *
     * @return AntecedentesPersonales
     */
    public function setOtroHabito($otroHabito)
    {
        $this->otroHabito = $otroHabito;

        return $this;
    }

    /**
     * Get otroHabito
     *
     * @return string
     */
    public function getOtroHabito()
    {
        return $this->otroHabito;
    }
}

