<?php

namespace AgendaBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AntecedentesFamiliares
 *
 * @ORM\Table(name="antecedentes_familiares")
 * @ORM\Entity(repositoryClass="AgendaBundle\Repository\AntecedentesFamiliaresRepository")
 */
class AntecedentesFamiliares
{
    /**
     * @var int
     *
     * @ORM\Column(name="id_antecedente_f", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\OneToOne(targetEntity="AdministradorBundle\Entity\Paciente")
     * @ORM\JoinColumn(name="id_paciente", referencedColumnName="id_paciente")
     */
    private $idPaciente;

    /**
     * @var string
     *
     * @ORM\Column(name="cancer_antecedente_f", type="text", nullable=true)
     */
    private $cancer;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_cong_antecedente_f", type="text", nullable=true)
     */
    private $congenitas;

    /**
     * @var string
     *
     * @ORM\Column(name="cardiopatia_antecedente_f", type="text", nullable=true)
     */
    private $cardiopatia;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_infec_antecedente_f", type="text", nullable=true)
     */
    private $infecciosas;

    /**
     * @var string
     *
     * @ORM\Column(name="diabetes_antecedente_f", type="text", nullable=true)
     */
    private $diabetes;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_menta_antecedente_f", type="text", nullable=true)
     */
    private $mentales;

    /**
     * @var string
     *
     * @ORM\Column(name="enf_cebvas_antecedente_f", type="text", nullable=true)
     */
    private $cerebroVascular;

    /**
     * @var string
     *
     * @ORM\Column(name="hipertension_antecedente_f", type="text", nullable=true)
     */
    private $hipertension;

    /**
     * @var string
     *
     * @ORM\Column(name="otra_antecedente_f", type="text", nullable=true)
     */
    private $otro;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idPaciente
     *
     * @param \int $idPaciente
     *
     * @return Paciente
     */
    public function setIdPaciente($idPaciente)
    {
        $this->idPaciente = $idPaciente;

        return $this;
    }

    /**
     * Get idPaciente
     *
     * @return \int
     */
    public function getIdPaciente()
    {
        return $this->idPaciente;
    }

    /**
     * Set cancer
     *
     * @param string $cancer
     *
     * @return AntecedentesFamiliares
     */
    public function setCancer($cancer)
    {
        $this->cancer = $cancer;

        return $this;
    }

    /**
     * Get cancer
     *
     * @return string
     */
    public function getCancer()
    {
        return $this->cancer;
    }

    /**
     * Set congenitas
     *
     * @param string $congenitas
     *
     * @return AntecedentesFamiliares
     */
    public function setCongenitas($congenitas)
    {
        $this->congenitas = $congenitas;

        return $this;
    }

    /**
     * Get congenitas
     *
     * @return string
     */
    public function getCongenitas()
    {
        return $this->congenitas;
    }

    /**
     * Set cardiopatia
     *
     * @param string $cardiopatia
     *
     * @return AntecedentesFamiliares
     */
    public function setCardiopatia($cardiopatia)
    {
        $this->cardiopatia = $cardiopatia;

        return $this;
    }

    /**
     * Get cardiopatia
     *
     * @return string
     */
    public function getCardiopatia()
    {
        return $this->cardiopatia;
    }

    /**
     * Set infecciosas
     *
     * @param string $infecciosas
     *
     * @return AntecedentesFamiliares
     */
    public function setInfecciosas($infecciosas)
    {
        $this->infecciosas = $infecciosas;

        return $this;
    }

    /**
     * Get infecciosas
     *
     * @return string
     */
    public function getInfecciosas()
    {
        return $this->infecciosas;
    }

    /**
     * Set diabetes
     *
     * @param string $diabetes
     *
     * @return AntecedentesFamiliares
     */
    public function setDiabetes($diabetes)
    {
        $this->diabetes = $diabetes;

        return $this;
    }

    /**
     * Get diabetes
     *
     * @return string
     */
    public function getDiabetes()
    {
        return $this->diabetes;
    }

    /**
     * Set mentales
     *
     * @param string $mentales
     *
     * @return AntecedentesFamiliares
     */
    public function setMentales($mentales)
    {
        $this->mentales = $mentales;

        return $this;
    }

    /**
     * Get mentales
     *
     * @return string
     */
    public function getMentales()
    {
        return $this->mentales;
    }

    /**
     * Set cerebroVascular
     *
     * @param string $cerebroVascular
     *
     * @return AntecedentesFamiliares
     */
    public function setCerebroVascular($cerebroVascular)
    {
        $this->cerebroVascular = $cerebroVascular;

        return $this;
    }

    /**
     * Get cerebroVascular
     *
     * @return string
     */
    public function getCerebroVascular()
    {
        return $this->cerebroVascular;
    }

    /**
     * Set hipertension
     *
     * @param string $hipertension
     *
     * @return AntecedentesFamiliares
     */
    public function setHipertension($hipertension)
    {
        $this->hipertension = $hipertension;

        return $this;
    }

    /**
     * Get hipertension
     *
     * @return string
     */
    public function getHipertension()
    {
        return $this->hipertension;
    }

    /**
     * Set otro
     *
     * @param string $otro
     *
     * @return AntecedentesFamiliares
     */
    public function setOtro($otro)
    {
        $this->otro = $otro;

        return $this;
    }

    /**
     * Get otro
     *
     * @return string
     */
    public function getOtro()
    {
        return $this->otro;
    }
}

